/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.repository.filesystem;

import com.streamscape.sdo.CloneableDataObject;

public class FSFile
extends CloneableDataObject {
    private long creationTimestamp;
    private long lastModified;
    private long fileSize;
    private String ownerId;
    private String path;
    private boolean isDirectory = false;

    protected FSFile(String path) {
        this.path = path;
    }

    public static FSFile createFile(String path) {
        FSFile file = new FSFile(path);
        file.isDirectory = false;
        return file;
    }

    public static FSFile createDirectory(String path) {
        FSFile file = new FSFile(path);
        file.isDirectory = true;
        return file;
    }

    public long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public void setCreationTimestamp(long creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public String getName() {
        return FSFile.toName(this.getPath());
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public long getSize() {
        return this.fileSize;
    }

    public void setSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public boolean isFile() {
        return !this.isDirectory;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public void setDirectory(boolean directory) {
        this.isDirectory = directory;
    }

    public boolean isAbsolute() {
        return this.getPath().startsWith("/");
    }

    public static String toName(String path) {
        return path.substring(path.lastIndexOf(47) + 1);
    }

    public static String toParent(String path) {
        int i;
        for (i = path.length() - 1; i >= 0 && path.charAt(i) != '/'; --i) {
        }
        return path.substring(0, i);
    }

    public String toURL() {
        return "tfcache://artifacts/" + this.getPath();
    }

    public String toString() {
        return this.getPath();
    }

    public boolean equals(Object other) {
        if (!(other instanceof FSFile)) {
            return false;
        }
        FSFile otherFile = (FSFile)other;
        return this.isDirectory == otherFile.isDirectory && this.path.equals(otherFile.getPath());
    }

    @Override
    public FSFile clone() {
        return (FSFile)super.clone();
    }
}

