/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.repository.cli;

import com.streamscape.repository.RepositoryException;
import com.streamscape.repository.cli.RepositoryAccessorException;
import com.streamscape.repository.enums.PackageType;
import com.streamscape.repository.filesystem.FSFile;
import com.streamscape.repository.object.Binding;
import com.streamscape.repository.object.ReferenceContext;
import com.streamscape.repository.pkg.Package;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.sys.SysId;
import com.streamscape.service.osf.clients.ClientFactory;
import com.streamscape.service.osf.jdbc.JDBCFactory;
import com.streamscape.service.osf.transports.TransportFactory;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;

public interface RepositoryAccessor {
    public String getNodeName();

    public boolean isOpened();

    public SysId getSystemId() throws RepositoryAccessorException;

    public String getProviderClass() throws RepositoryAccessorException;

    public String getVendor() throws RepositoryAccessorException;

    public String getInstallRoot() throws RepositoryAccessorException;

    public boolean isTypeResolutionCapable() throws RepositoryAccessorException;

    public boolean isObjectReferenceCapable() throws RepositoryAccessorException;

    public boolean isGlobalsCapable() throws RepositoryAccessorException;

    public boolean isTransactionCapable() throws RepositoryAccessorException;

    public Map<String, Object> getEnvironment() throws RepositoryAccessorException;

    public Object addEnvironmentVariable(String var1, Object var2) throws RepositoryAccessorException;

    public Object removeEnvironmentVariable(String var1) throws RepositoryAccessorException;

    public boolean inXact() throws RepositoryAccessorException;

    public FSFile getRootDirectory() throws RepositoryAccessorException, RepositoryException;

    public void createDirectory(FSFile var1, String var2) throws RepositoryAccessorException, RepositoryException;

    public FSFile createDirectory(String var1) throws RepositoryAccessorException, RepositoryException;

    public void createFile(String var1, byte[] var2, long var3) throws RepositoryAccessorException, RepositoryException;

    public void createFile(String var1, File var2, long var3) throws RepositoryAccessorException, RepositoryException;

    public void createFile(String var1, InputStream var2, int var3, long var4) throws RepositoryAccessorException, RepositoryException;

    public void deleteDirectory(String var1, boolean var2) throws RepositoryAccessorException, RepositoryException;

    public void deleteFile(String var1) throws RepositoryAccessorException, RepositoryException;

    public boolean existsFile(String var1) throws RepositoryAccessorException, RepositoryException;

    public String getFileContent(String var1) throws RepositoryAccessorException, RepositoryException;

    public byte[] getFileContentBytes(String var1) throws RepositoryAccessorException, RepositoryException;

    public void getFileContent(String var1, OutputStream var2) throws RepositoryAccessorException, RepositoryException;

    public FSFile getDetails(String var1) throws RepositoryAccessorException, RepositoryException;

    public List<FSFile> getDetails(Collection<String> var1) throws RepositoryAccessorException, RepositoryException;

    public boolean isDirectory(String var1) throws RepositoryAccessorException, RepositoryException;

    public boolean isFile(String var1) throws RepositoryAccessorException, RepositoryException;

    public List<String> listFiles(String var1) throws RepositoryAccessorException, RepositoryException;

    public List<String> listDirectories(String var1) throws RepositoryAccessorException, RepositoryException;

    public List<String> listAllArtifacts(String var1) throws RepositoryAccessorException, RepositoryException;

    public List<FSFile> getFilesDetails(String var1) throws RepositoryAccessorException, RepositoryException;

    public List<FSFile> getDirectoriesDetails(String var1) throws RepositoryAccessorException, RepositoryException;

    public List<FSFile> getAllArtifactsDetails(String var1) throws RepositoryAccessorException, RepositoryException;

    public FSFile renameArtifact(FSFile var1, String var2) throws RepositoryAccessorException, RepositoryException;

    public void renameArtifact(String var1, String var2) throws RepositoryAccessorException, RepositoryException;

    public void updateFile(String var1, byte[] var2) throws RepositoryAccessorException, RepositoryException;

    public void updateFile(String var1, File var2) throws RepositoryAccessorException, RepositoryException;

    public void updateFile(String var1, InputStream var2, int var3) throws RepositoryAccessorException, RepositoryException;

    public void setFileExpiration(String var1, long var2) throws RepositoryAccessorException, RepositoryException;

    public void appendFile(String var1, byte[] var2) throws RepositoryAccessorException, RepositoryException;

    public void appendFile(String var1, File var2) throws RepositoryAccessorException, RepositoryException;

    public void appendFile(String var1, InputStream var2, int var3) throws RepositoryAccessorException, RepositoryException;

    public void saveServiceConfiguration(ServiceConfigurationObject var1) throws RepositoryAccessorException, RepositoryException;

    public ServiceConfigurationObject loadServiceConfiguration(String var1, String var2) throws RepositoryAccessorException, RepositoryException;

    public void removeServiceConfiguration(String var1, String var2) throws RepositoryAccessorException, RepositoryException;

    public boolean existsServiceConfiguration(String var1, String var2) throws RepositoryAccessorException, RepositoryException;

    public List<String> listServiceTypes() throws RepositoryAccessorException, RepositoryException;

    public List<String> listServiceNames() throws RepositoryAccessorException, RepositoryException;

    public List<String> listServicesByType(String var1) throws RepositoryAccessorException, RepositoryException;

    public void importServiceConfiguration(String var1, String var2, String var3, boolean var4) throws RepositoryAccessorException, RepositoryException;

    public void exportServiceConfiguration(String var1, String var2, String var3) throws RepositoryAccessorException, RepositoryException;

    public String resolveSemanticType(String var1) throws RepositoryAccessorException, RepositoryException;

    public String resolveSemanticClass(String var1) throws RepositoryAccessorException, RepositoryException;

    public SemanticType getSemanticType(String var1) throws RepositoryAccessorException, RepositoryException;

    public boolean existsSemanticType(String var1) throws RepositoryAccessorException, RepositoryException;

    public List<String> listSemanticTypes() throws RepositoryAccessorException, RepositoryException;

    public List<SemanticType> getSemanticTypes() throws RepositoryAccessorException, RepositoryException;

    public ReferenceContext getRootContext() throws RepositoryAccessorException, RepositoryException;

    public ReferenceContext createReferenceContext(String var1) throws RepositoryAccessorException, NamingException, RepositoryException;

    public ReferenceContext createReferenceContext(ReferenceContext var1, String var2) throws RepositoryAccessorException, NamingException, RepositoryException;

    public void destroyReferenceContext(ReferenceContext var1) throws RepositoryAccessorException, NamingException, RepositoryException;

    public void setReferenceContext(ReferenceContext var1) throws RepositoryAccessorException, NamingException, RepositoryException;

    public void resetReferenceContext() throws RepositoryAccessorException, NamingException, RepositoryException;

    public ReferenceContext getReferenceContext() throws RepositoryAccessorException, RepositoryException;

    public ReferenceContext lookupReferenceContext(String var1) throws RepositoryAccessorException, NamingException, RepositoryException;

    public boolean existsReferenceContext(String var1) throws RepositoryAccessorException, NamingException, RepositoryException;

    public List<String> listReferenceContexts() throws RepositoryAccessorException, RepositoryException;

    public void bindObject(String var1, Object var2) throws RepositoryAccessorException, NamingException, RepositoryException;

    public void rebindObject(String var1, Object var2) throws RepositoryAccessorException, NamingException, RepositoryException;

    public void unbindObject(String var1) throws RepositoryAccessorException, NamingException, RepositoryException;

    public void renameObject(String var1, String var2) throws RepositoryAccessorException, NamingException, RepositoryException;

    public Object lookupObject(String var1) throws RepositoryAccessorException, NamingException, RepositoryException;

    public Object lookupObject(String var1, String var2) throws RepositoryAccessorException, NamingException, RepositoryException;

    public Object lookupObject(ReferenceContext var1, String var2) throws RepositoryAccessorException, NamingException, RepositoryException;

    public boolean existsObject(String var1) throws RepositoryAccessorException, NamingException, RepositoryException;

    public List<String> listQualifiedObjectNames() throws RepositoryAccessorException, NamingException, RepositoryException;

    public List<String> listQualifiedObjectNames(ReferenceContext var1) throws RepositoryAccessorException, NamingException, RepositoryException;

    public List<String> listObjectNames(String var1) throws RepositoryAccessorException, RepositoryException;

    public List<String> listObjectNames(ReferenceContext var1, String var2) throws RepositoryAccessorException, NamingException, RepositoryException;

    public List<Binding> listBindings() throws RepositoryAccessorException, RepositoryException;

    public List<Binding> listBindings(ReferenceContext var1) throws RepositoryAccessorException, NamingException, RepositoryException;

    public void addPackage(Package var1) throws RepositoryAccessorException, RepositoryException;

    public void addPackage(Package var1, File[] var2) throws RepositoryAccessorException, RepositoryException;

    public Package getPackage(PackageType var1, String var2) throws RepositoryAccessorException, RepositoryException;

    public Package getPackage(String var1) throws RepositoryAccessorException, NamingException, RepositoryException;

    public Package getPackageByArchive(String var1) throws RepositoryAccessorException, RepositoryException;

    public void removePackage(PackageType var1, String var2, boolean var3) throws RepositoryAccessorException, RepositoryException;

    public void removePackage(String var1, boolean var2) throws RepositoryAccessorException, NamingException, RepositoryException;

    public boolean existsPackage(PackageType var1, String var2) throws RepositoryAccessorException, RepositoryException;

    public boolean existsPackage(String var1) throws RepositoryAccessorException, NamingException, RepositoryException;

    public void updatePackage(Package var1) throws RepositoryAccessorException, RepositoryException;

    public void importPackage(String var1, PackageType var2, String var3) throws RepositoryAccessorException, RepositoryException;

    public void importPackage(String var1, String var2) throws RepositoryAccessorException, NamingException, RepositoryException;

    public void exportPackage(String var1, PackageType var2, String var3) throws RepositoryAccessorException, RepositoryException;

    public void exportPackage(String var1, String var2) throws RepositoryAccessorException, NamingException, RepositoryException;

    public List<String> listPackages() throws RepositoryAccessorException, RepositoryException;

    public List<String> listPackagesByType(PackageType var1) throws RepositoryAccessorException, RepositoryException;

    public void addArchive(File var1) throws RepositoryAccessorException, RepositoryException;

    public void addArchive(String var1, byte[] var2) throws RepositoryAccessorException, RepositoryException;

    public void removeArchive(String var1) throws RepositoryAccessorException, RepositoryException;

    public boolean existsArchive(String var1) throws RepositoryAccessorException, RepositoryException;

    public byte[] getArchive(String var1) throws RepositoryAccessorException, RepositoryException;

    public InputStream getArchiveStream(String var1) throws RepositoryAccessorException, RepositoryException;

    public URL getArchiveURL(String var1) throws RepositoryAccessorException, RepositoryException;

    public List<URL> getArchiveURLs() throws RepositoryAccessorException, RepositoryException;

    public List<String> listArchives() throws RepositoryAccessorException, RepositoryException;

    public void addExtensionArchive(File var1) throws RepositoryAccessorException, RepositoryException;

    public void addExtensionArchive(String var1, byte[] var2) throws RepositoryAccessorException, RepositoryException;

    public void removeExtensionArchive(String var1, boolean var2) throws RepositoryAccessorException, RepositoryException;

    public boolean existsExtensionArchive(String var1) throws RepositoryAccessorException, RepositoryException;

    public byte[] getExtensionArchive(String var1) throws RepositoryAccessorException, RepositoryException;

    public URL getExtensionArchiveURL(String var1) throws RepositoryAccessorException, RepositoryException;

    public List<URL> getExtensionArchiveURLs() throws RepositoryAccessorException, RepositoryException;

    public List<String> listExtensionArchives() throws RepositoryAccessorException, RepositoryException;

    public void saveTransportFactory(TransportFactory var1) throws RepositoryAccessorException, RepositoryException;

    public TransportFactory loadTransportFactory(String var1, String var2) throws RepositoryAccessorException, RepositoryException;

    public void removeTransportFactory(String var1, String var2) throws RepositoryAccessorException, RepositoryException;

    public boolean existsTransportFactory(String var1, String var2) throws RepositoryAccessorException, RepositoryException;

    public List<String> listTransportFactoryNames() throws RepositoryAccessorException, RepositoryException;

    public List<String> listTransportFactoryTypes() throws RepositoryAccessorException, RepositoryException;

    public List<String> listTransportFactoriesByType(String var1) throws RepositoryAccessorException, RepositoryException;

    public void importTransportFactory(String var1, String var2, String var3) throws RepositoryAccessorException, RepositoryException;

    public void exportTransportFactory(String var1, String var2, String var3) throws RepositoryAccessorException, RepositoryException;

    public void saveJDBCFactory(JDBCFactory var1) throws RepositoryAccessorException, RepositoryException;

    public JDBCFactory loadJDBCFactory(String var1, String var2) throws RepositoryAccessorException, RepositoryException;

    public void removeJDBCFactory(String var1, String var2) throws RepositoryAccessorException, RepositoryException;

    public boolean existsJDBCFactory(String var1, String var2) throws RepositoryAccessorException, RepositoryException;

    public List<String> listJDBCFactoryNames() throws RepositoryAccessorException, RepositoryException;

    public List<String> listJDBCFactoryTypes() throws RepositoryAccessorException, RepositoryException;

    public List<String> listJDBCFactoriesByType(String var1) throws RepositoryAccessorException, RepositoryException;

    public void importJDBCFactory(String var1, String var2, String var3) throws RepositoryAccessorException, RepositoryException;

    public void exportJDBCFactory(String var1, String var2, String var3) throws RepositoryAccessorException, RepositoryException;

    public void saveClientFactory(ClientFactory var1) throws RepositoryAccessorException, RepositoryException;

    public ClientFactory loadClientFactory(String var1, String var2) throws RepositoryAccessorException, RepositoryException;

    public void removeClientFactory(String var1, String var2) throws RepositoryAccessorException, RepositoryException;

    public boolean existsClientFactory(String var1, String var2) throws RepositoryAccessorException, RepositoryException;

    public List<String> listClientFactoryNames() throws RepositoryAccessorException, RepositoryException;

    public List<String> listClientFactoryTypes() throws RepositoryAccessorException, RepositoryException;

    public List<String> listClientFactoriesByType(String var1) throws RepositoryAccessorException, RepositoryException;

    public void importClientFactory(String var1, String var2, String var3) throws RepositoryAccessorException, RepositoryException;

    public void exportClientFactory(String var1, String var2, String var3) throws RepositoryAccessorException, RepositoryException;
}

