/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.repository.cache;

import com.streamscape.Trace;
import com.streamscape.lib.evfs.FileChangeListener;
import com.streamscape.lib.jar.JarFile;
import com.streamscape.lib.loader.ClassLoaderReference;
import com.streamscape.lib.loader.Helper;
import com.streamscape.lib.loader.PackageLoaderRegistry;
import com.streamscape.lib.loader.TFCacheJarStorage;
import com.streamscape.lib.loader.net.AbstractURLHandler;
import com.streamscape.lib.loader.net.jar.JarURLHandler;
import com.streamscape.lib.loader.net.tfcache.TFCacheURLHandler;
import com.streamscape.lib.utils.ArrayIterator;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.lib.utils.CryptoUtils;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.Pair;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.lib.utils.URLUtils;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.lib.utils.Utils;
import com.streamscape.lib.zip.ZipFile;
import com.streamscape.omf.FactoryManagerException;
import com.streamscape.omf.serializer.SerializerException;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.omf.xml.XSerializerFactory;
import com.streamscape.repository.cache.ArtifactCachePolicy;
import com.streamscape.repository.cache.CacheArtifactInfo;
import com.streamscape.repository.cache.CacheIOThread;
import com.streamscape.repository.cache.CacheMissException;
import com.streamscape.repository.cache.IllegalStateException;
import com.streamscape.repository.cache.OwnersTable;
import com.streamscape.repository.cache.SystemObjectsPersister;
import com.streamscape.repository.cache.SystemTableHelper;
import com.streamscape.repository.cache.TFCacheException;
import com.streamscape.repository.enums.CachedEntity;
import com.streamscape.repository.enums.LockType;
import com.streamscape.repository.enums.PackageType;
import com.streamscape.repository.globals.GlobalVariableCollection;
import com.streamscape.repository.listeners.RepositoryArtifactChangeListener;
import com.streamscape.repository.listeners.RepositoryStateChangeListener;
import com.streamscape.repository.namespace.EntityName;
import com.streamscape.repository.namespace.EntityScope;
import com.streamscape.repository.object.ReferenceContext;
import com.streamscape.repository.pkg.Package;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeState;
import com.streamscape.runtime.mf.admin.dfo.JDBCFactoryObject;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.advisory.RepositoryArtifactStateChangeAdvisory;
import com.streamscape.sdo.advisory.RepositoryStateChangeAdvisory;
import com.streamscape.sdo.enums.ArtifactState;
import com.streamscape.sdo.enums.FileState;
import com.streamscape.sdo.enums.RepositoryState;
import com.streamscape.sdo.enums.Severity;
import com.streamscape.sdo.file.FileMetaInfo;
import com.streamscape.sdo.mf.admin.SemanticTypeFactoryException;
import com.streamscape.sdo.mf.admin.TypeFactory;
import com.streamscape.sdo.sys.SysId;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.container.ContainerLockSupport;
import com.streamscape.sef.dispatcher.AbstractTFCache;
import com.streamscape.sef.security.SecurityManager;
import com.streamscape.sef.security.SecurityManagerException;
import com.streamscape.sef.security.User;
import com.streamscape.service.osf.clients.ClientFactory;
import com.streamscape.service.osf.jdbc.JDBCFactory;
import com.streamscape.service.osf.transports.TransportFactory;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.invoke.CallSite;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;

public class TFCache
extends AbstractTFCache
implements FileChangeListener {
    public static final String ROOT_DIRECTORY = ".tfcache";
    protected File cacheLocationCanonicalFile;
    private File junk;
    protected CacheSubDirWithContext artifacts;
    private PackagesCacheSubDir packages;
    private CacheSubDirWithContext objects;
    private CacheSubDir types;
    private CacheSubDir globals;
    private CacheSubDir services;
    private CacheSubDir transportFactories;
    private CacheSubDir jdbcFactories;
    private CacheSubDir clientFactories;
    private CacheSubDir lib;
    private CacheSubDir ext;
    private String eMapDir;
    private String slash;
    private ReferenceContext rctx;
    private String pwd = "/";
    private ContainerLockSupport.CurrentNodeLock nodeLock = null;
    protected FabricComponent ctxComponent;
    protected ReentrantLock lock = new ReentrantLock(true);
    protected boolean inTransaction = false;
    private boolean isOpened = false;
    private boolean isSynchronizedWithFs = false;
    private ArtifactCachePolicy evictionMap = new ArtifactCachePolicy();
    private final Map<String, FileObject> lockTable = new ConcurrentHashMap<String, FileObject>();
    private XSerializerFactory xFactory;
    private XSerializer xf;
    private PackageLoaderRegistry loaderRegistry;
    private SecurityManager securityManager;
    protected CacheIOThread ioThread;
    private RepositoryStateChangeListener rscListener;
    private RepositoryArtifactChangeListener racListener;
    private CacheStatistics Statistics = new CacheStatistics();
    private boolean isAdmin = true;
    private String currentUser = "UNKNOWN";
    private Map<CachedEntity, CacheSubDir> subDirByType = new HashMap<CachedEntity, CacheSubDir>();
    private final Map<CachedEntity, EntityProcessor> entityProcessors = new HashMap<CachedEntity, EntityProcessor>();
    private final Set<String> scheduledJunk = new HashSet<String>();
    protected final ExpirablePathStorage createdByCache = new ExpirablePathStorage();
    protected final OwnersTable ownersTable;
    private volatile int ownersSaveRetries = 0;
    protected final SystemObjectsPersister systemObjectsPersister;
    private final Set<RandomAccessFile> syncFilesToClose = new HashSet<RandomAccessFile>();
    private final Set<String> skipMonitoringPaths = new HashSet<String>();
    private long ioThreadCycle = 1000L;
    private int ioThreadGc;
    private static final String XDO_EXT = ".xdo";
    private static final String GLOBALS_ENTITY_NAME = "GlobalVariables";
    private static final String GLOBALS_FILE = "GlobalVariables.xdo";
    private static final String EVICTION_MAP_FILENAME = "ArtifactCachePolicy.EvictionMap.xdo";
    private static Pattern PACKAGE_PATTERN;
    private static final int BUFFER_SIZE = 65536;
    private static final Method SET_DIRTY_METHOD;

    public TFCache(String dir, PackageLoaderRegistry loaderRegistry, XSerializerFactory xFactory) {
        TFCache.checkContext();
        this.loaderRegistry = loaderRegistry;
        this.xFactory = xFactory;
        try {
            this.xf = xFactory.createSerializer("RuntimeCache$Serializer");
            this.xf.mapAttribute("SemanticType", "class");
            this.rctx = ReferenceContext.ROOT;
        }
        catch (Exception exception) {
            throw new RuntimeException("Initialization of Runtime Cache failed.", exception);
        }
        this.slash = System.getProperty("file.separator");
        try {
            this.cacheLocationCanonicalFile = new File(dir + File.separatorChar + ROOT_DIRECTORY).getCanonicalFile();
        }
        catch (IOException exception) {
            throw new RuntimeException("Runtime Cache initialization failed.", exception);
        }
        this.junk = new File(dir + File.separatorChar + ".junk");
        this.nodeLock = ContainerLockSupport.getCurrentNodeLock();
        if (!this.nodeLock.isInitialized()) {
            this.nodeLock.setUpDir(dir);
        }
        this.eMapDir = "objects" + File.separatorChar + "sys";
        this.packages = new PackagesCacheSubDir(CachedEntity.PACKAGE, "pkg");
        this.artifacts = new CacheSubDirWithContext(CachedEntity.ARTIFACT, "artifacts");
        this.objects = new CacheSubDirWithContext(CachedEntity.OBJECT, "objects");
        this.types = new CacheSubDir(CachedEntity.TYPE, "types");
        this.globals = new CacheSubDir(CachedEntity.GLOBAL_VARIABLES, "globals");
        this.services = new CacheSubDir(CachedEntity.SERVICE, "services");
        this.transportFactories = new CacheSubDir(CachedEntity.TRANSPORT_FACTORY, "transports");
        this.jdbcFactories = new CacheSubDir(CachedEntity.JDBC_FACTORY, "jdbc");
        this.clientFactories = new CacheSubDir(CachedEntity.CLIENT_FACTORY, "clients");
        this.lib = new CacheSubDir(CachedEntity.LIB, "lib");
        this.ext = new CacheSubDir(CachedEntity.EXT, "ext");
        try {
            this.systemObjectsPersister = new SystemObjectsPersister(this);
            this.ownersTable = new OwnersTable(this);
            this.ownersTable.setAutoFlushEnabled(false);
        }
        catch (Exception exception) {
            throw new RuntimeException("Initialization of Runtime Cache failed.", exception);
        }
    }

    private void initProcessors() {
        this.entityProcessors.put(CachedEntity.ARTIFACT, new ArtifactProcessor());
        this.entityProcessors.put(CachedEntity.EXT, new ExtProcessor());
        this.entityProcessors.put(CachedEntity.GLOBAL_VARIABLES, new JunkNewKeepLockOldProcessor());
        this.entityProcessors.put(CachedEntity.LIB, new LibProcessor());
        this.entityProcessors.put(CachedEntity.PACKAGE, new PackageProcessor());
        this.entityProcessors.put(CachedEntity.OBJECT, new ObjectProcessor());
        this.entityProcessors.put(CachedEntity.TYPE, new TypeProcessor());
        this.entityProcessors.put(CachedEntity.CLIENT_FACTORY, new ClientFactoryProcessor());
        this.entityProcessors.put(CachedEntity.JDBC_FACTORY, new JDBCFactoryProcessor());
        this.entityProcessors.put(CachedEntity.TRANSPORT_FACTORY, new TransportFactoryProcessor());
        this.entityProcessors.put(CachedEntity.SERVICE, new ServiceProcessor());
    }

    public String getCacheLocation() {
        return this.cacheLocationCanonicalFile.getAbsolutePath() + File.separatorChar;
    }

    protected boolean allowedToXact() throws TFCacheException, IllegalStateException {
        this.checkOpened();
        if (!this.lock.isHeldByCurrentThread()) {
            throw new TFCacheException("Transaction not started or cache is locked by another user.");
        }
        if (!this.inXact()) {
            throw new TFCacheException("Transaction not started.");
        }
        return true;
    }

    @Override
    public boolean inXact() {
        return this.inTransaction;
    }

    @Override
    public void beginXLocked(FabricComponent component, long timeout) throws InterruptedException, TFCacheException, IllegalStateException {
        this.checkOpened();
        if (timeout < 0L) {
            throw new TFCacheException("Invalid Timeout value specified: " + timeout);
        }
        if (!this.lock.tryLock(timeout, TimeUnit.MILLISECONDS)) {
            throw new TFCacheException("Begin XLocked aborted due to timeout.");
        }
        if (this.inTransaction) {
            this.lock.unlock();
            throw new TFCacheException("Internal error. inTransaction flag is true, but lock is not locked.");
        }
        this.inTransaction = true;
        this.ctxComponent = component;
    }

    @Override
    public void endXLocked() throws InterruptedException, TFCacheException, IllegalStateException {
        this.checkOpened();
        if (!this.lock.isHeldByCurrentThread()) {
            throw new TFCacheException("End XLocked failed. Cache resources are locked by another thread.");
        }
        this.inTransaction = false;
        this.ctxComponent = null;
        this.lock.unlock();
    }

    @Override
    public void abortXLocked() {
        if (!this.isOpen()) {
            return;
        }
        if (!this.lock.isHeldByCurrentThread()) {
            Trace.logError(TFCache.class, "Transaction abort failed: transaction was started by another thread.");
            return;
        }
        this.inTransaction = false;
        this.ctxComponent = null;
        this.lock.unlock();
    }

    protected String normalizePathInCache(String pathInCache) {
        return StringUtils.trimSlashes(pathInCache).replace(File.separator + File.separator, File.separator);
    }

    protected boolean existsDistinctEntity(String pathInCache) {
        return this.ownersTable.containsPathExact(pathInCache);
    }

    private boolean existsDistinctEntityErrorIfDiffCase(String pathInCache) throws TFCacheException {
        return this.ownersTable.checkExistenceInExactCaseErrorIfDiff(pathInCache);
    }

    protected boolean existsSemanticEntity(String pathInCache) {
        return this.ownersTable.containsPathIgnoreCase(pathInCache);
    }

    private void requireExistsDistinctEntity(String pathInCache, CacheSubDir subDirForMissInc) throws TFCacheException {
        if (!this.existsDistinctEntity(pathInCache)) {
            subDirForMissInc.incMiss();
            throw new CacheMissException("Entity '" + pathInCache + "' not in cache.");
        }
    }

    @Override
    public synchronized boolean existsDistinctEntity(String name, CachedEntity type) {
        return this.existsDistinctEntity(name, this.subDirByType.get((Object)type));
    }

    private synchronized boolean existsDistinctEntity(String name, CacheSubDir subDir) {
        return subDir != null && this.existsDistinctEntity(subDir.getPathInCacheWithinContext(name));
    }

    protected boolean existsEntity(String instanceName, String typeName, String ext, CachedEntity type) throws IllegalStateException, TFCacheException, NamingException {
        this.checkOpened();
        TFCache.checkNames(instanceName, typeName);
        return this.existsDistinctEntity(typeName + "." + instanceName + ext, type);
    }

    protected boolean isFilenameMatched(String filename, String entityName) {
        if (filename.equals(entityName)) {
            return true;
        }
        String[] parts = filename.split("\\.");
        return parts.length >= 2 && parts.length <= 3 && parts[parts.length - 2].equals(entityName);
    }

    private List<CacheSubDir> getSubDirsByScope(EntityScope scope) {
        boolean isNonObject;
        ArrayList<CacheSubDir> result = new ArrayList<CacheSubDir>();
        boolean isAll = scope.equals((Object)EntityScope.ALL);
        if (isAll | (isNonObject = scope.equals((Object)EntityScope.NON_OBJECT)) | scope.equals((Object)EntityScope.CLIENT_FACTORY)) {
            result.add(this.clientFactories);
        }
        if (isAll | isNonObject | scope.equals((Object)EntityScope.JDBC_FACTORY)) {
            result.add(this.jdbcFactories);
        }
        if (isAll | isNonObject | scope.equals((Object)EntityScope.PACKAGE)) {
            result.add(this.packages);
        }
        if (isAll | isNonObject | scope.equals((Object)EntityScope.SERVICE)) {
            result.add(this.services);
        }
        if (isAll | isNonObject | scope.equals((Object)EntityScope.TRANSPORT_FACTORY)) {
            result.add(this.transportFactories);
        }
        if (isAll | isNonObject | scope.equals((Object)EntityScope.TYPE)) {
            result.add(this.types);
        }
        if (isAll | scope.equals((Object)EntityScope.OBJECT)) {
            result.add(this.objects);
        }
        return result;
    }

    private void scanForEntities(List<EntityName> results, File location, String entityName, ReferenceContext context, int limit, boolean isRecursive) throws NamingException, IOException {
        File[] files = location.listFiles();
        if (files == null) {
            throw new IOException("Obtaining list of files in '" + String.valueOf(location) + "' failed due to I/O error.");
        }
        for (File file : files) {
            String exactCaseFilename;
            String pathInCache = this.ownersTable.getPathInExactCase(this.getPathInCache(file));
            if (pathInCache == null) continue;
            int slashPos = pathInCache.lastIndexOf(File.separatorChar);
            String string = exactCaseFilename = slashPos < 0 ? pathInCache : pathInCache.substring(slashPos + 1);
            if (file.isDirectory()) {
                if (isRecursive) {
                    this.scanForEntities(results, file, entityName, new ReferenceContext(context, exactCaseFilename), limit, isRecursive);
                }
            } else if (this.isFilenameMatched(exactCaseFilename.toUpperCase(), entityName.toUpperCase())) {
                results.add(new EntityName(context, exactCaseFilename));
            }
            if (limit <= 0 || results.size() < limit) continue;
            return;
        }
    }

    private List<EntityName> getDistinguishedNameAll(EntityScope scope, String entityName, int limit) throws IllegalStateException, NamingException, IOException {
        ArrayList<EntityName> results = new ArrayList<EntityName>();
        List<CacheSubDir> subDirs = this.getSubDirsByScope(scope);
        if (subDirs.size() == 1) {
            this.scanForEntities(results, subDirs.get(0).getBaseCanonicalFile(), entityName, ReferenceContext.ROOT, limit, true);
        } else {
            for (CacheSubDir subDir : subDirs) {
                this.scanForEntities(results, subDir.getBaseCanonicalFile(), entityName, new ReferenceContext(ReferenceContext.ROOT, subDir.getBaseDirName()), limit, true);
            }
        }
        return results;
    }

    private List<EntityName> getDistinguishedNameAllObjectCurrentContext(EntityScope scope, String entityName, int limit) throws TFCacheException, IllegalStateException, NamingException, IOException {
        ArrayList<EntityName> results;
        if (scope.equals((Object)EntityScope.OBJECT)) {
            results = new ArrayList<EntityName>();
            this.scanForEntities(results, this.objects.getCurrentCanonicalFile(), entityName, this.getReferenceContext(), limit, false);
        } else {
            results = this.getDistinguishedNameAll(scope, entityName, limit);
        }
        return results;
    }

    private void assertExists(List<EntityName> list, EntityScope scope, String entityName) throws TFCacheException {
        if (list.size() == 0) {
            throw new TFCacheException("'" + entityName + "' is not found in scope '" + scope.name() + "'.");
        }
    }

    private void assertUnique(List<EntityName> list, EntityScope scope, String entityName) throws TFCacheException {
        if (list.size() > 1) {
            throw new TFCacheException("'" + entityName + "' is not unique in scope '" + scope.name() + "'.");
        }
    }

    public List<EntityName> getDistinguishedNameAll(EntityScope scope, String entityName) throws IllegalStateException, NamingException, IOException {
        return this.getDistinguishedNameAll(scope, entityName, 0);
    }

    public EntityName getDistinguishedName(EntityScope scope, String entityName) throws TFCacheException, IllegalStateException, NamingException, IOException {
        List<EntityName> results = this.getDistinguishedNameAllObjectCurrentContext(scope, entityName, 2);
        this.assertExists(results, scope, entityName);
        this.assertUnique(results, scope, entityName);
        return results.get(0);
    }

    public boolean assertDistinguishedName(EntityScope scope, String entityName) throws TFCacheException, IllegalStateException, NamingException, IOException {
        List<EntityName> results = this.getDistinguishedNameAllObjectCurrentContext(scope, entityName, 2);
        this.assertUnique(results, scope, entityName);
        return results.size() > 0;
    }

    public EntityName getDistinguishedContextName() throws TFCacheException, IllegalStateException, InvalidNameException {
        ReferenceContext context = this.getReferenceContext();
        ArrayList<String> path = new ArrayList<String>();
        while (context.getParentContext() != null) {
            path.add(context.getContextName());
            context = context.getParentContext();
        }
        EntityName eName = new EntityName(ReferenceContext.ROOT, "");
        for (int i = path.size() - 1; i >= 0; --i) {
            eName.add((String)path.get(i));
        }
        return eName;
    }

    private File getFile(String pathInCache) {
        return new File(this.cacheLocationCanonicalFile, pathInCache);
    }

    private boolean isDirectory(String pathInCache) {
        return this.getFile(pathInCache).isDirectory();
    }

    private boolean isDescendantOrEquals(String dirPathInCache, String pathInCache) {
        String dirPathInCacheUp;
        String pathInCacheUp = pathInCache.toUpperCase();
        return pathInCacheUp.startsWith(dirPathInCacheUp = dirPathInCache.toUpperCase()) && (pathInCacheUp.length() == dirPathInCacheUp.length() || pathInCacheUp.charAt(dirPathInCacheUp.length()) == File.separatorChar);
    }

    public boolean hasRepositoryStructures() {
        return this.globals.getBaseCanonicalFile().exists() && this.services.getBaseCanonicalFile().exists() && this.transportFactories.getBaseCanonicalFile().exists() && this.jdbcFactories.getBaseCanonicalFile().exists() && this.clientFactories.getBaseCanonicalFile().exists() && this.types.getBaseCanonicalFile().exists();
    }

    protected ArtifactCachePolicy getEvictionMap() {
        return this.evictionMap;
    }

    @Override
    public synchronized void extendLease(String fileName, CachedEntity type, long time) throws TFCacheException, IllegalStateException {
        this.allowedToXact();
        String pathInCache = this.subDirByType.get((Object)type).getPathInCacheWithinContext(fileName);
        if (!this.evictionMap.containsArtifact(pathInCache)) {
            throw new CacheMissException("Entity '" + pathInCache + "' not in cache.");
        }
        Date evict = this.evictionMap.getScheduledEventTime(pathInCache);
        evict.setTime(evict.getTime() + time);
        Trace.logDebug(TFCache.class, "Lease for entity '" + pathInCache + "' has been extended by " + time + " millis.");
        try {
            this.saveEvictionMap();
        }
        catch (Exception exception) {
            if (exception instanceof TFCacheException) {
                throw (TFCacheException)exception;
            }
            throw new TFCacheException(exception);
        }
        this.raiseRepositoryArtifactChangeAdvisory(Severity.INFO, pathInCache, type, ArtifactState.LEASE_EXTENDED, "Lease for Artifact '" + pathInCache + "' extended to: " + String.valueOf(evict));
    }

    @Override
    public synchronized void expireEntity(String name, CachedEntity type) throws IllegalStateException, TFCacheException {
        this.allowedToXact();
        switch (type) {
            case ARTIFACT: {
                break;
            }
            case PACKAGE: {
                throw new TFCacheException("Packages may not be expired. Use removePackage() instead.");
            }
            case OBJECT: {
                break;
            }
            case TYPE: {
                break;
            }
            case GLOBAL_VARIABLES: {
                break;
            }
            case SERVICE: {
                break;
            }
            case TRANSPORT_FACTORY: {
                break;
            }
            case JDBC_FACTORY: {
                break;
            }
            case CLIENT_FACTORY: {
                break;
            }
            case LIB: {
                throw new TFCacheException("Archives may not be expired. Use removePackage() instead.");
            }
            case EXT: {
                throw new TFCacheException("Archive extensions may not be expired.");
            }
        }
        CacheSubDir subDir = this.subDirByType.get((Object)type);
        String pathInCache = this.subDirByType.get((Object)type).getPathInCacheWithinContext(name);
        this.requireExistsDistinctEntity(pathInCache, subDir);
        if (!this.getFile(pathInCache).exists()) {
            throw new CacheMissException("Entity '" + pathInCache + "' not in cache.");
        }
        Date expire = new Date(System.currentTimeMillis());
        this.evictionMap.addArtifact(pathInCache, expire);
        Trace.logDebug(TFCache.class, "Lease for entity '" + pathInCache + "' has been set to expire at " + String.valueOf(expire) + ".");
    }

    public synchronized void setArtifactExpiration(String path, long expiration) throws TFCacheException, IllegalStateException {
        this.allowedToXact();
        String pathInCache = this.artifacts.getPathInCacheWithinContext(path);
        if (expiration > 0L) {
            Date ts = new Date(System.currentTimeMillis() + expiration);
            this.evictionMap.addArtifact(pathInCache, ts);
            Trace.logDebug(TFCache.class, "Artifact '" + pathInCache + "' will expire at : " + String.valueOf(ts));
        } else {
            this.evictionMap.removeArtifact(pathInCache);
        }
        this.saveEvictionMap();
    }

    public synchronized void evict(String name, CachedEntity type) throws TFCacheException, IllegalStateException {
        this.allowedToXact();
        switch (type) {
            case PACKAGE: {
                throw new TFCacheException("Packages may not be expired.  Use removePackage() instead.");
            }
            case LIB: {
                throw new TFCacheException("Archives may not be expired.  Use removePackage() instead.");
            }
            case EXT: {
                throw new TFCacheException("Archive extensions may not be expired.");
            }
        }
        CacheSubDir subDir = this.subDirByType.get((Object)type);
        String pathInCache = subDir.getPathInCacheWithinContext(name);
        this.requireExistsDistinctEntity(pathInCache, subDir);
        this.evict(pathInCache);
    }

    protected synchronized void evict(String pathInCache) throws TFCacheException, IllegalStateException {
        if (!this.existsDistinctEntity(pathInCache)) {
            ++this.Statistics.evictMiss;
            this.getEvictionMap().removeArtifact(pathInCache);
            this.saveEvictionMap();
            this.raiseRepositoryArtifactChangeAdvisory(Severity.SEVERE, pathInCache, CachedEntity.ARTIFACT, ArtifactState.NOT_IN_CACHE, "Eviction Error: Entity '" + pathInCache + "' not in cache.");
            throw new CacheMissException("Entity '" + pathInCache + "' not in cache. (will be removed from lock table)");
        }
        File file = this.getFile(pathInCache);
        FileObject fo = (FileObject)this.getLockTable().get(pathInCache);
        this.closeCacheFile(pathInCache);
        file.delete();
        this.getEvictionMap().removeArtifact(pathInCache);
        this.createdByCache.remove(pathInCache);
        this.ownersTable.removeEntity(pathInCache);
        this.saveEvictionMap();
        String message = "Entity '" + pathInCache + "' evicted from cache.";
        Trace.logDebug(TFCache.class, message);
        this.raiseRepositoryArtifactChangeAdvisory(Severity.INFO, pathInCache, fo.type, ArtifactState.DESTROYED, message, true);
    }

    @Override
    public synchronized void printLeasedEntities() {
        Iterator<String> leased = this.getEvictionMap().getArtifacts();
        System.out.println("\nLease Expires                  \t Artifact Path");
        System.out.println("------------------------------ \t ---------------------------------------------");
        while (leased.hasNext()) {
            String artf = leased.next();
            Date leaseDt = this.getEvictionMap().getScheduledEventTime(artf);
            String format = "%1$-30s \t %2$-45s \n";
            System.out.format(format, leaseDt, artf);
        }
        System.out.println("\n");
    }

    public ArtifactCachePolicy getLeasedEntityTable() throws IllegalStateException {
        this.checkOpened();
        return this.evictionMap;
    }

    public synchronized void printLocksTable() throws IOException {
        Iterator<String> locked = this.lockTable.keySet().iterator();
        System.out.println("\nShared Lock  \t File Size       \t Artifact Path");
        System.out.println("-----------  \t --------------  \t ---------------------------------------------");
        while (locked.hasNext()) {
            String artf = locked.next();
            FileObject f = this.lockTable.get(artf);
            Boolean shr = f.lock.isShared();
            Double size = new Double(Long.toString(f.file.length())) / 1024.0;
            DecimalFormat mask = new DecimalFormat("#########.##");
            String format = "%1$-11s \t %2$-14s \t %3$-45s \n";
            System.out.format(format, shr, mask.format(size) + " Kbytes", artf);
        }
        System.out.println("\n");
    }

    protected Map getLockTable() throws IllegalStateException {
        this.checkOpened();
        return this.lockTable;
    }

    public synchronized void printStatistics() {
        System.out.println("\nStatistic Name       \t Value");
        System.out.println("-------------------- \t ------------");
        String format = "%1$-20s \t %2$-12s \n";
        System.out.format(format, "Artifact Cache Miss ", this.Statistics.ArtifactMiss);
        System.out.format(format, "Object Cache Miss   ", this.Statistics.ObjectMiss);
        System.out.format(format, "Package Cache Miss  ", this.Statistics.PkgMiss);
        System.out.format(format, "Types Cache Miss    ", this.Statistics.TypeMiss);
        System.out.format(format, "Globals Cache Miss  ", this.Statistics.GlobalsMiss);
        System.out.format(format, "Service Cache Miss  ", this.Statistics.SvcMiss);
        System.out.format(format, "Transport Cache Miss", this.Statistics.TransportMiss);
        System.out.format(format, "JDBC Cache Miss     ", this.Statistics.JDBCMiss);
        System.out.format(format, "Client Cache Miss   ", this.Statistics.ClientMiss);
        System.out.format(format, "Tools Cache Miss    ", this.Statistics.ToolMiss);
        System.out.format(format, "Archive Cache Miss  ", this.Statistics.libMiss);
        System.out.format(format, "Eviction Cache Miss ", this.Statistics.evictMiss);
        System.out.println("\n");
    }

    @Override
    public synchronized CacheStatistics getStatistics() throws IllegalStateException {
        this.checkOpened();
        return this.Statistics;
    }

    @Override
    public synchronized boolean exists() {
        return this.cacheLocationCanonicalFile.exists();
    }

    @Override
    public synchronized boolean isLocked() throws IOException {
        return this.nodeLock.isLockedByAnotherVM();
    }

    @Override
    public synchronized boolean isOpen() {
        return this.isOpened;
    }

    private synchronized void lock(byte[] xdoc) throws TFCacheException, IllegalStateException {
        try {
            this.checkNotLocked();
        }
        catch (IOException exception) {
            throw new TFCacheException(exception);
        }
        try {
            this.nodeLock.lock();
        }
        catch (IOException exception) {
            throw new TFCacheException(exception);
        }
        this.nodeLock.writeToLockFile(xdoc);
    }

    private void synchronizeDirWithFs(File file, String pathInCache, CachedEntity entityType, Set<String> obsolete, String owner) {
        String[] files;
        this.ownersTable.checkEntityInfo((String)pathInCache, null, 0L, owner);
        if (((String)pathInCache).length() > 0) {
            pathInCache = (String)pathInCache + File.separator;
        }
        if ((files = file.list()) != null) {
            for (String child : files) {
                this.synchronizeWithFs((String)pathInCache + child, entityType, obsolete, owner);
            }
        }
    }

    private void synchronizeFirstLevelDir(CacheSubDir subDir, Set<String> obsolete, String owner) {
        obsolete.remove(subDir.getBaseDirName());
        this.synchronizeDirWithFs(subDir.getBaseCanonicalFile(), subDir.getBaseDirName(), subDir.getType(), obsolete, owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizeWithFs(String pathInCache, CachedEntity entityType, Set<String> obsolete, String owner) {
        obsolete.remove(pathInCache);
        if (this.skipProcessing(pathInCache)) {
            return;
        }
        RandomAccessFile raf = this.processEntity(pathInCache, entityType, obsolete, entityType == CachedEntity.EXT);
        File file = this.getFile(pathInCache);
        if (file.isDirectory()) {
            this.synchronizeDirWithFs(file, pathInCache, entityType, obsolete, owner);
        } else if (raf != null) {
            this.ownersTable.checkEntityInfo(pathInCache, new CryptoUtils.Sha256RandomAccessFileHashCalculator(raf), file.length(), owner);
            Set<RandomAccessFile> set = this.syncFilesToClose;
            synchronized (set) {
                if (this.syncFilesToClose.remove(raf)) {
                    try {
                        raf.close();
                    }
                    catch (IOException e) {
                        Trace.logException(TFCache.class, e, true);
                    }
                }
            }
        }
    }

    private void processFirstLevelJunk() throws IOException {
        File[] files = this.cacheLocationCanonicalFile.listFiles();
        if (files == null) {
            throw new IOException("Obtaining list of files in '" + String.valueOf(this.cacheLocationCanonicalFile) + "' failed due to I/O error.");
        }
        for (File file : files) {
            String pathInCache = this.getPathInCache(file);
            TFCache tFCache = this;
            if (pathInCache.equals(tFCache.nodeLock.getLockFileName())) continue;
            TFCache tFCache2 = this;
            if (pathInCache.equals(tFCache2.nodeLock.getLockFailFileName()) || file.equals(this.junk) || this.getEntityType(pathInCache) != null) continue;
            this.processJunk(pathInCache, CachedEntity.ARTIFACT);
        }
    }

    private void synchronizeWithFs(boolean isUseUnknownUserIfCorrupted) throws Exception {
        Trace.logDebug(TFCache.class, "Synchronizing cache with filesystem...");
        this.ownersTable.init();
        String owner = this.ownersTable.isCorrupted() && isUseUnknownUserIfCorrupted ? "UNKNOWN" : this.getCurrentUser();
        Trace.logDebug(TFCache.class, "Building lock table for standard cached entities...");
        HashSet<String> obsolete = new HashSet<String>(this.ownersTable.getPathSetExactCase());
        this.synchronizeFirstLevelDir(this.ext, obsolete, owner);
        this.synchronizeFirstLevelDir(this.lib, obsolete, owner);
        this.synchronizeFirstLevelDir(this.artifacts, obsolete, owner);
        Trace.logDebug(TFCache.class, "Building lock table for repository cached entities...");
        this.synchronizeFirstLevelDir(this.types, obsolete, owner);
        this.synchronizeFirstLevelDir(this.objects, obsolete, owner);
        this.synchronizeFirstLevelDir(this.packages, obsolete, owner);
        this.synchronizeFirstLevelDir(this.transportFactories, obsolete, owner);
        this.synchronizeFirstLevelDir(this.services, obsolete, owner);
        this.synchronizeFirstLevelDir(this.jdbcFactories, obsolete, owner);
        this.synchronizeFirstLevelDir(this.clientFactories, obsolete, owner);
        String globalsPathInCache = this.globals.getPathInCacheWithinContext(GLOBALS_FILE);
        if (!this.existsEntityFile(globalsPathInCache)) {
            this.ownersTable.removeEntity(globalsPathInCache);
            this.initGlobalVariables();
            Trace.logInfo(TFCache.class, "Global variables file not found and recreated.");
        } else {
            this.openCacheFile(globalsPathInCache, CachedEntity.GLOBAL_VARIABLES);
        }
        obsolete.remove(globalsPathInCache);
        this.processFirstLevelJunk();
        for (String pathInCache : obsolete) {
            this.ownersTable.removeEntity(pathInCache);
            String msg = "Entity '" + pathInCache + "' not found on file system and removed from owners table.";
            Trace.logDebug(TFCache.class, msg);
            this.raiseRepositoryArtifactChangeAdvisory(Severity.WARNING, pathInCache, this.getEntityType(pathInCache), ArtifactState.NOT_EXISTS, msg, false);
        }
        this.ownersTable.save();
        this.ownersTable.setAutoFlushEnabled(true);
        this.isSynchronizedWithFs = true;
    }

    public synchronized void open(SysId sysId, boolean force, boolean isUseUnknownUserForCorruptedOwnersTable) throws TFCacheException, IllegalStateException {
        Trace.logInfo(TFCache.class, "Opening Runtime Cache...");
        try {
            if (!this.cacheLocationCanonicalFile.exists()) {
                throw new TFCacheException("Runtime Cache does not exist at this location.");
            }
            this.checkNotLocked();
            if (!this.artifacts.getBaseCanonicalFile().exists()) {
                throw new TFCacheException("Missing Artifacts directory in Runtime Cache.");
            }
            if (!this.objects.getBaseCanonicalFile().exists()) {
                throw new TFCacheException("Missing Objects directory in Runtime Cache.");
            }
            if (!this.ext.getBaseCanonicalFile().exists()) {
                throw new TFCacheException("Missing ext directory in Runtime Cache.");
            }
            if (!this.packages.getBaseCanonicalFile().exists()) {
                throw new TFCacheException("Missing Packages directory in Repository Cache.");
            }
            if (!this.lib.getBaseCanonicalFile().exists()) {
                throw new TFCacheException("Missing lib directory in Repository Cache.");
            }
            if (!this.types.getBaseCanonicalFile().exists()) {
                throw new TFCacheException("Missing Types directory in Repository Cache.");
            }
            if (!this.globals.getBaseCanonicalFile().exists()) {
                throw new TFCacheException("Missing Globals directory in Repository Cache.");
            }
            if (!this.services.getBaseCanonicalFile().exists()) {
                throw new TFCacheException("Missing Services directory in Repository Cache.");
            }
            if (!this.transportFactories.getBaseCanonicalFile().exists()) {
                throw new TFCacheException("Missing TransportFactories directory in Repository Cache.");
            }
            if (!this.jdbcFactories.getBaseCanonicalFile().exists()) {
                throw new TFCacheException("Missing JDBCFactories directory in Repository Cache.");
            }
            if (!this.clientFactories.getBaseCanonicalFile().exists()) {
                throw new TFCacheException("Missing ClientFactories directory in Repository Cache.");
            }
            this.lock(this.serialize(sysId));
            Trace.logDebug(TFCache.class, "Creating and starting I/O thread...");
            try {
                this.ioThread = new CacheIOThread(this, this.ioThreadCycle, this.ioThreadGc);
                this.initProcessors();
            }
            catch (Exception exception) {
                Trace.logException(TFCache.class, exception, true);
                Trace.logError(TFCache.class, "Creation of Cache IO Thread failed.");
                throw new TFCacheException(exception);
            }
            this.ioThread.start();
            this.ioThread.resetMonitor();
            this.isOpened = true;
            Helper.setTFCache(this);
            SystemTableHelper.setTFCache(this);
            this.beginXLocked(null, 1000L);
            this.synchronizeWithFs(isUseUnknownUserForCorruptedOwnersTable);
            this.loadEvictionMap();
            this.endXLocked();
            this.ioThread.startMonitor();
        }
        catch (IllegalStateException exception) {
            if (this.inXact()) {
                this.abortXLocked();
            }
            this.isOpened = false;
            throw exception;
        }
        catch (Exception exception) {
            if (this.inXact()) {
                this.abortXLocked();
            }
            this.isOpened = false;
            throw new TFCacheException(exception);
        }
        Trace.logInfo(TFCache.class, "Runtime Cache opened.");
        this.raiseRepositoryStateChangeAdvisory(RepositoryState.OPENED, "Runtime Cache opened.");
    }

    @Override
    protected boolean addSemanticType(SemanticType semanticType) throws Exception {
        Trace.logDebug(TFCache.class, "Aliasing semantic type [" + semanticType.getTypeName() + "]...");
        try {
            ClassUtils.loadClass(semanticType.getClassName(), this.loaderRegistry.getSystemClassLoaderChain());
        }
        catch (Throwable exception) {
            if (exception instanceof ClassNotFoundException) {
                Trace.logError(TFCache.class, "Semantic class '" + semanticType.getClassName() + "' not found.");
            } else {
                Trace.logException(TFCache.class, exception, true);
                Trace.logError(TFCache.class, "Registering semantic class '" + semanticType.getClassName() + "' failed.");
            }
            this.checkSerialVersionUID(semanticType, false);
            this.updateSemanticType(semanticType, false);
            return true;
        }
        try {
            this.xFactory.alias(semanticType);
        }
        catch (FactoryManagerException exception) {
            Trace.logError(TFCache.class, "Aliasing of semantic class '" + semanticType.getClassName() + "' failed.");
            this.removeInvalidSemanticType(semanticType.getTypeName());
            return false;
        }
        if (!semanticType.isValid()) {
            this.checkSerialVersionUID(semanticType, false);
            this.updateSemanticType(semanticType, true);
            Trace.logInfo(TFCache.class, "Semantic type [" + semanticType.getTypeName() + "] validated.");
        } else {
            this.checkSerialVersionUID(semanticType, true);
        }
        Trace.logDebug(TFCache.class, "Semantic type [" + semanticType.getTypeName() + "] aliased (for class '" + semanticType.getClassName() + "').");
        return false;
    }

    private void checkSerialVersionUID(SemanticType type, boolean withUpdate) throws Exception {
        if (type.getSerialVersionUID() == 9969000000302071L) {
            TFCache.setSerialVersionUID(type, 0L);
            if (withUpdate) {
                this.updateSemanticType(type);
            }
        }
    }

    void updateSemanticType(SemanticType type) throws Exception {
        Trace.logDebug(TFCache.class, "Updating semantic type [" + type.getTypeName() + "]...");
        this.allowedToXact();
        String pathInCache = this.getSemanticTypePathInCache(type.getTypeName());
        if (pathInCache == null) {
            ++this.Statistics.TypeMiss;
            throw new CacheMissException("Semantic type [" + type.getTypeName() + "] does not exist.");
        }
        try {
            if (this.xFactory.isAliased(type.getTypeName())) {
                this.xFactory.unalias(type.getTypeName());
            }
            this.xFactory.alias(type);
            this.updateEntity(pathInCache, this.getCacheFile(pathInCache), this.serialize(type));
        }
        catch (Exception exception) {
            if (exception instanceof TFCacheException) {
                throw exception;
            }
            throw new TFCacheException(exception);
        }
        Trace.logDebug(TFCache.class, "Semantic type [" + type.getTypeName() + "] updated.");
    }

    private void updateSemanticType(SemanticType type, boolean isValid) throws Exception {
        TFCache.setValid(type, isValid);
        this.updateSemanticType(type);
    }

    private void removeInvalidSemanticType(String typeName) throws TFCacheException, NamingException {
        String pathInCache = this.getSemanticTypePathInCache(typeName);
        this.createdByCache.remove(pathInCache);
        this.ownersTable.removeEntity(pathInCache);
        this.processJunk(pathInCache, CachedEntity.TYPE);
    }

    protected void unlockSubcontextArtifacts() throws TFCacheException, IllegalStateException, NamingException {
        try {
            for (String pathInCache : this.listObjects(false)) {
                this.closeCacheFile(pathInCache);
            }
            for (String cctx : this.listSubcontexts()) {
                ReferenceContext ctx = new ReferenceContext(this.getReferenceContext(), cctx);
                Trace.logDebug(TFCache.class, "Unlocking subcontext: " + ctx.getContextNameSpace());
                this.setReferenceContext(ctx);
                this.unlockSubcontextArtifacts();
            }
        }
        catch (Exception exception) {
            if (exception instanceof TFCacheException) {
                throw (TFCacheException)exception;
            }
            throw new TFCacheException(exception);
        }
        if (!this.getReferenceContext().isRoot()) {
            this.setReferenceContext(this.getReferenceContext().getParentContext());
        }
    }

    protected void unlockDirectoryTreeArtifacts() throws TFCacheException, IllegalStateException {
        try {
            for (String filename : this.listArtifacts(false)) {
                this.closeCacheFile(this.artifacts.getPathInCacheWithinContext(filename));
            }
            for (String dir : this.listDirectories()) {
                this.changeToDirectory(dir);
                Trace.logDebug(TFCache.class, "Unlocking sub-directory: " + dir);
                this.unlockDirectoryTreeArtifacts();
            }
        }
        catch (Exception exception) {
            if (exception instanceof TFCacheException) {
                throw (TFCacheException)exception;
            }
            throw new TFCacheException(exception);
        }
    }

    public boolean isCacheURL(URL url) {
        return url.getProtocol().equals("tfcache");
    }

    protected void checkCacheURL(URL url) throws TFCacheException {
        if (!this.isCacheURL(url)) {
            throw new TFCacheException("URL " + url.toExternalForm() + " does not belong to Runtime Cache.");
        }
    }

    protected void checkCachePath(String pathInCache) throws TFCacheException {
        if (new File(pathInCache).isAbsolute()) {
            throw new TFCacheException("Absolute paths are not allowed to access TFCache entities.");
        }
        if (pathInCache.startsWith(".." + File.separatorChar) || pathInCache.contains(File.separatorChar + ".." + File.separatorChar) || pathInCache.endsWith(File.separatorChar + "..")) {
            throw new TFCacheException("TFCache path should not contain '..' pseudo directory.");
        }
    }

    private String getPathInCache(URL url) throws TFCacheException {
        this.checkCacheURL(url);
        return StringUtils.trimSlashes(URLUtils.getFsPathByUrl(url));
    }

    public synchronized void lockEntity(URL url) throws TFCacheException {
        this.lockEntity(this.getPathInCache(url));
    }

    public synchronized void unlockEntity(URL url) throws TFCacheException {
        this.unlockEntity(this.getPathInCache(url));
    }

    public synchronized void lockEntity(String pathInCache) throws TFCacheException {
        pathInCache = this.normalizePathInCache(pathInCache);
        this.checkCachePath(pathInCache);
        this.requireExistsDistinctEntity(pathInCache, this.artifacts);
        File file = this.getFile(pathInCache);
        FileObject fileObject = this.lockTable.get(pathInCache);
        if (fileObject != null) {
            fileObject.lock();
        } else {
            if (!file.exists()) {
                throw new CacheMissException("Entity '" + pathInCache + "' does not exist.");
            }
            CachedEntity type = this.getEntityType(pathInCache);
            if (type != null) {
                this.openCacheFile(pathInCache, type);
            } else {
                throw new TFCacheException("Unknown entity type for '" + pathInCache + "'.");
            }
        }
    }

    public synchronized void unlockEntity(String pathInCache) throws TFCacheException {
        pathInCache = this.normalizePathInCache(pathInCache);
        this.checkCachePath(pathInCache);
        this.requireExistsDistinctEntity(pathInCache, this.artifacts);
        FileObject fileObject = this.lockTable.get(pathInCache);
        if (fileObject != null) {
            if (fileObject.getLockCounter() <= 0) {
                throw new TFCacheException("Entity '" + pathInCache + "' lock counter is in incorrect state.");
            }
            fileObject.unlock();
            if (fileObject.getLockCounter() == 0) {
                this.closeCacheFile(pathInCache);
            }
        } else {
            throw new CacheMissException("Entity '" + pathInCache + "' not in Lock Table.");
        }
    }

    protected void lockDirectoryTreeArtifacts() throws TFCacheException, IllegalStateException, NamingException {
        try {
            for (String artifact : this.listArtifacts(false)) {
                this.openCacheFile(artifact, CachedEntity.ARTIFACT);
            }
            for (String contextNamespace : this.listSubcontexts()) {
                ReferenceContext ctx = new ReferenceContext(this.getReferenceContext(), contextNamespace);
                Trace.logDebug(TFCache.class, "Locking sub-directory '" + ctx.getContextNameSpace() + "'...");
                this.setReferenceContext(ctx);
                this.lockDirectoryTreeArtifacts();
            }
        }
        catch (Exception exception) {
            if (exception instanceof TFCacheException) {
                throw (TFCacheException)exception;
            }
            throw new TFCacheException(exception);
        }
        if (!this.getReferenceContext().isRoot()) {
            this.setReferenceContext(this.getReferenceContext().getParentContext());
        }
    }

    protected void lockSubcontextArtifacts() throws TFCacheException, IllegalStateException, NamingException {
        try {
            for (String afs : this.listObjects(false)) {
                this.openCacheFile(afs, CachedEntity.OBJECT);
            }
            for (String cctx : this.listSubcontexts()) {
                ReferenceContext ctx = new ReferenceContext(this.getReferenceContext(), cctx);
                Trace.logDebug(TFCache.class, "Locking subcontext: " + ctx.getContextNameSpace());
                this.setReferenceContext(ctx);
                this.lockSubcontextArtifacts();
            }
        }
        catch (Exception exception) {
            if (exception instanceof TFCacheException) {
                throw (TFCacheException)exception;
            }
            throw new TFCacheException(exception);
        }
        if (!this.getReferenceContext().isRoot()) {
            this.setReferenceContext(this.getReferenceContext().getParentContext());
        }
    }

    public synchronized void init() throws TFCacheException, IllegalStateException {
        try {
            if (this.cacheLocationCanonicalFile.exists()) {
                throw new TFCacheException("Runtime Cache already exists at this location.");
            }
            this.checkNotLocked();
            Trace.logInfo(TFCache.class, "Initializing cache " + this.cacheLocationCanonicalFile.getPath());
            this.ownersTable.init();
            this.mkdirs(this.cacheLocationCanonicalFile);
            this.mkdirs(this.artifacts);
            this.mkdirs(this.objects);
            this.mkdirs(this.objects.getBaseDirName() + File.separatorChar + "sys" + File.separatorChar + "serializer");
            this.mkdirs(this.eMapDir);
            this.mkdirs(this.ext);
            Trace.logInfo(TFCache.class, " Creating Repository extensions..");
            this.mkdirs(this.packages);
            this.mkdirs(this.lib);
            this.mkdirs(this.types);
            this.mkdirs(this.globals);
            this.mkdirs(this.services);
            this.mkdirs(this.transportFactories);
            this.mkdirs(this.jdbcFactories);
            this.mkdirs(this.clientFactories);
            Trace.logInfo(TFCache.class, "Done.");
            this.raiseRepositoryStateChangeAdvisory(RepositoryState.INIT, "Runtime Cache initialized.");
        }
        catch (Exception exception) {
            if (exception instanceof TFCacheException) {
                throw (TFCacheException)exception;
            }
            throw new TFCacheException(exception);
        }
    }

    public synchronized void destroy() throws TFCacheException, IllegalStateException {
        if (!this.exists()) {
            throw new TFCacheException("Runtime Cache does not exist at this location. Nothing to destroy().");
        }
        if (this.isOpen()) {
            throw new IllegalStateException("Runtime Cache is currently open. Must be closed prior to calling destroy().", IllegalStateException.ErrorCode.CACHE_ALREADY_OPENED);
        }
        FileIOUtils.deleteFileDir(this.cacheLocationCanonicalFile);
        Trace.logInfo(TFCache.class, "Cache destroyed at location: " + this.cacheLocationCanonicalFile.getPath());
    }

    public synchronized void close() throws IllegalStateException {
        if (!this.isOpen()) {
            return;
        }
        if (RuntimeState.isActive()) {
            Trace.logInfo(TFCache.class, "Cache is in an Active runtime. Close ignored.");
            return;
        }
        Iterator<String> evFiles = this.getEvictionMap().getArtifacts();
        while (evFiles.hasNext()) {
            String file = evFiles.next();
            try {
                this.evict(file);
            }
            catch (Exception exception) {
                Trace.logException(this, exception, true);
            }
        }
        for (Map.Entry<String, FileObject> entry : this.lockTable.entrySet()) {
            try {
                this.unlock(entry.getKey(), entry.getValue());
            }
            catch (TFCacheException exception) {
                Trace.logException(TFCache.class, exception, true);
            }
        }
        Trace.logInfo(TFCache.class, "Closing cache " + this.cacheLocationCanonicalFile.getPath());
        this.ioThread.suspendMonitorAndWait();
        this.ioThread.stop();
        this.isOpened = false;
        this.raiseRepositoryStateChangeAdvisory(RepositoryState.CLOSED, "Runtime Cache closed.");
        Helper.unsetTFCache();
        SystemTableHelper.unsetTFCache();
    }

    private void unlock(String pathInCache, FileObject fileObject) throws TFCacheException {
        try {
            fileObject.lock.release();
            fileObject.file.close();
        }
        catch (Exception exception) {
            Trace.logException(SystemObjectsPersister.class, exception, true);
            throw new TFCacheException("Releasing and closing cached file '" + pathInCache + "' failed.");
        }
    }

    @Override
    public synchronized List<String> listPackages(boolean absolute) throws UtilitiesException, IllegalStateException {
        return this.list(this.packages, "*.pkg", absolute);
    }

    @Override
    public synchronized List<String> listQualifiedBindings() throws UtilitiesException, IllegalStateException {
        this.checkOpened();
        return FileIOUtils.directoryList(this.objects.getCurrentCanonicalFile().getPath(), "*.xdo", false).stream().map(binding -> binding.substring(0, binding.length() - 4)).collect(Collectors.toList());
    }

    @Override
    public synchronized List<String> listBindings(String typeFilter) throws UtilitiesException, IllegalStateException {
        this.checkOpened();
        ArrayList<String> result = new ArrayList<String>();
        for (String binding : FileIOUtils.directoryList(this.objects.getCurrentCanonicalFile().getPath(), "*.xdo", false)) {
            binding = binding.substring(0, binding.length() - 4);
            StringTokenizer st = new StringTokenizer(binding, ".");
            int nameTokens = st.countTokens();
            if (typeFilter != null && !typeFilter.equals("")) {
                binding = st.nextToken();
                if (!binding.equals(typeFilter)) continue;
                if (nameTokens == 2) {
                    binding = StringUtils.deNormalizeObjectName(st.nextToken());
                } else if (nameTokens == 1) {
                    binding = StringUtils.deNormalizeObjectName(binding);
                } else {
                    throw new UtilitiesException("Unexpected number of tokens (" + nameTokens + ") encountered in Binding Name for filter '" + typeFilter + "'.");
                }
                result.add(binding);
                continue;
            }
            if (nameTokens == 2) {
                st.nextToken();
                binding = StringUtils.deNormalizeObjectName(st.nextToken());
            } else if (nameTokens == 1) {
                binding = StringUtils.deNormalizeObjectName(st.nextToken());
            } else {
                throw new UtilitiesException("Unexpected number of tokens (" + nameTokens + ") encountered in Binding Name for filter '" + typeFilter + "'.");
            }
            result.add(binding);
        }
        return result;
    }

    protected synchronized List<String> listObjects(boolean absolute) throws UtilitiesException, IllegalStateException {
        return this.list(this.objects, "", absolute);
    }

    @Override
    public synchronized List<String> listArtifacts(boolean absolute) throws UtilitiesException, IllegalStateException {
        return this.list(this.artifacts, "", absolute);
    }

    public synchronized List<String> listFiles() {
        ArrayList<String> result = new ArrayList<String>();
        this.artifacts.getCurrentCanonicalFile().listFiles(pathname -> {
            if (pathname.isFile()) {
                result.add(pathname.getName());
            }
            return false;
        });
        return result;
    }

    private List<String> list(CacheSubDir subDir, String filter, boolean absolute) throws UtilitiesException, IllegalStateException {
        this.checkOpened();
        return FileIOUtils.directoryList(subDir.getCurrentCanonicalFile().getPath(), filter, absolute);
    }

    public synchronized List<String> listArchives(boolean absolute) throws UtilitiesException, IllegalStateException {
        return this.list(this.lib, "*.jar", absolute);
    }

    public synchronized List<String> listExtensionArchives(boolean absolute) throws UtilitiesException, IllegalStateException {
        return this.list(this.ext, "*.jar", absolute);
    }

    @Override
    public synchronized List<String> listServices(boolean absolute) throws UtilitiesException, IllegalStateException, TFCacheException {
        return this.list(this.services, "*.sco", absolute);
    }

    @Override
    public synchronized List<String> listTransportFactories(boolean absolute) throws UtilitiesException, IllegalStateException, TFCacheException {
        return this.list(this.transportFactories, "*.tfo", absolute);
    }

    @Override
    public synchronized List<String> listJDBCFactories(boolean absolute) throws UtilitiesException, IllegalStateException, TFCacheException {
        return this.list(this.jdbcFactories, "*.dfo", absolute);
    }

    @Override
    public synchronized List<String> listClientFactories(boolean absolute) throws UtilitiesException, IllegalStateException, TFCacheException {
        return this.list(this.clientFactories, "*.cfo", absolute);
    }

    @Override
    public synchronized List<String> listSemanticTypes(boolean absolute, boolean includeSystem) throws UtilitiesException, IllegalStateException, TFCacheException {
        this.checkOpened();
        ArrayList<String> result = new ArrayList<String>();
        List<String> allTypes = FileIOUtils.directoryList(this.types.getBaseCanonicalPath(), "*.type", absolute);
        if (absolute) {
            for (String string : allTypes) {
                String relativeName = string.substring(string.lastIndexOf(this.slash) + 1);
                if (includeSystem && relativeName.startsWith("sys.")) {
                    result.add(string);
                    continue;
                }
                if (relativeName.startsWith("sys.")) continue;
                result.add(string);
            }
        } else {
            for (String string : allTypes) {
                StringTokenizer st = new StringTokenizer(string, ".");
                if (includeSystem && string.startsWith("sys.")) {
                    String string3 = st.nextToken();
                    string3 = string3 + "." + st.nextToken();
                    result.add(string3);
                    continue;
                }
                if (string.startsWith("sys.")) continue;
                result.add(st.nextToken());
            }
        }
        return result;
    }

    @Override
    public synchronized List<String> listLibs(boolean absolute) throws UtilitiesException, IllegalStateException {
        return this.list(this.lib, "*.jar", absolute);
    }

    @Override
    public synchronized List<String> listExts(boolean absolute) throws UtilitiesException, IllegalStateException {
        return this.list(this.ext, "*.jar", absolute);
    }

    public synchronized List<URL> getArchiveURLs() throws TFCacheException, IllegalStateException {
        ArrayList<URL> archiveURLs = new ArrayList<URL>();
        try {
            for (String jarName : this.listLibs(false)) {
                archiveURLs.add(this.getArchiveURL(jarName));
            }
        }
        catch (Exception exception) {
            if (exception instanceof TFCacheException) {
                throw (TFCacheException)exception;
            }
            throw new TFCacheException(exception);
        }
        return archiveURLs;
    }

    @Override
    public synchronized List<URL> getExtensionURLs() throws TFCacheException, IllegalStateException {
        ArrayList<URL> extensionURLs = new ArrayList<URL>();
        try {
            for (String jarName : this.listExts(false)) {
                extensionURLs.add(this.getExtArchiveURL(jarName));
            }
        }
        catch (Exception exception) {
            if (exception instanceof TFCacheException) {
                throw (TFCacheException)exception;
            }
            throw new TFCacheException(exception);
        }
        return extensionURLs;
    }

    private Object deserializeEntity(RandomAccessFile raf, String xmlRoot) throws TFCacheException, IOException, SerializerException {
        raf.seek(0L);
        byte[] bytes = new byte[(int)raf.length()];
        raf.readFully(bytes);
        return this.deserialize(xmlRoot, bytes);
    }

    public boolean existsPackage(PackageType type, String typeName) throws TFCacheException, IllegalStateException, NamingException {
        return this.existsEntity(typeName, type.name(), ".pkg", CachedEntity.PACKAGE);
    }

    @Override
    public synchronized Package getPackage(PackageType type, String name) throws TFCacheException, IllegalStateException {
        return (Package)this.getXmlData(type.name(), name, ".pkg", this.packages, "Package");
    }

    public synchronized Package getPackageByArchive(String jarName) throws TFCacheException, IllegalStateException, NamingException {
        String pkgName = this.packages.getPackage(jarName);
        if (pkgName != null) {
            Pair<PackageType, String> parsedName = Package.parseFullName(pkgName);
            return this.getPackage((PackageType)((Object)parsedName.first), (String)parsedName.second);
        }
        return null;
    }

    @Override
    public synchronized void addPackage(Package pkg, File[] jars) throws TFCacheException, IllegalStateException {
        Trace.logInfo(TFCache.class, "Adding package '" + String.valueOf(pkg) + "' to runtime cache...");
        this.allowedToXact();
        try {
            String jarName;
            String pathInCache = this.packages.getPathInCacheWithinContext(pkg.getArtifactName());
            if (this.existsDistinctEntityErrorIfDiffCase(pathInCache)) {
                throw new TFCacheException("Package '" + String.valueOf(pkg) + "' already exists.");
            }
            List<String> pkgJars = pkg.listJARs();
            for (File jarFile : jars) {
                jarName = jarFile.getName();
                if (!pkgJars.contains(jarName)) {
                    throw new TFCacheException("Package '" + String.valueOf(pkg) + "' does not contain archive '" + jarName + "'.");
                }
                if (!jarFile.exists()) {
                    throw new TFCacheException("Archive '" + jarFile.getAbsolutePath() + "' does not exist.");
                }
                if (!this.existsDistinctEntityErrorIfDiffCase(this.ext.getPathInCacheWithinContext(jarName))) continue;
                throw new TFCacheException("Extension archive '" + jarName + "' already exists.");
            }
            this.packages.checkPackage(pkg);
            for (File jarFile : jars) {
                jarName = jarFile.getName();
                if (this.existsDistinctEntityErrorIfDiffCase(this.lib.getPathInCacheWithinContext(jarName))) {
                    this.removeArchive(jarName, true);
                }
                this.addArchive(jarFile);
            }
            this.updateEntity(pathInCache, this.openCacheFile(pathInCache, CachedEntity.PACKAGE), this.serialize(pkg));
            this.packages.addPackage(pkg);
            this.raiseRepositoryArtifactChangeAdvisory(Severity.INFO, pathInCache, CachedEntity.PACKAGE, ArtifactState.CREATED, "Package '" + String.valueOf(pkg) + "' added.");
        }
        catch (Exception exception) {
            if (exception instanceof TFCacheException) {
                throw (TFCacheException)exception;
            }
            throw new TFCacheException(exception);
        }
    }

    public synchronized void addPackage(Package pkg) throws TFCacheException, IllegalStateException {
        Trace.logDebug(TFCache.class, "Adding package '" + String.valueOf(pkg) + "' to runtime cache...");
        this.allowedToXact();
        String pathInCache = this.packages.getPathInCacheWithinContext(pkg.getArtifactName());
        if (this.existsDistinctEntity(pathInCache)) {
            throw new TFCacheException("Package '" + String.valueOf(pkg) + "' already exists.");
        }
        this.checkPackage(pkg);
        try {
            this.updateEntity(pathInCache, this.openCacheFile(pathInCache, CachedEntity.PACKAGE), this.serialize(pkg));
            this.packages.addPackage(pkg);
            this.raiseRepositoryArtifactChangeAdvisory(Severity.INFO, pathInCache, CachedEntity.PACKAGE, ArtifactState.CREATED, "Package '" + String.valueOf(pkg) + "' added.");
        }
        catch (Exception exception) {
            if (exception instanceof TFCacheException) {
                throw (TFCacheException)exception;
            }
            throw new TFCacheException(exception);
        }
    }

    public synchronized void updatePackage(Package pkg, boolean withCheck) throws TFCacheException, IllegalStateException {
        Trace.logDebug(TFCache.class, "Updating package '" + String.valueOf(pkg) + "' in runtime cache...");
        this.allowedToXact();
        String pathInCache = this.packages.getPathInCacheWithinContext(pkg.getArtifactName());
        if (!this.existsDistinctEntity(pathInCache)) {
            ++this.Statistics.PkgMiss;
            throw new CacheMissException("Package '" + String.valueOf(pkg) + "' does not exist.");
        }
        if (withCheck) {
            this.checkPackage(pkg);
        }
        try {
            Package oldPackage = this.getPackage(pkg.getType(), pkg.getName());
            this.updateEntity(pathInCache, this.getCacheFile(pathInCache), this.serialize(pkg));
            this.packages.removePackage(oldPackage);
            this.packages.addPackage(pkg);
            this.raiseRepositoryArtifactChangeAdvisory(Severity.INFO, pathInCache, CachedEntity.PACKAGE, ArtifactState.UPDATED, "Package '" + String.valueOf(pkg) + "' changed.");
        }
        catch (Exception exception) {
            if (exception instanceof TFCacheException) {
                throw (TFCacheException)exception;
            }
            throw new TFCacheException(exception);
        }
    }

    boolean isPackageValid(Package pkg) throws TFCacheException {
        for (String jar : pkg.listJARs()) {
            if (this.existsDistinctEntityErrorIfDiffCase(this.lib.getPathInCacheWithinContext(jar))) continue;
            return false;
        }
        return true;
    }

    private void checkPackage(Package pkg) throws TFCacheException {
        for (String jar : pkg.listJARs()) {
            if (this.existsDistinctEntityErrorIfDiffCase(this.lib.getPathInCacheWithinContext(jar))) continue;
            this.throwInvalidPackage(pkg, "Archive '" + jar + "' does not exist.");
        }
        this.packages.checkPackage(pkg);
        TFCache.setDirty(pkg, false);
    }

    @Override
    public synchronized void forcePackage(String pkgName, PackageType pkgType, boolean withJars) throws TFCacheException, IllegalStateException {
        Trace.logInfo(TFCache.class, "Removing package '" + pkgType.name() + "." + pkgName + "' from repository...");
        this.allowedToXact();
        if (!this.existsDistinctEntity(this.packages.getPathInCacheWithinContext(pkgType.name() + "." + pkgName + ".pkg"))) {
            ++this.Statistics.PkgMiss;
            throw new CacheMissException("Package Artifact '" + pkgType.name() + "." + pkgName + ".pkg' does not exist.");
        }
        Package pkg = this.getPackage(pkgType, pkgName);
        String pkgPathInCache = this.packages.getPathInCacheWithinContext(pkg.getArtifactName());
        this.closeCacheFile(pkgPathInCache);
        this.getFile(pkgPathInCache).delete();
        this.ownersTable.removeEntity(pkgPathInCache);
        this.createdByCache.remove(pkgPathInCache);
        this.packages.removePackage(pkg);
        if (withJars) {
            for (String jar : pkg.listJARs()) {
                if (!this.existsDistinctEntity(this.lib.getPathInCacheWithinContext(jar))) continue;
                this.removeArchive(jar, true);
            }
        }
        this.raiseRepositoryArtifactChangeAdvisory(Severity.INFO, pkgPathInCache, CachedEntity.PACKAGE, ArtifactState.DESTROYED, "Package '" + String.valueOf(pkg) + "' removed.", true);
    }

    @Override
    public synchronized boolean existsBinding(String name) throws TFCacheException, IllegalStateException {
        try {
            return this.listBindings(null).contains(name);
        }
        catch (UtilitiesException exception) {
            throw new TFCacheException(exception);
        }
    }

    @Override
    public void putArtifact(File file, String name, long expiration) throws TFCacheException, IllegalStateException {
        this.putArtifact(file, name, expiration, false);
    }

    public synchronized void putArtifact(File file, String name, long expiration, boolean isAppend) throws TFCacheException, IllegalStateException {
        if (name == null) {
            name = file.getName();
        }
        Trace.logDebug(TFCache.class, "Put runtime cache artifact '" + name + "'...");
        this.allowedToXact();
        try {
            RandomAccessFile artifact = new RandomAccessFile(file, "rw");
            FileChannel afc = artifact.getChannel();
            Trace.logDebug(TFCache.class, "Acquiring a lock on file resource: " + file.getAbsolutePath());
            FileLock flock = afc.lock();
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(artifact.getFD()));
            byte[] bytes = new byte[(int)file.length()];
            bis.read(bytes);
            flock.release();
            artifact.close();
            bis.close();
            this.putArtifact(bytes, name, expiration, isAppend);
        }
        catch (Exception exception) {
            if (exception instanceof TFCacheException) {
                throw (TFCacheException)exception;
            }
            throw new TFCacheException(exception);
        }
    }

    public void putArtifact(InputStream stream, int size, String name, long expiration) throws TFCacheException, IllegalStateException {
        this.putArtifact(stream, size, name, expiration, false);
    }

    public synchronized void putArtifact(final InputStream stream, final int size, String name, long expiration, boolean isAppend) throws TFCacheException, IllegalStateException {
        this.putData(name, "", this.artifacts, expiration, isAppend, new ArtifactDataCallback(this){

            @Override
            public byte[] getBytes() throws TFCacheException {
                return null;
            }

            @Override
            public InputStream getStream() {
                return stream;
            }

            @Override
            public int getStreamSize() {
                return size;
            }
        });
    }

    @Override
    public void putArtifact(byte[] data, String name, long expiration) throws TFCacheException, IllegalStateException {
        this.putArtifact(data, name, expiration, false);
    }

    public synchronized void putArtifact(final byte[] data, String name, long expiration, boolean isAppend) throws TFCacheException, IllegalStateException {
        this.putData(name, "", this.artifacts, expiration, isAppend, new ArtifactDataCallback(this){

            @Override
            public byte[] getBytes() throws TFCacheException {
                return data;
            }

            @Override
            public InputStream getStream() {
                return null;
            }

            @Override
            public int getStreamSize() {
                return 0;
            }
        });
    }

    private void putObject(final byte[] data, String name, long expiration) throws TFCacheException, IllegalStateException {
        this.putData(name, "", this.objects, expiration, new BytesPutDataCallback(){

            @Override
            public byte[] getBytes() throws TFCacheException {
                return data;
            }

            @Override
            public void checkNames() throws TFCacheException {
            }

            @Override
            public void success(String name, String pathInCache, ArtifactState state, String action) throws TFCacheException, IllegalStateException {
                ReferenceContext ctx = TFCache.this.getReferenceContext();
                TFCache.this.raiseRepositoryArtifactChangeAdvisory(Severity.INFO, pathInCache, CachedEntity.OBJECT, state, "Object '" + ctx.getContextNameSpace() + (ctx.isRoot() ? "" : "/") + name + "' " + action + ".", true);
            }
        });
    }

    @Override
    public synchronized byte[] getArtifact(String name) throws TFCacheException, IllegalStateException {
        return this.getData(name, "", this.artifacts);
    }

    public synchronized void getArtifact(String name, OutputStream stream) throws TFCacheException, IllegalStateException {
        this.getData(name, "", this.artifacts, stream);
    }

    @Override
    public synchronized RandomAccessFile getEntityAsFile(String name, CachedEntity type) throws TFCacheException, IllegalStateException {
        return this.getEntityAsFile(name, this.subDirByType.get((Object)type));
    }

    private synchronized RandomAccessFile getEntityAsFile(String name, CacheSubDir subDir) throws TFCacheException, IllegalStateException {
        return this.doGetEntityAsFile(name, subDir, name);
    }

    private synchronized RandomAccessFile getEntityAsFile(String entityName, String extension, CacheSubDir subDir) throws TFCacheException, IllegalStateException {
        return this.doGetEntityAsFile(entityName + extension, subDir, entityName);
    }

    private synchronized RandomAccessFile doGetEntityAsFile(String fullName, CacheSubDir subDir, String entityName) throws TFCacheException, IllegalStateException {
        this.allowedToXact();
        if (!this.existsDistinctEntity(fullName, subDir)) {
            subDir.incMiss();
            throw new CacheMissException(subDir.getType().toLabel() + " '" + entityName + "' does not exist.");
        }
        return this.getCacheFile(subDir.getPathInCacheWithinContext(fullName));
    }

    public synchronized RandomAccessFile getJar(String pathInCache) throws TFCacheException, IllegalStateException {
        CacheSubDir subDir = this.getSubDir(pathInCache = this.normalizePathInCache(pathInCache));
        if (subDir == this.lib || subDir == this.ext) {
            this.requireExistsDistinctEntity(pathInCache, subDir);
            return this.getCacheFile(pathInCache);
        }
        throw new TFCacheException(pathInCache + " is not in 'jar' or 'ext' location.");
    }

    public synchronized RandomAccessFile getEntityAsFile(String pathInCache) throws TFCacheException, IllegalStateException {
        if (new File(pathInCache).isAbsolute()) {
            throw new TFCacheException("Absolute paths are not allowed to access TFCache entities.");
        }
        this.allowedToXact();
        pathInCache = this.normalizePathInCache(pathInCache);
        this.requireExistsDistinctEntity(pathInCache, this.artifacts);
        return this.getCacheFile(pathInCache);
    }

    private void putData(String entityName, String extension, CacheSubDir subDir, long expiration, PutDataCallback provider) throws TFCacheException, IllegalStateException {
        this.putData(entityName, extension, subDir, expiration, false, provider);
    }

    private void putData(String entityName, String extension, CacheSubDir subDir, long expiration, boolean isAppend, PutDataCallback provider) throws TFCacheException, IllegalStateException {
        String filename = entityName + extension;
        String pathInCache = subDir.getPathInCacheWithinContext(filename);
        switch (subDir.getType()) {
            case ARTIFACT: 
            case OBJECT: {
                Trace.logDebug(TFCache.class, "Caching " + subDir.getType().toLabel() + " '" + pathInCache + "'...");
                break;
            }
            default: {
                Trace.logDebug(TFCache.class, "Caching " + subDir.getType().toLabel() + " '" + filename + "'...");
            }
        }
        this.allowedToXact();
        provider.checkNames();
        boolean exists = this.existsDistinctEntityErrorIfDiffCase(pathInCache);
        try {
            RandomAccessFile artifact;
            RandomAccessFile randomAccessFile = artifact = exists ? this.getCacheFile(pathInCache) : this.openCacheFile(pathInCache, subDir.getType());
            if (isAppend) {
                if (provider.getBytes() != null) {
                    this.appendEntity(pathInCache, artifact, provider.getBytes());
                } else {
                    this.appendEntity(pathInCache, artifact, provider.getStream(), provider.getStreamSize());
                }
            } else if (provider.getBytes() != null) {
                this.updateEntity(pathInCache, artifact, provider.getBytes());
            } else {
                this.updateEntity(pathInCache, artifact, provider.getStream(), provider.getStreamSize());
            }
            if (expiration > 0L) {
                Date ts = new Date(System.currentTimeMillis() + expiration);
                this.evictionMap.addArtifact(pathInCache, ts);
                Trace.logDebug(TFCache.class, subDir.getType().toLabel() + " '" + pathInCache + "' will expire at " + String.valueOf(ts) + ".");
                this.saveEvictionMap();
            }
        }
        catch (Exception exception) {
            if (exception instanceof TFCacheException) {
                throw (TFCacheException)exception;
            }
            throw new TFCacheException(exception);
        }
        provider.success(entityName, pathInCache, exists ? ArtifactState.UPDATED : ArtifactState.CREATED, exists ? "modified" : "added");
    }

    private void putData(String typeName, String instanceName, String extension, CacheSubDir subDir, long expiration, DataProvider dataProvider) throws TFCacheException, IllegalStateException {
        this.putData(typeName, instanceName, extension, subDir, expiration, false, dataProvider);
    }

    private void putData(final String typeName, final String instanceName, String extension, final CacheSubDir subDir, long expiration, boolean isAppend, final DataProvider dataProvider) throws TFCacheException, IllegalStateException {
        this.putData(typeName + "." + instanceName, extension, subDir, expiration, isAppend, new BytesPutDataCallback(){

            @Override
            public byte[] getBytes() throws TFCacheException {
                return dataProvider.getBytes();
            }

            @Override
            public void checkNames() throws TFCacheException {
                TFCache.checkNames(instanceName, typeName);
            }

            @Override
            public void success(String name, String pathInCache, ArtifactState state, String action) throws TFCacheException, IllegalStateException {
                TFCache.this.raiseRepositoryArtifactChangeAdvisory(Severity.INFO, pathInCache, subDir.getType(), state, "Configuration '" + typeName + "." + instanceName + "' " + action + ".", true);
            }
        });
    }

    private void putXmlData(String typeName, String instanceName, String extension, CacheSubDir subDir, long expiration, final Object object) throws TFCacheException, IllegalStateException {
        this.putData(typeName, instanceName, extension, subDir, expiration, new BytesDataProvider(){

            @Override
            public byte[] getBytes() throws TFCacheException {
                try {
                    return TFCache.this.serialize(object);
                }
                catch (Exception exception) {
                    throw new TFCacheException(exception);
                }
            }
        });
    }

    private void putXmlData(final String entityName, String extension, final CacheSubDir subDir, long expiration, final Object object) throws TFCacheException, IllegalStateException {
        this.putData(entityName, extension, subDir, expiration, new BytesPutDataCallback(){

            @Override
            public byte[] getBytes() throws TFCacheException {
                try {
                    return TFCache.this.serialize(object);
                }
                catch (Exception exception) {
                    throw new TFCacheException(exception);
                }
            }

            @Override
            public void checkNames() throws TFCacheException {
                TFCache.checkName(entityName);
            }

            @Override
            public void success(String name, String pathInCache, ArtifactState state, String action) throws TFCacheException, IllegalStateException {
                TFCache.this.raiseRepositoryArtifactChangeAdvisory(Severity.INFO, pathInCache, subDir.getType(), state, "Configuration '" + name + "' " + action + ".", true);
            }
        });
    }

    private byte[] getData(String entityName, String extension, CacheSubDir subDir) throws TFCacheException, IllegalStateException {
        return TFCache.getFileContent(this.getEntityAsFile(entityName, extension, subDir));
    }

    private static byte[] getFileContent(RandomAccessFile raf) throws TFCacheException {
        try {
            byte[] bytes = new byte[(int)raf.length()];
            raf.readFully(bytes);
            return bytes;
        }
        catch (IOException exception) {
            throw new TFCacheException(exception);
        }
    }

    private byte[] getData(String typeName, String instanceName, String extension, CacheSubDir subDir) throws TFCacheException, IllegalStateException {
        return this.getData(typeName + "." + instanceName, extension, subDir);
    }

    private void getData(String entityName, String extension, CacheSubDir subDir, OutputStream stream) throws TFCacheException, IllegalStateException {
        try {
            RandomAccessFile artifact = this.getEntityAsFile(entityName, extension, subDir);
            FileIOUtils.copyLarge(artifact, stream);
        }
        catch (UtilitiesException exception) {
            throw new TFCacheException(exception);
        }
    }

    private Object getXmlData(String entityName, String extension, CacheSubDir subDir, String xmlRoot) throws TFCacheException, IllegalStateException {
        byte[] bytes = this.getData(entityName, extension, subDir);
        try {
            return this.deserialize(xmlRoot, bytes);
        }
        catch (SerializerException exception) {
            throw new TFCacheException(exception);
        }
    }

    private Object getXmlData(String typeName, String instanceName, String extension, CacheSubDir subDir, String xmlRoot) throws TFCacheException, IllegalStateException {
        return this.getXmlData(typeName + "." + instanceName, extension, subDir, xmlRoot);
    }

    @Override
    public synchronized void putJDBCFactory(JDBCFactory dfo, long expiration) throws TFCacheException, IllegalStateException {
        this.putXmlData(dfo.getFactoryType(), dfo.getFactoryName(), ".dfo", this.jdbcFactories, expiration, dfo);
    }

    public synchronized void putJDBCFactoryXml(String factoryName, String factoryType, byte[] xDoc, long expiration, boolean validate) throws TFCacheException, IllegalStateException, SerializerException {
        if (validate) {
            this.deserialize("JDBCFactory", xDoc);
        }
        this.putData(factoryType, factoryName, ".dfo", this.jdbcFactories, expiration, new SimpleDataProvider(xDoc));
    }

    @Override
    public synchronized JDBCFactory getJDBCFactory(String factoryName, String factoryType) throws TFCacheException, IllegalStateException {
        return (JDBCFactoryObject)this.getXmlData(factoryType, factoryName, ".dfo", this.jdbcFactories, "JDBCFactory");
    }

    public synchronized String getJDBCFactoryXml(String factoryName, String factoryType) throws TFCacheException, IllegalStateException {
        return new String(this.getData(factoryType, factoryName, ".dfo", this.jdbcFactories));
    }

    @Override
    public synchronized void putClientFactory(ClientFactory cfo, long expiration) throws TFCacheException, IllegalStateException {
        this.putXmlData(cfo.getFactoryType(), cfo.getFactoryName(), ".cfo", this.clientFactories, expiration, cfo);
    }

    public synchronized void putClientFactoryXml(String factoryName, String factoryType, byte[] xDoc, long expiration, boolean validate) throws TFCacheException, IllegalStateException, SerializerException {
        if (validate) {
            this.deserialize("ClientFactory", xDoc);
        }
        this.putData(factoryType, factoryName, ".cfo", this.clientFactories, expiration, new SimpleDataProvider(xDoc));
    }

    @Override
    public synchronized ClientFactory getClientFactory(String factoryName, String factoryType) throws TFCacheException, IllegalStateException {
        return (ClientFactory)this.getXmlData(factoryType, factoryName, ".cfo", this.clientFactories, "ClientFactory");
    }

    public synchronized String getClientFactoryXml(String factoryName, String factoryType) throws TFCacheException, IllegalStateException {
        return new String(this.getData(factoryType, factoryName, ".cfo", this.clientFactories));
    }

    @Override
    public synchronized void putTransportFactory(TransportFactory tfo, long expiration) throws TFCacheException, IllegalStateException {
        this.putXmlData(tfo.getFactoryType(), tfo.getFactoryName(), ".tfo", this.transportFactories, expiration, tfo);
    }

    public synchronized void putTransportFactoryXml(String factoryName, String factoryType, byte[] xDoc, long expiration, boolean validate) throws TFCacheException, IllegalStateException, SerializerException {
        if (validate) {
            this.deserialize("TransportFactory", xDoc);
        }
        this.putData(factoryType, factoryName, ".tfo", this.transportFactories, expiration, new SimpleDataProvider(xDoc));
    }

    @Override
    public synchronized TransportFactory getTransportFactory(String factoryName, String factoryType) throws TFCacheException, IllegalStateException {
        return (TransportFactory)this.getXmlData(factoryType, factoryName, ".tfo", this.transportFactories, "TransportFactory");
    }

    public synchronized String getTransportFactoryXml(String factoryName, String factoryType) throws TFCacheException, IllegalStateException {
        return new String(this.getData(factoryType, factoryName, ".tfo", this.transportFactories));
    }

    @Override
    public synchronized void addArchive(File jar) throws TFCacheException, IllegalStateException {
        this.doAddArchive(jar.getName(), jar, null, false);
    }

    public void addArchive(String jarName, byte[] jarContent) throws TFCacheException, IllegalStateException {
        this.doAddArchive(jarName, null, jarContent, false);
    }

    @Override
    public List<SemanticType> addExtensionArchive(File jar) throws TFCacheException, IllegalStateException {
        return this.doAddArchive(jar.getName(), jar, null, true);
    }

    public List<SemanticType> addExtensionArchive(String jarName, byte[] jarContent) throws TFCacheException, IllegalStateException {
        return this.doAddArchive(jarName, null, jarContent, true);
    }

    private synchronized List<SemanticType> doAddArchive(String jarName, File jarFile, byte[] jarContent, boolean extension) throws TFCacheException, IllegalStateException {
        List<SemanticType> result = null;
        String entity = (extension ? "extension " : "") + "archive";
        Trace.logInfo(TFCache.class, "Adding " + entity + " '" + (jarFile != null ? jarFile.getAbsolutePath() : jarName) + "' to repository...");
        this.allowedToXact();
        if (this.existsDistinctEntityErrorIfDiffCase(this.ext.getPathInCacheWithinContext(jarName))) {
            throw new TFCacheException("Extension archive '" + jarName + "' already exists.");
        }
        if (this.existsDistinctEntityErrorIfDiffCase(this.lib.getPathInCacheWithinContext(jarName))) {
            throw new TFCacheException("Archive '" + jarName + "' already exists.");
        }
        try {
            CacheSubDir subDir = extension ? this.ext : this.lib;
            String pathInCache = subDir.getPathInCacheWithinContext(jarName);
            this.createdByCache.add(pathInCache);
            if (jarFile != null) {
                FileIOUtils.copyFileDir(jarFile, new File(subDir.getBaseCanonicalFile(), jarName));
            } else {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(jarContent);
                FileOutputStream outputStream = new FileOutputStream(new File(subDir.getBaseCanonicalFile(), jarName));
                FileIOUtils.copyLarge(inputStream, (OutputStream)outputStream);
                ((InputStream)inputStream).close();
                ((OutputStream)outputStream).close();
            }
            this.openCacheFile(pathInCache, subDir.type);
            if (extension) {
                Trace.logInfo(TFCache.class, "Extension archive added and will be auto-loaded.");
                result = this.addToExtClassLoader(jarName, this.getExtArchiveURL(jarName));
            }
            this.ownersTable.createNewEntityInfo(pathInCache, null, 0L, this.getCurrentUser());
            this.raiseRepositoryArtifactChangeAdvisory(Severity.INFO, pathInCache, subDir.getType(), ArtifactState.CREATED, StringUtils.toCapitalized(entity) + " '" + jarName + "' added.", extension);
        }
        catch (Exception exception) {
            if (exception instanceof TFCacheException) {
                throw (TFCacheException)exception;
            }
            throw new TFCacheException(exception);
        }
        return result;
    }

    @Override
    public synchronized void removeSemanticType(String typeName) throws TFCacheException, IllegalStateException, NamingException {
        Trace.logDebug(TFCache.class, "Removing semantic type '" + typeName + "'...");
        this.allowedToXact();
        String pathInCache = this.getSemanticTypePathInCache(typeName);
        if (pathInCache == null) {
            ++this.Statistics.TypeMiss;
            throw new CacheMissException("Semantic type '" + typeName + "' does not exist.");
        }
        if (this.existsTypeInNamespace("/", typeName)) {
            throw new TFCacheException("Semantic type '" + typeName + "' has bound instances and may not be removed.");
        }
        this.evict(pathInCache);
        this.raiseRepositoryArtifactChangeAdvisory(Severity.INFO, pathInCache, CachedEntity.TYPE, ArtifactState.DESTROYED, "Semantic type '" + typeName + "' has been removed.", true);
        Trace.logInfo(TFCache.class, "Semantic type '" + typeName + "' removed.");
    }

    private String getSemanticTypePathInCache(String typeName) throws TFCacheException {
        TFCache.checkName(typeName);
        String result = this.types.getPathInCacheWithinContext(typeName + ".type");
        return this.existsDistinctEntity(result) ? result : null;
    }

    @Override
    public synchronized boolean existsTypeInNamespace(String namespace, String typeName) throws IllegalStateException, TFCacheException, NamingException {
        boolean exists = false;
        this.checkOpened();
        ReferenceContext oldCtx = this.getReferenceContext();
        ReferenceContext currentCtx = this.lookupReferenceContext(namespace);
        this.setReferenceContext(currentCtx);
        for (String sub : this.listSubcontexts()) {
            boolean contains = this.existsTypeInNamespace(sub, typeName);
            if (exists) continue;
            exists = contains;
        }
        try {
            for (String bind : this.listQualifiedBindings()) {
                if (!bind.startsWith(typeName + ".")) continue;
                exists = true;
                Trace.logDebug(TFCache.class, "Found a bound '" + typeName + "' instance: " + bind + ".");
            }
        }
        catch (Exception exception) {
            this.setReferenceContext(oldCtx);
            throw new TFCacheException(exception);
        }
        this.setReferenceContext(oldCtx);
        return exists;
    }

    private void removeEntity(String label, CacheSubDir subDir, String entityName, boolean force) throws TFCacheException, IllegalStateException {
        block8: {
            String capLabel = StringUtils.toCapitalized(label);
            String pathInSubDir = subDir.getPathInSubDirWithinContext(entityName);
            Trace.logDebug(TFCache.class, "Removing " + label + " '" + entityName + "' from cache...");
            this.allowedToXact();
            try {
                File file = subDir.getFileWithinContext(entityName);
                String pathInCache = subDir.getPathInCacheWithinContext(entityName);
                ReferenceContext ctx = this.getReferenceContext();
                if (ctx.getContextNameSpace().startsWith("/sys") && !this.isAdmin) {
                    throw new SecurityViolationException(4019, "System area '" + ctx.getContextNameSpace() + "' can only be modified by administrator.");
                }
                if (this.existsDistinctEntity(pathInCache) && file.exists()) {
                    if (force) {
                        this.evict(pathInCache);
                    } else if (!file.delete()) {
                        throw new TFCacheException(capLabel + " '" + pathInSubDir + "' is in use and can not be removed.");
                    }
                    break block8;
                }
                subDir.incMiss();
                throw new CacheMissException(capLabel + " '" + pathInSubDir + "' does not exist.");
            }
            catch (Exception exception) {
                if (exception instanceof TFCacheException) {
                    throw (TFCacheException)exception;
                }
                throw new TFCacheException(exception);
            }
        }
    }

    protected FileObject unlockEntityFile(String pathInCache) throws TFCacheException {
        FileObject fileObject = this.lockTable.get(pathInCache);
        if (fileObject != null) {
            try {
                fileObject.lock.release();
                fileObject.file.close();
            }
            catch (Exception exception) {
                Trace.logException(SystemObjectsPersister.class, exception, true);
                throw new TFCacheException("Releasing or closing cached file '" + pathInCache + "' failed.");
            }
        }
        return fileObject;
    }

    protected boolean restoreFileObject(FileObject fileObject, File file, String pathInCache) {
        try {
            fileObject.file = new RandomAccessFile(file, "rw");
            fileObject.lock = fileObject.file.getChannel().lock();
            return true;
        }
        catch (Exception exception) {
            Trace.logException(TFCache.class, exception, true);
            try {
                this.closeCacheFile(pathInCache);
            }
            catch (TFCacheException ex2) {
                Trace.logException(TFCache.class, ex2, true);
            }
            return false;
        }
    }

    private void restoreFileObjects(List<Pair<String, FileObject>> fileObjects, String basePathInCache) {
        for (Pair<String, FileObject> pair : fileObjects) {
            if (pair.second == null) continue;
            Object filePathInCache = ((String)pair.first).length() > 0 ? basePathInCache + File.separator + (String)pair.first : basePathInCache;
            this.restoreFileObject((FileObject)pair.second, this.getFile((String)filePathInCache), (String)filePathInCache);
        }
    }

    private void deepUnlockEntityFile(List<Pair<String, FileObject>> fileObjects, String basePathInCache, String pathInBase) throws TFCacheException {
        String path = basePathInCache + (String)(pathInBase.length() > 0 ? File.separator + pathInBase : "");
        File[] files = this.getFile(path).listFiles();
        if (files == null) {
            throw new TFCacheException("Obtaining list of files in '" + path + "' failed due to I/O error.");
        }
        for (File file : files) {
            String filePathInBase = (String)(pathInBase.length() > 0 ? pathInBase + File.separator : "") + file.getName();
            if (file.isDirectory()) {
                this.deepUnlockEntityFile(fileObjects, basePathInCache, filePathInBase);
                fileObjects.add(new Pair<CallSite, Object>((CallSite)((Object)filePathInBase), null));
                continue;
            }
            fileObjects.add(new Pair<CallSite, FileObject>((CallSite)((Object)filePathInBase), this.unlockEntityFile(basePathInCache + File.separator + filePathInBase)));
        }
    }

    private void renameEntity(String label, CacheSubDir subDir, String oldName, String newName) throws TFCacheException, IllegalStateException {
        String capLabel = StringUtils.toCapitalized(label);
        String oldPathInSubDir = subDir.getPathInSubDirWithinContext(oldName);
        String newPathInSubDir = subDir.getPathInSubDirWithinContext(newName);
        this.allowedToXact();
        String oldPathInCache = subDir.getPathInCacheWithinContext(oldName);
        String newPathInCache = subDir.getPathInCacheWithinContext(newName);
        File oldFile = this.getFile(oldPathInCache);
        File newFile = this.getFile(newPathInCache);
        if (!this.existsDistinctEntity(oldPathInCache) || !oldFile.exists()) {
            subDir.incMiss();
            throw new CacheMissException(capLabel + " '" + oldPathInSubDir + "' does not exist.");
        }
        if (this.ownersTable.getPathInExactCase(newPathInCache) != null || newFile.exists()) {
            throw new TFCacheException(capLabel + " '" + newName + "' already exists");
        }
        ArrayList<Pair<String, FileObject>> fileObjects = new ArrayList<Pair<String, FileObject>>();
        if (oldFile.isDirectory()) {
            fileObjects.add(new Pair<String, Object>("", null));
            this.deepUnlockEntityFile(fileObjects, oldPathInCache, "");
        } else {
            fileObjects.add(new Pair<String, FileObject>("", this.unlockEntityFile(oldPathInCache)));
        }
        if (oldFile.renameTo(newFile)) {
            for (Pair pair : fileObjects) {
                String appendPath = ((String)pair.first).length() > 0 ? File.separator + (String)pair.first : "";
                String oldPath = oldPathInCache + appendPath;
                String newPath = newPathInCache + appendPath;
                this.createdByCache.remove(oldPath);
                this.createdByCache.add(newPath);
                if (pair.second == null) continue;
                this.lockTable.remove(oldPath);
                if (!this.restoreFileObject((FileObject)pair.second, this.getFile(newPath), newPath)) continue;
                this.lockTable.put(newPath, (FileObject)pair.second);
            }
        } else {
            this.restoreFileObjects(fileObjects, oldPathInCache);
            throw new TFCacheException("Renaming '" + oldPathInCache + " to '" + newPathInCache + "' failed.");
        }
        this.ownersTable.rename(oldPathInCache, newPathInCache);
        this.raiseRepositoryArtifactChangeAdvisory(Severity.INFO, oldPathInCache, subDir.getType(), ArtifactState.CHANGED, capLabel + " '" + oldPathInSubDir + "' renamed to '" + newPathInSubDir + "'.");
    }

    @Override
    public void removeArchive(String jarName, boolean force) throws TFCacheException, IllegalStateException {
        this.doRemoveArchive(jarName, force, false);
    }

    @Override
    public List<SemanticType> removeExtensionArchive(String jarName, boolean force) throws TFCacheException, IllegalStateException {
        return this.doRemoveArchive(jarName, force, true);
    }

    synchronized List<SemanticType> doRemoveArchive(String jarName, boolean force, boolean extension) throws TFCacheException, IllegalStateException {
        List<SemanticType> result = null;
        CacheSubDir subDir = extension ? this.ext : this.lib;
        String entity = (extension ? "extension " : "") + "archive";
        Trace.logInfo(TFCache.class, "Removing " + entity + " '" + jarName + "' from repository...");
        String pathInCache = subDir.getPathInCacheWithinContext(jarName);
        File file = subDir.getFileWithinContext(jarName);
        if (this.existsDistinctEntity(pathInCache) && file.exists()) {
            try {
                if (extension) {
                    result = this.removeFromExtClassLoader(jarName, force);
                }
            }
            catch (Exception exception) {
                if (exception instanceof TFCacheException) {
                    throw (TFCacheException)exception;
                }
                throw new TFCacheException(exception);
            }
            if (this.lockTable.containsKey(pathInCache)) {
                this.removeEntity(entity, subDir, jarName, extension || force);
            } else {
                String pathInSubDir = subDir.getPathInSubDirWithinContext(jarName);
                this.allowedToXact();
                file.delete();
                this.createdByCache.remove(pathInCache);
                this.ownersTable.removeEntity(pathInCache);
            }
        } else {
            subDir.incMiss();
            throw new CacheMissException(StringUtils.toCapitalized(entity) + " '" + jarName + "' does not exist.");
        }
        return result;
    }

    public synchronized void removeArtifact(String name) throws TFCacheException, IllegalStateException {
        this.removeEntity("artifact", this.artifacts, name, true);
    }

    public synchronized void removeObject(String objectName) throws TFCacheException, IllegalStateException {
        this.removeEntity("object", this.objects, objectName + XDO_EXT, true);
    }

    public synchronized void removeServiceConfiguration(String entityName) throws TFCacheException, IllegalStateException {
        this.removeEntity("service configuration", this.services, entityName, true);
    }

    public synchronized void removeServiceConfiguration(String serviceName, String serviceType) throws TFCacheException, IllegalStateException {
        this.removeServiceConfiguration(serviceType + "." + serviceName + ".sco");
    }

    public synchronized void removeTransportFactory(String entityName) throws TFCacheException, IllegalStateException {
        this.removeEntity("transport factory", this.transportFactories, entityName, true);
    }

    public synchronized void removeTransportFactory(String factoryName, String factoryType) throws TFCacheException, IllegalStateException {
        this.removeTransportFactory(factoryType + "." + factoryName + ".tfo");
    }

    public synchronized void removeJDBCFactory(String entityName) throws TFCacheException, IllegalStateException {
        this.removeEntity("JDBC factory", this.jdbcFactories, entityName, true);
    }

    public synchronized void removeJDBCFactory(String factoryName, String factoryType) throws TFCacheException, IllegalStateException {
        this.removeJDBCFactory(factoryType + "." + factoryName + ".dfo");
    }

    public synchronized void removeClientFactory(String entityName) throws TFCacheException, IllegalStateException {
        this.removeEntity("client factory", this.clientFactories, entityName, true);
    }

    public synchronized void removeClientFactory(String factoryName, String factoryType) throws TFCacheException, IllegalStateException {
        this.removeClientFactory(factoryType + "." + factoryName + ".cfo");
    }

    public synchronized void renameObject(String oldName, String newName) throws TFCacheException, IllegalStateException {
        this.renameEntity("object artifact", this.objects, oldName + XDO_EXT, newName + XDO_EXT);
    }

    public synchronized void renameArtifact(String oldName, String newName) throws TFCacheException, IllegalStateException {
        this.renameEntity("artifact", this.artifacts, oldName, newName);
    }

    @Override
    public synchronized URL getArchiveURL(String jarName) throws TFCacheException, IllegalStateException {
        try {
            if (this.existsDistinctEntity(jarName, CachedEntity.LIB)) {
                return new URL("tfcache:///lib/" + jarName);
            }
            ++this.Statistics.libMiss;
            throw new CacheMissException("Archive '" + jarName + "' does not exist.");
        }
        catch (Exception exception) {
            if (exception instanceof TFCacheException) {
                throw (TFCacheException)exception;
            }
            throw new TFCacheException(exception);
        }
    }

    public synchronized URL getExtArchiveURL(String jarName) throws TFCacheException, IllegalStateException {
        try {
            if (this.existsDistinctEntity(jarName, CachedEntity.EXT)) {
                return new URL("tfcache:///ext/" + jarName);
            }
            ++this.Statistics.extMiss;
            throw new CacheMissException("Extension archive '" + jarName + "' does not exist.");
        }
        catch (Exception exception) {
            if (exception instanceof TFCacheException) {
                throw (TFCacheException)exception;
            }
            throw new TFCacheException(exception);
        }
    }

    @Override
    public synchronized byte[] getArchive(String jarName) throws TFCacheException, IllegalStateException {
        this.allowedToXact();
        try {
            String pathInCache = this.lib.getPathInCacheWithinContext(jarName);
            if (this.existsDistinctEntity(pathInCache)) {
                if (this.lockTable.containsKey(pathInCache)) {
                    RandomAccessFile artifact = this.getCacheFile(pathInCache);
                    artifact.seek(0L);
                    byte[] bytes = new byte[(int)artifact.length()];
                    artifact.readFully(bytes);
                    return bytes;
                }
                return FileIOUtils.getFileContent(this.lib.getFileWithinContext(jarName));
            }
            ++this.Statistics.libMiss;
            throw new CacheMissException("Archive '" + jarName + "' does not exist.");
        }
        catch (Exception exception) {
            if (exception instanceof TFCacheException) {
                throw (TFCacheException)exception;
            }
            throw new TFCacheException(exception);
        }
    }

    public synchronized InputStream getArchiveStream(String jarName) throws TFCacheException, IllegalStateException {
        try {
            String pathInCache = this.lib.getPathInCacheWithinContext(jarName);
            if (this.existsDistinctEntity(pathInCache)) {
                if (this.lockTable.containsKey(pathInCache)) {
                    return new ArchiveURLInputStream(jarName);
                }
                return new FileInputStream(this.lib.getFileWithinContext(jarName));
            }
            ++this.Statistics.libMiss;
            throw new CacheMissException("Archive '" + jarName + "' does not exist.");
        }
        catch (Exception exception) {
            if (exception instanceof TFCacheException) {
                throw (TFCacheException)exception;
            }
            throw new TFCacheException(exception);
        }
    }

    public synchronized byte[] getExtensionArchive(String jarName) throws TFCacheException, IllegalStateException {
        this.allowedToXact();
        try {
            String pathInCache = this.ext.getPathInCacheWithinContext(jarName);
            if (this.existsDistinctEntity(pathInCache)) {
                RandomAccessFile artifact = this.getCacheFile(pathInCache);
                artifact.seek(0L);
                byte[] bytes = new byte[(int)artifact.length()];
                artifact.readFully(bytes);
                return bytes;
            }
            ++this.Statistics.libMiss;
            throw new CacheMissException("Extension archive '" + jarName + "' does not exist.");
        }
        catch (IOException exception) {
            throw new TFCacheException(exception);
        }
    }

    @Override
    public synchronized void putServiceConfiguration(ServiceConfigurationObject sco, long expiration) throws TFCacheException, IllegalStateException {
        this.putXmlData(sco.getServiceType(), sco.getServiceName(), ".sco", this.services, expiration, sco);
    }

    public synchronized void putServiceConfigurationXml(String serviceName, String serviceType, byte[] xDoc, long expiration, boolean validate) throws TFCacheException, IllegalStateException, SerializerException {
        if (validate) {
            this.deserialize("ServiceConfiguration", xDoc);
        }
        this.putData(serviceType, serviceName, ".sco", this.services, expiration, new SimpleDataProvider(xDoc));
    }

    @Override
    public synchronized ServiceConfigurationObject getServiceConfiguration(String serviceName, String serviceType) throws TFCacheException, IllegalStateException {
        return (ServiceConfigurationObject)this.getXmlData(serviceType, serviceName, ".sco", this.services, "ServiceConfiguration");
    }

    public synchronized String getServiceConfigurationXml(String serviceName, String serviceType) throws TFCacheException, IllegalStateException {
        return new String(this.getData(serviceType, serviceName, ".sco", this.services));
    }

    public boolean existsService(String serviceName, String typeName) throws TFCacheException, IllegalStateException, NamingException {
        return this.existsEntity(serviceName, typeName, ".sco", CachedEntity.SERVICE);
    }

    public boolean existsTransportFactory(String factoryName, String factoryType) throws TFCacheException, IllegalStateException, NamingException {
        return this.existsEntity(factoryName, factoryType, ".tfo", CachedEntity.TRANSPORT_FACTORY);
    }

    public boolean existsJDBCFactory(String factoryName, String factoryType) throws TFCacheException, IllegalStateException, NamingException {
        return this.existsEntity(factoryName, factoryType, ".dfo", CachedEntity.JDBC_FACTORY);
    }

    public boolean existsClientFactory(String factoryName, String factoryType) throws TFCacheException, IllegalStateException, NamingException {
        return this.existsEntity(factoryName, factoryType, ".cfo", CachedEntity.CLIENT_FACTORY);
    }

    @Override
    public synchronized void addSemanticType(SemanticType type, boolean noAlias) throws TFCacheException, IllegalStateException {
        Trace.logDebug(TFCache.class, "Caching semantic type '" + type.getTypeName() + "'...");
        TFCache.checkSemanticName(type.getTypeName());
        this.allowedToXact();
        if (!type.isSystem() && this.existsSemanticType(type.getTypeName())) {
            throw new TFCacheException("Semantic type '" + type.getTypeName() + "' already exists.");
        }
        String pathInCache = this.types.getPathInCacheWithinContext((type.isSystem() ? "sys." : "") + type.getTypeName() + ".type");
        boolean exists = this.existsDistinctEntityErrorIfDiffCase(pathInCache);
        try {
            if (!noAlias) {
                this.xFactory.alias(type);
            }
            RandomAccessFile artifact = exists ? this.getCacheFile(pathInCache) : this.openCacheFile(pathInCache, CachedEntity.TYPE);
            this.updateEntity(pathInCache, artifact, this.serialize(type));
            this.raiseRepositoryArtifactChangeAdvisory(Severity.INFO, pathInCache, CachedEntity.TYPE, exists ? ArtifactState.UPDATED : ArtifactState.CREATED, "Configuration '" + type.getTypeName() + "' " + (exists ? "modified" : "added") + ".", true);
        }
        catch (Exception exception) {
            if (exception instanceof TFCacheException) {
                throw (TFCacheException)exception;
            }
            throw new TFCacheException(exception);
        }
    }

    @Override
    public boolean existsSemanticType(String typeName) throws TFCacheException, IllegalStateException {
        this.checkOpened();
        TFCache.checkSemanticName(typeName);
        return this.existsDistinctEntity("sys." + typeName + ".type", CachedEntity.TYPE) || this.existsDistinctEntity(typeName + ".type", CachedEntity.TYPE);
    }

    @Override
    public synchronized SemanticType getSemanticType(String typeName) throws TFCacheException, IllegalStateException {
        String entityName;
        TFCache.checkSemanticName(typeName);
        this.allowedToXact();
        if (this.existsDistinctEntity("sys." + typeName + ".type", CachedEntity.TYPE)) {
            entityName = "sys." + typeName + ".type";
        } else if (this.existsDistinctEntity(typeName + ".type", CachedEntity.TYPE)) {
            entityName = typeName + ".type";
        } else {
            ++this.Statistics.TypeMiss;
            throw new CacheMissException("Semantic type '" + typeName + "' does not exist.");
        }
        try {
            RandomAccessFile artifact = this.getCacheFile(this.types.getPathInCacheWithinContext(entityName));
            byte[] bytes = new byte[(int)artifact.length()];
            artifact.readFully(bytes);
            return (SemanticType)this.deserialize("SemanticType", bytes);
        }
        catch (Exception exception) {
            if (exception instanceof TFCacheException) {
                throw (TFCacheException)exception;
            }
            throw new TFCacheException(exception);
        }
    }

    public void initGlobalVariables() throws IllegalStateException, TFCacheException {
        this.putGlobalVariables(this.createGlobalVariables());
    }

    @Override
    public GlobalVariableCollection getGlobalVariables() throws TFCacheException, IllegalStateException {
        return (GlobalVariableCollection)this.getXmlData(GLOBALS_ENTITY_NAME, XDO_EXT, this.globals, "SysGlobals");
    }

    @Override
    public void putGlobalVariables(GlobalVariableCollection variables) throws TFCacheException, IllegalStateException {
        this.putXmlData(GLOBALS_ENTITY_NAME, XDO_EXT, this.globals, 0L, variables);
    }

    public synchronized boolean isArtifactDirectory(String path) {
        return this.artifacts.getFileWithinContext(path).isDirectory();
    }

    public synchronized String getArtifactPathFromRoot(String path) {
        return this.artifacts.getPathInSubDirWithinContext(path);
    }

    @Override
    public synchronized void createDirectory(String dirPath) throws TFCacheException, IllegalStateException {
        Trace.logDebug(TFCache.class, "Creating directory '" + dirPath + "'...");
        if (dirPath == null) {
            throw new TFCacheException("Null directory path.");
        }
        if (dirPath.equals("/") || dirPath.equals(".")) {
            throw new TFCacheException("Invalid directory path.");
        }
        this.allowedToXact();
        try {
            String NS = this.getAbsoluteNamespace(dirPath, this.pwd);
            String pathInCache = this.artifacts.getPathInCache(this.getNamespacePathFromRoot(NS, "/"));
            if (this.existsDistinctEntityErrorIfDiffCase(pathInCache)) {
                throw new TFCacheException("Directory '" + NS + "' already exists.");
            }
            Trace.logDebug(TFCache.class, "Creating directory '" + NS + "' resolved to '" + pathInCache + "'...");
            this.mkdirs(pathInCache);
        }
        catch (UtilitiesException exception) {
            throw new TFCacheException(exception);
        }
    }

    private void deleteDirectoryInternal(String pathInCache, String label, CachedEntity entityType) throws TFCacheException {
        try {
            File dirFile = this.getFile(pathInCache);
            String fsPath = dirFile.getAbsolutePath();
            for (String filename : FileIOUtils.directoryList(fsPath, "", false)) {
                String filePathInCache = pathInCache + File.separatorChar + filename;
                this.evict(filePathInCache);
            }
            for (String dirName : FileIOUtils.directorySublist(fsPath, false)) {
                this.deleteDirectoryInternal(pathInCache + File.separatorChar + dirName, label, entityType);
            }
            if (dirFile.delete()) {
                this.createdByCache.remove(pathInCache);
                this.ownersTable.removeEntity(pathInCache);
                this.raiseRepositoryArtifactChangeAdvisory(Severity.INFO, pathInCache, entityType, ArtifactState.DESTROYED, "Entity '" + pathInCache + "' has been evicted from cache.", true);
            } else {
                this.raiseRepositoryArtifactChangeAdvisory(Severity.WARNING, pathInCache, entityType, ArtifactState.SHARE_VIOLATION, "Could not delete " + label + " '" + pathInCache + "'. Make sure it is not in use.", true);
            }
        }
        catch (Exception exception) {
            if (exception instanceof TFCacheException) {
                throw (TFCacheException)exception;
            }
            throw new TFCacheException(exception);
        }
    }

    @Override
    public synchronized void deleteDirectory(String dirPath) throws TFCacheException, IllegalStateException {
        Trace.logDebug(TFCache.class, "Deleting directory '" + dirPath + "'...");
        if (dirPath == null) {
            throw new TFCacheException("Null directory path specified.");
        }
        this.allowedToXact();
        try {
            String pathInCache = this.artifacts.getPathInCache(this.getNamespacePathFromRoot(dirPath, this.pwd));
            if (!this.existsDistinctEntity(pathInCache)) {
                throw new TFCacheException("Invalid directory path specified '" + dirPath + "'.");
            }
            this.deleteDirectoryInternal(pathInCache, "artifacts directory", CachedEntity.ARTIFACT);
        }
        catch (Exception exception) {
            if (exception instanceof TFCacheException) {
                throw (TFCacheException)exception;
            }
            throw new TFCacheException(exception);
        }
    }

    @Override
    public synchronized void changeToDirectory(String dirPath) throws TFCacheException, IllegalStateException {
        dirPath = this.getAbsoluteNamespace(dirPath, this.pwd);
        this.requireExistsDistinctEntity(this.artifacts.getPathInCache(this.getNamespacePathFromRoot(dirPath, "/")), this.artifacts);
        this.pwd = dirPath;
        this.artifacts.setContext(this.pwd);
    }

    @Override
    public synchronized String getPresentWorkingDirectory() throws TFCacheException, IllegalStateException {
        return this.pwd;
    }

    @Override
    public synchronized String getAbsoluteWorkingDirectory() throws TFCacheException, IllegalStateException {
        return this.artifacts.getCurrentCanonicalFile().getAbsolutePath() + File.separatorChar;
    }

    @Override
    public synchronized List<String> listDirectories() throws TFCacheException, IllegalStateException {
        this.checkOpened();
        try {
            return FileIOUtils.directorySublist(this.artifacts.getCurrentCanonicalFile().getPath(), false);
        }
        catch (UtilitiesException exception) {
            throw new TFCacheException(exception);
        }
    }

    @Override
    public synchronized ReferenceContext createSubcontext(ReferenceContext parentContext, String ctxNamespace) throws TFCacheException, IllegalStateException {
        TFCache.checkName(ctxNamespace);
        this.allowedToXact();
        try {
            String pathInCache;
            ReferenceContext parentCtx;
            if (parentContext == null) {
                parentCtx = this.lookupReferenceContext(".");
            } else if (parentContext.isRoot()) {
                parentCtx = this.lookupReferenceContext("/");
            } else {
                parentCtx = this.lookupReferenceContext(parentContext.getContextNameSpace());
                if (parentCtx == null) {
                    throw new TFCacheException("Parent context '" + parentContext.getContextNameSpace() + "' does not exist.");
                }
            }
            String NS = this.getNamespacePathFromRoot(ctxNamespace, parentCtx.getContextNameSpace());
            if (NS.startsWith("/sys") || NS.startsWith("sys")) {
                this.checkRights("System area '" + NS + "' can only be modified by administrator.");
            }
            if (this.existsDistinctEntityErrorIfDiffCase(pathInCache = this.objects.getPathInCache(NS))) {
                throw new TFCacheException("Reference context '" + NS + "' already exists.");
            }
            Trace.logDebug(TFCache.class, "Creating subcontext '" + NS + "' resolved to '" + pathInCache + "'...");
            this.mkdirs(pathInCache);
            return this.lookupReferenceContext(NS);
        }
        catch (Exception exception) {
            if (exception instanceof TFCacheException) {
                throw (TFCacheException)exception;
            }
            throw new TFCacheException(exception);
        }
    }

    @Override
    public synchronized void destroySubcontext(ReferenceContext ctx) throws SecurityViolationException, TFCacheException, IllegalStateException {
        if (ctx == null) {
            throw new TFCacheException("Reference context is null.");
        }
        this.allowedToXact();
        if (ctx.getContextNameSpace().startsWith("/sys")) {
            this.checkRights("System area '" + ctx.getContextNameSpace() + "' can only be modified by administrator.");
        }
        Trace.logDebug(TFCache.class, "Destroying subcontext '" + ctx.getContextNameSpace() + "'...");
        try {
            String pathInCache = this.objects.getPathInCache(this.getNamespacePathFromRoot(ctx.getContextNameSpace(), this.getReferenceContext().getContextNameSpace()));
            if (!this.existsDistinctEntity(pathInCache)) {
                throw new TFCacheException("Invalid Reference Context path specified '" + pathInCache + "'.");
            }
            this.deleteDirectoryInternal(pathInCache, "reference context", CachedEntity.OBJECT);
        }
        catch (Exception exception) {
            if (exception instanceof TFCacheException) {
                throw (TFCacheException)exception;
            }
            throw new TFCacheException(exception);
        }
    }

    @Override
    public synchronized void setReferenceContext(ReferenceContext ctx) throws TFCacheException, IllegalStateException, NamingException {
        ReferenceContext newCtx;
        this.allowedToXact();
        ReferenceContext referenceContext = newCtx = ctx == null ? this.lookupReferenceContext("/") : this.lookupReferenceContext(ctx.getContextNameSpace());
        if (newCtx == null) {
            throw new TFCacheException("Reference context '" + ctx.getContextNameSpace() + "' does not exist.");
        }
        this.rctx = newCtx;
        this.objects.setContext(this.getNamespacePathFromRoot(this.rctx.getContextNameSpace(), "/"));
    }

    @Override
    public synchronized ReferenceContext getReferenceContext() throws IllegalStateException {
        this.checkOpened();
        return this.rctx;
    }

    @Override
    public synchronized ReferenceContext lookupReferenceContext(String ctxNamespace) throws TFCacheException, IllegalStateException, NamingException {
        if (ctxNamespace == null) {
            throw new TFCacheException("Reference context name is null.");
        }
        if (ctxNamespace.equals("/")) {
            return ReferenceContext.ROOT;
        }
        if (ctxNamespace.equals(".")) {
            return this.getReferenceContext();
        }
        String NS = this.getAbsoluteNamespace(ctxNamespace, this.getReferenceContext().getContextNameSpace());
        String pathInObjects = this.getNamespacePathFromRoot(NS, "/");
        if (!this.objects.getFileFromBase(pathInObjects).exists()) {
            return null;
        }
        return new ReferenceContext(ReferenceContext.ROOT, NS);
    }

    public synchronized boolean existsReferenceContext(String ctxNamespace) throws TFCacheException, IllegalStateException, NamingException {
        if (ctxNamespace == null) {
            throw new TFCacheException("Reference context name is null.");
        }
        if (ctxNamespace.equals("/")) {
            return true;
        }
        if (ctxNamespace.equals(".")) {
            return this.rctx != null;
        }
        String NS = this.getAbsoluteNamespace(ctxNamespace, this.getReferenceContext().getContextNameSpace());
        String pathInObjects = this.getNamespacePathFromRoot(NS, "/");
        return this.objects.getFileFromBase(pathInObjects).exists();
    }

    @Override
    public synchronized ReferenceContext createSubcontext(String ctxNamespace) throws SecurityViolationException, TFCacheException, IllegalStateException, NamingException {
        if (ctxNamespace == null) {
            throw new TFCacheException("Reference context name is null.");
        }
        this.allowedToXact();
        try {
            String pathInCache;
            if (ctxNamespace.equals("/")) {
                return ReferenceContext.ROOT;
            }
            if (ctxNamespace.equals(".")) {
                return this.getReferenceContext();
            }
            String NS = this.getAbsoluteNamespace(ctxNamespace, this.getReferenceContext().getContextNameSpace());
            if (NS.startsWith("/sys") || NS.startsWith("sys")) {
                this.checkRights("System area '" + NS + "' can only be modified by administrator.");
            }
            if (this.existsDistinctEntityErrorIfDiffCase(pathInCache = this.objects.getPathInCache(this.getNamespacePathFromRoot(NS, "/")))) {
                throw new NamingException("Reference context '" + NS + "' already exists.");
            }
            Trace.logDebug(TFCache.class, "Creating subcontext '" + NS + "' resolved to '" + pathInCache + "'...");
            this.mkdirs(pathInCache);
            return new ReferenceContext(ReferenceContext.ROOT, NS);
        }
        catch (UtilitiesException exception) {
            throw new TFCacheException(exception);
        }
    }

    @Override
    public synchronized List<String> listSubcontexts() throws TFCacheException, IllegalStateException {
        this.checkOpened();
        try {
            return FileIOUtils.directorySublist(this.objects.getCurrentCanonicalFile().getPath(), false);
        }
        catch (UtilitiesException exception) {
            throw new TFCacheException(exception);
        }
    }

    @Override
    public synchronized List<SemanticType> getTypes(boolean includeSystem) throws TFCacheException, IllegalStateException {
        this.allowedToXact();
        ArrayList<SemanticType> types = new ArrayList<SemanticType>();
        try {
            for (String typeName : this.listSemanticTypes(false, includeSystem)) {
                types.add(this.getSemanticType(typeName));
            }
        }
        catch (Exception exception) {
            if (exception instanceof TFCacheException) {
                throw (TFCacheException)exception;
            }
            throw new TFCacheException(exception);
        }
        return types;
    }

    @Override
    public synchronized String resolveSemanticType(String typeName) throws TFCacheException, IllegalStateException {
        this.checkOpened();
        SemanticType type = this.getSemanticType(typeName);
        return type.getClassName();
    }

    @Override
    public synchronized void putObject(Object obj, String name, long expiration) throws SecurityViolationException, TFCacheException, IllegalStateException, NamingException {
        Trace.logDebug(TFCache.class, "Saving object '" + obj.getClass().getName() + "' with name '" + name + "'...");
        this.allowedToXact();
        if (obj == null) {
            throw new TFCacheException("Object is null.");
        }
        if (name == null) {
            throw new TFCacheException("Object name is null.");
        }
        if (name.isEmpty() || !StringUtils.validateObjectName(name)) {
            throw new TFCacheException("Object name '" + name + "' is invalid.");
        }
        ReferenceContext ctx = this.getReferenceContext();
        if (ctx.getContextNameSpace().startsWith("/sys")) {
            this.checkRights("System area '" + ctx.getContextNameSpace() + "' can only be modified by administrator.");
        }
        try {
            for (String objName : this.listObjects(false)) {
                if (!objName.endsWith("." + StringUtils.normalizeObjectName(name) + XDO_EXT)) continue;
                throw new TFCacheException("Object '" + name + "' already exists.");
            }
            String typeName = this.xFactory.lookup(obj.getClass());
            if (typeName == null) {
                ArrayIterator interfaces = new ArrayIterator(obj.getClass().getInterfaces());
                while (interfaces.hasNext()) {
                    typeName = this.xFactory.lookup(interfaces.next());
                    if (typeName == null) continue;
                    SemanticType type = this.xFactory.lookupSemanticType(typeName);
                    if (!type.isInterface()) {
                        throw new TFCacheException("Class resolution failure. Semantic type superclass '" + typeName + "' not an interface.");
                    }
                    Trace.logDebug(TFCache.class, "Found matching interface '" + typeName + "' for class '" + obj.getClass().getName() + "'.");
                    break;
                }
                if (typeName == null) {
                    throw new TFCacheException("Class resolution failure. Semantic type not found for class '" + obj.getClass().getName() + "'.");
                }
            }
            String fileName = name.equals(typeName) ? StringUtils.normalizeObjectName(name) + XDO_EXT : typeName + "." + StringUtils.normalizeObjectName(name) + XDO_EXT;
            this.putObject(this.serialize(typeName, obj), fileName, expiration);
        }
        catch (Exception exception) {
            if (exception instanceof TFCacheException) {
                throw (TFCacheException)exception;
            }
            throw new TFCacheException(exception);
        }
    }

    void updateObject(String objectType, String objectName, Object obj) throws TFCacheException, IllegalStateException {
        String filename = objectName.equals(objectType) ? StringUtils.normalizeObjectName(objectName) + XDO_EXT : objectType + "." + StringUtils.normalizeObjectName(objectName) + XDO_EXT;
        Trace.logDebug(TFCache.class, "Updating object '" + filename + "'...");
        this.allowedToXact();
        try {
            String pathInCache = this.objects.getPathInCacheWithinContext(filename);
            if (pathInCache == null) {
                ++this.Statistics.ObjectMiss;
                throw new CacheMissException(objectType + " object with name '" + objectName + "' does not exist.");
            }
            this.updateEntity(pathInCache, this.getCacheFile(pathInCache), this.serialize(objectType, obj));
        }
        catch (Exception exception) {
            if (exception instanceof TFCacheException) {
                throw (TFCacheException)exception;
            }
            throw new TFCacheException(exception);
        }
        Trace.logDebug(TFCache.class, "Object '" + filename + "' updated.");
    }

    @Override
    public synchronized Object lookup(String instanceName) throws TFCacheException, IllegalStateException {
        List<String> bindings;
        TFCache.checkObjectName(instanceName);
        try {
            bindings = this.listQualifiedBindings();
        }
        catch (Exception exception) {
            if (exception instanceof TFCacheException) {
                throw (TFCacheException)exception;
            }
            throw new TFCacheException(exception);
        }
        for (String binding : bindings) {
            String instance;
            String type;
            StringTokenizer st = new StringTokenizer(binding, ".");
            if (st.countTokens() == 1) {
                instance = type = st.nextToken();
            } else if (st.countTokens() == 2) {
                type = st.nextToken();
                instance = st.nextToken();
            } else {
                throw new TFCacheException("Object name " + binding + " is invalid.");
            }
            if (!instance.equals(StringUtils.normalizeObjectName(instanceName))) continue;
            return this.getObject(instanceName, type);
        }
        return null;
    }

    @Override
    public synchronized Object getObject(String instanceName, String typeName) throws TFCacheException, IllegalStateException {
        this.allowedToXact();
        if (instanceName == null || instanceName.isEmpty()) {
            throw new TFCacheException("Instance name is null or empty.");
        }
        if (typeName == null || typeName.isEmpty()) {
            throw new TFCacheException("Type name is null or empty.");
        }
        TFCache.checkSemanticName(typeName);
        TFCache.checkObjectName(instanceName);
        String artifactName = instanceName.equals(typeName) ? StringUtils.normalizeObjectName(instanceName) : typeName + "." + StringUtils.normalizeObjectName(instanceName);
        String fullArtifactName = artifactName + XDO_EXT;
        if (!this.existsDistinctEntity(fullArtifactName, CachedEntity.OBJECT)) {
            ++this.Statistics.ObjectMiss;
            throw new CacheMissException("Object '" + fullArtifactName + "' does not exist.");
        }
        Trace.logDebug(TFCache.class, "Loading object '" + fullArtifactName + "' from cache...");
        try {
            RandomAccessFile artifact = this.getCacheFile(this.objects.getPathInCacheWithinContext(fullArtifactName));
            byte[] bytes = new byte[(int)artifact.length()];
            artifact.readFully(bytes);
            Object obj = this.deserialize(typeName, bytes);
            Trace.logDebug(TFCache.class, "Object '" + fullArtifactName + "' loaded.");
            return obj;
        }
        catch (Exception exception) {
            if (exception instanceof TFCacheException) {
                ((TFCacheException)exception).init(this.objects.getCurrentDir(), fullArtifactName);
                throw (TFCacheException)exception;
            }
            throw new TFCacheException(exception, this.objects.getCurrentDir(), fullArtifactName);
        }
    }

    @Override
    protected synchronized RandomAccessFile getCachedFileWithoutLocks(String path, CachedEntity type) throws TFCacheException {
        if (!this.existsDistinctEntity(path, type)) {
            throw new CacheMissException("File of type " + String.valueOf((Object)type) + "'" + path + "' does not exist.");
        }
        return this.getCacheFile(this.subDirByType.get((Object)type).getPathInCacheWithinContext(path));
    }

    @Override
    public synchronized String resolveClass(String implementingClass) throws TFCacheException, IllegalStateException {
        this.checkOpened();
        Trace.logDebug(TFCache.class, "Resolving cache class '" + implementingClass + "' to Semantic Type..");
        for (SemanticType type : this.getTypes(true)) {
            if (!type.getClassName().equals(implementingClass)) continue;
            return type.getTypeName();
        }
        throw new TFCacheException("Class resolution failure. Semantic type not found for class '" + implementingClass + "'.");
    }

    public synchronized void setStateChangeListener(RepositoryStateChangeListener listener) {
        this.rscListener = listener;
    }

    public synchronized void setArtifactChangeListener(RepositoryArtifactChangeListener listener) {
        this.racListener = listener;
    }

    void setIoThreadCycle(long ioThreadCycle) {
        this.ioThreadCycle = ioThreadCycle;
    }

    @Override
    protected long getIoTimeout() {
        return this.ioThreadCycle;
    }

    @Override
    protected void setIoTimeout(long timeout) throws TFCacheException {
        try {
            if (this.ioThread != null) {
                this.ioThread.setTimeout(timeout);
            }
            this.setIoThreadCycle(timeout);
        }
        catch (FabricException exception) {
            throw new TFCacheException("Changing timeout of CacheIOThread failed.", exception);
        }
    }

    void setIoThreadGc(int ioThreadGc) {
        this.ioThreadGc = ioThreadGc;
    }

    private void raiseRepositoryStateChangeAdvisory(RepositoryState state, String message) {
        if (this.rscListener != null) {
            RepositoryStateChangeAdvisory advisory = new RepositoryStateChangeAdvisory();
            advisory.setState(state);
            advisory.setMessage(message);
            advisory.setCode(0);
            try {
                this.rscListener.onEvent(advisory);
            }
            catch (Exception exception) {
                Trace.logException(TFCache.class, exception, true);
                Trace.logError(TFCache.class, "Raising of advisory '" + advisory.getEventId() + "' failed.");
            }
        }
    }

    protected void raiseRepositoryArtifactChangeAdvisory(Severity severity, String pathInCache, CachedEntity type, ArtifactState state, String message, boolean raiseLockedForCreatedOrUnlockedForDestroyed) {
        this.raiseRepositoryArtifactChangeAdvisory(severity, pathInCache, type, state, message);
    }

    protected void raiseRepositoryArtifactChangeAdvisory(Severity severity, String pathInCache, CachedEntity type, ArtifactState state, String message) {
        if (this.racListener != null) {
            RepositoryArtifactStateChangeAdvisory advisory = new RepositoryArtifactStateChangeAdvisory();
            advisory.setArtifactPath(pathInCache);
            advisory.setEntityType(type);
            advisory.setState(state);
            advisory.setMessage(message);
            advisory.setSeverity(severity);
            try {
                this.racListener.onEvent(advisory);
            }
            catch (Exception exception) {
                Trace.logException(TFCache.class, exception, true);
                Trace.logError(TFCache.class, "Raising of advisory '" + advisory.getEventId() + "' failed.");
            }
        }
    }

    private synchronized void saveEvictionMap() throws IllegalStateException, TFCacheException {
        String pathInCache = this.eMapDir + File.separatorChar + EVICTION_MAP_FILENAME;
        try {
            RandomAccessFile artifact = this.existsDistinctEntityErrorIfDiffCase(pathInCache) ? this.getCacheFile(pathInCache) : this.openCacheFile(pathInCache, CachedEntity.OBJECT);
            this.updateEntity(pathInCache, artifact, this.serialize(this.evictionMap));
        }
        catch (Exception exception) {
            if (exception instanceof TFCacheException) {
                throw (TFCacheException)exception;
            }
            throw new TFCacheException(exception);
        }
    }

    private synchronized void loadEvictionMap() throws IllegalStateException, TFCacheException, NamingException {
        Trace.logDebug(TFCache.class, "Loading Eviction Map from cache...");
        ReferenceContext svc13 = this.getReferenceContext();
        if (this.existsDistinctEntityErrorIfDiffCase(this.eMapDir + File.separatorChar + EVICTION_MAP_FILENAME)) {
            ReferenceContext sys = new ReferenceContext(ReferenceContext.ROOT, "sys");
            this.setReferenceContext(sys);
            this.evictionMap = (ArtifactCachePolicy)this.getObject("EvictionMap", "ArtifactCachePolicy");
        }
        this.setReferenceContext(svc13);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] serialize(Object object) throws SerializerException {
        ClassLoader baseLoader = this.setClassLoader();
        try {
            byte[] byArray = this.xf.serialize(object).getBytes();
            return byArray;
        }
        finally {
            if (baseLoader != null) {
                this.xf.setClassLoader(baseLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] serialize(String semanticType, Object object) throws SerializerException {
        ClassLoader baseLoader = this.setClassLoader();
        try {
            byte[] byArray = this.xf.serialize(semanticType, object).getBytes();
            return byArray;
        }
        finally {
            if (baseLoader != null) {
                this.xf.setClassLoader(baseLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Object deserialize(String semanticType, byte[] data) throws SerializerException {
        ClassLoader baseLoader = this.setClassLoader();
        try {
            Object object = this.xf.deserialize(semanticType, data);
            return object;
        }
        finally {
            if (baseLoader != null) {
                this.xf.setClassLoader(baseLoader);
            }
        }
    }

    private ClassLoader setClassLoader() {
        ClassLoader currentLoader;
        ClassLoader baseLoader = this.xf.getClassLoader();
        ClassLoader classLoader = currentLoader = this.ctxComponent != null ? this.ctxComponent.getPackageManifestManager().getManifestClassLoader() : this.loaderRegistry.getSystemClassLoaderChain();
        if (ClassLoaderReference.getRealClassLoader(baseLoader) != ClassLoaderReference.getRealClassLoader(currentLoader)) {
            this.xf.setClassLoader(currentLoader);
            return baseLoader;
        }
        return null;
    }

    private boolean canLockFile(String pathInCache) {
        try {
            if (!this.existsDistinctEntity(pathInCache)) {
                return false;
            }
            File aFile = new File(this.cacheLocationCanonicalFile, pathInCache);
            RandomAccessFile artifact = new RandomAccessFile(aFile, "rw");
            FileLock lock = artifact.getChannel().tryLock();
            if (lock != null) {
                Trace.logDebug(TFCache.class, "Lock succeeded for '" + aFile.getAbsolutePath() + "'.");
                lock.release();
                artifact.getChannel().close();
                artifact.close();
            }
        }
        catch (OverlappingFileLockException e) {
            return false;
        }
        catch (Exception e) {
            Trace.logDebug(TFCache.class, "Lock Error: " + e.getClass().getName() + ": " + e.getMessage());
            return false;
        }
        return true;
    }

    protected String getPathInCache(File file) throws IOException {
        return FileIOUtils.getRelativePathForCanonicalBase(this.cacheLocationCanonicalFile, file);
    }

    protected RandomAccessFile openCacheFile(String pathInCache, CachedEntity type) throws TFCacheException {
        return this.openCacheFile(pathInCache, type, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RandomAccessFile openCacheFile(String pathInCache, CachedEntity type, boolean skipOwnerTable) throws TFCacheException {
        RandomAccessFile artifact = null;
        boolean exists = this.existsDistinctEntity(pathInCache);
        File aFile = new File(this.cacheLocationCanonicalFile, pathInCache);
        try {
            if (!exists) {
                this.createdByCache.add(pathInCache);
            }
            artifact = new RandomAccessFile(aFile, "rw");
            Map<String, FileObject> map = this.lockTable;
            synchronized (map) {
                if (this.lockTable.containsKey(pathInCache)) {
                    throw new TFCacheException.AlreadyLocked();
                }
                FileLock lock = FileIOUtils.lock(artifact.getChannel(), aFile.getAbsolutePath());
                this.lockTable.put(pathInCache, new FileObject(artifact, lock, type));
            }
            Trace.logDebug(TFCache.class, type.name() + " '" + pathInCache + "' locked.");
            if (!skipOwnerTable) {
                if (exists) {
                    if (!this.ownersTable.checkEntityInfo(pathInCache, new CryptoUtils.Sha256RandomAccessFileHashCalculator(artifact), artifact.length(), this.getCurrentUser())) {
                        this.closeCacheFile(pathInCache);
                        return null;
                    }
                } else {
                    this.ownersTable.createNewEntityInfo(pathInCache, null, 0L, this.getCurrentUser());
                }
            }
            switch (type) {
                case LIB: 
                case EXT: {
                    TFCacheJarStorage.getInstance().putJar(pathInCache, aFile, artifact);
                    break;
                }
            }
        }
        catch (OverlappingFileLockException e) {
            FileIOUtils.closeSafe(artifact);
            Trace.logDebug(TFCache.class, "Overlapping Lock Exception: resource '" + pathInCache + "', Message: " + e.getMessage());
            Map<String, FileObject> map = this.lockTable;
            synchronized (map) {
                if (this.lockTable.containsKey(pathInCache)) {
                    throw new TFCacheException.AlreadyLocked(e);
                }
                throw new TFCacheException(e);
            }
        }
        catch (Exception e) {
            FileIOUtils.closeSafe(artifact);
            Trace.logDebug(TFCache.class, "Lock Error: " + e.getClass().getName() + ": " + e.getMessage());
            e.printStackTrace();
        }
        return artifact;
    }

    protected synchronized RandomAccessFile getCacheFile(String pathInCache) throws TFCacheException {
        FileObject fileObject = this.lockTable.get(pathInCache);
        if (fileObject == null) {
            throw new TFCacheException("File '" + pathInCache + "' not in Lock Table.");
        }
        try {
            RandomAccessFile raf = fileObject.file;
            raf.seek(0L);
            return raf;
        }
        catch (IOException exception) {
            throw new TFCacheException(exception);
        }
    }

    protected synchronized void closeCacheFile(String pathInCache) throws TFCacheException {
        File aFile = new File(this.cacheLocationCanonicalFile, pathInCache);
        FileObject fileObj = this.lockTable.get(pathInCache);
        if (fileObj == null) {
            throw new TFCacheException("File '" + pathInCache + "' not in Lock Table.");
        }
        try {
            if (pathInCache.startsWith("lib" + File.separator) || pathInCache.startsWith("ext" + File.separator)) {
                TFCacheJarStorage.getInstance().removeJar(pathInCache);
            }
            if (fileObj.lock.channel().isOpen()) {
                fileObj.lock.release();
                fileObj.lock.channel().close();
            }
            if (fileObj.file.getChannel().isOpen()) {
                fileObj.file.close();
            }
            this.lockTable.remove(pathInCache);
            String msg = "Unlocked and closed resource artifact '" + pathInCache + "'.";
            Trace.logDebug(TFCache.class, msg);
            if (this.artifacts.containsPathInBase(pathInCache)) {
                this.raiseRepositoryArtifactChangeAdvisory(Severity.INFO, pathInCache, fileObj.type, ArtifactState.LOCKED, msg);
            }
        }
        catch (IOException exception) {
            throw new TFCacheException(exception);
        }
    }

    protected String getSystemObjectBackupPathInCache(String pathInCache) {
        return pathInCache + ".v";
    }

    protected void saveSystemObject(Object obj, String pathInCache) throws TFCacheException {
        this.saveSystemObject(obj, pathInCache, true);
    }

    protected void saveSystemObject(Object obj, String pathInCache, boolean deleteBackup) throws TFCacheException {
        this.systemObjectsPersister.saveSystemObject(obj, pathInCache, deleteBackup);
    }

    public synchronized void saveSystemObject(Object obj, OutputStream outputStream) throws TFCacheException {
        this.systemObjectsPersister.saveSystemObject(obj, outputStream);
    }

    protected synchronized void flushOwnersTable() {
        if (this.ownersTable.isDirty()) {
            this.ownersTable.save();
            if (this.ownersTable.isDirty()) {
                Trace.logError(CacheIOThread.class, "Saving owners table failed.");
            }
        }
    }

    protected void resetOwnersSaveRetries() {
        this.ownersSaveRetries = 0;
    }

    protected synchronized boolean existsEntityFile(String pathInCache) {
        return new File(this.cacheLocationCanonicalFile, pathInCache).exists();
    }

    public Object loadSystemObject(String pathInCache) throws TFCacheException {
        return this.loadSystemObject(pathInCache, true);
    }

    public synchronized Object loadSystemObject(String pathInCache, boolean useBackup) throws TFCacheException {
        return this.systemObjectsPersister.loadSystemObject(pathInCache, useBackup);
    }

    protected String getAbsoluteNamespace(String namespace, String currentNamespace) throws TFCacheException {
        if (!currentNamespace.startsWith("/")) {
            throw new TFCacheException("Invalid current namespace specified: '" + currentNamespace + "'. Expected absolute namespace.");
        }
        currentNamespace = StringUtils.trimTrailingSlashes(currentNamespace, '/', true);
        if (namespace == null || namespace.length() == 0) {
            return currentNamespace;
        }
        if ((namespace = StringUtils.trimTrailingSlashes(namespace, '/', true)).startsWith("/")) {
            return namespace;
        }
        return currentNamespace + (currentNamespace.endsWith("/") ? "" : "/") + namespace;
    }

    private String getNamespacePathFromRoot(String namespace, String currentNamespace) throws TFCacheException {
        return this.getAbsoluteNamespace(namespace, currentNamespace).substring(1).replace('/', File.separatorChar);
    }

    static void addSemanticType(Class typeClass, String description) throws SemanticTypeFactoryException {
        if (!TypeFactory.existsSemanticType(typeClass.getSimpleName())) {
            SemanticType type = TFCache.createSemanticType(typeClass);
            type.setDescription(description + " Autogenerated System Type.");
            TypeFactory.addSemanticType(type);
        }
    }

    static SemanticType createSemanticType(Class typeClass) {
        SemanticType type = TFCache.createSemanticType(typeClass.getSimpleName(), typeClass, true);
        type.setDescription("Autogenerated System Type.");
        return type;
    }

    protected CacheSubDir getSubDir(String pathInCache) {
        return this.subDirByType.values().stream().filter(subDir -> subDir.containsPathInBase(pathInCache)).findFirst().orElse(null);
    }

    protected CachedEntity getEntityType(String pathInCache) {
        CacheSubDir subDir = this.getSubDir(pathInCache);
        return subDir != null ? subDir.getType() : null;
    }

    public String getCurrentUser() {
        return this.currentUser;
    }

    public void setCurrentUser(String currentUser) throws SecurityManagerException {
        this.currentUser = currentUser;
        this.checkAdminRole();
    }

    @Override
    public synchronized boolean isAdminRole() {
        return this.isAdmin;
    }

    private void checkAdminRole() throws SecurityManagerException {
        User user;
        this.isAdmin = this.securityManager != null ? (user = this.securityManager.lookupUser(this.getCurrentUser())) != null && user.isAdministrator() : this.currentUser.equals("sysadmin");
    }

    public void setSecurityManager(SecurityManager securityManager) throws SecurityManagerException {
        this.securityManager = securityManager;
        this.checkAdminRole();
    }

    @Override
    public void forceSemanticType(String typeName, boolean sysType) throws TFCacheException, IllegalStateException, SecurityViolationException {
        Trace.logDebug(TFCache.class, "Forcing semantic type '" + (sysType ? "sys." : "") + typeName + "'...");
        this.allowedToXact();
        this.checkRights("Semantic type can only be removed by administrator.");
        String pathInCache = this.getSemanticTypePathInCache(typeName);
        if (pathInCache == null) {
            ++this.Statistics.TypeMiss;
            throw new CacheMissException("Semantic type '" + typeName + "' does not exist.");
        }
        this.evict(pathInCache);
        this.raiseRepositoryArtifactChangeAdvisory(Severity.INFO, pathInCache, CachedEntity.TYPE, ArtifactState.DESTROYED, "Semantic type '" + typeName + "' has been forced.", true);
        Trace.logDebug(TFCache.class, "Semantic type '" + typeName + "' forced.");
    }

    private void checkRights(String message) throws SecurityViolationException {
        if (!this.isAdmin) {
            throw new SecurityViolationException(4019, message);
        }
    }

    protected boolean mkdirs(String pathInCache) throws UtilitiesException {
        return this.mkdirs(pathInCache, false);
    }

    protected boolean mkdirs(String pathInCache, boolean skipOwnersTable) throws UtilitiesException {
        try {
            return this.mkdirs(new File(this.cacheLocationCanonicalFile, pathInCache), skipOwnersTable);
        }
        catch (IOException e) {
            throw new UtilitiesException("Create File Directory Error: " + e.getMessage());
        }
    }

    private boolean mkdirs(CacheSubDir subDir) throws IOException {
        return this.mkdirs(subDir.getBaseCanonicalFile());
    }

    protected boolean mkdirs(File dir) throws IOException {
        return this.mkdirs(dir, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean mkdirs(File dir, boolean skipOwnersTable) throws IOException {
        File parent = dir.getParentFile();
        if (!parent.exists() && !this.mkdirs(parent, skipOwnersTable)) {
            return false;
        }
        if (!dir.exists()) {
            String pathInCache = this.getPathInCache(dir);
            this.createdByCache.add(pathInCache);
            try {
                boolean result = dir.mkdir();
                if (!result) {
                    this.createdByCache.remove(pathInCache);
                }
                boolean bl = result;
                return bl;
            }
            finally {
                if (dir.exists()) {
                    if (!skipOwnersTable) {
                        try {
                            this.ownersTable.createNewEntityInfo(pathInCache, null, 0L, this.getCurrentUser());
                        }
                        catch (Exception exception) {
                            Trace.logException(TFCache.class, exception, true);
                        }
                    }
                } else {
                    this.createdByCache.remove(pathInCache);
                }
            }
        }
        return false;
    }

    private void closeCacheFileSafe(String pathInCache) {
        try {
            this.closeCacheFile(pathInCache);
        }
        catch (Exception ex2) {
            Trace.logException(TFCache.class, ex2, true);
        }
    }

    private Object deserialize(String pathInCache, String xmlRoot, CachedEntity entityType) throws TFCacheException.AlreadyLocked {
        RandomAccessFile raf = null;
        try {
            raf = this.openCacheFile(pathInCache, entityType);
            return this.deserializeEntity(raf, xmlRoot);
        }
        catch (TFCacheException.AlreadyLocked ex1) {
            throw ex1;
        }
        catch (Throwable exception) {
            Trace.logException(TFCache.class, exception, false);
            Trace.logError(TFCache.class, "Deserialization of '" + pathInCache + "' failed.");
            if (raf != null) {
                this.closeCacheFileSafe(pathInCache);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleForJunk(String pathInCache) {
        Set<String> set = this.scheduledJunk;
        synchronized (set) {
            this.scheduledJunk.add(pathInCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processScheduledJunk() {
        String[] stringArray = this.scheduledJunk;
        synchronized (this.scheduledJunk) {
            String[] toProcess = this.scheduledJunk.toArray(new String[0]);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (String pathInCache : toProcess) {
                Set<String> set = this.scheduledJunk;
                synchronized (set) {
                    this.scheduledJunk.remove(pathInCache);
                }
                CachedEntity entityType = this.getEntityType(pathInCache);
                this.processJunk(pathInCache, entityType != null ? entityType : CachedEntity.ARTIFACT);
            }
            return;
        }
    }

    void expireOldOwnCreatedInfo(long limit) {
        this.createdByCache.expireOld(limit);
    }

    void incrementOldOwnCreatedInfoCounter() {
        this.createdByCache.incCounter();
    }

    long getOldOwnCreatedInfoCounter() {
        return this.createdByCache.getCounter();
    }

    void moveObjectToJunk(String name) throws TFCacheException, IllegalStateException {
        this.moveToJunk(CachedEntity.OBJECT, name);
    }

    void moveToJunk(CachedEntity entity, String artifactName) throws TFCacheException, IllegalStateException {
        this.allowedToXact();
        switch (entity) {
            case PACKAGE: {
                this.doMoveToJunk(CachedEntity.PACKAGE, this.packages, artifactName, ".pkg");
                break;
            }
            case ARTIFACT: {
                this.doMoveToJunk(CachedEntity.ARTIFACT, this.artifacts, artifactName, "");
                break;
            }
            case OBJECT: {
                this.doMoveToJunk(CachedEntity.OBJECT, this.objects, artifactName, XDO_EXT);
                break;
            }
            case TYPE: {
                this.doMoveToJunk(CachedEntity.TYPE, this.types, artifactName, ".type");
                break;
            }
            case GLOBAL_VARIABLES: {
                this.doMoveToJunk(CachedEntity.GLOBAL_VARIABLES, this.globals, artifactName, XDO_EXT);
                break;
            }
            case SERVICE: {
                this.doMoveToJunk(CachedEntity.SERVICE, this.services, artifactName, ".sco");
                break;
            }
            case TRANSPORT_FACTORY: {
                this.doMoveToJunk(CachedEntity.TRANSPORT_FACTORY, this.transportFactories, artifactName, ".tfo");
                break;
            }
            case JDBC_FACTORY: {
                this.doMoveToJunk(CachedEntity.JDBC_FACTORY, this.jdbcFactories, artifactName, ".dfo");
                break;
            }
            case CLIENT_FACTORY: {
                this.doMoveToJunk(CachedEntity.CLIENT_FACTORY, this.clientFactories, artifactName, ".cfo");
                break;
            }
            case LIB: {
                this.doMoveToJunk(CachedEntity.LIB, this.lib, artifactName, ".jar");
                break;
            }
            case EXT: {
                this.doMoveToJunk(CachedEntity.EXT, this.ext, artifactName, ".jar");
            }
        }
    }

    private void doMoveToJunk(CachedEntity entity, CacheSubDir subDir, String artifactName, String suffix) {
        String pathInCache;
        if (!((String)artifactName).endsWith(suffix)) {
            artifactName = (String)artifactName + suffix;
        }
        if (this.existsDistinctEntity(pathInCache = subDir.getPathInCacheWithinContext((String)artifactName))) {
            this.processJunk(pathInCache, entity);
        }
    }

    private void processJunk(String pathInCache, CachedEntity entityType) {
        Trace.logDebug(TFCache.class, "Illegal entity '" + pathInCache + "' found.");
        if (!this.junk.exists()) {
            Trace.logDebug(TFCache.class, "Creating Junk folder '" + this.junk.getAbsolutePath() + "'...");
            if (!this.junk.mkdir()) {
                Trace.logError(TFCache.class, "Creation of Junk folder failed.");
                return;
            }
        }
        if (!this.junk.isDirectory()) {
            Trace.logError(TFCache.class, "Non-directory file already exists at Junk folder location '" + this.junk.getAbsolutePath() + "'.");
            return;
        }
        try {
            if (this.lockTable.containsKey(pathInCache)) {
                this.closeCacheFile(pathInCache);
            }
            this.createdByCache.remove(pathInCache);
            this.ownersTable.removeEntity(pathInCache);
            FileIOUtils.moveToDirWithUniqueName(new File(this.cacheLocationCanonicalFile, pathInCache), this.junk);
            this.raiseRepositoryArtifactChangeAdvisory(Severity.WARNING, pathInCache, entityType, ArtifactState.TO_JUNK, "Illegal entity '" + pathInCache + "' found. Moved to Junk folder.");
            Trace.logInfo(TFCache.class, "Illegal entity '" + pathInCache + "' moved to Junk folder.");
        }
        catch (Exception exception) {
            Trace.logError(TFCache.class, exception.getMessage());
            this.scheduleForJunk(pathInCache);
        }
    }

    private TypeNamePair parseTypeNameFromFileName(String fileName, String expectedExt) throws UtilitiesException {
        int dotPos = fileName.indexOf(46);
        if (!fileName.endsWith(expectedExt)) {
            throw new UtilitiesException("Expected '" + expectedExt + "' extension for " + fileName);
        }
        String type = fileName.substring(0, dotPos);
        String name = fileName.substring(dotPos + 1, fileName.length() - expectedExt.length());
        if (name.indexOf(46) >= 0) {
            throw new UtilitiesException("Filename " + fileName + " does not match <type name>.<instanceName name>" + expectedExt + " format.");
        }
        return new TypeNamePair(type, name);
    }

    private RandomAccessFile openCacheFileSafeIfNotLocked(String pathInCache, CachedEntity entityType) {
        try {
            return this.openCacheFile(pathInCache, entityType);
        }
        catch (TFCacheException.AlreadyLocked ignored) {
            return null;
        }
        catch (Exception exception) {
            Trace.logException(TFCache.class, exception, true);
            return null;
        }
    }

    private RandomAccessFile getCacheFileSafe(String pathInCache) {
        try {
            return this.getCacheFile(pathInCache);
        }
        catch (Exception exception) {
            Trace.logException(TFCache.class, exception, true);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RandomAccessFile openLockAddToSyncFilesToClose(String pathInCache) {
        try {
            RandomAccessFile raf = new RandomAccessFile(new File(this.cacheLocationCanonicalFile, pathInCache), "r");
            Set<RandomAccessFile> set = this.syncFilesToClose;
            synchronized (set) {
                this.syncFilesToClose.add(raf);
            }
            return raf;
        }
        catch (FileNotFoundException e) {
            Trace.logException(TFCache.class, e, true);
            return null;
        }
    }

    private void throwInvalidPackage(Package pkg, String cause) throws TFCacheException {
        throw new TFCacheException("Package '" + pkg.getFullName() + "' is invalid. Cause: " + cause);
    }

    public void registerSystemObjectPath(String pathInCache) {
        this.skipMonitoringPaths.add(pathInCache.toUpperCase());
        this.skipMonitoringPaths.add(this.getSystemObjectBackupPathInCache(pathInCache).toUpperCase());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean skipProcessing(String pathInCache) {
        TFCache tFCache = this;
        if (pathInCache.equals(tFCache.nodeLock.getLockFileName())) return true;
        TFCache tFCache2 = this;
        if (pathInCache.equals(tFCache2.nodeLock.getLockFailFileName())) return true;
        if (!this.skipMonitoringPaths.contains(pathInCache.toUpperCase())) return false;
        return true;
    }

    private void processNewEntity(String pathInCache) {
        if (this.skipProcessing(pathInCache)) {
            return;
        }
        Trace.logDebug(TFCache.class, "New cached file '" + pathInCache + "' found.");
        CachedEntity entityType = this.getEntityType(pathInCache);
        if (entityType == null) {
            this.processJunk(pathInCache, CachedEntity.ARTIFACT);
        } else {
            this.processEntity(pathInCache, entityType, null, true);
        }
    }

    private RandomAccessFile processEntity(String pathInCache, CachedEntity entityType, Set<String> obsolete, boolean isNew) {
        EntityProcessor processor = this.entityProcessors.get((Object)entityType);
        if (processor != null) {
            return processor.doProcess(pathInCache, entityType, obsolete, isNew);
        }
        Trace.logException(TFCache.class, new TFCacheException("Entity processor is not registered for entity type: " + String.valueOf((Object)entityType)), true);
        this.processJunk(pathInCache, entityType);
        return null;
    }

    @Override
    public void onChange(FileMetaInfo state) {
        if (state.getLastState().equals((Object)FileState.CREATED)) {
            File file = new File(state.getAbsoluteFileName());
            try {
                if (FileIOUtils.isDescendantForCanonicalBase(this.cacheLocationCanonicalFile, file)) {
                    String pathInCache = this.getPathInCache(file);
                    if (file.exists() && !this.createdByCache.remove(pathInCache)) {
                        this.processNewEntity(pathInCache);
                    }
                } else {
                    Trace.logError(TFCache.class, "Non-cache location file state change received: " + file.getPath());
                }
            }
            catch (Exception exception) {
                Trace.logException(TFCache.class, exception, true);
            }
        }
    }

    private void updateEntity(String pathInCache, RandomAccessFile raf, byte[] content) throws IOException, NoSuchAlgorithmException, TFCacheException {
        if (raf.length() > 0L) {
            raf.setLength(0L);
        }
        byte[] hash = CryptoUtils.calcSha256Hash(content);
        raf.write(content);
        raf.getFD().sync();
        this.ownersTable.setHash(pathInCache, hash);
    }

    private void appendEntity(String pathInCache, RandomAccessFile raf, byte[] content) throws IOException, NoSuchAlgorithmException, TFCacheException {
        MessageDigest digest = CryptoUtils.createSha256Digest();
        if (raf.length() > 0L) {
            try {
                FileIOUtils.processStream(new FileInputStream(raf.getFD()), -1L, digest::update);
            }
            catch (UtilitiesException e) {
                throw new TFCacheException(e);
            }
        }
        digest.update(content);
        raf.write(content);
        raf.getFD().sync();
        this.ownersTable.setHash(pathInCache, digest.digest());
    }

    private void updateEntity(String pathInCache, RandomAccessFile raf, InputStream stream, int streamSize) throws IOException, NoSuchAlgorithmException, TFCacheException {
        if (raf.length() > 0L) {
            raf.setLength(0L);
        }
        this.doUpdateEntity(pathInCache, raf, stream, streamSize, CryptoUtils.createSha256Digest());
    }

    private void appendEntity(String pathInCache, RandomAccessFile raf, InputStream stream, int streamSize) throws IOException, NoSuchAlgorithmException, TFCacheException {
        MessageDigest digest = CryptoUtils.createSha256Digest();
        if (raf.length() > 0L) {
            try {
                FileIOUtils.processLargeStream(new FileInputStream(raf.getFD()), -1L, digest::update);
            }
            catch (UtilitiesException e) {
                throw new TFCacheException(e);
            }
        }
        this.doUpdateEntity(pathInCache, raf, stream, streamSize, digest);
    }

    private void doUpdateEntity(String pathInCache, RandomAccessFile raf, InputStream stream, int streamSize, MessageDigest digest) throws IOException, NoSuchAlgorithmException, TFCacheException {
        int nReadBytes;
        if (streamSize < 0) {
            streamSize = stream.available();
        }
        byte[] buffer = new byte[65536];
        long nTotalReadBytes = 0L;
        long remaining = streamSize;
        while (remaining > 0L && (nReadBytes = stream.read(buffer, 0, Utils.min(buffer.length, remaining))) != -1) {
            raf.write(buffer, 0, nReadBytes);
            digest.update(buffer, 0, nReadBytes);
            remaining = (long)streamSize - (nTotalReadBytes += (long)nReadBytes);
        }
        raf.getFD().sync();
        this.ownersTable.setHash(pathInCache, digest.digest());
    }

    public synchronized void resumeDirectoryMonitor() {
        this.ioThread.startMonitor();
        this.raiseRepositoryStateChangeAdvisory(RepositoryState.RESUMED, "Runtime Cache directory monitor resumed.");
    }

    public synchronized void suspendDirectoryMonitor() {
        this.ioThread.suspendMonitorAndWait();
        this.raiseRepositoryStateChangeAdvisory(RepositoryState.SUSPENDED, "Runtime Cache directory monitor suspended.");
    }

    private String getAbsolutePath(String pathInCache) throws TFCacheException {
        if (new File(pathInCache = StringUtils.trimSlashes(pathInCache)).isAbsolute()) {
            throw new TFCacheException("Absolute paths are not allowed to access TFCache entities");
        }
        return new File(this.cacheLocationCanonicalFile, pathInCache).getAbsolutePath();
    }

    public boolean isEntityLocked(String pathInCache) {
        return this.lockTable.containsKey(pathInCache);
    }

    public CacheArtifactInfo getCacheArtifactInfo(String pathInCache) throws TFCacheException {
        return this.getCacheEntityInfo(this.artifacts.getPathInCacheWithinContext(this.normalizePathInCache(pathInCache)), this.artifacts);
    }

    public CacheArtifactInfo getCacheEntityInfo(String pathInCache) throws TFCacheException {
        pathInCache = this.normalizePathInCache(pathInCache);
        CacheSubDir subDir = this.getSubDir(pathInCache);
        return this.getCacheEntityInfo(pathInCache, subDir);
    }

    private CacheArtifactInfo getCacheEntityInfo(String normalizedPathInCache, CacheSubDir subDir) throws TFCacheException {
        this.requireExistsDistinctEntity(normalizedPathInCache, subDir);
        File file = new File(this.cacheLocationCanonicalFile, normalizedPathInCache);
        if (!file.exists()) {
            subDir.incMiss();
            throw new CacheMissException("Entity '" + normalizedPathInCache + "' does not exist.");
        }
        CacheArtifactInfo result = new CacheArtifactInfo();
        result.setPathInCache(normalizedPathInCache);
        result.setSize(file.length());
        result.setLastModifiedTime(new Date(file.lastModified()));
        result.setCreationTime(new Date(this.ownersTable.getCreationTimeStamp(normalizedPathInCache)));
        result.setOwner(this.ownersTable.getOwner(normalizedPathInCache));
        result.setHash(this.ownersTable.getHash(normalizedPathInCache));
        result.setModificationLock(this.ownersTable.getModificationLock(normalizedPathInCache));
        result.setLocked(this.isEntityLocked(normalizedPathInCache));
        return result;
    }

    public void setEntityOwner(String pathInCache) throws TFCacheException {
        pathInCache = this.normalizePathInCache(pathInCache);
        this.requireExistsDistinctEntity(pathInCache, this.artifacts);
        String user = this.getCurrentUser();
        this.ownersTable.setOwner(pathInCache, user);
        this.raiseRepositoryArtifactChangeAdvisory(Severity.INFO, pathInCache, this.getEntityType(pathInCache), ArtifactState.OWNER_CHANGED, "Entity '" + pathInCache + "' owner was set to '" + user + "'");
    }

    public String getEntityOwner(String pathInCache) {
        pathInCache = this.normalizePathInCache(pathInCache);
        return this.ownersTable.getOwner(pathInCache);
    }

    public void lockEntityForModify(String pathInCache, LockType mlock) throws TFCacheException {
        pathInCache = this.normalizePathInCache(pathInCache);
        this.ownersTable.setModificationLock(pathInCache, mlock);
        this.raiseRepositoryArtifactChangeAdvisory(Severity.INFO, pathInCache, this.getEntityType(pathInCache), mlock.equals((Object)LockType.NONE) ? ArtifactState.UNLOCKED_FOR_MODIFY : ArtifactState.LOCKED_FOR_MODIFY, "Entity '" + pathInCache + "' modification lock was set to '" + String.valueOf((Object)mlock) + "'");
    }

    public void unlockEntityForModify(String pathInCache) throws TFCacheException {
        this.lockEntityForModify(pathInCache, LockType.NONE);
    }

    public void lockServiceConfiguration(String serviceName, String serviceType, LockType mlock) throws TFCacheException {
        String pathInCache = this.services.getPathInCacheWithinContext(serviceType + "." + serviceName + ".sco");
        this.lockEntityForModify(pathInCache, mlock);
    }

    public void lockTransportFactory(String factoryName, String factoryType, LockType mlock) throws TFCacheException {
        String pathInCache = this.transportFactories.getPathInCacheWithinContext(factoryType + "." + factoryName + ".tfo");
        this.lockEntityForModify(pathInCache, mlock);
    }

    public void lockJDBCFactory(String factoryName, String factoryType, LockType mlock) throws TFCacheException {
        String pathInCache = this.jdbcFactories.getPathInCacheWithinContext(factoryType + "." + factoryName + ".dfo");
        this.lockEntityForModify(pathInCache, mlock);
    }

    public void lockClientFactory(String factoryName, String factoryType, LockType mlock) throws TFCacheException {
        String pathInCache = this.clientFactories.getPathInCacheWithinContext(factoryType + "." + factoryName + ".cfo");
        this.lockEntityForModify(pathInCache, mlock);
    }

    private String pathToFs(String path) {
        if (File.separatorChar != '/') {
            path = path.replace('/', File.separatorChar);
        }
        return path;
    }

    void checkOpened() throws IllegalStateException {
        if (!this.isOpen()) {
            throw new IllegalStateException("Runtime cache is not open.", IllegalStateException.ErrorCode.CACHE_NOT_OPENED);
        }
    }

    void checkNotLocked() throws IllegalStateException, IOException {
        if (this.isLocked()) {
            throw new IllegalStateException("Runtime Cache is locked by another application.", IllegalStateException.ErrorCode.CACHE_ALREADY_LOCKED);
        }
    }

    static void checkNames(String instanceName, String typeName) throws TFCacheException {
        if (!StringUtils.validateString(instanceName)) {
            throw new TFCacheException("Instance name '" + instanceName + "' is invalid.");
        }
        if (!StringUtils.validateString(typeName)) {
            throw new TFCacheException("Type name '" + instanceName + "' is invalid.");
        }
    }

    static void checkName(String entityName) throws TFCacheException {
        if (!StringUtils.validateString(entityName)) {
            throw new TFCacheException("Name '" + entityName + "' is invalid.");
        }
    }

    static void checkObjectName(String name) throws TFCacheException {
        if (!StringUtils.validateObjectName(name)) {
            throw new TFCacheException("Object name '" + name + "' is invalid.");
        }
    }

    static void checkSemanticName(String typeName) throws TFCacheException {
        if (!StringUtils.validateSemanticName(typeName)) {
            throw new TFCacheException("Semantic type name '" + typeName + "' is invalid.");
        }
    }

    static void setDirty(Package pkg, boolean dirty) {
        try {
            SET_DIRTY_METHOD.invoke((Object)pkg, dirty);
        }
        catch (Exception exception) {
            Trace.logException(TFCache.class, exception, true);
        }
    }

    @Override
    protected void nextVersion(Package pkg) {
        super.nextVersion(pkg);
    }

    static {
        AbstractURLHandler.initHandlers(Arrays.asList(new TFCacheURLHandler(), new JarURLHandler()));
        PACKAGE_PATTERN = Pattern.compile("(?i)([^\\.]+)\\.([^\\.]+)");
        try {
            SET_DIRTY_METHOD = Package.class.getDeclaredMethod("setDirty", Boolean.TYPE);
            SET_DIRTY_METHOD.setAccessible(true);
        }
        catch (Throwable exception) {
            throw new RuntimeException("Initialization of TFCache failed.", exception);
        }
    }

    static class CacheStatistics {
        protected long PkgMiss = 0L;
        protected long ArtifactMiss = 0L;
        protected long ObjectMiss = 0L;
        protected long TypeMiss = 0L;
        protected long GlobalsMiss = 0L;
        protected long SvcMiss = 0L;
        protected long TransportMiss = 0L;
        protected long JDBCMiss = 0L;
        protected long ClientMiss = 0L;
        protected long ToolMiss = 0L;
        protected long libMiss = 0L;
        protected long extMiss = 0L;
        protected long evictMiss = 0L;

        CacheStatistics() {
        }
    }

    static class ExpirablePathStorage {
        private final HashMap<String, Long> pathSet = new HashMap();
        private final Lock lock = new ReentrantLock();
        private long counter = 0L;

        ExpirablePathStorage() {
        }

        public long getCounter() {
            return this.counter;
        }

        public void incCounter() {
            this.lock.lock();
            ++this.counter;
            this.lock.unlock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void expireOld(long limit) {
            this.lock.lock();
            try {
                List<String> toDelete = this.pathSet.entrySet().stream().filter(entry -> (Long)entry.getValue() <= limit).map(Map.Entry::getKey).collect(Collectors.toList());
                toDelete.forEach(this.pathSet::remove);
            }
            finally {
                this.lock.unlock();
            }
        }

        public void add(String path) {
            this.lock.lock();
            try {
                this.pathSet.put(StringUtils.trimTrailingSlashes(path), System.currentTimeMillis());
            }
            finally {
                this.lock.unlock();
            }
        }

        public boolean remove(String path) {
            this.lock.lock();
            try {
                boolean bl = this.pathSet.remove(path) != null;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        public boolean contains(String path) {
            this.lock.lock();
            try {
                boolean bl = this.pathSet.containsKey(path);
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        public void dump() {
            this.lock.lock();
            try {
                System.out.println(">>>CreatedByCache Dump");
                for (Map.Entry<String, Long> entry : this.pathSet.entrySet()) {
                    System.out.println(entry.getKey() + " " + String.valueOf(entry.getValue()));
                }
                System.out.println("<<<CreatedByCache Dump");
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    class PackagesCacheSubDir
    extends CacheSubDir {
        Map<String, String> packagesByArchive;

        PackagesCacheSubDir(CachedEntity type, String dirName) {
            super(type, dirName);
            this.packagesByArchive = new HashMap<String, String>();
        }

        synchronized void checkPackage(Package pkg) throws TFCacheException {
            String pkgName = pkg.getFullName();
            for (String jarName : pkg.listJARs()) {
                String anotherPkgName = this.packagesByArchive.get(jarName);
                if (anotherPkgName == null || anotherPkgName.equals(pkgName)) continue;
                TFCache.this.throwInvalidPackage(pkg, "Another package '" + anotherPkgName + "' already contains archive '" + jarName + "'.");
            }
        }

        synchronized void addPackage(Package pkg) {
            String pkgName = pkg.getFullName();
            for (String jarName : pkg.listJARs()) {
                this.packagesByArchive.put(jarName, pkgName);
            }
        }

        synchronized void removePackage(Package pkg) {
            for (String jarName : pkg.listJARs()) {
                this.packagesByArchive.remove(jarName);
            }
        }

        synchronized String getPackage(String jarName) {
            return this.packagesByArchive.get(jarName);
        }
    }

    class CacheSubDirWithContext
    extends CacheSubDir {
        private String context;
        private File contextCanonicalFile;

        CacheSubDirWithContext(CachedEntity type, String dirName) {
            super(type, dirName);
            this.context = "";
            this.contextCanonicalFile = this.getBaseCanonicalFile();
        }

        public String getContext() {
            return this.context;
        }

        public void setContext(String context) {
            this.context = StringUtils.trimLeadingSlashes(context, '/');
            this.contextCanonicalFile = new File(this.getBaseCanonicalFile(), context);
        }

        @Override
        public String getCurrentDir() {
            return this.getBaseDirName() + StringUtils.prependSeparatorIfNotEmptyAndRelative(TFCache.this.pathToFs(this.context));
        }

        @Override
        public File getCurrentCanonicalFile() {
            return this.contextCanonicalFile;
        }

        @Override
        public String getPathInSubDirWithinContext(String entityName) {
            if (entityName.startsWith("/")) {
                return this.getPathInSubDir(entityName);
            }
            return this.getContext() + (String)(entityName.length() > 0 ? "/" + entityName : entityName);
        }
    }

    class CacheSubDir {
        private CachedEntity type;
        private String dirName;
        private File canonicalFile;

        CacheSubDir(CachedEntity type, String dirName) {
            this.type = type;
            this.dirName = dirName;
            this.canonicalFile = new File(TFCache.this.cacheLocationCanonicalFile, dirName);
            TFCache.this.subDirByType.put(type, this);
        }

        public CachedEntity getType() {
            return this.type;
        }

        public String getBaseDirName() {
            return this.dirName;
        }

        public File getBaseCanonicalFile() {
            return this.canonicalFile;
        }

        public String getBaseCanonicalPath() {
            return this.canonicalFile.getPath();
        }

        public boolean containsPathInBase(String pathInCache) {
            return TFCache.this.isDescendantOrEquals(this.dirName, pathInCache);
        }

        public String getCurrentDir() {
            return this.dirName;
        }

        public File getCurrentCanonicalFile() {
            return this.canonicalFile;
        }

        public String getPathRelativeToBase(String pathInCache) {
            return StringUtils.trimSlashes(StringUtils.trimLeadingSlashes(pathInCache).substring(this.dirName.length()));
        }

        public String getPathInCache(String entityName) {
            entityName = TFCache.this.pathToFs(entityName);
            return this.getBaseDirName() + StringUtils.prependSeparatorIfNotEmptyAndRelative(entityName);
        }

        public String getPathInCacheWithinContext(String entityName) {
            if ((entityName = TFCache.this.pathToFs(entityName)).startsWith(File.separator)) {
                return this.getBaseDirName() + entityName;
            }
            return this.getCurrentDir() + StringUtils.prependSeparatorIfNotEmptyAndRelative(entityName);
        }

        public String getPathInSubDir(String entityName) {
            return entityName.startsWith("/") ? entityName : "/" + entityName;
        }

        public String getPathInSubDirWithinContext(String entityName) {
            return this.getPathInSubDir(entityName);
        }

        public File getFileWithinContext(String entityName) {
            return new File(this.getCurrentCanonicalFile(), entityName);
        }

        public File getFileFromBase(String entityName) {
            return new File(this.getBaseCanonicalFile(), entityName);
        }

        public void incMiss() {
            switch (this.type) {
                case ARTIFACT: {
                    ++TFCache.this.Statistics.ArtifactMiss;
                    break;
                }
                case CLIENT_FACTORY: {
                    ++TFCache.this.Statistics.ClientMiss;
                    break;
                }
                case EXT: {
                    ++TFCache.this.Statistics.extMiss;
                    break;
                }
                case GLOBAL_VARIABLES: {
                    ++TFCache.this.Statistics.GlobalsMiss;
                    break;
                }
                case JDBC_FACTORY: {
                    ++TFCache.this.Statistics.JDBCMiss;
                    break;
                }
                case LIB: {
                    ++TFCache.this.Statistics.libMiss;
                    break;
                }
                case PACKAGE: {
                    ++TFCache.this.Statistics.PkgMiss;
                    break;
                }
                case SERVICE: {
                    ++TFCache.this.Statistics.SvcMiss;
                    break;
                }
                case TRANSPORT_FACTORY: {
                    ++TFCache.this.Statistics.TransportMiss;
                    break;
                }
                case TYPE: {
                    ++TFCache.this.Statistics.TypeMiss;
                    break;
                }
                default: {
                    ++TFCache.this.Statistics.ArtifactMiss;
                }
            }
        }
    }

    class ArtifactProcessor
    implements EntityProcessor {
        ArtifactProcessor() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public RandomAccessFile doProcess(String pathInCache, CachedEntity entityType, Set<String> obsolete, boolean isNew) {
            boolean isDir = TFCache.this.isDirectory(pathInCache);
            if (!isNew) {
                if (isDir) return null;
                return TFCache.this.openCacheFileSafeIfNotLocked(pathInCache, entityType);
            }
            String extension = FileIOUtils.getExtension(pathInCache);
            String msg = "Artifact '" + pathInCache + "' added.";
            TFCache.this.raiseRepositoryArtifactChangeAdvisory(Severity.INFO, pathInCache, entityType, ArtifactState.CREATED, msg);
            if (!isDir) {
                RandomAccessFile raf = TFCache.this.openCacheFileSafeIfNotLocked(pathInCache, entityType);
                if (raf == null) return raf;
                TFCache.this.raiseRepositoryArtifactChangeAdvisory(Severity.INFO, pathInCache, entityType, ArtifactState.LOCKED, msg);
                return raf;
            }
            try {
                TFCache.this.ownersTable.createNewEntityInfo(pathInCache, null, 0L, TFCache.this.getCurrentUser());
                return null;
            }
            catch (Exception exception) {
                Trace.logException(TFCache.class, exception, true);
                return null;
            }
        }
    }

    class ExtProcessor
    extends AbstractArchiveProcessor {
        ExtProcessor() {
            super(TFCache.this.ext);
        }

        @Override
        public RandomAccessFile doProcess(String pathInCache, CachedEntity entityType, Set<String> obsolete, boolean isNew) {
            String jarName = this.doProcess(pathInCache, entityType);
            if (jarName == null) {
                return null;
            }
            if (isNew) {
                if (TFCache.this.isSynchronizedWithFs && !this.checkArchiveUniqueness(pathInCache, entityType, TFCache.this.lib, jarName, obsolete)) {
                    return null;
                }
                Trace.logDebug(TFCache.class, "New extension archive '" + pathInCache + "' found.");
            }
            return TFCache.this.isSynchronizedWithFs ? this.doProcessStandard(jarName, pathInCache, entityType, isNew) : this.doProcessAtOpening(jarName, pathInCache, entityType, isNew);
        }

        private RandomAccessFile doProcessAtOpening(String jarName, String pathInCache, CachedEntity entityType, boolean isNew) {
            RandomAccessFile raf = TFCache.this.openCacheFileSafeIfNotLocked(pathInCache, entityType);
            if (isNew && raf != null) {
                try {
                    TFCache.this.addToExtClassLoader(jarName, TFCache.this.getExtArchiveURL(jarName));
                }
                catch (Exception exception) {
                    Trace.logException(TFCache.class, exception, true);
                }
            }
            return raf;
        }

        private RandomAccessFile doProcessStandard(String jarName, String pathInCache, CachedEntity entityType, boolean isNew) {
            if (isNew) {
                try {
                    TFCache.this.addExtArchive(jarName, FileIOUtils.getFileContent(new File(".tfcache/" + pathInCache)));
                }
                catch (Exception exception) {
                    Trace.logException(TFCache.class, exception, true);
                }
            }
            try {
                return TFCache.this.getCacheFile(pathInCache);
            }
            catch (TFCacheException exception) {
                Trace.logException(TFCache.class, exception, true);
                return null;
            }
        }
    }

    class JunkNewKeepLockOldProcessor
    implements EntityProcessor {
        JunkNewKeepLockOldProcessor() {
        }

        @Override
        public RandomAccessFile doProcess(String pathInCache, CachedEntity entityType, Set<String> obsolete, boolean isNew) {
            if (isNew) {
                TFCache.this.processJunk(pathInCache, entityType);
                return null;
            }
            if (!TFCache.this.isDirectory(pathInCache)) {
                return TFCache.this.openCacheFileSafeIfNotLocked(pathInCache, entityType);
            }
            return null;
        }
    }

    class LibProcessor
    extends AbstractArchiveProcessor {
        LibProcessor() {
            super(TFCache.this.lib);
        }

        @Override
        public RandomAccessFile doProcess(String pathInCache, CachedEntity entityType, Set<String> obsolete, boolean isNew) {
            if (isNew) {
                TFCache.this.processJunk(pathInCache, entityType);
                return null;
            }
            String jarName = this.doProcess(pathInCache, entityType);
            if (jarName == null) {
                return null;
            }
            if (!this.checkArchiveUniqueness(pathInCache, entityType, TFCache.this.ext, jarName, obsolete)) {
                return null;
            }
            return TFCache.this.openCacheFileSafeIfNotLocked(pathInCache, entityType);
        }
    }

    class PackageProcessor
    implements EntityProcessor {
        PackageProcessor() {
        }

        @Override
        public RandomAccessFile doProcess(String pathInCache, CachedEntity entityType, Set<String> obsolete, boolean isNew) {
            if (isNew) {
                TFCache.this.processJunk(pathInCache, entityType);
                return null;
            }
            try {
                Package pkg = (Package)TFCache.this.deserialize(pathInCache, "Package", entityType);
                if (pkg != null) {
                    try {
                        String pkgFilename = pathInCache.substring(pathInCache.lastIndexOf(File.separatorChar) + 1);
                        if (!pkg.getArtifactName().equals(pkgFilename)) {
                            TFCache.this.throwInvalidPackage(pkg, "Package filename '" + pkgFilename + "' does not match to package name.");
                        }
                        TFCache.this.checkPackage(pkg);
                    }
                    catch (TFCacheException exception) {
                        Trace.logException(this, exception, false);
                        TFCache.this.processJunk(pathInCache, entityType);
                        return null;
                    }
                } else {
                    TFCache.this.processJunk(pathInCache, entityType);
                    return null;
                }
                TFCache.this.packages.addPackage(pkg);
            }
            catch (TFCacheException.AlreadyLocked exception) {
                return null;
            }
            return TFCache.this.getCacheFileSafe(pathInCache);
        }

        private Pair<String, String> parseFilename(String filename) {
            Matcher matcher = PACKAGE_PATTERN.matcher(filename);
            matcher.find();
            return new Pair<String, String>(matcher.group(1), matcher.group(2));
        }
    }

    class ObjectProcessor
    implements EntityProcessor {
        private final String objectsLocation;
        private final String protoLocation;
        private boolean isOk;
        private String model;
        private String instanceName;
        private String dirPath;
        private Object object;

        ObjectProcessor() {
            this.objectsLocation = TFCache.this.objects.getBaseDirName();
            this.protoLocation = TFCache.this.objects.getPathInCacheWithinContext("sys" + File.separatorChar + "datagram" + File.separatorChar + "prototype");
        }

        private void parseFilename(String filename) {
            if (!this.isOk) {
                return;
            }
            int dotPos = filename.indexOf(46);
            if (dotPos >= 0) {
                this.model = filename.substring(0, dotPos);
                this.instanceName = filename.substring(dotPos + 1);
                if (this.instanceName.indexOf(46) >= 0) {
                    Trace.logError(TFCache.class, "Instance name should not contain '.': " + filename);
                    this.isOk = false;
                }
            } else {
                this.model = filename;
                this.instanceName = "";
            }
        }

        private void checkInstanceDuplication() {
            if (!this.isOk) {
                return;
            }
            if (this.instanceName.length() > 0) {
                List<String> instances;
                String ending = "." + this.instanceName + TFCache.XDO_EXT;
                try {
                    instances = FileIOUtils.directoryList(TFCache.this.getAbsolutePath(this.dirPath), "*.xdo", true);
                }
                catch (Exception exception) {
                    Trace.logException(TFCache.class, exception, true);
                    this.isOk = false;
                    return;
                }
                for (String instance : instances) {
                    if (!instance.endsWith(ending) || instance.endsWith(TFCache.this.slash + this.model + ending)) continue;
                    Trace.logError(TFCache.class, "Instance already exists within the same context: " + instance);
                    this.isOk = false;
                    return;
                }
            }
        }

        private void deserialize(String pathInCache, CachedEntity entityType, boolean isNew) throws TFCacheException.AlreadyLocked {
            if (!this.isOk) {
                return;
            }
            if (isNew) {
                this.isOk = TFCache.this.deserialize(pathInCache, this.model, entityType) != null;
            } else {
                try {
                    TFCache.this.openCacheFile(pathInCache, entityType);
                }
                catch (TFCacheException.AlreadyLocked ex1) {
                    throw ex1;
                }
                catch (Exception exception) {
                    Trace.logException(TFCache.class, exception, false);
                    Trace.logError(TFCache.class, "Opening file '" + pathInCache + "' failed.");
                }
            }
        }

        @Override
        public RandomAccessFile doProcess(String pathInCache, CachedEntity entityType, Set<String> obsolete, boolean isNew) {
            boolean isDirectory = TFCache.this.isDirectory(pathInCache);
            if (isDirectory) {
                if (!isNew) {
                    return null;
                }
            } else if ((!isNew || TFCache.this.isDescendantOrEquals(this.protoLocation, pathInCache)) && this.isEntityValid(pathInCache)) {
                this.isOk = true;
                int lastSlash = pathInCache.lastIndexOf(File.separatorChar);
                this.dirPath = pathInCache.substring(0, lastSlash + 1);
                String extension = pathInCache.substring(pathInCache.length() - 4);
                String filename = pathInCache.substring(lastSlash + 1, pathInCache.length() - extension.length());
                this.object = null;
                this.parseFilename(filename);
                this.checkInstanceDuplication();
                try {
                    this.deserialize(pathInCache, entityType, isNew);
                    if (this.isOk) {
                        if (isNew) {
                            Trace.logDebug(TFCache.class, "Object artifact '" + filename + "' successfully loaded.");
                            String context = TFCache.this.objects.getPathRelativeToBase(this.dirPath).replace(TFCache.this.slash, "/");
                            TFCache.this.raiseRepositoryArtifactChangeAdvisory(Severity.INFO, pathInCache, CachedEntity.OBJECT, ArtifactState.CREATED, "Object '" + context + this.model + "." + this.instanceName + "' added.", true);
                        }
                        return TFCache.this.getCacheFileSafe(pathInCache);
                    }
                }
                catch (TFCacheException.AlreadyLocked exception) {
                    return null;
                }
            }
            TFCache.this.processJunk(pathInCache, entityType);
            return null;
        }

        private boolean isEntityValid(String pathInCache) {
            return pathInCache.endsWith(TFCache.XDO_EXT);
        }
    }

    class TypeProcessor
    implements EntityProcessor {
        private static final String extension = ".type";
        private static final String sysPrefix = "sys.";
        private boolean isOk;
        private boolean isNew;
        private String typeName;

        TypeProcessor() {
        }

        private void parseFilename(String filename) {
            if (!this.isOk) {
                return;
            }
            if (filename.startsWith(sysPrefix)) {
                if (this.isNew) {
                    Trace.logError(TFCache.class, "Addition of system types to filesystem is not allowed");
                    this.isOk = false;
                } else {
                    this.typeName = filename.substring(sysPrefix.length());
                }
            } else {
                this.typeName = filename;
            }
        }

        private void checkDuplication() {
            if (!this.isOk) {
                return;
            }
            try {
                if (this.isNew && TFCache.this.existsDistinctEntityErrorIfDiffCase(TFCache.this.types.getPathInCacheWithinContext(sysPrefix + this.typeName + extension))) {
                    Trace.logError(TFCache.class, "System type with the same name '" + this.typeName + "' already exists.");
                    this.isOk = false;
                }
            }
            catch (TFCacheException exception) {
                Trace.logException(TFCache.class, exception, false);
                this.isOk = false;
            }
        }

        private void deserialize(String pathInCache, CachedEntity entityType) throws TFCacheException.AlreadyLocked {
            if (!this.isOk) {
                return;
            }
            SemanticType type = (SemanticType)TFCache.this.deserialize(pathInCache, "SemanticType", entityType);
            if (type != null) {
                if (this.isNew && type.isSystem()) {
                    Trace.logError(TFCache.class, "Addition of system types to filesystem is not allowed.");
                    this.isOk = false;
                } else if (!type.getTypeName().equals(this.typeName)) {
                    Trace.logError(TFCache.class, "Semantic type name mismatch, read '" + type.getTypeName() + "', but the filename is: '" + this.typeName + ".type'.");
                    this.isOk = false;
                }
            } else {
                this.isOk = false;
            }
        }

        @Override
        public RandomAccessFile doProcess(String pathInCache, CachedEntity entityType, Set<String> obsolete, boolean isNew) {
            this.isNew = isNew;
            if (TFCache.this.types.containsPathInBase(pathInCache) && pathInCache.endsWith(extension)) {
                int onlySlash = pathInCache.lastIndexOf(File.separatorChar);
                if (pathInCache.indexOf(File.separatorChar) == onlySlash) {
                    this.isOk = true;
                    String filename = pathInCache.substring(onlySlash + 1, pathInCache.length() - extension.length());
                    this.parseFilename(filename);
                    this.checkDuplication();
                    try {
                        this.deserialize(pathInCache, entityType);
                        if (this.isOk) {
                            if (isNew) {
                                Trace.logDebug(TFCache.class, "Semantic type '" + this.typeName + "' successfully loaded.");
                                TFCache.this.raiseRepositoryArtifactChangeAdvisory(Severity.INFO, pathInCache, CachedEntity.TYPE, ArtifactState.CREATED, "Configuration '" + filename + "' added.", true);
                            }
                            return TFCache.this.getCacheFileSafe(pathInCache);
                        }
                    }
                    catch (TFCacheException.AlreadyLocked exception) {
                        return null;
                    }
                }
            }
            TFCache.this.processJunk(pathInCache, entityType);
            return null;
        }
    }

    class ClientFactoryProcessor
    extends SimpleSerializedEntityProcessor {
        ClientFactoryProcessor() {
            super(CachedEntity.CLIENT_FACTORY, "Client Factory", TFCache.this.clientFactories, ".cfo", false);
        }

        @Override
        public TypeNamePair readTypeName(String pathInCache, CachedEntity entityType) throws TFCacheException.AlreadyLocked {
            ClientFactory factory = (ClientFactory)TFCache.this.deserialize(pathInCache, "ClientFactory", entityType);
            return factory == null ? null : new TypeNamePair(factory.getFactoryType(), factory.getFactoryName());
        }
    }

    class JDBCFactoryProcessor
    extends SimpleSerializedEntityProcessor {
        JDBCFactoryProcessor() {
            super(CachedEntity.JDBC_FACTORY, "JDBC Factory", TFCache.this.jdbcFactories, ".dfo", false);
        }

        @Override
        public TypeNamePair readTypeName(String pathInCache, CachedEntity entityType) throws TFCacheException.AlreadyLocked {
            JDBCFactoryObject factory = (JDBCFactoryObject)TFCache.this.deserialize(pathInCache, "JDBCFactory", entityType);
            return factory == null ? null : new TypeNamePair(factory.getFactoryType(), factory.getFactoryName());
        }
    }

    class TransportFactoryProcessor
    extends SimpleSerializedEntityProcessor {
        TransportFactoryProcessor() {
            super(CachedEntity.TRANSPORT_FACTORY, "Transport Factory", TFCache.this.transportFactories, ".tfo", false);
        }

        @Override
        public TypeNamePair readTypeName(String pathInCache, CachedEntity entityType) throws TFCacheException.AlreadyLocked {
            TransportFactory factory = (TransportFactory)TFCache.this.deserialize(pathInCache, "TransportFactory", entityType);
            return factory == null ? null : new TypeNamePair(factory.getFactoryType(), factory.getFactoryName());
        }
    }

    class ServiceProcessor
    extends SimpleSerializedEntityProcessor {
        ServiceProcessor() {
            super(CachedEntity.SERVICE, "Service Configuration", TFCache.this.services, ".sco", false);
        }

        @Override
        public TypeNamePair readTypeName(String pathInCache, CachedEntity entityType) throws TFCacheException.AlreadyLocked {
            ServiceConfigurationObject sco = (ServiceConfigurationObject)TFCache.this.deserialize(pathInCache, "ServiceConfiguration", entityType);
            return sco == null ? null : new TypeNamePair(sco.getServiceType(), sco.getServiceName());
        }
    }

    protected static class FileObject {
        RandomAccessFile file = null;
        FileLock lock = null;
        CachedEntity type = null;
        int lockCounter;

        FileObject(RandomAccessFile raf, FileLock flock, CachedEntity entity) {
            this.file = raf;
            this.lock = flock;
            this.type = entity;
            this.lockCounter = 1;
        }

        public int getLockCounter() {
            return this.lockCounter;
        }

        public void lock() {
            ++this.lockCounter;
        }

        public void unlock() {
            --this.lockCounter;
        }
    }

    private static interface PutDataCallback
    extends DataProvider {
        public void checkNames() throws TFCacheException;

        public void success(String var1, String var2, ArtifactState var3, String var4) throws TFCacheException, IllegalStateException;
    }

    private static interface DataProvider {
        public byte[] getBytes() throws TFCacheException;

        public InputStream getStream();

        public int getStreamSize();
    }

    private static class SimpleDataProvider
    extends BytesDataProvider {
        private byte[] data;

        public SimpleDataProvider(byte[] data) {
            this.data = data;
        }

        @Override
        public byte[] getBytes() throws TFCacheException {
            return this.data;
        }
    }

    private static class ArchiveURLInputStream
    extends InputStream {
        private URLConnection connection;
        private InputStream is;

        ArchiveURLInputStream(String jarName) throws IOException {
            this.connection = new URL("tfcache:///lib/" + jarName).openConnection();
            this.is = this.connection.getInputStream();
        }

        @Override
        public int read() throws IOException {
            return this.is.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.is.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.is.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.is.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.connection.getContentLength();
        }

        @Override
        public void close() throws IOException {
            this.is.close();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.is.mark(readlimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.is.reset();
        }

        @Override
        public boolean markSupported() {
            return this.is.markSupported();
        }
    }

    static class TypeNamePair {
        private String type;
        private String name;

        public TypeNamePair(String type, String name) {
            this.type = type;
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }
    }

    static interface EntityProcessor {
        public RandomAccessFile doProcess(String var1, CachedEntity var2, Set<String> var3, boolean var4);
    }

    abstract class SimpleSerializedEntityProcessor
    implements EntityProcessor {
        private String extension;
        private CacheSubDir subDir;
        private CachedEntity entityType;
        private String entityTypeName;
        private boolean skipDeserializationAtStartup;

        public SimpleSerializedEntityProcessor(CachedEntity entityType, String entityTypeName, CacheSubDir subDir, String extension, boolean skipDeserializationAtStartup) {
            this.entityType = entityType;
            this.entityTypeName = entityTypeName;
            this.subDir = subDir;
            this.extension = extension;
            this.skipDeserializationAtStartup = skipDeserializationAtStartup;
        }

        public abstract TypeNamePair readTypeName(String var1, CachedEntity var2) throws TFCacheException.AlreadyLocked;

        @Override
        public RandomAccessFile doProcess(String pathInCache, CachedEntity entityType, Set<String> obsolete, boolean isNew) {
            TypeNamePair typeName;
            if (!this.entityType.equals((Object)entityType)) {
                Trace.logError(TFCache.class, "Entity processor type mismatch: " + String.valueOf((Object)this.entityType) + " is used for " + String.valueOf((Object)entityType) + ".");
                TFCache.this.processJunk(pathInCache, entityType);
                return null;
            }
            String fileName = this.subDir.getPathRelativeToBase(pathInCache);
            if (fileName.contains(File.separator)) {
                TFCache.this.processJunk(pathInCache, entityType);
                return null;
            }
            try {
                typeName = TFCache.this.parseTypeNameFromFileName(fileName, this.extension);
            }
            catch (UtilitiesException exception) {
                Trace.logException(TFCache.class, exception, false);
                TFCache.this.processJunk(pathInCache, entityType);
                return null;
            }
            if (!isNew && this.skipDeserializationAtStartup) {
                return TFCache.this.openCacheFileSafeIfNotLocked(pathInCache, entityType);
            }
            try {
                TypeNamePair readTypeName = this.readTypeName(pathInCache, entityType);
                if (readTypeName != null) {
                    if (readTypeName.getType().equals(typeName.getType()) && readTypeName.getName().equals(typeName.getName())) {
                        if (isNew) {
                            Trace.logDebug(TFCache.class, this.entityTypeName + " '" + typeName.getType() + "." + typeName.getName() + "' successfully loaded.");
                            TFCache.this.raiseRepositoryArtifactChangeAdvisory(Severity.INFO, pathInCache, entityType, ArtifactState.CREATED, "Configuration '" + typeName.getType() + "." + typeName.getName() + "' added.", true);
                        }
                        return TFCache.this.getCacheFileSafe(pathInCache);
                    }
                    Trace.logError(TFCache.class, this.entityTypeName + " type and name mismatch: '" + readTypeName.getType() + "." + readTypeName.getName() + " was read from file, but filename is '" + fileName + "'.");
                    TFCache.this.closeCacheFileSafe(pathInCache);
                }
                TFCache.this.processJunk(pathInCache, entityType);
            }
            catch (TFCacheException.AlreadyLocked alreadyLocked) {
                // empty catch block
            }
            return null;
        }
    }

    abstract class AbstractArchiveProcessor
    implements EntityProcessor {
        private CacheSubDir subDir;

        AbstractArchiveProcessor(CacheSubDir subDir) {
            this.subDir = subDir;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String doProcess(String pathInCache, CachedEntity entityType) {
            String jarName = this.subDir.getPathRelativeToBase(pathInCache);
            if (jarName.length() == 0) {
                return null;
            }
            if (!jarName.endsWith(".jar") || jarName.contains(File.separator)) {
                TFCache.this.processJunk(pathInCache, entityType);
                return null;
            }
            ZipFile jarFile = null;
            try {
                jarFile = new JarFile(new File(TFCache.this.cacheLocationCanonicalFile, pathInCache));
                ((JarFile)jarFile).getManifest();
            }
            catch (Exception exception) {
                Trace.logException(TFCache.class, exception, true);
                Trace.logError(TFCache.class, "Checking archive '" + pathInCache + "' failed. Moving to junk...");
                TFCache.this.processJunk(pathInCache, entityType);
                String string = null;
                return string;
            }
            finally {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return jarName;
        }

        boolean checkArchiveUniqueness(String pathInCache, CachedEntity entityType, CacheSubDir subDir, String jarName, Set<String> obsolete) {
            try {
                String pathInSubDir = subDir.getPathInCacheWithinContext(jarName);
                if (TFCache.this.existsDistinctEntityErrorIfDiffCase(pathInSubDir) && (obsolete == null || !obsolete.contains(pathInSubDir))) {
                    Trace.logError(TFCache.class, "Archive '" + jarName + "' already exists in " + subDir.getBaseDirName() + ". Moving '" + pathInCache + "' to Junk...");
                    TFCache.this.processJunk(pathInCache, entityType);
                    return false;
                }
            }
            catch (TFCacheException exception) {
                Trace.logException(TFCache.class, exception, true);
                Trace.logError(TFCache.class, "Archive '" + jarName + "' already exists in " + subDir.getBaseDirName() + ". Moving '" + pathInCache + "' to Junk...");
                TFCache.this.processJunk(pathInCache, entityType);
                return false;
            }
            return true;
        }
    }

    class JunkNewKeepOldProcessor
    implements EntityProcessor {
        JunkNewKeepOldProcessor() {
        }

        @Override
        public RandomAccessFile doProcess(String pathInCache, CachedEntity entityType, Set<String> obsolete, boolean isNew) {
            if (isNew) {
                TFCache.this.processJunk(pathInCache, entityType);
                return null;
            }
            if (!TFCache.this.isDirectory(pathInCache)) {
                return TFCache.this.openLockAddToSyncFilesToClose(pathInCache);
            }
            return null;
        }
    }

    private static abstract class StreamPutDataCallback
    implements PutDataCallback {
        private StreamPutDataCallback() {
        }

        @Override
        public byte[] getBytes() throws TFCacheException {
            return null;
        }
    }

    private static abstract class BytesPutDataCallback
    extends BytesDataProvider
    implements PutDataCallback {
        private BytesPutDataCallback() {
        }
    }

    private static abstract class BytesDataProvider
    implements DataProvider {
        private BytesDataProvider() {
        }

        @Override
        public InputStream getStream() {
            return null;
        }

        @Override
        public int getStreamSize() {
            return 0;
        }
    }

    private abstract class ArtifactDataCallback
    implements PutDataCallback {
        private ArtifactDataCallback() {
        }

        @Override
        public void checkNames() throws TFCacheException {
        }

        @Override
        public void success(String name, String pathInCache, ArtifactState state, String action) throws TFCacheException, IllegalStateException {
            TFCache.this.raiseRepositoryArtifactChangeAdvisory(Severity.INFO, pathInCache, CachedEntity.ARTIFACT, state, "Artifact '" + pathInCache + "' " + action + ".", true);
        }
    }
}

