/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.repository.cache;

import com.streamscape.Trace;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.repository.cache.SystemTableHelper;
import com.streamscape.repository.cache.TFCache;
import com.streamscape.repository.cache.TFCacheException;
import com.streamscape.repository.enums.CachedEntity;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sdo.enums.ArtifactState;
import com.streamscape.sdo.enums.Severity;
import java.io.File;
import java.util.concurrent.locks.ReentrantLock;

public abstract class SystemTableFile<T>
extends CloneableDataObject {
    protected T store;
    protected String name;
    protected ArtifactState recreatedState;
    protected String filePath;
    private transient TFCache cache;
    private transient ReentrantLock lock = new ReentrantLock(true);
    private boolean isDirty = false;
    private transient boolean isCorrupted = false;

    protected SystemTableFile(String name, String fileName, ArtifactState recreatedState) {
        this.name = name;
        this.filePath = fileName;
        this.recreatedState = recreatedState;
        this.cache = SystemTableHelper.getTfCache();
    }

    public void save() {
        this.save(true);
    }

    public synchronized void save(boolean deleteBackup) {
        try {
            this.lock.lock();
            this.cache.saveSystemObject(this.store, this.filePath, deleteBackup);
            this.setDirty(false);
        }
        catch (TFCacheException exception) {
            this.setDirty(true);
            Trace.logException(SystemTableFile.class, exception, true);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void load() throws TFCacheException {
        this.load(true);
    }

    public synchronized void load(boolean useBackup) throws TFCacheException {
        block6: {
            this.setCorrupted(false);
            try {
                this.lock.lock();
                if (this.cache.existsEntityFile(this.filePath)) {
                    try {
                        this.store = this.cache.loadSystemObject(this.filePath, useBackup);
                        break block6;
                    }
                    catch (TFCacheException exception) {
                        throw new TFCacheException("Reading system table '" + this.name + "' failed.", exception);
                    }
                }
                Trace.logInfo(SystemTableFile.class, "System table '" + this.name + "' not found. Recreating...");
                this.doRecreate(true);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copy(String toPath) throws Exception {
        File file = new File(this.cache.cacheLocationCanonicalFile, this.filePath);
        TFCache.FileObject fileObject = null;
        try {
            this.lock.lock();
            fileObject = this.cache.unlockEntityFile(this.filePath);
            FileIOUtils.copyFileDir(file, new File(toPath + "/" + this.name + ".sdo"));
        }
        finally {
            if (fileObject != null) {
                this.cache.restoreFileObject(fileObject, file, this.filePath);
            }
            this.lock.unlock();
        }
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    protected void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    public boolean isCorrupted() {
        return this.isCorrupted;
    }

    protected void setCorrupted(boolean isCorrupted) {
        this.isCorrupted = isCorrupted;
    }

    protected void recreate() {
        this.recreate(true);
    }

    protected void recreate(boolean saveBackup) {
        if (saveBackup) {
            this.saveBackup();
        }
        this.doRecreate(true);
    }

    private void doRecreate(boolean deleteSystemBackup) {
        this.createStore();
        this.save(deleteSystemBackup);
        this.setCorrupted(false);
        this.cache.raiseRepositoryArtifactChangeAdvisory(Severity.WARNING, this.filePath, CachedEntity.OBJECT, this.recreatedState, "System table '" + this.name + "' was recreated.");
        Trace.logInfo(SystemTableFile.class, "System table '" + this.name + "' recreated.");
    }

    private void saveBackup() {
        try {
            this.lock.lock();
            this.cache.saveSystemObject(this.store, this.filePath + ".backup", true);
        }
        catch (TFCacheException exception) {
            Trace.logException(SystemTableFile.class, exception, true);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected abstract void createStore();

    @Override
    public SystemTableFile<T> clone() {
        SystemTableFile result = (SystemTableFile)super.clone();
        result.store = this.store != null ? this.cloneStore() : null;
        return result;
    }

    protected abstract T cloneStore();
}

