/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.repository.cache;

import com.streamscape.Trace;
import com.streamscape.lib.utils.CryptoUtils;
import com.streamscape.lib.utils.RandomAccessFileInputStream;
import com.streamscape.omf.FactoryManagerException;
import com.streamscape.omf.java.JSerializer;
import com.streamscape.omf.java.JSerializerFactory;
import com.streamscape.repository.cache.IllegalStateException;
import com.streamscape.repository.cache.OwnersTable;
import com.streamscape.repository.cache.TFCache;
import com.streamscape.repository.cache.TFCacheException;
import com.streamscape.repository.enums.CachedEntity;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

class SystemObjectsPersister {
    private static Cipher cipher;
    private static final byte[] KEY_BYTES;
    private static final byte[] MARKER;
    private static final Key KEY;
    TFCache cache;
    JSerializer serializer;
    private static final Class FILES_CLASS;
    private static final Class PATH_CLASS;
    private static final Class COPY_OPTION_CLASS;
    private static final Class STANDARD_COPY_OPTION_CLASS;
    private static final Class COPY_OPTIONS_ARRAY_CLASS;
    private static final Method MOVE_METHOD;
    private static final Method DELETE_METHOD;
    private static final Method TO_PATH_METHOD;
    private static final Object OPTIONS;

    SystemObjectsPersister(TFCache cache) throws FactoryManagerException {
        this.cache = cache;
        this.serializer = JSerializerFactory.getInstance().getDefaultSerializer();
    }

    private static Class newClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Method getMethod(Class ownerClass, String methodName, Class[] parameterTypes) {
        try {
            return ownerClass.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void saveSystemObject(Object obj, String pathInCache, boolean deleteBackup) throws TFCacheException {
        TFCache.FileObject fileObject = this.cache.unlockEntityFile(pathInCache);
        File file = new File(this.cache.cacheLocationCanonicalFile, pathInCache);
        String pathInCacheBackup = this.cache.getSystemObjectBackupPathInCache(pathInCache);
        File backupFile = new File(this.cache.cacheLocationCanonicalFile, pathInCacheBackup);
        if (file.exists()) {
            this.cache.createdByCache.add(pathInCacheBackup);
            try {
                if (MOVE_METHOD != null) {
                    MOVE_METHOD.invoke(null, TO_PATH_METHOD.invoke((Object)file, new Object[0]), TO_PATH_METHOD.invoke((Object)backupFile, new Object[0]), OPTIONS);
                } else if (!file.renameTo(backupFile)) {
                    throw new IllegalStateException();
                }
            }
            catch (Throwable exception) {
                Object object;
                this.cache.createdByCache.remove(pathInCacheBackup);
                if (fileObject != null) {
                    this.cache.restoreFileObject(fileObject, file, pathInCache);
                }
                if (exception instanceof InvocationTargetException) {
                    exception = exception.getCause();
                }
                if (exception instanceof IllegalStateException) {
                    object = "";
                    throw new TFCacheException("Creation of backup file: '" + pathInCacheBackup + "' failed." + (String)object);
                }
                object = " Cause: " + exception.toString();
                throw new TFCacheException("Creation of backup file: '" + pathInCacheBackup + "' failed." + (String)object);
            }
        }
        try {
            block21: {
                if (!file.getParentFile().exists()) {
                    this.cache.mkdirs(file.getParentFile(), true);
                }
                if (fileObject != null) {
                    this.cache.createdByCache.add(pathInCache);
                    if (!this.cache.restoreFileObject(fileObject, file, pathInCache)) {
                        this.cache.createdByCache.remove(pathInCache);
                        throw new TFCacheException("Saving file '" + pathInCache + "' failed.");
                    }
                    this.saveEncryptedObject(fileObject.file, obj);
                } else {
                    this.saveEncryptedObject(this.cache.openCacheFile(pathInCache, CachedEntity.OBJECT, true), obj);
                }
                if (deleteBackup) {
                    try {
                        if (!backupFile.exists()) break block21;
                        if (DELETE_METHOD != null) {
                            DELETE_METHOD.invoke(null, TO_PATH_METHOD.invoke((Object)backupFile, new Object[0]));
                        } else {
                            backupFile.delete();
                        }
                    }
                    catch (Exception exception) {
                        Trace.logException(this, exception, true);
                        Trace.logError(this, "Removing backup file '" + pathInCacheBackup + "' failed.");
                    }
                }
            }
            Trace.logDebug(SystemObjectsPersister.class, "Object '" + pathInCache + "' saved.");
            return;
        }
        catch (IOException exception) {
            Trace.logException(SystemObjectsPersister.class, exception, true);
            throw new TFCacheException("Saving file '" + pathInCache + "' failed.");
        }
    }

    void saveSystemObject(Object obj, OutputStream outputStream) throws TFCacheException {
        try {
            DataOutputStream dataStream = new DataOutputStream(CryptoUtils.encryptOutputStream(outputStream, cipher, KEY));
            dataStream.write(MARKER);
            this.serializer.serialize(obj, dataStream);
            dataStream.close();
        }
        catch (Exception exception) {
            throw new TFCacheException("Saving system object failed.", exception);
        }
    }

    private Object loadEncryptedObject(RandomAccessFile file) throws Exception {
        DataInputStream stream = new DataInputStream(CryptoUtils.decryptInputStream(new RandomAccessFileInputStream(file), cipher, KEY));
        byte[] header = new byte[MARKER.length];
        stream.readFully(header);
        if (Arrays.equals(header, MARKER)) {
            Object result = this.serializer.deserialize(stream);
            stream.close();
            return result;
        }
        throw new TFCacheException("Wrong header. File is corrupted.");
    }

    private void saveEncryptedObject(final RandomAccessFile file, Object obj) throws TFCacheException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.saveSystemObject(obj, stream);
        try {
            stream.writeTo(new OutputStream(this){

                @Override
                public void write(int b) throws IOException {
                    Trace.logException(OwnersTable.class, new Exception("INTERNAL ERROR"), true);
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    file.write(b, off, len);
                }
            });
        }
        catch (IOException exception) {
            throw new TFCacheException(exception);
        }
    }

    private RandomAccessFile openCachedFile(String pathInCache) throws TFCacheException {
        return this.cache.isEntityLocked(pathInCache) ? this.cache.getCacheFile(pathInCache) : this.cache.openCacheFile(pathInCache, CachedEntity.OBJECT, true);
    }

    Object loadSystemObject(String pathInCache, boolean useBackup) throws TFCacheException {
        boolean existsBackup;
        Object result = null;
        String pathInCacheBackup = this.cache.getSystemObjectBackupPathInCache(pathInCache);
        File backupFile = new File(this.cache.cacheLocationCanonicalFile, pathInCacheBackup);
        if (useBackup && (existsBackup = backupFile.exists())) {
            Trace.logDebug(SystemObjectsPersister.class, "Backup file found: '" + pathInCacheBackup + "'. Trying to load...");
            RandomAccessFile raf = null;
            try {
                raf = new RandomAccessFile(backupFile, "r");
                result = this.loadEncryptedObject(raf);
            }
            catch (Exception exception) {
                Trace.logException(SystemObjectsPersister.class, exception, true);
                Trace.logError(SystemObjectsPersister.class, "Failed to load backup file.");
            }
            try {
                if (raf != null) {
                    raf.close();
                }
            }
            catch (IOException exception) {
                Trace.logException(SystemObjectsPersister.class, exception, true);
            }
        }
        if (result == null) {
            if (useBackup) {
                backupFile.delete();
            }
            if (this.cache.existsEntityFile(pathInCache)) {
                try {
                    return this.loadEncryptedObject(this.openCachedFile(pathInCache));
                }
                catch (Exception exception) {
                    throw exception instanceof TFCacheException ? (TFCacheException)exception : new TFCacheException(exception);
                }
            }
            throw new TFCacheException("Cached file '" + pathInCache + "' not found.");
        }
        Trace.logDebug(SystemObjectsPersister.class, "Backup file loaded. Saving to '" + pathInCache + "'...");
        try {
            RandomAccessFile raf = this.openCachedFile(pathInCache);
            this.saveEncryptedObject(raf, result);
            Trace.logDebug(SystemObjectsPersister.class, "'" + pathInCache + "' successfully saved.");
            backupFile.delete();
        }
        catch (Exception exception) {
            Trace.logException(SystemObjectsPersister.class, exception, true);
        }
        return result;
    }

    static {
        KEY_BYTES = new byte[]{35, 56, -33, 70, 88, -32, -58, -17, -70, 25, -32, 15, -114, 37, 127, -63};
        MARKER = new byte[]{37, 93, 5, 75, 89, -117, -108, 83, -103, -84, 101, 17, 66, 125, -74, -37};
        KEY = new SecretKeySpec(KEY_BYTES, "AES");
        try {
            cipher = Cipher.getInstance("AES");
        }
        catch (Exception ex) {
            Trace.logException(SystemObjectsPersister.class, ex, true);
        }
        FILES_CLASS = SystemObjectsPersister.newClass("java.nio.file.Files");
        PATH_CLASS = SystemObjectsPersister.newClass("java.nio.file.Path");
        COPY_OPTION_CLASS = SystemObjectsPersister.newClass("java.nio.file.CopyOption");
        STANDARD_COPY_OPTION_CLASS = SystemObjectsPersister.newClass("java.nio.file.StandardCopyOption");
        Class clazz = COPY_OPTIONS_ARRAY_CLASS = COPY_OPTION_CLASS != null ? Array.newInstance(COPY_OPTION_CLASS, 0).getClass() : null;
        if (FILES_CLASS != null) {
            MOVE_METHOD = SystemObjectsPersister.getMethod(FILES_CLASS, "move", new Class[]{PATH_CLASS, PATH_CLASS, COPY_OPTIONS_ARRAY_CLASS});
            DELETE_METHOD = SystemObjectsPersister.getMethod(FILES_CLASS, "delete", new Class[]{PATH_CLASS});
            TO_PATH_METHOD = SystemObjectsPersister.getMethod(File.class, "toPath", new Class[0]);
        } else {
            MOVE_METHOD = null;
            DELETE_METHOD = null;
            TO_PATH_METHOD = null;
        }
        if (COPY_OPTION_CLASS != null) {
            OPTIONS = Array.newInstance(COPY_OPTION_CLASS, 1);
            Array.set(OPTIONS, 0, Enum.valueOf(STANDARD_COPY_OPTION_CLASS, "REPLACE_EXISTING"));
        } else {
            OPTIONS = null;
        }
    }
}

