/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.repository.cache;

import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.repository.cache.IllegalStateException;
import com.streamscape.repository.cache.TFCache;
import com.streamscape.repository.cache.TFCacheException;
import com.streamscape.repository.enums.CachedEntity;
import com.streamscape.repository.enums.PackageType;
import com.streamscape.repository.globals.GlobalVariableCollection;
import com.streamscape.repository.object.ReferenceContext;
import com.streamscape.repository.pkg.Package;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sef.FabricComponent;
import com.streamscape.service.osf.clients.ClientFactory;
import com.streamscape.service.osf.jdbc.JDBCFactory;
import com.streamscape.service.osf.transports.TransportFactory;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.List;
import javax.naming.NamingException;

public interface RuntimeCache {
    public static final String FORCE_LOCK = "streamscape.runtime.cache.forcelock";
    public static final long Day = 86400000L;
    public static final long Hour = 3600000L;
    public static final long Minute = 60000L;
    public static final long Second = 1000L;
    public static final long NoExpire = 0L;

    public boolean exists();

    public boolean isLocked() throws IOException;

    public boolean isOpen();

    public void printLeasedEntities();

    public boolean inXact();

    public void beginXLocked(FabricComponent var1, long var2) throws InterruptedException, TFCacheException, IllegalStateException;

    public void endXLocked() throws InterruptedException, TFCacheException, IllegalStateException;

    public void abortXLocked();

    public List<String> listPackages(boolean var1) throws UtilitiesException, IllegalStateException;

    public List<String> listBindings(String var1) throws UtilitiesException, IllegalStateException;

    public List<String> listQualifiedBindings() throws UtilitiesException, IllegalStateException;

    public List<String> listArtifacts(boolean var1) throws UtilitiesException, IllegalStateException;

    public List<String> listServices(boolean var1) throws UtilitiesException, IllegalStateException, TFCacheException;

    public List<String> listTransportFactories(boolean var1) throws UtilitiesException, IllegalStateException, TFCacheException;

    public List<String> listJDBCFactories(boolean var1) throws UtilitiesException, IllegalStateException, TFCacheException;

    public List<String> listClientFactories(boolean var1) throws UtilitiesException, IllegalStateException, TFCacheException;

    public List<String> listSemanticTypes(boolean var1, boolean var2) throws UtilitiesException, IllegalStateException, TFCacheException;

    public List<String> listLibs(boolean var1) throws UtilitiesException, IllegalStateException;

    public List<String> listExts(boolean var1) throws UtilitiesException, IllegalStateException;

    public void extendLease(String var1, CachedEntity var2, long var3) throws TFCacheException, IllegalStateException;

    public Package getPackage(PackageType var1, String var2) throws TFCacheException, IllegalStateException;

    public void addPackage(Package var1, File[] var2) throws TFCacheException, IllegalStateException;

    public void forcePackage(String var1, PackageType var2, boolean var3) throws TFCacheException, IllegalStateException;

    public void putServiceConfiguration(ServiceConfigurationObject var1, long var2) throws TFCacheException, IllegalStateException;

    public ServiceConfigurationObject getServiceConfiguration(String var1, String var2) throws TFCacheException, IllegalStateException;

    public void putJDBCFactory(JDBCFactory var1, long var2) throws TFCacheException, IllegalStateException;

    public JDBCFactory getJDBCFactory(String var1, String var2) throws TFCacheException, IllegalStateException;

    public void putClientFactory(ClientFactory var1, long var2) throws TFCacheException, IllegalStateException;

    public ClientFactory getClientFactory(String var1, String var2) throws TFCacheException, IllegalStateException;

    public void putTransportFactory(TransportFactory var1, long var2) throws TFCacheException, IllegalStateException;

    public TransportFactory getTransportFactory(String var1, String var2) throws TFCacheException, IllegalStateException;

    public void addArchive(File var1) throws TFCacheException, IllegalStateException;

    public List<SemanticType> addExtensionArchive(File var1) throws TFCacheException, IllegalStateException;

    public void removeArchive(String var1, boolean var2) throws TFCacheException, IllegalStateException;

    public List<SemanticType> removeExtensionArchive(String var1, boolean var2) throws TFCacheException, IllegalStateException;

    public byte[] getArchive(String var1) throws TFCacheException, IllegalStateException;

    public URL getArchiveURL(String var1) throws TFCacheException, IllegalStateException;

    public List<URL> getExtensionURLs() throws TFCacheException, IllegalStateException;

    public boolean existsDistinctEntity(String var1, CachedEntity var2);

    public boolean existsBinding(String var1) throws TFCacheException, IllegalStateException, NamingException;

    public boolean existsSemanticType(String var1) throws TFCacheException, IllegalStateException, NamingException;

    public void putArtifact(byte[] var1, String var2, long var3) throws TFCacheException, IllegalStateException;

    public void putArtifact(File var1, String var2, long var3) throws TFCacheException, IllegalStateException;

    public byte[] getArtifact(String var1) throws TFCacheException, IllegalStateException;

    public RandomAccessFile getEntityAsFile(String var1, CachedEntity var2) throws TFCacheException, IllegalStateException;

    public GlobalVariableCollection getGlobalVariables() throws TFCacheException, IllegalStateException;

    public void putGlobalVariables(GlobalVariableCollection var1) throws TFCacheException, IllegalStateException;

    public ReferenceContext createSubcontext(ReferenceContext var1, String var2) throws SecurityViolationException, TFCacheException, IllegalStateException, NamingException;

    public ReferenceContext createSubcontext(String var1) throws SecurityViolationException, TFCacheException, IllegalStateException, NamingException;

    public void destroySubcontext(ReferenceContext var1) throws SecurityViolationException, TFCacheException, IllegalStateException, NamingException;

    public void expireEntity(String var1, CachedEntity var2) throws IllegalStateException, TFCacheException;

    public void setReferenceContext(ReferenceContext var1) throws TFCacheException, IllegalStateException, NamingException;

    public ReferenceContext getReferenceContext() throws TFCacheException, IllegalStateException;

    public ReferenceContext lookupReferenceContext(String var1) throws TFCacheException, IllegalStateException, NamingException;

    public List<String> listSubcontexts() throws TFCacheException, IllegalStateException;

    public void createDirectory(String var1) throws TFCacheException, IllegalStateException;

    public void deleteDirectory(String var1) throws TFCacheException, IllegalStateException;

    public void changeToDirectory(String var1) throws TFCacheException, IllegalStateException;

    public String getPresentWorkingDirectory() throws TFCacheException, IllegalStateException;

    public String getAbsoluteWorkingDirectory() throws TFCacheException, IllegalStateException;

    public List<String> listDirectories() throws TFCacheException, IllegalStateException;

    public SemanticType getSemanticType(String var1) throws TFCacheException, IllegalStateException;

    public List<SemanticType> getTypes(boolean var1) throws TFCacheException, IllegalStateException;

    public void addSemanticType(SemanticType var1, boolean var2) throws TFCacheException, IllegalStateException;

    public void removeSemanticType(String var1) throws TFCacheException, IllegalStateException, NamingException;

    public void forceSemanticType(String var1, boolean var2) throws SecurityViolationException, TFCacheException, IllegalStateException;

    public String resolveSemanticType(String var1) throws TFCacheException, IllegalStateException;

    public void putObject(Object var1, String var2, long var3) throws SecurityViolationException, TFCacheException, IllegalStateException, NamingException;

    public Object getObject(String var1, String var2) throws TFCacheException, IllegalStateException;

    public Object lookup(String var1) throws TFCacheException, IllegalStateException, NamingException;

    public String resolveClass(String var1) throws TFCacheException, IllegalStateException;

    public TFCache.CacheStatistics getStatistics() throws IllegalStateException;

    public boolean existsTypeInNamespace(String var1, String var2) throws IllegalStateException, TFCacheException, NamingException;

    public boolean isAdminRole();
}

