/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.repository.cache;

import com.streamscape.Trace;
import com.streamscape.lib.utils.CryptoUtils;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.omf.FactoryManagerException;
import com.streamscape.repository.cache.TFCache;
import com.streamscape.repository.cache.TFCacheException;
import com.streamscape.repository.enums.CachedEntity;
import com.streamscape.repository.enums.LockType;
import com.streamscape.sdo.enums.ArtifactState;
import com.streamscape.sdo.enums.Severity;
import com.streamscape.sef.container.ContainerLockSupport;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

public class OwnersTable {
    public static final String UNKNOWN_USER = "UNKNOWN";
    protected static String OWNERS_TABLE_PATH_IN_CACHE = "objects/sys/security/Owners.sdo";
    private TFCache cache;
    private boolean isAutoFlushEnabled;
    private ReentrantLock lock = new ReentrantLock(true);
    private boolean isCorrupted;
    private boolean isDirty;
    private boolean isInitialized = false;
    private Map<String, EntityInfoV2> infoByPathExactCase = new HashMap<String, EntityInfoV2>();
    private Map<String, String> pathByIgnoreCase = new HashMap<String, String>();

    public OwnersTable(TFCache cache) throws FactoryManagerException {
        this.cache = cache;
        this.isAutoFlushEnabled = true;
        this.setCorrupted(false);
        this.setDirty(false);
        cache.registerSystemObjectPath(OWNERS_TABLE_PATH_IN_CACHE);
    }

    public void setAutoFlushEnabled(boolean autoFlushEnabled) {
        this.isAutoFlushEnabled = autoFlushEnabled;
    }

    public String getOwner(String pathInCache) {
        EntityInfoV2 info = this.infoByPathExactCase.get(pathInCache);
        return info != null ? info.getOwnerId() : null;
    }

    public byte[] getHash(String pathInCache) {
        EntityInfoV2 info = this.infoByPathExactCase.get(pathInCache);
        return info != null ? info.getHash() : null;
    }

    public LockType getModificationLock(String pathInCache) {
        EntityInfoV2 info = this.infoByPathExactCase.get(pathInCache);
        return info != null ? info.getModificationLock() : null;
    }

    public long getCreationTimeStamp(String pathInCache) {
        EntityInfoV2 info = this.infoByPathExactCase.get(pathInCache);
        return info != null ? Long.valueOf(info.getCreationTimestamp()) : null;
    }

    public boolean containsPathExact(String pathInCache) {
        return this.infoByPathExactCase.containsKey(pathInCache);
    }

    public boolean containsPathIgnoreCase(String pathInCache) {
        return this.pathByIgnoreCase.containsKey(pathInCache.toUpperCase());
    }

    public boolean checkExistenceInExactCaseErrorIfDiff(String pathInCache) throws TFCacheException {
        if (!this.infoByPathExactCase.containsKey(pathInCache)) {
            this.checkWithDifferentCase(pathInCache);
            return false;
        }
        return true;
    }

    public String getPathInExactCase(String pathInCacheIgnoreCase) {
        return this.pathByIgnoreCase.get(pathInCacheIgnoreCase.toUpperCase());
    }

    private void checkWithDifferentCase(String pathInCache) throws TFCacheException {
        String pathDup = this.pathByIgnoreCase.get(pathInCache.toUpperCase());
        if (pathDup != null) {
            throw new TFCacheException("'" + pathInCache + "' already in owners table but in different case: '" + pathDup + "'.");
        }
    }

    private EntityInfoV2 getOrCreateInfo(String pathInCache) throws TFCacheException {
        EntityInfoV2 info = this.infoByPathExactCase.get(pathInCache);
        if (info == null) {
            this.checkWithDifferentCase(pathInCache);
            info = new EntityInfoV2();
            this.putInfo(pathInCache, info);
        }
        return info;
    }

    private void putInfo(String pathInCache, EntityInfoV2 info) {
        this.infoByPathExactCase.put(pathInCache, info);
        this.pathByIgnoreCase.put(pathInCache.toUpperCase(), pathInCache);
    }

    public void setOwner(String pathInCache, String owner) throws TFCacheException {
        try {
            this.lock.lock();
            this.getOrCreateInfo(pathInCache).setOwnerId(owner);
            this.changed();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setHash(String pathInCache, byte[] hash) throws TFCacheException {
        try {
            this.lock.lock();
            this.getOrCreateInfo(pathInCache).setHash(hash);
            this.changed();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setModificationLock(String pathInCache, LockType mlock) throws TFCacheException {
        try {
            this.lock.lock();
            this.getOrCreateInfo(pathInCache).setModificationLock(mlock);
            this.changed();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(String oldPathInCache, String newPathInCache) throws TFCacheException {
        try {
            this.lock.lock();
            ArrayList<String> paths = new ArrayList<String>(this.infoByPathExactCase.keySet());
            for (String oldPath : paths) {
                if (!oldPath.equals(oldPathInCache) && !oldPath.startsWith(oldPathInCache + File.separator)) continue;
                String newPath = newPathInCache + oldPath.substring(oldPathInCache.length());
                this.infoByPathExactCase.put(newPath, this.infoByPathExactCase.remove(oldPath));
                this.pathByIgnoreCase.remove(oldPath.toUpperCase());
                this.pathByIgnoreCase.put(newPath.toUpperCase(), newPath);
            }
            this.changed();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeEntity(String pathInCache) throws TFCacheException {
        try {
            this.lock.lock();
            if (this.infoByPathExactCase.remove(pathInCache) != null) {
                this.pathByIgnoreCase.remove(pathInCache.toUpperCase());
                this.changed();
            } else {
                this.checkWithDifferentCase(pathInCache);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void removeInfo(String pathInCache) {
        this.infoByPathExactCase.remove(pathInCache);
        this.pathByIgnoreCase.remove(pathInCache.toUpperCase());
    }

    private void fillPathsByIgnoreCase() {
        this.pathByIgnoreCase.clear();
        for (String path : this.infoByPathExactCase.keySet()) {
            this.pathByIgnoreCase.put(path.toUpperCase(), path);
        }
    }

    private void changed() {
        if (this.isAutoFlushEnabled) {
            try {
                this.save();
            }
            catch (Exception exception) {
                Trace.logException(this, exception, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createNewEntityInfo(String pathInCache, CryptoUtils.HashCalculator hashCalculator, long size, String owner) throws IOException, NoSuchAlgorithmException, TFCacheException {
        try {
            this.lock.lock();
            EntityInfoV2 info = new EntityInfoV2();
            info.setCreationTimestamp(System.currentTimeMillis());
            info.setOwnerId(owner);
            if (hashCalculator != null) {
                info.setHash(hashCalculator.calculateHash());
            }
            info.setSize(size);
            this.putInfo(pathInCache, info);
            this.changed();
            Trace.logDebug(OwnersTable.class, "Entity '" + pathInCache + "' added to owners table, set owner to " + owner + ".");
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkEntityInfo(String pathInCache, CryptoUtils.HashCalculator hashCalculator, long size, String owner) {
        if (pathInCache.equals(OWNERS_TABLE_PATH_IN_CACHE)) {
            return true;
        }
        try {
            this.lock.lock();
            EntityInfoV2 info = this.infoByPathExactCase.get(pathInCache);
            if (info == null) {
                this.checkWithDifferentCase(pathInCache);
                this.createNewEntityInfo(pathInCache, hashCalculator, size, owner);
                boolean bl = true;
                return bl;
            }
            if (!StringUtils.equalsNullSafe(info.getOwnerId(), owner)) {
                String msg = "Entity '" + pathInCache + "' owner '" + info.getOwnerId() + "' does not equal to current owner '" + owner + "'.";
                this.cache.raiseRepositoryArtifactChangeAdvisory(Severity.WARNING, pathInCache, this.cache.getEntityType(pathInCache), ArtifactState.RECOVER_OWNER_MISMATCH, msg);
                boolean bl = true;
                return bl;
            }
            if (hashCalculator != null) {
                switch (info.getModificationLock()) {
                    case EXCLUSIVE: 
                    case READ_ONLY: 
                    case READ_WRITE: {
                        if (size == info.getSize() && Arrays.equals(hashCalculator.calculateHash(), info.getHash())) break;
                        String msg = "Entity '" + pathInCache + "' have been modified outside of runtime.";
                        Trace.logError(OwnersTable.class, msg);
                        this.cache.raiseRepositoryArtifactChangeAdvisory(Severity.WARNING, pathInCache, this.cache.getEntityType(pathInCache), ArtifactState.RECOVER_INVALID_MODIFICATION, msg);
                        boolean bl = false;
                        return bl;
                    }
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            Trace.logException(OwnersTable.class, ex, true);
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void synchronizeWithFs(String pathInCache, Set<String> obsolete, String owner) {
        File file;
        block9: {
            block8: {
                file = new File(this.cache.cacheLocationCanonicalFile, (String)pathInCache);
                if (((String)pathInCache).equals(OWNERS_TABLE_PATH_IN_CACHE)) break block8;
                ContainerLockSupport.getCurrentNodeLock();
                if (!((String)pathInCache).equals(ContainerLockSupport.CurrentNodeLock.getLockFileName())) break block9;
            }
            return;
        }
        obsolete.remove(pathInCache);
        if (file.isDirectory()) {
            if (this.cache.artifacts.containsPathInBase((String)pathInCache)) {
                this.checkEntityInfo((String)pathInCache, null, 0L, owner);
            }
            if (((String)pathInCache).length() > 0) {
                pathInCache = (String)pathInCache + File.separator;
            }
            for (String child : file.list()) {
                this.synchronizeWithFs((String)pathInCache + child, obsolete, owner);
            }
        } else {
            this.checkEntityInfo((String)pathInCache, new CryptoUtils.Sha256FileHashCalculator(file), file.length(), owner);
        }
    }

    public Set<String> getPathSetExactCase() {
        return this.infoByPathExactCase.keySet();
    }

    public Set<String> getPathSetIgnoreCase() {
        return this.pathByIgnoreCase.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronizeWithFs(String owner) throws TFCacheException {
        try {
            this.lock.lock();
            HashSet<String> obsolete = new HashSet<String>(this.infoByPathExactCase.keySet());
            boolean saveAutoFlushEnabled = this.isAutoFlushEnabled;
            this.setAutoFlushEnabled(false);
            this.synchronizeWithFs("", obsolete, owner);
            for (String pathInCache : obsolete) {
                this.removeInfo(pathInCache);
                String msg = "Entity '" + pathInCache + "' not found on file system, removed from owners table.";
                Trace.logDebug(OwnersTable.class, msg);
                this.cache.raiseRepositoryArtifactChangeAdvisory(Severity.WARNING, pathInCache, this.cache.getEntityType(pathInCache), ArtifactState.NOT_EXISTS, msg, false);
            }
            this.save();
            this.setAutoFlushEnabled(saveAutoFlushEnabled);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isCorrupted() {
        return this.isCorrupted;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    private void setCorrupted(boolean corrupted) {
        this.isCorrupted = corrupted;
    }

    private void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    private void onTableCorrupt() {
        this.infoByPathExactCase = new HashMap<String, EntityInfoV2>();
        this.pathByIgnoreCase.clear();
        this.setCorrupted(true);
        this.cache.raiseRepositoryArtifactChangeAdvisory(Severity.WARNING, OWNERS_TABLE_PATH_IN_CACHE, CachedEntity.OBJECT, ArtifactState.RECOVER_OWNERS_TABLE, "Corrupted owners table was recreated.");
        Trace.logInfo(OwnersTable.class, "Owners table recreated.");
    }

    public synchronized void init() {
        if (!this.isInitialized) {
            this.load();
            this.isInitialized = true;
        }
    }

    private void fillFrom(Map map) {
        this.infoByPathExactCase = new HashMap<String, EntityInfoV2>();
        for (Map.Entry entry : map.entrySet()) {
            String pathInCache = (String)entry.getKey();
            if (!(entry.getValue() instanceof EntityInfo)) continue;
            EntityInfoV2 info = new EntityInfoV2((EntityInfo)entry.getValue());
            info.setCreationTimestamp(new File(this.cache.getCacheLocation(), pathInCache).lastModified());
            this.infoByPathExactCase.put(pathInCache, info);
        }
        this.fillPathsByIgnoreCase();
    }

    private void load() {
        block9: {
            this.setCorrupted(false);
            try {
                this.lock.lock();
                if (this.cache.existsEntityFile(OWNERS_TABLE_PATH_IN_CACHE)) {
                    try {
                        this.infoByPathExactCase = (Map)this.cache.loadSystemObject(OWNERS_TABLE_PATH_IN_CACHE);
                        if (!(this.infoByPathExactCase.values().iterator().next() instanceof EntityInfoV2)) {
                            this.fillFrom(this.infoByPathExactCase);
                        }
                        this.fillPathsByIgnoreCase();
                    }
                    catch (TFCacheException ex) {
                        try {
                            this.fillFrom((Map)this.cache.loadSystemObject(OWNERS_TABLE_PATH_IN_CACHE));
                            break block9;
                        }
                        catch (TFCacheException ex2) {
                            Trace.logException(OwnersTable.class, ex, true);
                            Trace.logError(OwnersTable.class, "Failed to read owners table.");
                            this.onTableCorrupt();
                        }
                    }
                    break block9;
                }
                Trace.logInfo(OwnersTable.class, "Owners table was not found, will be recreated.");
                this.onTableCorrupt();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void save() {
        try {
            this.lock.lock();
            this.cache.saveSystemObject(this.infoByPathExactCase, OWNERS_TABLE_PATH_IN_CACHE);
            this.setDirty(false);
            this.cache.resetOwnersSaveRetries();
        }
        catch (TFCacheException exception) {
            this.setDirty(true);
            Trace.logException(OwnersTable.class, exception, true);
        }
        finally {
            this.lock.unlock();
        }
    }

    static {
        OWNERS_TABLE_PATH_IN_CACHE = OWNERS_TABLE_PATH_IN_CACHE.replace('/', File.separatorChar);
    }

    static class EntityInfoV2
    extends EntityInfo {
        private long creationTimestamp;

        public EntityInfoV2() {
        }

        public EntityInfoV2(EntityInfo info) {
            this.setHash(info.getHash());
            this.setSize(info.getSize());
            this.setModificationLock(info.getModificationLock());
            this.setOwnerId(info.getOwnerId());
        }

        public long getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public void setCreationTimestamp(long creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }
    }

    static class EntityInfo {
        private String ownerId = null;
        private LockType modificationLock = LockType.NONE;
        private long size;
        private byte[] hash = null;

        public String getOwnerId() {
            return this.ownerId;
        }

        public void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public LockType getModificationLock() {
            return this.modificationLock;
        }

        public void setModificationLock(LockType modificationLock) {
            this.modificationLock = modificationLock;
        }

        public byte[] getHash() {
            return this.hash;
        }

        public void setHash(byte[] hash) {
            this.hash = hash;
        }

        public long getSize() {
            return this.size;
        }

        public void setSize(long size) {
            this.size = size;
        }
    }
}

