/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.repository.cache;

import com.streamscape.Trace;
import com.streamscape.lib.loader.LoadedPackagesProvider;
import com.streamscape.lib.loader.PackageLoaderRegistry;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.omf.java.SerialSchema;
import com.streamscape.omf.xml.XSerializerFactory;
import com.streamscape.repository.AbstractRepositoryContext;
import com.streamscape.repository.RepositoryException;
import com.streamscape.repository.UnsupportedCapabilityException;
import com.streamscape.repository.cache.CacheArtifactInfo;
import com.streamscape.repository.cache.IllegalStateException;
import com.streamscape.repository.cache.TFCache;
import com.streamscape.repository.cache.TFCacheException;
import com.streamscape.repository.enums.CachedEntity;
import com.streamscape.repository.enums.LockType;
import com.streamscape.repository.enums.PackageType;
import com.streamscape.repository.filesystem.FSFile;
import com.streamscape.repository.globals.GlobalVariableCollection;
import com.streamscape.repository.listeners.RepositoryArtifactChangeListener;
import com.streamscape.repository.listeners.RepositoryStateChangeListener;
import com.streamscape.repository.object.Binding;
import com.streamscape.repository.object.ReferenceContext;
import com.streamscape.repository.pkg.Package;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.pkg.PackageStore;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.advisory.RepositoryStateChangeAdvisory;
import com.streamscape.sdo.enums.RepositoryState;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.enums.ComponentModel;
import com.streamscape.sef.security.Groups;
import com.streamscape.sef.security.Organizations;
import com.streamscape.sef.security.SecurityManager;
import com.streamscape.sef.security.SecurityManagerException;
import com.streamscape.sef.security.Users;
import com.streamscape.service.osf.clients.ClientFactory;
import com.streamscape.service.osf.config.ClientFactoryPropertyValue;
import com.streamscape.service.osf.config.JDBCFactoryPropertyValue;
import com.streamscape.service.osf.config.ObjectPropertyValue;
import com.streamscape.service.osf.config.TransportFactoryPropertyValue;
import com.streamscape.service.osf.jdbc.JDBCFactory;
import com.streamscape.service.osf.transports.TransportFactory;
import com.streamscape.tools.mnode.ManagedNodes;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javax.naming.NameClassPair;
import javax.naming.NamingException;

public class MFContext
extends AbstractRepositoryContext {
    private TFCache cache;
    private boolean isOpen;
    private long token = 0L;
    private String beforeSudoUser = null;
    private RepositoryStateChangeListener rscListener;
    private RepositoryArtifactChangeListener racListener;
    private LoadedPackagesProvider loadedPackagesProvider;
    public static final String PROTOTYPE = "prototype";
    public static final String SCO_EXT = ".sco";
    private static final String TFO_EXT = ".tfo";
    private static final String DFO_EXT = ".dfo";
    private static final String CFO_EXT = ".cfo";
    private static final String PKG_EXT = ".pkg";
    private static final String WCO_EXT = ".wco";
    private EntityHelper serviceHelper = new ServiceHelper();
    private EntityHelper clientFactoryHelper = new ClientFactoryHelper();
    private EntityHelper transportFactoryHelper = new TransportFactoryHelper();
    private EntityHelper jdbcFactoryHelper = new JDBCFactoryHelper();
    private EntityHelper pkgHelper = new PackageHelper();

    public TFCache getTFCache() {
        return this.cache;
    }

    @Override
    public void init(HashMap<String, Object> env, HashMap<String, Object> props) throws RepositoryException {
        Object ioThreadGc;
        if (this.cache != null) {
            throw new RepositoryException(4013, "MFContext is already initialized");
        }
        super.init(env, props);
        if (!this.getEnvironment().get("streamscape.naming.provider.url").equals("tlp://local")) {
            throw new RepositoryException(4010, "MFContext supports only 'tlp://local' as Provider URL. '" + String.valueOf(this.getEnvironment().get("streamscape.naming.provider.url")) + "' is specified.");
        }
        PackageLoaderRegistry packageLoaderRegistry = (PackageLoaderRegistry)props.get("PACKAGE_LOAD_REGISTRY_OBJ");
        if (packageLoaderRegistry == null) {
            throw new RepositoryException(4012, "Package Loader Registry is not passed to Repository Context");
        }
        this.loadedPackagesProvider = (LoadedPackagesProvider)props.get("LOADED_PACKAGES_PROVIDER");
        if (this.loadedPackagesProvider == null) {
            throw new RepositoryException(4012, "Loaded Packages Provider is not passed to Repository Context");
        }
        String startupDir = (String)this.getEnvironment().get("streamscape.runtime.startup.dir");
        if (startupDir.equals(".")) {
            startupDir = System.getProperty("user.dir");
        }
        this.setInstallRoot((String)this.getEnvironment().get("streamscape.install.root"));
        this.cache = new TFCache(startupDir, packageLoaderRegistry, XSerializerFactory.getInstance());
        String user = "sysadmin";
        if (((Boolean)env.get("streamscape.runtime.enable.security")).booleanValue()) {
            this.cache.registerSystemObjectPath(Organizations.TABLE_PATH_IN_CACHE);
            this.cache.registerSystemObjectPath(Users.TABLE_PATH_IN_CACHE);
            this.cache.registerSystemObjectPath(Groups.TABLE_PATH_IN_CACHE);
            user = (String)env.get("streamscape.naming.security.principal");
        }
        this.cache.registerSystemObjectPath(ManagedNodes.TABLE_PATH_IN_CACHE);
        this.cache.registerSystemObjectPath(SerialSchema.TABLE_PATH_IN_CACHE);
        try {
            this.cache.setCurrentUser(user);
        }
        catch (SecurityManagerException exception) {
            throw new RepositoryException(4018, (Throwable)exception);
        }
        Object ioThreadCycleValue = props.get("IoThreadCycle");
        if (ioThreadCycleValue != null) {
            try {
                this.cache.setIoThreadCycle(Long.parseLong(String.valueOf(ioThreadCycleValue)));
            }
            catch (NumberFormatException exception) {
                Trace.logError(MFContext.class, "Parsing of 'IoThreadCycle' repository parameter value: '" + String.valueOf(ioThreadCycleValue) + "' failed.");
            }
        }
        if ((ioThreadGc = props.get("IoThreadGc")) != null) {
            try {
                this.cache.setIoThreadGc(Integer.parseInt(String.valueOf(ioThreadGc)));
            }
            catch (NumberFormatException ex) {
                Trace.logError(MFContext.class, "Parsing of 'IoThreadGc' repository parameter value: '" + String.valueOf(ioThreadGc) + "'failed.");
            }
        }
    }

    @Override
    public boolean exists() {
        return this.cache.exists();
    }

    @Override
    public long open(boolean create) throws RepositoryException, com.streamscape.repository.IllegalStateException {
        if (this.isOpen()) {
            throw new com.streamscape.repository.IllegalStateException("Repository context is already open.");
        }
        try {
            if (this.cache.exists()) {
                if (create) {
                    FileIOUtils.deleteFileDir(new File(this.cache.getCacheLocation()));
                }
            } else if (create) {
                this.cache.init();
            } else {
                throw new RepositoryException(4017, "Repository does not exist at '" + this.cache.getCacheLocation() + "'.");
            }
            this.cache.open(this.getSystemId(), (Boolean)this.getEnvironment().get("streamscape.runtime.cache.forcelock"), false);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
        this.isOpen = true;
        this.token = new Random().nextLong();
        return this.token;
    }

    private void checkToken(long token) throws RepositoryException {
        if (this.token != token) {
            throw new RepositoryException(4011, "Security token is invalid.");
        }
    }

    @Override
    public void close(long token) throws RepositoryException, com.streamscape.repository.IllegalStateException {
        this.checkToken(token);
        this.checkOpened();
        if (this.inXact()) {
            this.commitXact();
            Trace.logDebug(MFContext.class, "Auto commit forced on close.");
        }
        try {
            this.cache.close();
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
        this.isOpen = false;
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void removeAll() throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        try {
            this.cache.destroy();
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public void beginXact(FabricComponent component, long timeout) throws InterruptedException, RepositoryException {
        super.beginXact(component, timeout);
        try {
            this.cache.beginXLocked(component, timeout);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public void commitXact() throws RepositoryException {
        super.commitXact();
        try {
            this.cache.endXLocked();
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public void rollbackXact() throws RepositoryException {
        super.rollbackXact();
        this.cache.abortXLocked();
    }

    @Override
    public void abortXact() {
        super.abortXact();
        this.cache.abortXLocked();
    }

    @Override
    public void sudo(long token) throws RepositoryException {
        this.checkToken(token);
        this.allowedToXact();
        this.checkOpened();
        if (this.beforeSudoUser != null) {
            Trace.logInfo(MFContext.class, "MFContext is already in sudo mode");
        } else {
            this.cache.suspendDirectoryMonitor();
            String user = this.cache.getCurrentUser();
            try {
                this.cache.setCurrentUser("sysadmin");
            }
            catch (SecurityManagerException exception) {
                this.cache.resumeDirectoryMonitor();
                throw new RepositoryException(4018, (Throwable)exception);
            }
            this.beforeSudoUser = user;
        }
    }

    @Override
    public void unsudo(long token) throws RepositoryException {
        this.checkToken(token);
        this.allowedToXact();
        this.checkOpened();
        if (this.beforeSudoUser != null) {
            try {
                this.cache.setCurrentUser(this.beforeSudoUser);
            }
            catch (SecurityManagerException exception) {
                throw new RepositoryException(4018, (Throwable)exception);
            }
            this.beforeSudoUser = null;
            this.cache.resumeDirectoryMonitor();
        } else {
            Trace.logInfo(MFContext.class, "MFContext is NOT in sudo mode");
        }
    }

    @Override
    public void setRepositoryStateChangeListener(RepositoryStateChangeListener listener) throws RepositoryException {
        if (this.rscListener != null) {
            throw new RepositoryException(4002, "RepositoryStateChangeListener is already set.");
        }
        this.rscListener = listener;
        this.cache.setStateChangeListener(listener);
    }

    @Override
    public void setRepositoryArtifactChangeListener(RepositoryArtifactChangeListener listener) throws RepositoryException {
        if (this.racListener != null) {
            throw new RepositoryException(4002, "RepositoryStateChangeListener is already set.");
        }
        this.racListener = listener;
        this.cache.setArtifactChangeListener(listener);
    }

    @Override
    public void setSecurityManager(SecurityManager securityManager) throws RepositoryException {
        if (securityManager == null) {
            throw new RepositoryException(4003, "Security Manager is null.");
        }
        try {
            this.cache.setSecurityManager(securityManager);
        }
        catch (SecurityManagerException exception) {
            throw new RepositoryException(4018, (Throwable)exception);
        }
    }

    @Override
    public String setCurrentUser(String userName) throws RepositoryException {
        String result = this.cache.getCurrentUser();
        try {
            if (userName != null) {
                this.allowedToXact();
                this.cache.setCurrentUser(userName);
            }
        }
        catch (SecurityManagerException exception) {
            throw new RepositoryException(4018, (Throwable)exception);
        }
        return result;
    }

    @Override
    public void initObjectReferenceRepository() throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        try {
            this.cache.setReferenceContext(this.getRootContext());
            for (String contextName : this.cache.listSubcontexts()) {
                this.cache.destroySubcontext(this.cache.lookupReferenceContext(contextName));
            }
            for (String objectName : this.cache.listQualifiedBindings()) {
                this.cache.removeObject(objectName);
            }
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    private void clearSubcontext(ReferenceContext context, boolean isRemoveObjects) throws RepositoryException {
        try {
            this.cache.setReferenceContext(context);
            for (String contextName : this.cache.listSubcontexts()) {
                this.clearSubcontext(this.cache.lookupReferenceContext(contextName), isRemoveObjects);
            }
            this.cache.setReferenceContext(context);
            if (isRemoveObjects) {
                for (String objectName : this.cache.listQualifiedBindings()) {
                    this.cache.removeObject(objectName);
                }
            }
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public void clearObjectReferenceRepository() throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        this.clearSubcontext(this.getRootContext(), false);
    }

    @Override
    public void setReferenceContext(ReferenceContext ctx) throws NamingException, RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        try {
            this.cache.setReferenceContext(ctx);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public ReferenceContext getReferenceContext() throws RepositoryException {
        this.checkOpened();
        try {
            return this.cache.getReferenceContext();
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return null;
        }
    }

    @Override
    public ReferenceContext getRootContext() throws RepositoryException {
        this.checkOpened();
        try {
            return this.cache.lookupReferenceContext("/");
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return null;
        }
    }

    @Override
    public ReferenceContext createSubcontext(ReferenceContext parentContext, String relativeNamespace) throws NamingException, RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        try {
            return this.cache.createSubcontext(parentContext, relativeNamespace);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return null;
        }
    }

    @Override
    public ReferenceContext createSubcontext(String ctxNamespace) throws NamingException, RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        try {
            return this.cache.createSubcontext(ctxNamespace);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return null;
        }
    }

    @Override
    public void destroySubcontext(ReferenceContext ctx) throws NamingException, RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        try {
            this.cache.destroySubcontext(ctx);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public Object lookup(String name) throws NamingException, RepositoryException {
        this.checkOpened();
        try {
            return this.cache.lookup(name);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return null;
        }
    }

    @Override
    public Object lookup(String namespace, String objectName) throws NamingException, RepositoryException {
        this.checkOpened();
        this.allowedToXact();
        ReferenceContext context = this.lookupReferenceContext(namespace);
        if (context == null) {
            MFContext.throwException(4000, "Reference context '" + namespace + "' does not exist.");
        }
        return this.doLookup(context, objectName, this.getReferenceContext());
    }

    @Override
    public Object lookup(ReferenceContext context, String objectName) throws NamingException, RepositoryException {
        this.checkOpened();
        this.allowedToXact();
        return this.doLookup(context, objectName, this.getReferenceContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doLookup(ReferenceContext context, String objectName, ReferenceContext oldContext) throws NamingException, RepositoryException {
        this.setReferenceContext(context);
        try {
            Object object = this.lookup(objectName);
            return object;
        }
        finally {
            this.setReferenceContext(oldContext);
        }
    }

    @Override
    public boolean existsBinding(String name) throws NamingException, RepositoryException {
        this.checkOpened();
        try {
            return this.cache.existsBinding(name);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return false;
        }
    }

    @Override
    public ReferenceContext lookupReferenceContext(String ctxNamespace) throws NamingException, RepositoryException {
        this.checkOpened();
        try {
            return this.cache.lookupReferenceContext(ctxNamespace);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return null;
        }
    }

    @Override
    public boolean existsReferenceContext(String ctxNamespace) throws NamingException, RepositoryException {
        this.checkOpened();
        try {
            return this.cache.existsReferenceContext(ctxNamespace);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return false;
        }
    }

    private void checkBinding(String name) throws RepositoryException {
        try {
            if (!this.cache.existsBinding(name)) {
                throw new RepositoryException(4024, "Object '" + name + "' is not bound to context '" + String.valueOf(this.getReferenceContext()) + "'.");
            }
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    private void checkBindingIsAbsent(String name) throws RepositoryException {
        try {
            if (this.cache.existsBinding(name)) {
                throw new RepositoryException(4025, "Object '" + name + "' is already bound to context '" + String.valueOf(this.getReferenceContext()) + "'.");
            }
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public void bind(String name, Object obj) throws NamingException, RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        try {
            this.checkBindingIsAbsent(name);
            this.cache.putObject(obj, name, 0L);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException, RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        String rebindName = name + "$rebind";
        if (this.existsBinding(rebindName)) {
            if (this.existsBinding(name)) {
                this.unbind(rebindName);
            } else {
                this.rename(rebindName, name);
            }
        }
        this.bind(rebindName, obj);
        this.unbind(name);
        this.rename(rebindName, name);
    }

    @Override
    public void updateObject(String objectType, String objectName, Object obj) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        try {
            this.cache.updateObject(objectType, objectName, obj);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException, RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        try {
            this.checkBinding(oldName);
            this.checkBindingIsAbsent(newName);
            Object oldObject = this.cache.lookup(oldName);
            this.unbind(oldName);
            this.bind(newName, oldObject);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public void unbind(String name) throws NamingException, RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        try {
            boolean exists = false;
            for (String binding : this.cache.listQualifiedBindings()) {
                String normalName;
                StringTokenizer st = new StringTokenizer(binding, ".");
                int nTokens = st.countTokens();
                if (nTokens == 1) {
                    normalName = StringUtils.deNormalizeObjectName(binding);
                    if (!name.equals(normalName)) continue;
                    exists = true;
                    this.cache.removeObject(binding);
                    continue;
                }
                if (nTokens == 2) {
                    st.nextToken();
                    normalName = st.nextToken();
                    if (!name.equals(normalName = StringUtils.deNormalizeObjectName(normalName))) continue;
                    exists = true;
                    this.cache.removeObject(binding);
                    continue;
                }
                throw new RepositoryException(4005, "Object name is invalid: wrong number of tokens.");
            }
            if (!exists) {
                throw new RepositoryException(4024, "Object '" + name + "' is not bound to context '" + String.valueOf(this.getReferenceContext()) + "'.");
            }
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public String resolveClass(String className) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        try {
            return this.cache.resolveClass(className);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listBoundNames(ReferenceContext ctx, String typeFilter) throws NamingException, RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        ReferenceContext savedContext = null;
        try {
            savedContext = this.getReferenceContext();
            this.setReferenceContext(ctx);
            List<String> list = this.cache.listBindings(typeFilter);
            return list;
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            List<String> list = null;
            return list;
        }
        finally {
            this.restoreRefCtx(savedContext);
        }
    }

    @Override
    public List<String> listBoundNames(String typeFilter) throws RepositoryException {
        this.checkOpened();
        try {
            return this.cache.listBindings(typeFilter);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return null;
        }
    }

    @Override
    public List<String> listSubcontexts() throws RepositoryException {
        this.checkOpened();
        try {
            return this.cache.listSubcontexts();
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Binding> listBindings(ReferenceContext ctx) throws NamingException, RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        ReferenceContext savedContext = null;
        try {
            savedContext = this.getReferenceContext();
            this.setReferenceContext(ctx);
            List<Binding> list = this.listBindings();
            return list;
        }
        finally {
            this.restoreRefCtx(savedContext);
        }
    }

    @Override
    public List<Binding> listBindings() throws RepositoryException {
        this.checkOpened();
        ArrayList<Binding> result = new ArrayList<Binding>();
        try {
            ReferenceContext ctx = this.cache.getReferenceContext();
            this.processBindings((type, name, clazz) -> {
                Binding binding = new Binding(name, clazz, type, true);
                binding.setName(name);
                binding.setNameInNamespace(ctx.getContextNameSpace() + "/" + name);
                binding.setObject(this.cache.lookup(name));
                result.add(binding);
            });
            for (String ctxName : this.cache.listSubcontexts()) {
                Binding binding = new Binding(ctxName, ReferenceContext.class.getName(), "ReferenceContext", true);
                binding.setName(ctxName);
                binding.setNameInNamespace(ctx.getContextNameSpace() + "/" + ctxName);
                try {
                    binding.setObject(this.cache.lookupReferenceContext(ctxName));
                }
                catch (Exception exception) {
                    MFContext.processException(exception);
                }
                result.add(binding);
            }
            return result;
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NameClassPair> list(ReferenceContext ctx) throws NamingException, RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        ReferenceContext savedContext = null;
        try {
            savedContext = this.getReferenceContext();
            this.setReferenceContext(ctx);
            List<NameClassPair> list = this.list();
            return list;
        }
        finally {
            this.restoreRefCtx(savedContext);
        }
    }

    @Override
    public List<NameClassPair> list() throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        ArrayList<NameClassPair> result = new ArrayList<NameClassPair>();
        try {
            ReferenceContext ctx = this.cache.getReferenceContext();
            this.processBindings((type, name, clazz) -> {
                NameClassPair ncp = new NameClassPair(name, clazz, true);
                ncp.setName(name);
                ncp.setNameInNamespace(ctx.getContextNameSpace() + "/" + name);
                result.add(ncp);
            });
            for (String ctxName : this.cache.listSubcontexts()) {
                NameClassPair ncp = new NameClassPair(ctxName, ReferenceContext.class.getName(), true);
                ncp.setName(ctxName);
                ncp.setNameInNamespace(ctx.getContextNameSpace() + "/" + ctxName);
                result.add(ncp);
            }
            return result;
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object loadObject(ObjectPropertyValue scoParameterValue) throws NamingException, RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        if (scoParameterValue == null) {
            throw new RepositoryException(4003, "Object parameter value is null.");
        }
        if (!StringUtils.validateString(scoParameterValue.getObjectName())) {
            throw new NamingException("Object name '" + scoParameterValue.getObjectName() + "' is invalid.");
        }
        ReferenceContext savedContext = this.getReferenceContext();
        this.setReferenceContext(scoParameterValue.getReferenceContext());
        try {
            Object object = this.cache.getObject(scoParameterValue.getObjectName(), scoParameterValue.getObjectType());
            return object;
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            Object var4_5 = null;
            return var4_5;
        }
        finally {
            this.restoreRefCtx(savedContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listQualifiedBoundNames(ReferenceContext ctx) throws NamingException, RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        ReferenceContext savedContext = null;
        try {
            savedContext = this.getReferenceContext();
            this.setReferenceContext(ctx);
            List<String> list = this.listQualifiedBoundNames();
            return list;
        }
        finally {
            this.restoreRefCtx(savedContext);
        }
    }

    @Override
    public List<String> listQualifiedBoundNames() throws NamingException, RepositoryException {
        this.checkOpened();
        try {
            return this.cache.listQualifiedBindings();
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return null;
        }
    }

    @Override
    public void initTypeRepository() throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
    }

    @Override
    public void clearTypeRepository() throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        try {
            for (String typeName : this.cache.listSemanticTypes(false, false)) {
                this.cache.forceSemanticType(typeName, false);
            }
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public void addSemanticType(SemanticType type, boolean noAlias) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        try {
            this.cache.addSemanticType(type, noAlias);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public void removeSemanticType(String typeName, boolean sysType, boolean force) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        try {
            if (force) {
                this.cache.forceSemanticType(typeName, sysType);
            } else {
                this.cache.removeSemanticType((String)(sysType ? "sys." + typeName : typeName));
            }
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public void updateSemanticType(SemanticType type) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        try {
            this.cache.updateSemanticType(type);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public String resolveSemanticType(String typeName) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        try {
            return this.cache.resolveSemanticType(typeName);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return null;
        }
    }

    @Override
    public SemanticType getSemanticType(String typeName) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        try {
            return this.cache.getSemanticType(typeName);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return null;
        }
    }

    @Override
    public boolean existsSemanticType(String typeName) throws RepositoryException {
        this.checkOpened();
        try {
            return this.cache.existsSemanticType(typeName);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return false;
        }
    }

    @Override
    public List<String> listSemanticTypes(boolean includeSysTypes) throws RepositoryException {
        this.checkOpened();
        try {
            return this.cache.listSemanticTypes(false, includeSysTypes);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return null;
        }
    }

    @Override
    public List<SemanticType> getSemanticTypes(boolean includeSysTypes) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        try {
            return this.cache.getTypes(includeSysTypes);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return null;
        }
    }

    @Override
    public void initServiceRepository() throws RepositoryException {
        this.clearServiceRepository();
    }

    @Override
    public void clearServiceRepository() throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        try {
            Set boundServices = RuntimeContext.getInstance().getBoundComponents().stream().filter(component -> component.getComponentModel() == ComponentModel.CTX_SERVICE).map(component -> component.getType() + "." + component.getName()).collect(Collectors.toSet());
            for (String serviceEntityName : this.cache.listServices(false)) {
                String serviceComponentName = serviceEntityName.substring(0, serviceEntityName.length() - SCO_EXT.length());
                if (!boundServices.contains(serviceComponentName)) {
                    this.cache.removeServiceConfiguration(serviceEntityName);
                    continue;
                }
                Trace.logInfo(MFContext.class, "Removing bound service component: '" + serviceComponentName + "' failed.");
            }
            this.raiseRepositoryStateChangeAdvisory(RepositoryState.INIT, "Service repository have been cleared.");
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public void addServiceType(ServiceConfigurationObject sco) throws RepositoryException {
        if (!sco.getServiceName().equals(PROTOTYPE)) {
            throw new RepositoryException(4028, "SCO '" + sco.getServiceType() + "." + sco.getServiceName() + "' is not prototype.");
        }
        this.saveServiceConfiguration(sco);
    }

    @Override
    public void removeServiceType(String serviceType) throws RepositoryException {
        this.serviceHelper.removeEntityType(serviceType);
    }

    @Override
    public void removeService(String serviceName, String serviceType) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        try {
            this.cache.removeServiceConfiguration(serviceName, serviceType);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public String getServiceConfigurationArtifact(String serviceName, String serviceType) throws RepositoryException {
        this.checkOpened();
        try {
            return this.cache.getServiceConfigurationXml(serviceName, serviceType);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return null;
        }
    }

    @Override
    public ServiceConfigurationObject loadServiceConfiguration(String serviceName, String serviceType) throws RepositoryException {
        this.checkOpened();
        try {
            return this.cache.getServiceConfiguration(serviceName, serviceType);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return null;
        }
    }

    @Override
    public void saveServiceConfiguration(ServiceConfigurationObject sco) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        try {
            this.cache.putServiceConfiguration(sco, 0L);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public boolean existsService(String serviceName, String serviceType) throws RepositoryException {
        this.checkOpened();
        try {
            return this.cache.existsService(serviceName, serviceType);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return false;
        }
    }

    @Override
    public boolean existsServiceType(String serviceType) throws RepositoryException {
        return this.serviceHelper.existsType(serviceType);
    }

    @Override
    public List<String> listServiceTypes() throws RepositoryException {
        return this.serviceHelper.listEntityTypes();
    }

    @Override
    public List<String> listServiceNames() throws RepositoryException {
        return this.serviceHelper.listEntityNames();
    }

    @Override
    public List<String> listServicesByType(String serviceType) throws RepositoryException {
        return this.serviceHelper.listEntitiesByType(serviceType);
    }

    @Override
    public void lockServiceConfiguration(String serviceName, String serviceType, LockType lock) throws RepositoryException, UnsupportedCapabilityException {
        this.allowedToXact();
        this.checkOpened();
        try {
            this.cache.lockServiceConfiguration(serviceName, serviceType, lock);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public void unlockServiceConfiguration(String serviceName, String serviceType) throws RepositoryException, UnsupportedCapabilityException {
        this.lockServiceConfiguration(serviceName, serviceType, LockType.NONE);
    }

    @Override
    public void importServiceConfigurationArtifact(String workingDir, String serviceName, String serviceType, boolean validate) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        try {
            if (this.cache.existsService(serviceName, serviceType)) {
                throw new RepositoryException(4031, "Service '" + serviceType + "." + serviceName + "' already exists.");
            }
            this.cache.putServiceConfigurationXml(serviceName, serviceType, FileIOUtils.getFile(workingDir, serviceType + "." + serviceName + SCO_EXT), 0L, validate);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public void exportServiceConfigurationArtifact(String workingDir, String serviceName, String serviceType) throws RepositoryException {
        this.checkOpened();
        try {
            if (!this.cache.existsService(serviceName, serviceType)) {
                throw new RepositoryException(4032, "Service '" + serviceType + "." + serviceName + "' does not exist.");
            }
            File exportFile = new File(workingDir, serviceType + "." + serviceName + SCO_EXT);
            if (exportFile.exists()) {
                throw new RepositoryException(4029, "File '" + exportFile.getAbsolutePath() + "' already exists.");
            }
            FileIOUtils.putFile(workingDir, exportFile.getName(), this.cache.getServiceConfigurationXml(serviceName, serviceType).getBytes());
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public void initGlobalsRepository() throws RepositoryException {
        this.checkOpened();
        this.allowedToXact();
        try {
            this.cache.initGlobalVariables();
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public GlobalVariableCollection getGlobalVariables() throws RepositoryException {
        this.checkOpened();
        try {
            return this.cache.getGlobalVariables();
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return null;
        }
    }

    @Override
    public void putGlobalVariables(GlobalVariableCollection variables) throws RepositoryException {
        this.checkOpened();
        this.allowedToXact();
        try {
            this.cache.putGlobalVariables(variables);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public void initTransportFactoryRepository() throws RepositoryException {
        this.clearTransportFactoryRepository();
    }

    @Override
    public void clearTransportFactoryRepository() throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        try {
            for (String serviceEntityName : this.cache.listTransportFactories(false)) {
                this.cache.removeTransportFactory(serviceEntityName);
            }
            this.raiseRepositoryStateChangeAdvisory(RepositoryState.INIT, "Transport factory repository have been cleared.");
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public void addTransportFactoryType(TransportFactory factory) throws RepositoryException {
        if (!factory.getFactoryName().equals(PROTOTYPE)) {
            throw new RepositoryException(4028, "Transport factory '" + factory.getFactoryType() + "." + factory.getFactoryName() + "' is not prototype.");
        }
        this.saveTransportFactory(factory);
    }

    @Override
    public void removeTransportFactoryType(String factoryType) throws RepositoryException {
        this.transportFactoryHelper.removeEntityType(factoryType);
    }

    @Override
    public boolean existsTransportFactoryType(String factoryType) throws RepositoryException {
        return this.transportFactoryHelper.existsType(factoryType);
    }

    @Override
    public void removeTransportFactory(String factoryName, String factoryType) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        try {
            this.cache.removeTransportFactory(factoryName, factoryType);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public String getTransportFactoryArtifact(String factoryName, String factoryType) throws RepositoryException {
        this.checkOpened();
        try {
            return this.cache.getTransportFactoryXml(factoryName, factoryType);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return null;
        }
    }

    @Override
    public TransportFactory loadTransportFactory(TransportFactoryPropertyValue scoParameterValue) throws RepositoryException {
        return this.loadTransportFactory(scoParameterValue.getFactoryName(), scoParameterValue.getFactoryType());
    }

    @Override
    public TransportFactory loadTransportFactory(String factoryName, String factoryType) throws RepositoryException {
        this.checkOpened();
        try {
            return this.cache.getTransportFactory(factoryName, factoryType);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return null;
        }
    }

    @Override
    public void saveTransportFactory(TransportFactory factory) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        try {
            this.cache.putTransportFactory(factory, 0L);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public boolean existsTransportFactory(String factoryName, String factoryType) throws RepositoryException {
        this.checkOpened();
        try {
            return this.cache.existsTransportFactory(factoryName, factoryType);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return false;
        }
    }

    @Override
    public List<String> listTransportFactoryTypes() throws RepositoryException {
        return this.transportFactoryHelper.listEntityTypes();
    }

    @Override
    public List<String> listTransportFactoryNames() throws RepositoryException {
        return this.transportFactoryHelper.listEntityNames();
    }

    @Override
    public List<String> listTransportFactoriesByType(String factoryType) throws RepositoryException {
        return this.transportFactoryHelper.listEntitiesByType(factoryType);
    }

    @Override
    public void lockTransportFactory(String factoryName, String factoryType, LockType lock) throws RepositoryException, UnsupportedCapabilityException {
        this.allowedToXact();
        this.checkOpened();
        try {
            this.cache.lockTransportFactory(factoryName, factoryType, lock);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public void unlockTransportFactory(String factoryName, String factoryType) throws RepositoryException, UnsupportedCapabilityException {
        this.lockTransportFactory(factoryName, factoryType, LockType.NONE);
    }

    @Override
    public void importTransportFactoryArtifact(String workingDir, String factoryName, String factoryType) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        try {
            if (this.cache.existsTransportFactory(factoryName, factoryType)) {
                throw new RepositoryException(4033, "Transport factory '" + factoryType + "." + factoryName + "' already exists.");
            }
            this.cache.putTransportFactoryXml(factoryName, factoryType, FileIOUtils.getFile(workingDir, factoryType + "." + factoryName + TFO_EXT), 0L, false);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public void exportTransportFactoryArtifact(String workingDir, String factoryName, String factoryType) throws RepositoryException {
        this.checkOpened();
        try {
            if (!this.cache.existsTransportFactory(factoryName, factoryType)) {
                throw new RepositoryException(4034, "Transport factory '" + factoryType + "." + factoryName + "' does not exist.");
            }
            File exportFile = new File(workingDir, factoryType + "." + factoryName + TFO_EXT);
            if (exportFile.exists()) {
                throw new RepositoryException(4029, "File '" + exportFile.getAbsolutePath() + "' already exists.");
            }
            FileIOUtils.putFile(workingDir, exportFile.getName(), this.cache.getTransportFactoryXml(factoryName, factoryType).getBytes());
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public void initJDBCFactoryRepository() throws RepositoryException {
        this.clearJDBCFactoryRepository();
    }

    @Override
    public void clearJDBCFactoryRepository() throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        try {
            for (String serviceEntityName : this.cache.listJDBCFactories(false)) {
                this.cache.removeJDBCFactory(serviceEntityName);
            }
            this.raiseRepositoryStateChangeAdvisory(RepositoryState.INIT, "JDBC factory repository have been cleared.");
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public void addJDBCFactoryType(JDBCFactory factory) throws RepositoryException {
        if (!factory.getFactoryName().equals(PROTOTYPE)) {
            throw new RepositoryException(4028, "JDBC factory '" + factory.getFactoryType() + "." + factory.getFactoryName() + "'is not prototype.");
        }
        this.saveJDBCFactory(factory);
    }

    @Override
    public void removeJDBCFactoryType(String factoryType) throws RepositoryException {
        this.jdbcFactoryHelper.removeEntityType(factoryType);
    }

    @Override
    public void removeJDBCFactory(String factoryName, String factoryType) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        try {
            this.cache.removeJDBCFactory(factoryName, factoryType);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public String getJDBCFactoryArtifact(String factoryName, String factoryType) throws RepositoryException {
        this.checkOpened();
        try {
            return this.cache.getJDBCFactoryXml(factoryName, factoryType);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return null;
        }
    }

    @Override
    public JDBCFactory loadJDBCFactory(JDBCFactoryPropertyValue scoParameterValue) throws RepositoryException {
        return this.loadJDBCFactory(scoParameterValue.getFactoryName(), scoParameterValue.getFactoryType());
    }

    @Override
    public JDBCFactory loadJDBCFactory(String factoryName, String factoryType) throws RepositoryException {
        this.checkOpened();
        try {
            return this.cache.getJDBCFactory(factoryName, factoryType);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return null;
        }
    }

    @Override
    public void saveJDBCFactory(JDBCFactory factory) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        try {
            this.cache.putJDBCFactory(factory, 0L);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public boolean existsJDBCFactory(String factoryName, String factoryType) throws RepositoryException {
        this.checkOpened();
        try {
            return this.cache.existsJDBCFactory(factoryName, factoryType);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return false;
        }
    }

    @Override
    public boolean existsJDBCFactoryType(String factoryType) throws RepositoryException {
        return this.jdbcFactoryHelper.existsType(factoryType);
    }

    @Override
    public List<String> listJDBCFactoryTypes() throws RepositoryException {
        return this.jdbcFactoryHelper.listEntityTypes();
    }

    @Override
    public List<String> listJDBCFactoryNames() throws RepositoryException {
        return this.jdbcFactoryHelper.listEntityNames();
    }

    @Override
    public List<String> listJDBCFactoriesByType(String factoryType) throws RepositoryException {
        return this.jdbcFactoryHelper.listEntitiesByType(factoryType);
    }

    @Override
    public void lockJDBCFactory(String factoryName, String factoryType, LockType lock) throws RepositoryException, UnsupportedCapabilityException {
        this.allowedToXact();
        this.checkOpened();
        try {
            this.cache.lockJDBCFactory(factoryName, factoryType, lock);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public void unlockJDBCFactory(String factoryName, String factoryType) throws RepositoryException, UnsupportedCapabilityException {
        this.lockJDBCFactory(factoryName, factoryType, LockType.NONE);
    }

    @Override
    public void importJDBCFactoryArtifact(String workingDir, String factoryName, String factoryType) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        try {
            if (this.cache.existsJDBCFactory(factoryName, factoryType)) {
                throw new RepositoryException(4035, "JDBC factory '" + factoryType + "." + factoryName + "' already exists.");
            }
            this.cache.putJDBCFactoryXml(factoryName, factoryType, FileIOUtils.getFile(workingDir, factoryType + "." + factoryName + DFO_EXT), 0L, false);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public void exportJDBCFactoryArtifact(String workingDir, String factoryName, String factoryType) throws RepositoryException {
        this.checkOpened();
        try {
            if (!this.cache.existsJDBCFactory(factoryName, factoryType)) {
                throw new RepositoryException(4036, "JDBC factory '" + factoryType + "." + factoryName + "' does not exist.");
            }
            File exportFile = new File(workingDir, factoryType + "." + factoryName + DFO_EXT);
            if (exportFile.exists()) {
                throw new RepositoryException(4029, "File '" + exportFile.getAbsolutePath() + "' already exists.");
            }
            FileIOUtils.putFile(workingDir, exportFile.getName(), this.cache.getJDBCFactoryXml(factoryName, factoryType).getBytes());
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public void initClientFactoryRepository() throws RepositoryException {
        this.clearClientFactoryRepository();
    }

    @Override
    public void clearClientFactoryRepository() throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        try {
            for (String serviceEntityName : this.cache.listClientFactories(false)) {
                this.cache.removeClientFactory(serviceEntityName);
            }
            this.raiseRepositoryStateChangeAdvisory(RepositoryState.INIT, "Client factory repository have been cleared.");
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public void addClientFactoryType(ClientFactory factory) throws RepositoryException {
        if (!factory.getFactoryName().equals(PROTOTYPE)) {
            throw new RepositoryException(4028, "Client factory '" + factory.getFactoryType() + "." + factory.getFactoryName() + "'is not prototype.");
        }
        this.saveClientFactory(factory);
    }

    @Override
    public void removeClientFactoryType(String factoryType) throws RepositoryException {
        this.clientFactoryHelper.removeEntityType(MFContext.getClientFactoryType(factoryType));
    }

    @Override
    public void removeClientFactory(String factoryName, String factoryType) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        try {
            this.cache.removeClientFactory(factoryName, MFContext.getClientFactoryType(factoryType));
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public String getClientFactoryArtifact(String factoryName, String factoryType) throws RepositoryException {
        this.checkOpened();
        try {
            return this.cache.getClientFactoryXml(factoryName, MFContext.getClientFactoryType(factoryType));
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return null;
        }
    }

    @Override
    public ClientFactory loadClientFactory(ClientFactoryPropertyValue scoParameterValue) throws RepositoryException {
        return this.loadClientFactory(scoParameterValue.getFactoryName(), scoParameterValue.getFactoryType());
    }

    @Override
    public ClientFactory loadClientFactory(String factoryName, String factoryType) throws RepositoryException {
        this.checkOpened();
        try {
            return this.cache.getClientFactory(factoryName, MFContext.getClientFactoryType(factoryType));
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return null;
        }
    }

    @Override
    public void saveClientFactory(ClientFactory factory) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        try {
            factory.setFactoryType(MFContext.getClientFactoryType(factory.getFactoryType()));
            this.cache.putClientFactory(factory, 0L);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public boolean existsClientFactory(String factoryName, String factoryType) throws RepositoryException {
        this.checkOpened();
        try {
            return this.cache.existsClientFactory(factoryName, MFContext.getClientFactoryType(factoryType));
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return false;
        }
    }

    @Override
    public boolean existsClientFactoryType(String factoryType) throws RepositoryException {
        return this.clientFactoryHelper.existsType(MFContext.getClientFactoryType(factoryType));
    }

    @Override
    public List<String> listClientFactoryTypes() throws RepositoryException {
        return this.clientFactoryHelper.listEntityTypes();
    }

    @Override
    public List<String> listClientFactoryNames() throws RepositoryException {
        return this.clientFactoryHelper.listEntityNames();
    }

    @Override
    public List<String> listClientFactoriesByType(String factoryType) throws RepositoryException {
        return this.clientFactoryHelper.listEntitiesByType(MFContext.getClientFactoryType(factoryType));
    }

    @Override
    public void lockClientFactory(String factoryName, String factoryType, LockType lock) throws RepositoryException, UnsupportedCapabilityException {
        this.allowedToXact();
        this.checkOpened();
        try {
            this.cache.lockClientFactory(factoryName, MFContext.getClientFactoryType(factoryType), lock);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public void unlockClientFactory(String factoryName, String factoryType) throws RepositoryException, UnsupportedCapabilityException {
        this.lockClientFactory(factoryName, MFContext.getClientFactoryType(factoryType), LockType.NONE);
    }

    @Override
    public void importClientFactoryArtifact(String workingDir, String factoryName, String factoryType) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        try {
            factoryType = MFContext.getClientFactoryType(factoryType);
            if (this.cache.existsClientFactory(factoryName, factoryType)) {
                throw new RepositoryException(4037, "Client factory '" + factoryType + "." + factoryName + "' already exists.");
            }
            this.cache.putClientFactoryXml(factoryName, factoryType, FileIOUtils.getFile(workingDir, factoryType + "." + factoryName + CFO_EXT), 0L, false);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public void exportClientFactoryArtifact(String workingDir, String factoryName, String factoryType) throws RepositoryException {
        this.checkOpened();
        try {
            factoryType = MFContext.getClientFactoryType(factoryType);
            if (!this.cache.existsClientFactory(factoryName, factoryType)) {
                throw new RepositoryException(4038, "Client factory '" + factoryType + "." + factoryName + "' does not exist.");
            }
            File exportFile = new File(workingDir, factoryType + "." + factoryName + CFO_EXT);
            if (exportFile.exists()) {
                throw new RepositoryException(4029, "File '" + exportFile.getAbsolutePath() + "' already exists.");
            }
            FileIOUtils.putFile(workingDir, exportFile.getName(), this.cache.getClientFactoryXml(factoryName, factoryType).getBytes());
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    private static String getClientFactoryType(String factoryType) {
        return MFContext.isSpecialClientFactory(factoryType) ? factoryType.toUpperCase() : factoryType;
    }

    private static boolean isSpecialClientFactory(String factoryType) {
        return factoryType.equalsIgnoreCase("HTTP") || factoryType.equalsIgnoreCase("AWS");
    }

    @Override
    public void initPackageRepository() throws RepositoryException {
        this.clearPackageRepository();
    }

    @Override
    public void clearPackageRepository() throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        try {
            for (String packageEntityName : this.cache.listPackages(false)) {
                String pkgName;
                String[] nameParts = packageEntityName.split("\\.");
                PackageType pkgType = PackageType.valueOf(nameParts[0]);
                if (this.loadedPackagesProvider.isPackageLoaded(pkgType, pkgName = nameParts[1])) {
                    Trace.logDebug(MFContext.class, "Package '" + String.valueOf((Object)pkgType) + "." + pkgName + "' is loaded and cannot be removed.");
                    continue;
                }
                this.removePackage(pkgType, pkgName, true);
            }
            this.raiseRepositoryStateChangeAdvisory(RepositoryState.INIT, "Package repository have been cleared.");
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public boolean existsPackage(PackageType type, String name) throws RepositoryException {
        this.checkOpened();
        try {
            return this.cache.existsPackage(type, name);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return false;
        }
    }

    @Override
    public List<String> listPackagesByType(PackageType type) throws RepositoryException {
        return this.pkgHelper.listEntitiesByType(type.name());
    }

    @Override
    public List<String> listPackages() throws RepositoryException {
        try {
            return this.pkgHelper.listEntities();
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return null;
        }
    }

    @Override
    public void removePackage(PackageType type, String name, boolean withJars) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        try {
            if (this.loadedPackagesProvider.isPackageLoaded(type, name)) {
                throw new RepositoryException(4045, "Package '" + String.valueOf((Object)type) + "." + name + "' is loaded and cannot be removed.");
            }
            if (this.loadedPackagesProvider.isPackageRegistered(type, name)) {
                throw new RepositoryException(4054, "Package '" + String.valueOf((Object)type) + "." + name + "' is registered and cannot be removed.");
            }
            Package pkg = this.cache.getPackage(type, name);
            if (pkg == null) {
                throw new RepositoryException(4044, "Package '" + String.valueOf((Object)type) + "." + name + "' does not exist.");
            }
            this.cache.forcePackage(name, type, withJars);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    void removePackageForced(Package pkg) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        try {
            this.cache.forcePackage(pkg.getName(), pkg.getType(), true);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public void importPackage(String workingDir, PackageType type, String name) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        Package pkg = Package.create(type, name);
        File packageFile = new File(workingDir, pkg.getArtifactName());
        if (!packageFile.exists()) {
            throw new RepositoryException(4030, "Package file '" + packageFile.getAbsolutePath() + "' does not exist.");
        }
        try {
            if (this.cache.existsPackage(type, name)) {
                throw new RepositoryException(4043, "Package '" + pkg.getFullName() + "' already exists.");
            }
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            FileInputStream inputStream = new FileInputStream(packageFile);
            FileIOUtils.copyLarge(inputStream, (OutputStream)stream);
            pkg = (Package)XSerializerFactory.getInstance().getDefaultSerializer().deserialize(stream.toByteArray());
            inputStream.close();
            stream.close();
            List<File> jarsFiles = pkg.listJARs().stream().map(jar -> new File(workingDir, (String)jar)).collect(Collectors.toList());
            File[] jars = new File[jarsFiles.size()];
            jarsFiles.toArray(jars);
            this.cache.addPackage(pkg, jars);
            Trace.logInfo(MFContext.class, "Package '" + pkg.getFullName() + "' imported.");
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public void exportPackage(String workingDir, PackageType type, String name) throws RepositoryException {
        this.checkOpened();
        try {
            String pkgName = Package.getArtifactName(type, name);
            if (!this.cache.existsPackage(type, name)) {
                throw new RepositoryException(4044, "Package '" + pkgName + "' does not exist.");
            }
            Package pkg = this.cache.getPackage(type, name);
            if (!pkg.isValid()) {
                throw new RepositoryException(4046, "Package '" + pkg.getFullName() + "' is invalid and can not be exported (it has missing archives).");
            }
            for (String jarName : pkg.listJARs()) {
                Trace.logDebug(MFContext.class, "Exporting archive '" + jarName + "'...");
                if (!this.cache.existsDistinctEntity(jarName, CachedEntity.LIB)) {
                    throw new RepositoryException(4047, "Archive '" + jarName + " does not exist.");
                }
                ByteArrayInputStream input = new ByteArrayInputStream(this.getArchive(jarName));
                FileOutputStream output = new FileOutputStream(new File(workingDir, jarName));
                FileIOUtils.copyLarge(input, (OutputStream)output);
                input.close();
                output.close();
                Trace.logDebug(MFContext.class, "Archive '" + jarName + "' exported.");
            }
            PackageStore.savePackageObject(workingDir, pkg);
            Trace.logInfo(MFContext.class, "Package '" + pkg.getFullName() + "' exported.");
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public void savePackage(Package pkg, File[] jars) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        this.checkPackageScope(pkg);
        try {
            this.cache.addPackage(pkg, jars);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public void savePackage(Package pkg) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        this.checkPackageScope(pkg);
        try {
            this.cache.addPackage(pkg);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public void updatePackage(Package pkg) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        this.checkPackageScope(pkg);
        try {
            if (this.loadedPackagesProvider.isPackageLoaded(pkg)) {
                throw new RepositoryException(4045, "Package '" + pkg.getFullName() + "' is loaded and cannot be changed.");
            }
            if (this.loadedPackagesProvider.isPackageRegistered(pkg)) {
                Package existingPackage = this.cache.getPackage(pkg.getType(), pkg.getName());
                if (pkg.isGlobal() != existingPackage.isGlobal()) {
                    throw new RepositoryException(4000, "Method 'updatePackage' cannot be used for changing 'global' parameter. Use 'PackageManifestManager::setPackageScope' instead.");
                }
                if (pkg.isAutoload() != existingPackage.isAutoload()) {
                    throw new RepositoryException(4000, "Method 'updatePackage' cannot be used for changing 'autoload' parameter'. Use 'PackageManifestManager::updatePackage' instead.");
                }
                if (pkg.isGlobal()) {
                    throw new RepositoryException(4000, "Method 'updatePackage' cannot be used for changing global package. Use 'PackageManifestManager::updatePackage' instead.");
                }
            }
            this.cache.nextVersion(pkg);
            this.cache.updatePackage(pkg, true);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    void updatePackageForced(Package pkg) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        this.checkPackageScope(pkg);
        try {
            this.cache.updatePackage(pkg, true);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    private void checkPackageScope(Package pkg) throws RepositoryException {
        if (pkg.isGlobal() && !pkg.isGeneric()) {
            throw new RepositoryException(4055, "Only SDO or Collection packages can be global.");
        }
    }

    @Override
    public Package loadPackage(PackageType type, String name) throws RepositoryException {
        this.checkOpened();
        try {
            return this.cache.getPackage(type, name);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return null;
        }
    }

    public Package getPackageByArchive(String jarName) throws RepositoryException {
        this.checkOpened();
        try {
            return this.cache.getPackageByArchive(jarName);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return null;
        }
    }

    @Override
    public boolean existsArchive(String jarName) throws RepositoryException {
        this.checkOpened();
        try {
            return this.cache.existsDistinctEntity(jarName, CachedEntity.LIB);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return false;
        }
    }

    @Override
    public boolean existsExtensionArchive(String jarName) throws RepositoryException {
        this.checkOpened();
        try {
            return this.cache.existsDistinctEntity(jarName, CachedEntity.EXT);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return false;
        }
    }

    @Override
    public Package addArchive(File jar) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        try {
            this.cache.addArchive(jar);
            return this.validatePackage(jar.getName());
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return null;
        }
    }

    void addArchiveForced(File jar) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        try {
            this.cache.addArchive(jar);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public Package addArchive(String jarName, byte[] jarContent) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        try {
            this.cache.addArchive(jarName, jarContent);
            return this.validatePackage(jarName);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return null;
        }
    }

    private Package validatePackage(String jarName) throws Exception {
        Package pkg = this.cache.getPackageByArchive(jarName);
        if (pkg != null && !pkg.isValid() && this.cache.isPackageValid(pkg)) {
            Trace.logInfo(this, "Package '" + pkg.getFullName() + "' is valid.");
            TFCache.setDirty(pkg, false);
            this.cache.nextVersion(pkg);
            this.cache.updatePackage(pkg, false);
        }
        return pkg;
    }

    @Override
    public List<SemanticType> addExtensionArchive(File jar) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        try {
            return this.cache.addExtensionArchive(jar);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return null;
        }
    }

    @Override
    public List<SemanticType> addExtensionArchive(String jarName, byte[] jarContent) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        try {
            return this.cache.addExtensionArchive(jarName, jarContent);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return null;
        }
    }

    @Override
    public Package removeArchive(String jarName) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        try {
            Package pkg = this.cache.getPackageByArchive(jarName);
            if (pkg != null && this.loadedPackagesProvider.isPackageLoaded(pkg)) {
                throw new RepositoryException(4045, "Archive '" + jarName + "' cannot be removed. Cause: Package '" + pkg.getFullName() + "' is loaded.");
            }
            this.cache.removeArchive(jarName, true);
            if (pkg != null) {
                Trace.logInfo(this, "WARNING: Package '" + pkg.getFullName() + "' is invalid.");
                TFCache.setDirty(pkg, true);
                this.cache.updatePackage(pkg, false);
            }
            return pkg;
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return null;
        }
    }

    void removeArchiveForced(String jarName) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        try {
            this.cache.removeArchive(jarName, true);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public List<SemanticType> removeExtensionArchive(String jarName, boolean force) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        try {
            return this.cache.removeExtensionArchive(jarName, force);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return null;
        }
    }

    @Override
    public byte[] getArchive(String jarName) throws RepositoryException {
        this.checkOpened();
        try {
            return this.cache.getArchive(jarName);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return null;
        }
    }

    @Override
    public InputStream getArchiveStream(String jarName) throws RepositoryException {
        this.checkOpened();
        try {
            return this.cache.getArchiveStream(jarName);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return null;
        }
    }

    @Override
    public URL getArchiveURL(String jarName) throws RepositoryException {
        this.checkOpened();
        try {
            return this.cache.getArchiveURL(jarName);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return null;
        }
    }

    @Override
    public byte[] getExtensionArchive(String jarName) throws RepositoryException {
        this.checkOpened();
        try {
            return this.cache.getExtensionArchive(jarName);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return null;
        }
    }

    @Override
    public URL getExtensionArchiveURL(String jarName) throws RepositoryException {
        this.checkOpened();
        try {
            return this.cache.getExtArchiveURL(jarName);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return null;
        }
    }

    @Override
    public List<URL> getArchiveURLs() throws RepositoryException {
        this.checkOpened();
        try {
            return this.cache.getArchiveURLs();
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return null;
        }
    }

    @Override
    public List<URL> getExtensionArchiveURLs() throws RepositoryException {
        this.checkOpened();
        try {
            return this.cache.getExtensionURLs();
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return null;
        }
    }

    @Override
    public List<String> listArchives() throws RepositoryException {
        this.checkOpened();
        try {
            return this.cache.listArchives(false);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return null;
        }
    }

    @Override
    public List<String> listExtensionArchives() throws RepositoryException {
        this.checkOpened();
        try {
            return this.cache.listExtensionArchives(false);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return null;
        }
    }

    private String preparePath(String path) {
        return path.replace('\\', '/');
    }

    private void requireArtifactExists(String path) throws RepositoryException {
        if (!this.cache.existsDistinctEntity(path, CachedEntity.ARTIFACT)) {
            throw new RepositoryException(4049, "Artifact '" + path + "' does not exist.");
        }
    }

    private void requireArtifactAbsent(String path) throws RepositoryException {
        if (this.cache.existsDistinctEntity(path, CachedEntity.ARTIFACT)) {
            throw new RepositoryException(4048, "Artifact '" + path + "' already exists.");
        }
    }

    private void requireDirectoryExists(String path) throws RepositoryException {
        this.requireArtifactExists(path);
        if (!this.cache.isArtifactDirectory(path)) {
            throw new RepositoryException(4050, "Artifact '" + path + "' is not directory.");
        }
    }

    private void requireFileExists(String path) throws RepositoryException {
        this.requireArtifactExists(path);
        if (this.cache.isArtifactDirectory(path)) {
            throw new RepositoryException(4050, "Artifact '" + path + "' is a directory.");
        }
    }

    @Override
    public void createDirectory(FSFile baseDirectory, String newSubDirectoryName) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        this.requireDirectoryExists(baseDirectory.getPath());
        String path = baseDirectory.getPath() + "/" + newSubDirectoryName;
        this.requireArtifactAbsent(path);
        try {
            this.cache.createDirectory(path);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public FSFile createDirectory(String path) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        path = this.preparePath(path);
        this.requireArtifactAbsent(path);
        try {
            this.cache.createDirectory(path);
            return this.getDetails(path);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInDirectory(String dirPath, RepositoryTask task) throws RepositoryException {
        String savedPwd = null;
        try {
            if (dirPath != null && dirPath.length() > 0) {
                savedPwd = this.cache.getPresentWorkingDirectory();
                this.cache.changeToDirectory(dirPath);
            }
            task.run();
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
        finally {
            if (savedPwd != null) {
                try {
                    this.cache.changeToDirectory(savedPwd);
                }
                catch (Exception e) {
                    Trace.logException(MFContext.class, e, true);
                }
            }
        }
    }

    @Override
    public void createFile(String path, byte[] content, long expiration) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        this.requireArtifactAbsent(path);
        DecomposedPath dPath = new DecomposedPath(path);
        if (dPath.directoryPath != null) {
            this.requireDirectoryExists(dPath.directoryPath);
        }
        this.doInDirectory(dPath.directoryPath, () -> {
            try {
                this.cache.putArtifact(content, dPath.filename, expiration);
            }
            catch (Exception exception) {
                MFContext.processException(exception);
            }
        });
    }

    @Override
    public void createFile(String path, File file, long expiration) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        DecomposedPath dPath = new DecomposedPath(path);
        if (dPath.directoryPath != null) {
            this.requireDirectoryExists(dPath.directoryPath);
        }
        this.doInDirectory(dPath.directoryPath, () -> {
            try {
                this.cache.putArtifact(file, dPath.filename, expiration);
            }
            catch (Exception exception) {
                MFContext.processException(exception);
            }
        });
    }

    @Override
    public void createFile(String path, InputStream stream, int size, long expiration) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        DecomposedPath dPath = new DecomposedPath(path);
        if (dPath.directoryPath != null) {
            this.requireDirectoryExists(dPath.directoryPath);
        }
        this.doInDirectory(dPath.directoryPath, () -> {
            try {
                this.cache.putArtifact(stream, size, dPath.filename, expiration);
            }
            catch (Exception exception) {
                MFContext.processException(exception);
            }
        });
    }

    @Override
    public void deleteDirectory(String path, boolean isRecursive) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        this.requireDirectoryExists(path);
        this.doInDirectory(path, () -> {
            try {
                if (this.cache.listArtifacts(false).size() > 0 && !isRecursive) {
                    throw new RepositoryException(4050, "Artifact directory '" + path + "' is not empty.");
                }
                this.cache.deleteDirectory("");
            }
            catch (Exception exception) {
                MFContext.processException(exception);
            }
        });
    }

    @Override
    public void deleteFile(String path) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        path = this.preparePath(path);
        this.requireFileExists(path);
        try {
            this.cache.removeArtifact(path);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public boolean exists(String path) throws RepositoryException {
        this.checkOpened();
        return this.cache.existsDistinctEntity(path, CachedEntity.ARTIFACT);
    }

    @Override
    public String getContent(String path) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        path = this.preparePath(path);
        this.requireFileExists(path);
        try {
            return new String(this.cache.getArtifact(path));
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return null;
        }
    }

    @Override
    public byte[] getContentBytes(String path) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        path = this.preparePath(path);
        this.requireFileExists(path);
        try {
            return this.cache.getArtifact(path);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return null;
        }
    }

    @Override
    public void getContent(String path, OutputStream stream) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        path = this.preparePath(path);
        this.requireFileExists(path);
        try {
            this.cache.getArtifact(path, stream);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public FSFile getDetails(String path) throws RepositoryException {
        CacheArtifactInfo info;
        this.checkOpened();
        path = this.cache.getArtifactPathFromRoot(this.preparePath(path));
        this.requireArtifactExists(path);
        try {
            info = this.cache.getCacheArtifactInfo(path);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
            return null;
        }
        FSFile fsFile = this.cache.isArtifactDirectory(path) ? FSFile.createDirectory(path) : FSFile.createFile(path);
        fsFile.setCreationTimestamp(info.getCreationTime().getTime());
        fsFile.setSize(info.getSize());
        fsFile.setLastModified(info.getLastModifiedTime().getTime());
        fsFile.setOwnerId(info.getOwner());
        return fsFile;
    }

    @Override
    public List<FSFile> getDetails(Collection<String> paths) throws RepositoryException {
        this.checkOpened();
        ArrayList<FSFile> result = new ArrayList<FSFile>();
        for (String path : paths) {
            result.add(this.getDetails(this.preparePath(path)));
        }
        return result;
    }

    public List<FSFile> getDetails(String rootPath, Collection<String> paths) throws RepositoryException {
        this.checkOpened();
        ArrayList<FSFile> result = new ArrayList<FSFile>();
        for (String path : paths) {
            result.add(this.getDetails(this.preparePath(rootPath + "/" + path)));
        }
        return result;
    }

    @Override
    public FSFile getRootDirectory() throws RepositoryException {
        return this.getDetails("");
    }

    @Override
    public boolean isDirectory(String path) throws RepositoryException {
        this.checkOpened();
        path = this.preparePath(path);
        this.requireArtifactExists(path);
        return this.cache.isArtifactDirectory(path);
    }

    @Override
    public boolean isFile(String path) throws RepositoryException {
        this.checkOpened();
        path = this.preparePath(path);
        this.requireArtifactExists(path);
        return !this.cache.isArtifactDirectory(path);
    }

    @Override
    public List<String> listFiles(String path) throws RepositoryException {
        this.checkOpened();
        path = this.preparePath(path);
        this.requireDirectoryExists(path);
        Object[] result = new Object[]{null};
        this.doInDirectory(path, () -> {
            try {
                result[0] = this.cache.listFiles();
            }
            catch (Exception exception) {
                MFContext.processException(exception);
            }
        });
        return (List)result[0];
    }

    @Override
    public List<String> listDirectories(String path) throws RepositoryException {
        this.checkOpened();
        path = this.preparePath(path);
        this.requireDirectoryExists(path);
        Object[] result = new Object[]{null};
        this.doInDirectory(path, () -> {
            try {
                result[0] = this.cache.listDirectories();
            }
            catch (Exception exception) {
                MFContext.processException(exception);
            }
        });
        return (List)result[0];
    }

    @Override
    public List<String> listAll(String path) throws RepositoryException {
        this.checkOpened();
        path = this.preparePath(path);
        this.requireDirectoryExists(path);
        ArrayList<String> result = new ArrayList<String>();
        this.doInDirectory(path, () -> {
            try {
                result.addAll(this.cache.listDirectories());
                result.addAll(this.cache.listFiles());
            }
            catch (Exception exception) {
                MFContext.processException(exception);
            }
        });
        return result;
    }

    @Override
    public List<FSFile> getAllDetails(String path) throws RepositoryException {
        return this.getDetails(path, this.listAll(path));
    }

    @Override
    public List<FSFile> getFilesDetails(String path) throws RepositoryException {
        return this.getDetails(path, this.listFiles(path));
    }

    @Override
    public List<FSFile> getDirectoriesDetails(String path) throws RepositoryException {
        return this.getDetails(path, this.listDirectories(path));
    }

    @Override
    public FSFile renameArtifact(FSFile oldFile, String newName) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        String newPath = this.cache.getArtifactPathFromRoot(this.preparePath(newName));
        this.renameArtifact(oldFile.getPath(), newPath);
        FSFile result = oldFile.clone();
        result.setPath(newPath);
        return result;
    }

    @Override
    public void renameArtifact(String oldPath, String newPath) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        oldPath = this.preparePath(oldPath);
        newPath = this.preparePath(newPath);
        this.requireArtifactExists(oldPath);
        this.requireArtifactAbsent(newPath);
        try {
            this.cache.renameArtifact(oldPath, newPath);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    @Override
    public void updateFile(String path, byte[] content) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        this.requireFileExists(path);
        DecomposedPath dPath = new DecomposedPath(path);
        if (dPath.directoryPath != null) {
            this.requireDirectoryExists(dPath.directoryPath);
        }
        this.doInDirectory(dPath.directoryPath, () -> {
            try {
                this.cache.putArtifact(content, dPath.filename, -1L);
            }
            catch (Exception exception) {
                MFContext.processException(exception);
            }
        });
    }

    @Override
    public void updateFile(String path, File file) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        this.requireFileExists(path);
        DecomposedPath dPath = new DecomposedPath(path);
        if (dPath.directoryPath != null) {
            this.requireDirectoryExists(dPath.directoryPath);
        }
        this.doInDirectory(dPath.directoryPath, () -> {
            try {
                this.cache.putArtifact(file, dPath.filename, -1L);
            }
            catch (Exception exception) {
                MFContext.processException(exception);
            }
        });
    }

    @Override
    public void updateFile(String path, InputStream stream, int size) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        this.requireFileExists(path);
        DecomposedPath dPath = new DecomposedPath(path);
        if (dPath.directoryPath != null) {
            this.requireDirectoryExists(dPath.directoryPath);
        }
        this.doInDirectory(dPath.directoryPath, () -> {
            try {
                this.cache.putArtifact(stream, size, dPath.filename, -1L);
            }
            catch (Exception exception) {
                MFContext.processException(exception);
            }
        });
    }

    @Override
    public void appendFile(String path, byte[] content) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        this.requireFileExists(path);
        DecomposedPath dPath = new DecomposedPath(path);
        if (dPath.directoryPath != null) {
            this.requireDirectoryExists(dPath.directoryPath);
        }
        this.doInDirectory(dPath.directoryPath, () -> {
            try {
                this.cache.putArtifact(content, dPath.filename, -1L, true);
            }
            catch (Exception exception) {
                MFContext.processException(exception);
            }
        });
    }

    @Override
    public void appendFile(String path, File file) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        this.requireFileExists(path);
        DecomposedPath dPath = new DecomposedPath(path);
        if (dPath.directoryPath != null) {
            this.requireDirectoryExists(dPath.directoryPath);
        }
        this.doInDirectory(dPath.directoryPath, () -> {
            try {
                this.cache.putArtifact(file, dPath.filename, -1L, true);
            }
            catch (Exception exception) {
                MFContext.processException(exception);
            }
        });
    }

    @Override
    public void appendFile(String path, InputStream stream, int size) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        this.requireFileExists(path);
        DecomposedPath dPath = new DecomposedPath(path);
        if (dPath.directoryPath != null) {
            this.requireDirectoryExists(dPath.directoryPath);
        }
        this.doInDirectory(dPath.directoryPath, () -> {
            try {
                this.cache.putArtifact(stream, size, dPath.filename, -1L, true);
            }
            catch (Exception exception) {
                MFContext.processException(exception);
            }
        });
    }

    @Override
    public void setFileExpiration(String path, long expiration) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        path = this.preparePath(path);
        this.requireFileExists(path);
        try {
            this.cache.setArtifactExpiration(path, expiration);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    private void raiseRepositoryStateChangeAdvisory(RepositoryState state, String message) {
        if (this.rscListener != null) {
            RepositoryStateChangeAdvisory advisory = new RepositoryStateChangeAdvisory();
            advisory.setState(state);
            advisory.setMessage(message);
            advisory.setCode(0);
            try {
                this.rscListener.onEvent(advisory);
            }
            catch (Exception exception) {
                Trace.logException(MFContext.class, exception, true);
                Trace.logError(MFContext.class, "Raising of advisory '" + advisory.getEventId() + "' failed.");
            }
        }
    }

    private void processBinding(String bindingName, BindingProcessor processor) throws RepositoryException {
        block4: {
            try {
                String clazz;
                String name;
                int dotPos = bindingName.indexOf(46);
                String type = dotPos == -1 ? bindingName : bindingName.substring(0, dotPos);
                String string = name = dotPos == -1 ? bindingName : bindingName.substring(dotPos + 1);
                if (!this.checkName(name, "Invalid binding name: ", bindingName)) break block4;
                try {
                    clazz = this.resolveSemanticType(type);
                }
                catch (Exception exception) {
                    MFContext.processException(exception);
                    return;
                }
                processor.process(type, name, clazz);
            }
            catch (Exception exception) {
                MFContext.processException(exception);
            }
        }
    }

    private void processBindings(BindingProcessor processor) throws RepositoryException {
        try {
            for (String bindingName : this.cache.listQualifiedBindings()) {
                this.processBinding(bindingName, processor);
            }
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    private void raiseNamingError(String message) throws NamingException {
        Trace.logError(MFContext.class, message);
        throw new NamingException(message);
    }

    private boolean checkName(String name, String errorMessage, String fullName) throws NamingException {
        if (name.indexOf(46) >= 0) {
            this.raiseNamingError(errorMessage + fullName);
            return false;
        }
        return true;
    }

    private void restoreRefCtx(ReferenceContext savedRefCtx) {
        if (savedRefCtx != null) {
            try {
                this.setReferenceContext(savedRefCtx);
            }
            catch (Exception e) {
                Trace.logException(MFContext.class, e, true);
            }
        }
    }

    @Override
    public String getVendorString() {
        return "StreamScape Technologies";
    }

    @Override
    public boolean isTypeResolutionCapable() {
        return true;
    }

    @Override
    public boolean isObjectReferenceCapable() {
        return true;
    }

    @Override
    public boolean isGlobalsCapable() {
        return true;
    }

    @Override
    public boolean isTransactionCapable() {
        return false;
    }

    @Override
    public boolean isSudoCapable() {
        return true;
    }

    @Override
    public boolean isCached() {
        return true;
    }

    public void moveObjectToJunk(String objectName) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        try {
            this.cache.moveObjectToJunk(objectName);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    public void moveToJunk(CachedEntity objectType, String objectName) throws RepositoryException {
        this.allowedToXact();
        this.checkOpened();
        try {
            this.cache.moveToJunk(objectType, objectName);
        }
        catch (Exception exception) {
            MFContext.processException(exception);
        }
    }

    static void processException(Exception exception) throws RepositoryException {
        if (exception instanceof RepositoryException) {
            throw (RepositoryException)exception;
        }
        if (exception instanceof IllegalStateException) {
            MFContext.throwException(4016, exception);
        } else if (exception instanceof TFCacheException) {
            MFContext.throwException((TFCacheException)exception);
        } else {
            MFContext.throwException(4000, exception);
        }
    }

    protected static void throwException(TFCacheException cause) throws RepositoryException {
        throw MFContext.createProtectedObject(RepositoryException.class, new Class[]{TFCacheException.class}, cause);
    }

    protected static void throwException(int errorCode, String message) throws RepositoryException {
        MFContext.throwException(RepositoryException.class, errorCode, message);
    }

    protected static void throwException(int errorCode, Throwable cause) throws RepositoryException {
        MFContext.throwException(RepositoryException.class, errorCode, cause);
    }

    protected static void throwException(int errorCode, String message, Throwable cause) throws RepositoryException {
        MFContext.throwException(RepositoryException.class, errorCode, message, cause);
    }

    private class ServiceHelper
    extends EntityHelper {
        private ServiceHelper() {
            super("service", MFContext.SCO_EXT);
        }

        @Override
        protected List<String> listEntities() throws UtilitiesException, TFCacheException, IllegalStateException {
            return MFContext.this.cache.listServices(false);
        }

        @Override
        protected void removeEntity(String entityName) throws TFCacheException, IllegalStateException {
            MFContext.this.cache.removeServiceConfiguration(entityName);
        }
    }

    private static abstract class EntityHelper {
        protected String entityLabel;
        protected String entityExtension;

        protected EntityHelper(String entityLabel, String entityExtension) {
            this.entityLabel = entityLabel;
            this.entityExtension = entityExtension;
        }

        protected abstract List<String> listEntities() throws UtilitiesException, TFCacheException, IllegalStateException;

        protected abstract void removeEntity(String var1) throws TFCacheException, IllegalStateException;

        public void removeEntityType(String typeName) throws RepositoryException {
            String prototypeEntityName = typeName + ".prototype" + this.entityExtension;
            boolean existsType = false;
            try {
                for (String serviceEntityName : this.listEntities()) {
                    if (!serviceEntityName.startsWith(typeName + ".")) continue;
                    if (prototypeEntityName.equals(serviceEntityName)) {
                        existsType = true;
                        continue;
                    }
                    throw new RepositoryException(4027, "Type '" + typeName + "' " + this.entityLabel + " is in use and cannot be removed.");
                }
                if (!existsType) {
                    throw new RepositoryException(4026, "'" + typeName + "' prototype " + this.entityLabel + " does not exist.");
                }
                this.removeEntity(prototypeEntityName);
            }
            catch (Exception exception) {
                MFContext.processException(exception);
            }
        }

        public boolean existsType(String type) throws RepositoryException {
            try {
                return this.listEntities().stream().anyMatch(serviceEntityName -> serviceEntityName.startsWith(type + "."));
            }
            catch (Exception exception) {
                MFContext.processException(exception);
                return false;
            }
        }

        public List<String> listEntityTypes() throws RepositoryException {
            HashSet<String> types = new HashSet<String>();
            try {
                for (String entityName : this.listEntities()) {
                    int dotPos = entityName.indexOf(46);
                    if (dotPos <= 0) continue;
                    types.add(entityName.substring(0, dotPos));
                }
            }
            catch (Exception exception) {
                MFContext.processException(exception);
            }
            return new ArrayList<String>(types);
        }

        public List<String> listEntityNames() throws RepositoryException {
            try {
                return this.listEntities().stream().filter(entity -> entity.endsWith(this.entityExtension)).map(entity -> entity.substring(entity.indexOf(".") + 1, entity.length() - this.entityExtension.length())).collect(Collectors.toList());
            }
            catch (Exception exception) {
                MFContext.processException(exception);
                return new ArrayList<String>();
            }
        }

        public List<String> listEntitiesByType(String typeName) throws RepositoryException {
            try {
                return this.listEntities().stream().filter(entity -> entity.startsWith(typeName + ".") && entity.endsWith(this.entityExtension)).map(entity -> entity.substring(typeName.length() + 1, entity.length() - this.entityExtension.length())).collect(Collectors.toList());
            }
            catch (Exception exception) {
                MFContext.processException(exception);
                return new ArrayList<String>();
            }
        }
    }

    private class ClientFactoryHelper
    extends EntityHelper {
        private ClientFactoryHelper() {
            super("client factory", MFContext.CFO_EXT);
        }

        @Override
        protected List<String> listEntities() throws UtilitiesException, TFCacheException, IllegalStateException {
            return MFContext.this.cache.listClientFactories(false);
        }

        @Override
        protected void removeEntity(String entityName) throws TFCacheException, IllegalStateException {
            MFContext.this.cache.removeClientFactory(entityName);
        }
    }

    private class TransportFactoryHelper
    extends EntityHelper {
        private TransportFactoryHelper() {
            super("transport factory", MFContext.TFO_EXT);
        }

        @Override
        protected List<String> listEntities() throws UtilitiesException, TFCacheException, IllegalStateException {
            return MFContext.this.cache.listTransportFactories(false);
        }

        @Override
        protected void removeEntity(String entityName) throws TFCacheException, IllegalStateException {
            MFContext.this.cache.removeTransportFactory(entityName);
        }
    }

    private class JDBCFactoryHelper
    extends EntityHelper {
        private JDBCFactoryHelper() {
            super("JDBC factory", MFContext.DFO_EXT);
        }

        @Override
        protected List<String> listEntities() throws UtilitiesException, TFCacheException, IllegalStateException {
            return MFContext.this.cache.listJDBCFactories(false);
        }

        @Override
        protected void removeEntity(String entityName) throws TFCacheException, IllegalStateException {
            MFContext.this.cache.removeJDBCFactory(entityName);
        }
    }

    private class PackageHelper
    extends EntityHelper {
        private PackageHelper() {
            super("package", MFContext.PKG_EXT);
        }

        @Override
        protected List<String> listEntities() throws UtilitiesException, TFCacheException, IllegalStateException {
            return MFContext.this.cache.listPackages(false).stream().filter(entity -> entity.endsWith(this.entityExtension)).map(entity -> entity.substring(0, entity.length() - this.entityExtension.length())).collect(Collectors.toList());
        }

        @Override
        public List<String> listEntitiesByType(String typeName) throws RepositoryException {
            try {
                return this.listEntities().stream().filter(entity -> entity.startsWith(typeName + ".")).map(entity -> entity.substring(typeName.length() + 1)).collect(Collectors.toList());
            }
            catch (Exception exception) {
                MFContext.processException(exception);
                return new ArrayList<String>();
            }
        }

        @Override
        protected void removeEntity(String entityName) throws TFCacheException, IllegalStateException {
        }
    }

    private static interface BindingProcessor {
        public void process(String var1, String var2, String var3) throws TFCacheException, IllegalStateException, NamingException;
    }

    static interface RepositoryTask {
        public void run() throws RepositoryException;
    }

    static class DecomposedPath {
        String directoryPath;
        String filename;

        DecomposedPath(String filePath) {
            filePath = filePath.replace('\\', '/');
            int lastSlashPos = filePath.lastIndexOf(47);
            if (lastSlashPos > 0) {
                this.directoryPath = filePath.substring(0, lastSlashPos);
                this.filename = filePath.substring(lastSlashPos + 1);
            } else {
                this.directoryPath = null;
                this.filename = filePath;
            }
        }
    }
}

