/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.repository.cache;

import com.streamscape.Trace;
import com.streamscape.lib.concurrent.worker.MonitorWorker;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.repository.cache.CacheDirectoryMonitor;
import com.streamscape.repository.cache.TFCache;
import com.streamscape.sef.FabricException;
import java.util.Date;
import java.util.Iterator;

public class CacheIOThread
extends MonitorWorker {
    private final TFCache tfCache;
    private final CacheDirectoryMonitor directoryMonitor;
    private int gcCycles;
    private int gcCycleCounter;

    public CacheIOThread(TFCache tfCache, long ioThreadCycle, int gcCycles) throws FabricException {
        super("RSYS:TFCache.IOThread", "Periodically evicts expired files from TFCache.", ioThreadCycle);
        this.tfCache = tfCache;
        this.gcCycles = gcCycles;
        this.directoryMonitor = new CacheDirectoryMonitor(tfCache.getCacheLocation());
        this.directoryMonitor.setNotifyDirectories(true);
        this.directoryMonitor.setLockedStatesEnabled(false);
        this.directoryMonitor.addListener(tfCache);
    }

    public void resetMonitor() {
        this.directoryMonitor.resetSnapshot();
    }

    public void startMonitor() {
        this.directoryMonitor.start();
    }

    public void suspendMonitor() {
        this.directoryMonitor.suspend();
    }

    public void suspendMonitorAndWait() {
        this.directoryMonitor.suspend();
        this.directoryMonitor.waitProcessingFinished();
    }

    @Override
    protected void doExecute() {
        long oldOwnCreatedInfoCounter = this.tfCache.getOldOwnCreatedInfoCounter();
        this.tfCache.incrementOldOwnCreatedInfoCounter();
        this.tfCache.processScheduledJunk();
        Iterator<String> evFiles = this.tfCache.getEvictionMap().getArtifacts();
        while (evFiles.hasNext()) {
            String file = evFiles.next();
            Date evictTime = this.tfCache.getEvictionMap().getScheduledEventTime(file);
            if (System.currentTimeMillis() <= evictTime.getTime()) continue;
            try {
                this.tfCache.evict(file);
            }
            catch (Exception exception) {
                Trace.logException(this, exception, true);
                Trace.logError(this, "Evicting of file '" + file + "' failed.");
            }
        }
        try {
            this.directoryMonitor.process();
            this.tfCache.expireOldOwnCreatedInfo(oldOwnCreatedInfoCounter);
        }
        catch (Throwable ex) {
            Trace.logException(CacheIOThread.class, ex, true);
        }
        if (this.gcCycles > 0 && ++this.gcCycleCounter >= this.gcCycles) {
            Runtime.getRuntime().runFinalization();
            Runtime.getRuntime().gc();
            this.gcCycleCounter = 0;
        }
        this.tfCache.flushOwnersTable();
    }

    @Override
    protected void doStop() {
        super.doStop();
        this.directoryMonitor.removeListener(this.tfCache);
        this.directoryMonitor.stop();
        Trace.logInfo(this, "Cache IO Thread stopped.");
    }

    private void delete(String name) {
        FileIOUtils.deleteFile(name);
        this.tfCache.getEvictionMap().removeArtifact(name);
        Trace.logInfo(this, "Artifact '" + name + "' evicted from local cache.");
    }
}

