/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.repository.cache;

import com.streamscape.Trace;
import com.streamscape.lib.evfs.BaseDirectoryMonitor;
import com.streamscape.lib.evfs.FileChangeListener;
import com.streamscape.lib.evfs.FileSortStrategy;
import com.streamscape.sdo.enums.FileState;
import com.streamscape.sdo.file.FileMetaInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class CacheDirectoryMonitor
extends BaseDirectoryMonitor {
    private List<File> files;
    private List<File> newFiles;
    private static final FileStateHelper FILE_STATE_HELPER = new FileStateHelper();

    CacheDirectoryMonitor(String directory) throws IllegalArgumentException {
        super("TFCache directory monitor", directory, true, FileSortStrategy.SERVER_DEFAULT, false);
    }

    @Override
    protected void initSnapshot() {
        this.files = new ArrayList<File>();
        this.newFiles = new ArrayList<File>();
        this.snapshot = this.getFileObjects();
    }

    @Override
    protected List<FileMetaInfo> getFileObjects(File root) {
        this.newFiles.clear();
        ArrayList<FileMetaInfo> result = new ArrayList<FileMetaInfo>(this.snapshot != null ? this.snapshot.size() : 10);
        if (this.getFileObjects(root, result) == null) {
            return null;
        }
        this.files.clear();
        this.files.addAll(this.newFiles);
        return result;
    }

    private File getFile(List<File> files, String parentPath, String filename) {
        for (int i = 0; i < files.size(); ++i) {
            File file = files.get(i);
            String path = file.getPath();
            if (path.length() != parentPath.length() + File.separator.length() + filename.length() || !path.startsWith(parentPath) || path.indexOf(File.separator, parentPath.length()) != parentPath.length() || !path.endsWith(filename)) continue;
            return file;
        }
        return null;
    }

    private List<FileMetaInfo> getFileObjects(File root, List<FileMetaInfo> result) {
        String[] filenames = root.list();
        if (filenames != null) {
            for (String filename : filenames) {
                FileMetaInfo fileState;
                File file = this.getFile(this.files, root.getPath(), filename);
                if (file == null) {
                    file = new File(root, filename);
                }
                this.newFiles.add(file);
                int index = this.snapshot != null ? this.snapshot.indexOf(FILE_STATE_HELPER.update(file.getPath())) : -1;
                FileMetaInfo fileMetaInfo = fileState = index != -1 ? (FileMetaInfo)this.snapshot.get(index) : null;
                if (fileState == null || fileState.getLastModifiedTime() != file.lastModified() || fileState.getLastState() == FileState.CREATING || fileState.getLastState() == FileState.MODIFYING) {
                    fileState = new FileMetaInfo(file);
                } else {
                    fileState.setLastState(FileState.STATIC);
                    fileState.setSizeDelta(0L);
                }
                if (!fileState.isDirectory()) {
                    result.add(fileState);
                    continue;
                }
                if (this.notifyDirectories) {
                    result.add(fileState);
                }
                if (!this.recursiveScan) continue;
                this.getFileObjects(file, result);
            }
        } else {
            return null;
        }
        return result;
    }

    @Override
    protected synchronized void raiseEvent(FileMetaInfo state) throws Exception {
        FileMetaInfo clone = (FileMetaInfo)state.clone();
        for (FileChangeListener listener : this.fileChangeListeners) {
            listener.onChange(clone);
        }
    }

    @Override
    protected void logException(Throwable exception, boolean printStackTrace) {
        Trace.logException(this, exception, printStackTrace);
    }

    @Override
    protected void logError(String message) {
        Trace.logError(this, message);
    }

    @Override
    protected void logInfo(String message) {
        Trace.logInfo(this, message);
    }

    @Override
    protected void logDebug(String message) {
        Trace.logDebug(this, message);
    }

    private static class FileStateHelper
    extends FileMetaInfo {
        private FileStateHelper() {
        }

        FileStateHelper update(String path) {
            this.path = path;
            return this;
        }
    }
}

