/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.repository.cache;

import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sdo.SystemDataObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ArtifactCachePolicy
extends CloneableDataObject
implements SystemDataObject {
    protected long timeStamp = System.currentTimeMillis();
    protected Map<String, Date> scheduleMap = Collections.synchronizedMap(new HashMap());

    public synchronized Iterator<String> getArtifacts() {
        ArrayList<String> artifacts = new ArrayList<String>();
        for (String artifact : this.scheduleMap.keySet()) {
            artifacts.add(artifact);
        }
        return artifacts.iterator();
    }

    public synchronized boolean containsArtifact(String pathInCache) {
        return this.scheduleMap.containsKey(pathInCache);
    }

    public synchronized void addArtifact(String pathInCache, Date eventTime) {
        this.scheduleMap.put(pathInCache, eventTime);
    }

    public synchronized void removeArtifact(String pathInCache) {
        this.scheduleMap.remove(pathInCache);
    }

    public synchronized Date getScheduledEventTime(String pathInCache) {
        return this.scheduleMap.get(pathInCache);
    }

    public int size() {
        return this.scheduleMap.size();
    }

    @Override
    public Date getTimestamp() {
        return new Date(this.timeStamp);
    }

    @Override
    public void touch() {
        this.timeStamp = System.currentTimeMillis();
    }
}

