/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.repository;

import com.streamscape.Trace;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.repository.RepositoryContext;
import com.streamscape.repository.RepositoryException;
import com.streamscape.repository.cache.MFContext;
import java.util.HashMap;
import java.util.Map;

public class RepositoryContextFactory {
    private static String DEFAULT_REPOSITORY_CONTEXT = MFContext.class.getName();

    public static RepositoryContext createRepositoryContext(HashMap<String, Object> env, HashMap<String, Object> props) throws RepositoryException {
        String repositoryContextClassName = (String)env.get("streamscape.naming.factory.initial");
        if (repositoryContextClassName == null || repositoryContextClassName.length() == 0) {
            throw new RepositoryException(4004, "initial Context Factory is null or empty");
        }
        if (repositoryContextClassName.equals("com.streamscape.repository.provider.sef.MFContext")) {
            repositoryContextClassName = DEFAULT_REPOSITORY_CONTEXT;
        }
        try {
            Trace.logDebug(RepositoryContextFactory.class, "Initializing Repository Context '" + repositoryContextClassName + "'.");
            RepositoryContext repository = RepositoryContextFactory.createRepositoryContextInstance(repositoryContextClassName, env);
            repository.init(env, props);
            Trace.logInfo(RepositoryContextFactory.class, "Repository Context '" + repositoryContextClassName + "' initialized.");
            return repository;
        }
        catch (UtilitiesException exception) {
            throw new RepositoryException(4014, "Initialization of Repository Context failed.", exception);
        }
    }

    private static RepositoryContext createRepositoryContextInstance(String className, Map<String, Object> env) throws UtilitiesException {
        try {
            return (RepositoryContext)ClassUtils.createFromClassName(RepositoryContextFactory.class, className, true);
        }
        catch (UtilitiesException exception) {
            Trace.logDebug(RepositoryContextFactory.class, "Initialization of Repository Context '" + className + "' failed. Trying to use default implementation '" + DEFAULT_REPOSITORY_CONTEXT + "'...");
            env.put("streamscape.naming.factory.initial", DEFAULT_REPOSITORY_CONTEXT);
            return (RepositoryContext)ClassUtils.createFromClassName(RepositoryContextFactory.class, DEFAULT_REPOSITORY_CONTEXT, true);
        }
    }
}

