/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.repository;

import com.streamscape.Trace;
import com.streamscape.repository.RepositoryContext;
import com.streamscape.repository.RepositoryException;
import com.streamscape.repository.types.AbstractSemanticFactory;
import com.streamscape.sdo.sys.SysId;
import com.streamscape.sef.FabricComponent;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AbstractRepositoryContext
extends AbstractSemanticFactory
implements RepositoryContext {
    protected HashMap<String, Object> environment = new HashMap();
    protected HashMap<String, Object> repositoryProperties = new HashMap();
    protected ReentrantLock lock = new ReentrantLock(true);
    protected boolean inTransaction = false;
    protected FabricComponent transactionComponent = null;
    protected String installRoot = null;
    protected SysId sysId = null;

    @Override
    public void init(HashMap<String, Object> env) throws RepositoryException {
        this.init(env, null);
    }

    @Override
    public void init(HashMap<String, Object> env, HashMap<String, Object> props) throws RepositoryException {
        if (env != null) {
            this.environment.clear();
            this.environment.putAll(env);
        }
        if (props != null) {
            this.repositoryProperties.clear();
            this.repositoryProperties.putAll(props);
        }
        this.sysId = new SysId((String)this.environment.get("streamscape.naming.security.principal"));
    }

    @Override
    public HashMap<String, Object> getEnvironment() {
        return this.environment;
    }

    @Override
    public HashMap<String, Object> getRepositoryProperties() {
        return this.repositoryProperties;
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) {
        return this.environment.put(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) {
        return this.environment.remove(propName);
    }

    public void printEnvironment() {
        System.out.println("Repository Context Properties: " + this.getProviderClass());
        System.out.println("-----------------------------");
        for (Map.Entry<String, Object> entry : this.getEnvironment().entrySet()) {
            String prop = entry.getKey();
            String val = String.valueOf(entry.getValue());
            System.out.println(prop + "/t: " + val);
        }
    }

    @Override
    public void beginXact(FabricComponent component, long timeout) throws InterruptedException, RepositoryException {
        if (timeout < 0L) {
            throw new RepositoryException(4005, "Transaction timeout is invalid.");
        }
        if (this.lock.isHeldByCurrentThread()) {
            throw new RepositoryException(4021, "Transaction already started by this thread.");
        }
        if (!this.lock.tryLock(timeout, TimeUnit.MILLISECONDS)) {
            throw new RepositoryException(4022, "Transaction timeout expired.");
        }
        this.inTransaction = true;
        this.transactionComponent = component;
    }

    @Override
    public void commitXact() throws RepositoryException {
        this.allowedToXact();
        this.lock.unlock();
        this.inTransaction = false;
        this.transactionComponent = null;
    }

    @Override
    public void rollbackXact() throws RepositoryException {
        this.allowedToXact();
        this.lock.unlock();
        this.inTransaction = false;
        this.transactionComponent = null;
        throw new RepositoryException(4001, "Rollback is not supported. Transactional sequence is aborted.");
    }

    @Override
    public void abortXact() {
        if (this.lock.isHeldByCurrentThread()) {
            this.lock.unlock();
            this.inTransaction = false;
            this.transactionComponent = null;
        } else {
            Trace.logError(this, "Transaction abort failed: transaction was started by another thread.");
        }
    }

    @Override
    public void abortXactSafe() {
        if (this.inXactByCurrentThread()) {
            this.abortXact();
        }
    }

    @Override
    public void allowedToXact() throws RepositoryException {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new RepositoryException(4020, "Transaction not started or started by another thread.");
        }
    }

    @Override
    public boolean inXact() {
        return this.inTransaction;
    }

    @Override
    public boolean inXactByCurrentThread() {
        return this.inTransaction && this.lock.isHeldByCurrentThread();
    }

    @Override
    public void setInstallRoot(String rootDir) {
        if (this.installRoot == null) {
            this.installRoot = rootDir;
        }
    }

    @Override
    public String getInstallRoot() {
        return this.installRoot;
    }

    @Override
    public SysId getSystemId() {
        return this.sysId;
    }

    @Override
    public String getProviderClass() {
        return this.environment != null ? (String)this.environment.get("streamscape.naming.factory.initial") : "..";
    }

    protected void checkOpened() throws RepositoryException {
        if (!this.isOpen()) {
            throw new RepositoryException(4015, "Repository context is not opened.");
        }
    }
}

