/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.xsd;

import com.streamscape.omf.xsd.ComplexType;
import com.streamscape.omf.xsd.SimpleType;
import com.streamscape.omf.xsd.Type;
import com.streamscape.omf.xsd.UnionType;
import com.streamscape.omf.xsd.XsdElement;
import com.streamscape.omf.xsd.XsdException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class XsdSchema {
    private String documentation;
    private List<XsdElement> elements = new ArrayList<XsdElement>();

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public void addElement(XsdElement element) {
        if (!this.elements.contains(element)) {
            this.elements.add(element);
        }
    }

    public void removeElement(XsdElement element) {
        this.elements.remove(element);
    }

    public boolean existsElement(String elementName) {
        for (XsdElement element : this.elements) {
            if (!element.getName().equals(elementName)) continue;
            return true;
        }
        return false;
    }

    public boolean existsType(String typeName) {
        for (XsdElement element : this.elements) {
            if (element.getType() == null || !(element.getType() instanceof ComplexType) || !((ComplexType)element.getType()).getName().equals(typeName)) continue;
            return true;
        }
        return false;
    }

    public Collection<XsdElement> getElements() {
        return this.elements;
    }

    public Type getType(String typeName) {
        for (XsdElement element : this.elements) {
            if (element.getType() == null || !element.getType().getName().equals(typeName)) continue;
            return element.getType();
        }
        return null;
    }

    public void detectListsAndImplicitLists() {
        for (XsdElement element : this.elements) {
            Type elementType = element.getType();
            if (!(elementType instanceof ComplexType)) continue;
            ComplexType elementComplexType = (ComplexType)elementType;
            List<XsdElement> elementsProbablyLists = elementComplexType.getElements().stream().filter(e -> e.isProbablyList()).collect(Collectors.toList());
            if (elementComplexType.getElements().size() == 1 && elementsProbablyLists.size() == 1) {
                elementComplexType.setIsList(true);
                element.setMinOccurs(0);
                element.setMaxOccurs(0);
                elementComplexType.getElements().get(0).setMinOccurs(0);
                elementComplexType.getElements().get(0).setMaxOccurs(0);
                continue;
            }
            if (elementComplexType.getElements().size() <= 1 || elementsProbablyLists.size() < 1) continue;
            elementsProbablyLists.forEach(e -> {
                if (e.getType() instanceof ComplexType) {
                    XsdElement elementOfList = new XsdElement(e.getType().getName());
                    elementOfList.setType(e.getType());
                    elementOfList.setIsGlobal(false);
                    elementOfList.setMinOccurs(0);
                    elementOfList.setMaxOccurs(0);
                    ComplexType complexTypeList = new ComplexType(e.getType().getName() + "List");
                    complexTypeList.addElement(elementOfList);
                    complexTypeList.setIsList(true);
                    complexTypeList.setIsXmlImplicitCollection(true);
                    XsdElement elementList = new XsdElement(e.getName() + "List");
                    elementList.setType(complexTypeList);
                    elementList.setIsGlobal(false);
                    elementList.setMinOccurs(0);
                    elementList.setMaxOccurs(0);
                    elementComplexType.replace((XsdElement)e, elementList);
                }
            });
        }
    }

    public void sortElements() throws XsdException {
        HashMap<String, ElementInfo> map = new HashMap<String, ElementInfo>();
        for (XsdElement element : this.elements) {
            if (map.put(this.getComplexTypeNameOrElementName(element), new ElementInfo(this, element)) == null) continue;
            throw new XsdException("Duplicate type name '" + element.getName() + "'.");
        }
        ArrayList<XsdElement> sortedElements = new ArrayList<XsdElement>();
        while (map.size() > 0) {
            boolean changed = false;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (((ElementInfo)entry.getValue()).dependencies.size() == 0) {
                    sortedElements.add(((ElementInfo)entry.getValue()).element);
                    iterator.remove();
                    changed = true;
                    continue;
                }
                if (!this.removeTypesFromDependencies(((ElementInfo)entry.getValue()).dependencies, sortedElements, map)) continue;
                changed = true;
                break;
            }
            if (changed) continue;
            break;
        }
        if (map.size() > 0) {
            throw new XsdException("Failed to sort xsd schema types.");
        }
        this.elements = sortedElements;
        for (XsdElement element : this.elements) {
            if (element.getType() != null && element.getType() instanceof ComplexType) {
                ((ComplexType)element.getType()).resolveBaseType(this);
            }
            element.resolveType(this);
        }
    }

    private boolean removeTypesFromDependencies(Set<String> dependencies, List<XsdElement> sortedElements, Map<String, ElementInfo> map) throws XsdException {
        Iterator<String> iterator = dependencies.iterator();
        boolean changed = false;
        while (iterator.hasNext()) {
            String dependency = iterator.next();
            ElementInfo info = map.get(dependency);
            if (info != null) {
                this.removeTypesFromDependencies(info.dependencies, sortedElements, map);
                if (info.dependencies.size() != 0) continue;
                sortedElements.add(info.element);
                map.remove(dependency);
                iterator.remove();
                changed = true;
                continue;
            }
            if (this.findInSortedElements(dependency, sortedElements)) {
                iterator.remove();
                continue;
            }
            iterator.remove();
        }
        return changed;
    }

    private String getComplexTypeNameOrElementName(XsdElement element) {
        return element.getType() != null && element.getType() instanceof ComplexType ? ((ComplexType)element.getType()).getName() : element.getName();
    }

    private boolean findInSortedElements(String type, List<XsdElement> sortedElements) {
        for (XsdElement element : sortedElements) {
            if (!this.getComplexTypeNameOrElementName(element).equals(type)) continue;
            return true;
        }
        return false;
    }

    private class ElementInfo {
        XsdElement element;
        Set<String> dependencies = new HashSet<String>();

        ElementInfo(XsdSchema xsdSchema, XsdElement element) {
            this.element = element;
            this.addTypeDependencies(this.dependencies, element.getType());
            this.dependencies.remove(xsdSchema.getComplexTypeNameOrElementName(element));
        }

        private void addTypeDependencies(Set<String> dependencies, Type type) {
            block6: {
                block7: {
                    block5: {
                        if (type == null) {
                            return;
                        }
                        if (!(type instanceof SimpleType)) break block5;
                        this.addTypeDependencies(dependencies, ((SimpleType)type).getBaseType());
                        break block6;
                    }
                    if (!(type instanceof UnionType)) break block7;
                    for (Type unionType : ((UnionType)type).getUnionTypes()) {
                        this.addTypeDependencies(dependencies, unionType);
                    }
                    break block6;
                }
                if (!(type instanceof ComplexType)) break block6;
                ComplexType complexType = (ComplexType)type;
                if (complexType.getBaseTypeName() != null) {
                    dependencies.add(complexType.getBaseTypeName());
                }
                if (!complexType.isList()) {
                    dependencies.add(type.getName());
                }
                for (XsdElement element : complexType.getElements()) {
                    this.addTypeDependencies(dependencies, element.getType());
                }
            }
        }
    }
}

