/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.xsd;

import com.streamscape.omf.xml.xstream.io.HierarchicalStreamReader;
import com.streamscape.omf.xml.xstream.io.xml.XppDriver;
import com.streamscape.omf.xsd.AbstractParser;
import com.streamscape.omf.xsd.ComplexType;
import com.streamscape.omf.xsd.InternalType;
import com.streamscape.omf.xsd.SimpleType;
import com.streamscape.omf.xsd.Type;
import com.streamscape.omf.xsd.XsdElement;
import com.streamscape.omf.xsd.XsdException;
import com.streamscape.omf.xsd.XsdSchema;
import com.streamscape.omf.xsd.XsdTag;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.SAXException;

public class XsdParser
extends AbstractParser {
    private String defaultNamespace;
    private List<String> externalNamespaces = new ArrayList<String>();

    @Override
    protected XsdSchema onParse(Reader in, Map<String, String> typesMap, Map<String, String> aliasesMap) throws XsdException {
        XppDriver driver = new XppDriver();
        HierarchicalStreamReader reader = driver.createReader(in);
        if (typesMap != null) {
            throw new XsdException("Xsd parser doesn't allow types map.");
        }
        if (XsdTag.parse(reader.getNodeName()) != XsdTag.xsd_schema) {
            throw new XsdException("Xsd schema should start with 'xsd:schema' tag.");
        }
        this.parseNamespaces(reader);
        this.schema = new XsdSchema();
        this.context = new AbstractParser.Context(XsdTag.xsd_schema);
        while (true) {
            if (reader.hasMoreChildren()) {
                this.stack.push(this.context);
                reader.moveDown();
                this.onOpenTag(XsdTag.parse(reader.getNodeName()), reader, aliasesMap);
                continue;
            }
            if (this.stack.size() == 0) break;
            this.context = (AbstractParser.Context)this.stack.pop();
            reader.moveUp();
        }
        return this.schema;
    }

    private void parseNamespaces(HierarchicalStreamReader reader) {
        String targetNamespace = reader.getAttribute("targetNamespace");
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeName(i);
            String value = reader.getAttribute(i);
            if (!name.startsWith("xmlns:") || (name = name.substring("xmlns:".length())).equals("xs") || name.equals("xsd")) continue;
            if (targetNamespace != null && value.equals(targetNamespace)) {
                this.defaultNamespace = name;
                continue;
            }
            this.externalNamespaces.add(name);
        }
    }

    private void skipTag(HierarchicalStreamReader reader) {
        this.context = (AbstractParser.Context)this.stack.pop();
        reader.moveUp();
    }

    private String removeNamespace(String name) throws XsdException {
        if (name == null) {
            return name;
        }
        if (name.startsWith("xsd:") || name.startsWith("xs:")) {
            return name;
        }
        int pos = name.indexOf(":");
        if (pos != -1 && pos < name.length() + 1) {
            String namespace = name.substring(0, pos);
            if (this.defaultNamespace != null && namespace.equals(this.defaultNamespace) || this.externalNamespaces.contains(namespace)) {
                name = name.substring(pos + 1);
            } else {
                throw new XsdException("Unknown namespace '" + namespace + "'.");
            }
        }
        return name;
    }

    protected String getAlias(Map<String, String> aliasMap, String elementName) {
        if (aliasMap == null) {
            return null;
        }
        StringBuilder path = new StringBuilder("/");
        for (int i = 0; i < this.stack.size(); ++i) {
            path.append("/").append(((AbstractParser.Context)this.stack.elementAt((int)i)).element.getName());
        }
        path.append("/").append(elementName);
        return aliasMap.get(path.toString());
    }

    protected String resolveAlias(Map<String, String> aliasMap, String elementName) {
        return XsdParser.resolveAlias(this.getAlias(aliasMap, elementName), elementName);
    }

    private void onOpenTag(XsdTag tag, HierarchicalStreamReader reader, Map<String, String> aliasesMap) throws XsdException {
        switch (tag) {
            case xsd_documentation: {
                if (this.context.element != null) {
                    this.context.element.setDocumentation(reader.getValue());
                    break;
                }
                this.schema.setDocumentation(reader.getValue());
                break;
            }
            case xsd_element: {
                String defaultValue;
                String maxOccurs;
                String name = reader.getAttribute("name");
                if (name == null) {
                    throw new XsdException("Missing attribute 'name' for tag 'xsd:element'.");
                }
                name = this.removeNamespace(name);
                XsdElement element = new XsdElement(name);
                element.setAlias(this.resolveAlias(aliasesMap, name));
                String typeName = reader.getAttribute("type");
                typeName = this.removeNamespace(typeName);
                if (typeName != null) {
                    Type type = Type.createType(typeName);
                    element.setType(type);
                    if (this.context.element == null) {
                        throw new XsdException("Typed xsd:element '" + name + "' doesn't have parent element.");
                    }
                }
                ComplexType complexType = this.context.element != null && this.context.element.getType() != null && this.context.element.getType() instanceof ComplexType ? (ComplexType)this.context.element.getType() : null;
                String minOccurs = reader.getAttribute("minOccurs");
                if (minOccurs != null) {
                    if (minOccurs.equals("unbounded")) {
                        element.setMinOccurs(-1);
                    } else {
                        element.setMinOccurs(Integer.parseInt(minOccurs));
                    }
                }
                if ((maxOccurs = reader.getAttribute("maxOccurs")) != null) {
                    int maxOccursInt;
                    int n = maxOccursInt = maxOccurs.equals("unbounded") ? -1 : Integer.parseInt(maxOccurs);
                    if (maxOccursInt == -1 || maxOccursInt > 1) {
                        if (complexType == null) {
                            throw new XsdException("Failed to parse tag 'xsd:element' from name '" + name + "', maxOccurs greater then 1 can be inside complexType only.");
                        }
                        if (complexType.getElements().size() != 0) {
                            throw new XsdException("More then one unbounded element not allowed inside one complex type.");
                        }
                        complexType.setIsList(true);
                        if (!this.context.element.isGlobal()) {
                            this.schema.removeElement(this.context.element);
                        }
                    }
                    element.setMaxOccurs(maxOccursInt);
                }
                if ((defaultValue = reader.getAttribute("default")) != null) {
                    element.setDefaultValue(defaultValue);
                }
                if (complexType != null) {
                    element.setIsGlobal(false);
                    complexType.addElement(element);
                } else {
                    this.schema.addElement(element);
                }
                this.context = new AbstractParser.Context(tag, element);
                break;
            }
            case xsd_attribute: {
                ComplexType complexType;
                String name = reader.getAttribute("name");
                if (name == null) {
                    throw new XsdException("Missing attribute 'name' for tag 'xsd:attribute'.");
                }
                name = this.removeNamespace(name);
                XsdElement attribute = new XsdElement(name);
                attribute.setIsXmlAttribute(true);
                attribute.setIsGlobal(false);
                String typeName = reader.getAttribute("type");
                typeName = this.removeNamespace(typeName);
                if (typeName == null) {
                    typeName = "xsd:string";
                }
                attribute.setType(Type.createType(typeName));
                String defaultValue = reader.getAttribute("default");
                if (defaultValue != null) {
                    attribute.setDefaultValue(defaultValue);
                }
                ComplexType complexType2 = complexType = this.context.element != null && this.context.element.getType() != null && this.context.element.getType() instanceof ComplexType ? (ComplexType)this.context.element.getType() : null;
                if (complexType == null) {
                    throw new XsdException("xsd:attribute '" + name + "' should be defined inside complex type.");
                }
                complexType.addElement(attribute);
                break;
            }
            case xsd_complexType: {
                if (this.context.element == null) {
                    String name = reader.getAttribute("name");
                    if (name == null) {
                        throw new XsdException("Missing attribute 'name' for tag 'xsd:complexType'.");
                    }
                    name = this.removeNamespace(name);
                    XsdElement element = new XsdElement(name);
                    this.context = new AbstractParser.Context(tag, element);
                }
                this.schema.addElement(this.context.element);
                this.context.element.setType(new ComplexType(this.context.element.getName()));
                break;
            }
            case xsd_simpleType: {
                if (this.context.element == null) {
                    String name = reader.getAttribute("name");
                    if (name == null) {
                        throw new XsdException("Missing attribute 'name' for tag 'xsd:simpleType'.");
                    }
                    name = this.removeNamespace(name);
                    XsdElement element = new XsdElement(name);
                    this.schema.addElement(element);
                    this.context = new AbstractParser.Context(tag, element);
                }
                this.context.element.setType(new SimpleType(this.context.element.getName()));
                break;
            }
            case xsd_choice: {
                if (this.context.element == null || this.context.element.getType() == null || !(this.context.element.getType() instanceof ComplexType)) {
                    throw new XsdException("Unexpected tag xsd:choice, this tag is allowed inside 'complexType' tag only.");
                }
                ((ComplexType)this.context.element.getType()).setIsChoice(true);
                break;
            }
            case xsd_restriction: {
                if (this.context.element == null || this.context.element.getType() == null || !(this.context.element.getType() instanceof SimpleType)) {
                    throw new XsdException("Unexpected tag 'xsd:restriction', parent should be element simpleType.");
                }
                SimpleType simpleType = (SimpleType)this.context.element.getType();
                String base = reader.getAttribute("base");
                InternalType baseType = InternalType.createType(base);
                if (baseType == null) {
                    throw new XsdException("Unknown type '" + base + "'.");
                }
                simpleType.setBaseType(baseType);
                break;
            }
            case xsd_union: {
                if (this.context.element == null || this.context.element.getType() == null || !(this.context.element.getType() instanceof SimpleType)) {
                    throw new XsdException("Unexpected tag '" + reader.getNodeName() + "', parent should be element simpleType.");
                }
                SimpleType simpleType = (SimpleType)this.context.element.getType();
                String memberTypes = reader.getAttribute("memberTypes");
                if (memberTypes == null) {
                    throw new XsdException("xsd:union doesn't contain memberTypes attributes.");
                }
                simpleType.setBaseType(InternalType.createType("xsd:string"));
                break;
            }
            case xsd_enumeration: 
            case xsd_maxLength: 
            case xsd_length: 
            case xsd_pattern: 
            case xsd_totalDigits: 
            case xsd_fractionDigits: 
            case xsd_minExclusive: 
            case xsd_maxExclusive: 
            case xsd_maxInclusive: 
            case xsd_minInclusive: {
                if (this.context.element == null || this.context.element.getType() == null || !(this.context.element.getType() instanceof SimpleType)) {
                    throw new XsdException("Unexpected tag '" + reader.getNodeName() + "', parent should be element simpleType.");
                }
                SimpleType simpleType = (SimpleType)this.context.element.getType();
                simpleType.addRestriction(tag, reader.getAttribute("value"));
                break;
            }
            case xsd_extension: {
                if (this.context.element == null || this.context.element.getType() == null || !(this.context.element.getType() instanceof ComplexType)) {
                    throw new XsdException("Unexpected tag '" + reader.getNodeName() + "', parent should be element of complexType.");
                }
                ((ComplexType)this.context.element.getType()).setBaseTypeName(reader.getAttribute("base"));
                break;
            }
            case xsd_complexContent: 
            case xsd_annotation: 
            case xsd_sequence: {
                break;
            }
            case xsd_appinfo: {
                this.skipTag(reader);
                break;
            }
            case unknowntag: {
                throw new XsdException("Unknown tag '" + reader.getNodeName() + "'.");
            }
            default: {
                throw new XsdException("Unhandled tag '" + reader.getNodeName() + "'.");
            }
        }
    }

    public static void validateXml(String xsdfilename, String xmlfilename) throws XsdException, FileNotFoundException, IOException {
        XsdParser.validateXml(xsdfilename, new FileInputStream(xmlfilename));
    }

    public static void validateXml(String xsdfilename, InputStream xmlinput) throws XsdException, IOException {
        Validator validator;
        StreamSource schemaFile = new StreamSource(new File(xsdfilename));
        StreamSource xmlFile = new StreamSource(xmlinput);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            validator = schemaFactory.newSchema(schemaFile).newValidator();
        }
        catch (SAXException exception) {
            throw new XsdException("Failed to read XSD schema. Cause: " + exception.getLocalizedMessage());
        }
        try {
            validator.validate(xmlFile);
        }
        catch (SAXException exception) {
            throw new XsdException("Provided XML is not valid. Cause: " + exception.getLocalizedMessage());
        }
    }
}

