/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.xsd;

import com.streamscape.omf.xsd.ComplexType;
import com.streamscape.omf.xsd.Type;
import com.streamscape.omf.xsd.XsdException;
import com.streamscape.omf.xsd.XsdSchema;

public class XsdElement {
    private String name;
    private Type type;
    private String alias;
    private String documentation;
    private boolean isGlobal = true;
    private int minOccurs = 0;
    private int maxOccurs = 1;
    private String defaultValue = null;
    private boolean isXmlAttribute = false;
    private boolean isProbablyList = false;

    public XsdElement(String name) {
        this.name = name;
        this.isGlobal = true;
    }

    public String getName() {
        return this.name;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public void setMinOccurs(int minOccurs) {
        this.minOccurs = minOccurs;
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public void setMaxOccurs(int maxOccurs) {
        this.maxOccurs = maxOccurs;
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public void setIsGlobal(boolean isGlobal) {
        this.isGlobal = isGlobal;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isXmlAttribute() {
        return this.isXmlAttribute;
    }

    public void setIsXmlAttribute(boolean isXmlAttribute) {
        this.isXmlAttribute = isXmlAttribute;
    }

    public void resolveType(XsdSchema schema) throws XsdException {
        Type globalType;
        if (this.type == null || !(this.type instanceof ComplexType)) {
            return;
        }
        Type type = globalType = "map".equalsIgnoreCase(this.type.getName()) ? this.type : schema.getType(this.type.getName());
        if (globalType != null && globalType instanceof ComplexType) {
            this.type = globalType;
        }
        ((ComplexType)this.type).resolveElementTypes(schema);
    }

    public boolean isProbablyList() {
        return this.isProbablyList;
    }

    public XsdElement setProbablyList(boolean probablyList) {
        this.isProbablyList = probablyList;
        return this;
    }
}

