/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.xsd;

import com.streamscape.omf.json.JSONSerializerFactory;
import com.streamscape.omf.serializer.SerializerException;
import com.streamscape.omf.xml.xstream.io.HierarchicalStreamReader;
import com.streamscape.omf.xml.xstream.io.xml.XppDriver;
import com.streamscape.omf.xsd.XsdException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class XmlToMapDeserializer {
    public Map<String, Object> deserialize(InputStream input) throws XsdException {
        return this.deserialize(input, new HashMap<String, String>(), new HashMap<String, String>());
    }

    public Map<String, Object> deserialize(InputStream input, String charset) throws XsdException, UnsupportedEncodingException {
        return this.deserialize(input, new HashMap<String, String>(), new HashMap<String, String>(), charset);
    }

    public Map<String, Object> deserialize(InputStream input, Map<String, String> typesMap, Map<String, String> aliasesMap) throws XsdException {
        return this.deserialize(new InputStreamReader(input), typesMap, aliasesMap);
    }

    public Map<String, Object> deserialize(InputStream input, Map<String, String> typesMap, Map<String, String> aliasesMap, String charset) throws XsdException, UnsupportedEncodingException {
        return this.deserialize(new InputStreamReader(input, charset), typesMap, aliasesMap);
    }

    protected Map<String, Object> deserialize(Reader in, Map<String, String> typesMap, Map<String, String> aliasesMap) throws XsdException {
        XppDriver driver = new XppDriver();
        final HierarchicalStreamReader reader = driver.createReader(in);
        Map<String, String> attributes = this.getAttributes(reader);
        final Object result = this.deserialize(reader, typesMap, aliasesMap, "//" + reader.getNodeName(), attributes);
        if (result instanceof Map) {
            return (Map)result;
        }
        return new HashMap(){
            {
                this.put(reader.getNodeName(), result);
            }
        };
    }

    protected Object deserialize(HierarchicalStreamReader reader, Map<String, String> typesMap, Map<String, String> aliasesMap, String path, Map<String, String> attributes) throws XsdException {
        if (!reader.hasMoreChildren()) {
            String type;
            Cloneable result = null;
            String value = reader.getValue().trim();
            String string = type = typesMap != null ? typesMap.get(path) : null;
            if (type != null) {
                if (value.length() != 0 && !this.isImplicitList(typesMap, path)) {
                    throw new XsdException("Invalid type '" + type + "' specified for path '" + path + "' with value '" + value + "'.");
                }
                if (this.isMap(typesMap, path)) {
                    result = new LinkedHashMap();
                } else if (this.isList(typesMap, path)) {
                    result = new ArrayList();
                }
            }
            if (result == null) {
                result = value;
            }
            result = this.addAttributes(attributes, result);
            return result;
        }
        Object result = this.createType(typesMap, path);
        if (attributes != null) {
            result = this.addAttributes(attributes, result);
        }
        while (reader.hasMoreChildren()) {
            attributes = this.getAttributes(reader);
            reader.moveDown();
            String nodeName = reader.getNodeName();
            String childPath = path + "/" + nodeName;
            Object o = this.deserialize(reader, typesMap, aliasesMap, childPath, attributes);
            if (result instanceof Map) {
                Map resultMap = (Map)result;
                if (this.isImplicitList(typesMap, childPath) || resultMap.containsKey(nodeName)) {
                    Object implicitList = resultMap.get(nodeName);
                    if (implicitList == null) {
                        implicitList = new ArrayList();
                        resultMap.put(nodeName, implicitList);
                    } else if (!(implicitList instanceof List)) {
                        implicitList = new ArrayList();
                        ((List)implicitList).add(resultMap.get(nodeName));
                        resultMap.put(nodeName, implicitList);
                    }
                    ((List)implicitList).add(o);
                } else {
                    resultMap.put(nodeName, o);
                }
            } else if (result instanceof List) {
                ((List)result).add(o);
            }
            reader.moveUp();
        }
        return result;
    }

    private Object addAttributes(Map<String, String> attributes, Object result) {
        if (attributes != null) {
            if (!(result instanceof Map)) {
                LinkedHashMap oldResult = result;
                result = new LinkedHashMap();
                ((Map)result).put("value", oldResult);
            }
            ((Map)result).putAll(attributes);
        }
        return result;
    }

    private Map<String, String> getAttributes(HierarchicalStreamReader reader) {
        if (reader.getAttributeCount() > 0) {
            LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
            for (int i = 0; i < reader.getAttributeCount(); ++i) {
                String attributeName = reader.getAttributeName(i);
                attributes.put("@" + attributeName, reader.getAttribute(i));
            }
            return attributes;
        }
        return null;
    }

    private boolean isImplicitList(Map<String, String> typesMap, String path) {
        String type = typesMap != null ? typesMap.get(path) : null;
        return type != null && type.equalsIgnoreCase("implicit-list");
    }

    private boolean isList(Map<String, String> typesMap, String path) {
        String type = typesMap != null ? typesMap.get(path) : null;
        return type != null && type.equalsIgnoreCase("list");
    }

    private boolean isMap(Map<String, String> typesMap, String path) {
        String type = typesMap != null ? typesMap.get(path) : null;
        return type != null && type.equalsIgnoreCase("map");
    }

    private Object createType(Map<String, String> typesMap, String path) throws XsdException {
        String type;
        String string = type = typesMap != null ? typesMap.get(path) : null;
        if (type == null || this.isMap(typesMap, path) || this.isImplicitList(typesMap, path)) {
            return new LinkedHashMap();
        }
        if (this.isList(typesMap, path)) {
            return new ArrayList();
        }
        throw new XsdException("Invalid type '" + type + "' is specified for path '" + path + "'.");
    }

    public static void main(String[] args) {
        String xml = "<a1 _a1a = \"1\">\n  <a1b1 _a1b1a = \"2\">\n    <a1b1s1 _a1b1s1a = \"4\">q1</a1b1s1>\n    <a1b1s2>q2</a1b1s2>\n    <a1b1l1 _asdddd=\"123\">q3</a1b1l1>\n    <a1b1l1>q4</a1b1l1>\n  </a1b1>\n  <a1b2 _aa=\"10\">\n  </a1b2>\n  <a1s1 _dd =\"11\">q</a1s1>\n</a1>\n";
        try {
            HashMap<String, String> typesMap = new HashMap<String, String>(){
                {
                    this.put("//a1/a1b1/a1b1s2", "implicit-list");
                    this.put("//a1/a1b2", "list");
                }
            };
            Map<String, Object> map = new XmlToMapDeserializer().deserialize(new ByteArrayInputStream(xml.getBytes()), (Map<String, String>)typesMap, null);
            System.out.println(JSONSerializerFactory.getInstance().getDefaultSerializer().serialize(map));
        }
        catch (XsdException e) {
            e.printStackTrace();
        }
        catch (SerializerException e) {
            e.printStackTrace();
        }
    }
}

