/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.xsd;

import com.streamscape.omf.xml.xstream.io.HierarchicalStreamReader;
import com.streamscape.omf.xml.xstream.io.xml.XppDriver;
import com.streamscape.omf.xsd.AbstractParser;
import com.streamscape.omf.xsd.ComplexType;
import com.streamscape.omf.xsd.EDLType;
import com.streamscape.omf.xsd.Type;
import com.streamscape.omf.xsd.XsdElement;
import com.streamscape.omf.xsd.XsdException;
import com.streamscape.omf.xsd.XsdSchema;
import com.streamscape.omf.xsd.XsdTag;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;

public class XmlParser
extends AbstractParser {
    private Function<String, Boolean> semanticTypeExistsChecker;

    public XmlParser(Function<String, Boolean> semanticTypeExistsChecker) {
        this.semanticTypeExistsChecker = semanticTypeExistsChecker;
    }

    @Override
    protected XsdSchema onParse(Reader in, Map<String, String> typesMap, Map<String, String> aliasesMap) throws XsdException {
        XppDriver driver = new XppDriver();
        HierarchicalStreamReader reader = driver.createReader(in);
        this.schema = new XsdSchema();
        this.context = new AbstractParser.Context(XsdTag.xsd_schema);
        this.onOpenTag(reader.getNodeName(), reader, typesMap, aliasesMap);
        while (true) {
            if (reader.hasMoreChildren()) {
                this.stack.push(this.context);
                reader.moveDown();
                this.onOpenTag(reader.getNodeName(), reader, typesMap, aliasesMap);
                continue;
            }
            if (this.stack.size() == 0) break;
            this.context = (AbstractParser.Context)this.stack.pop();
            reader.moveUp();
        }
        return this.schema;
    }

    protected void readTillCloseTag(HierarchicalStreamReader reader) {
        int depth = 0;
        while (true) {
            if (reader.hasMoreChildren()) {
                reader.moveDown();
                ++depth;
                continue;
            }
            if (depth == 0) {
                return;
            }
            reader.moveUp();
            --depth;
        }
    }

    protected String getTypeName(String elementName, Map<String, String> typesMap) {
        if (typesMap == null) {
            return null;
        }
        StringBuilder path = new StringBuilder("/");
        for (int i = 0; i < this.stack.size(); ++i) {
            path.append("/").append(((AbstractParser.Context)this.stack.elementAt((int)i)).element.getName());
        }
        path.append("/").append(elementName);
        return typesMap.get(path.toString());
    }

    protected String getAlias(Map<String, String> aliasMap, String elementName) {
        if (aliasMap == null) {
            return null;
        }
        StringBuilder path = new StringBuilder("/");
        for (int i = 0; i < this.stack.size(); ++i) {
            path.append("/").append(((AbstractParser.Context)this.stack.elementAt((int)i)).element.getName());
        }
        path.append("/").append(elementName);
        return aliasMap.get(path.toString());
    }

    protected String resolveAlias(Map<String, String> aliasMap, String elementName) {
        return XmlParser.resolveAlias(this.getAlias(aliasMap, elementName), elementName);
    }

    protected void onOpenTag(String elementName, HierarchicalStreamReader reader, Map<String, String> typesMap, Map<String, String> aliasesMap) throws XsdException {
        XsdTag elementTag;
        ComplexType complexType;
        if (this.context.element != null && this.context.element.getType() instanceof ComplexType && (complexType = (ComplexType)this.context.element.getType()).existsElement(elementName)) {
            XsdElement element = complexType.getElements().stream().filter(e -> e.getName().equalsIgnoreCase(elementName)).findFirst().get();
            if (!this.context.element.isProbablyList()) {
                element.setProbablyList(true);
            }
            this.context = new AbstractParser.Context(XsdTag.xsd_complexType, element);
            return;
        }
        String typeName = this.getTypeName(elementName, typesMap);
        if (this.semanticTypeExistsChecker.apply(typeName).booleanValue() || this.schema.existsType(typeName != null ? typeName : elementName)) {
            this.readTillCloseTag(reader);
            if (typeName == null && this.schema.existsType(elementName)) {
                typeName = elementName;
            }
        }
        XsdElement element = new XsdElement(elementName);
        element.setAlias(this.resolveAlias(aliasesMap, elementName));
        ArrayList<String> attributes = new ArrayList<String>();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            attributes.add(reader.getAttributeName(i));
        }
        if (reader.hasMoreChildren()) {
            typeName = typeName != null ? typeName : elementName;
            element.setType(new ComplexType(typeName));
            elementTag = XsdTag.xsd_complexType;
            for (String attribute : attributes) {
                XsdElement attributeElement = new XsdElement(attribute);
                attributeElement.setIsXmlAttribute(true);
                String attributeTypeName = this.getTypeName(elementName + "/" + attribute, typesMap);
                if (attributeTypeName == null) {
                    attributeTypeName = "string";
                }
                attributeElement.setType(EDLType.createType(attributeTypeName));
                attributeElement.setIsGlobal(false);
                ((ComplexType)element.getType()).addElement(attributeElement);
            }
            this.schema.addElement(element);
        } else {
            Type type = this.schema.getType(typeName = typeName != null ? typeName : "string");
            if (type == null) {
                type = EDLType.createTypeOrSemanticType(typeName);
            }
            element.setType(type);
            elementTag = XsdTag.xsd_element;
        }
        if (this.context.element != null) {
            element.setIsGlobal(false);
            if (this.context.element.getType() instanceof ComplexType) {
                ((ComplexType)this.context.element.getType()).addElement(element);
            }
        } else if (elementTag == XsdTag.xsd_element) {
            throw new XsdException("Failed to parse element '" + elementName + "', this element should be inside complex type.");
        }
        this.context = new AbstractParser.Context(elementTag, element);
    }
}

