/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.xsd;

import com.streamscape.omf.xsd.InternalType;
import com.streamscape.omf.xsd.Type;
import com.streamscape.omf.xsd.XsdException;
import com.streamscape.omf.xsd.XsdSchema;
import com.streamscape.omf.xsd.XsdTag;
import com.streamscape.slex.lang.ScriptParser;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SimpleType
extends Type {
    private InternalType baseType;
    private List<String> enumerations = null;
    private Map<XsdTag, Restriction> restrictions = new HashMap<XsdTag, Restriction>();

    public SimpleType(String name) {
        super(name);
    }

    public InternalType getBaseType() {
        return this.baseType;
    }

    public void setBaseType(InternalType baseType) {
        this.baseType = baseType;
    }

    public List<String> getEnumerations() {
        return this.enumerations;
    }

    public void addRestriction(XsdTag tag, String value) throws XsdException {
        this.validateRestriction(tag, value);
        if (tag == XsdTag.xsd_enumeration) {
            if (this.enumerations == null) {
                this.enumerations = new ArrayList<String>();
            }
            this.enumerations.add(value);
        } else {
            this.restrictions.put(tag, new Restriction(tag, value));
        }
    }

    public String getRestrictionValue(XsdTag tag) {
        Restriction restriction = this.restrictions.get((Object)tag);
        if (restriction == null) {
            return null;
        }
        return restriction.getValue();
    }

    public void validateRestriction(XsdTag tag, String value) throws XsdException {
        try {
            switch (tag) {
                case xsd_enumeration: {
                    break;
                }
                case xsd_pattern: {
                    break;
                }
                case xsd_maxLength: 
                case xsd_length: {
                    Long.parseLong(value);
                    if (!this.baseType.isNumeric()) break;
                    throw new XsdException("Failed to validate restriction '" + String.valueOf((Object)tag) + "' for simple type '" + this.getName() + "'. Cause: length restriction allowed for string types only.");
                }
                case xsd_totalDigits: 
                case xsd_fractionDigits: 
                case xsd_minExclusive: 
                case xsd_maxExclusive: 
                case xsd_minInclusive: 
                case xsd_maxInclusive: {
                    new BigDecimal(value);
                    if (!this.baseType.isNumeric()) {
                        throw new XsdException("Failed to validate restriction '" + String.valueOf((Object)tag) + "' for simple type '" + this.getName() + "'. Cause: restriction allowed for numeric types only.");
                    }
                    if (tag != XsdTag.xsd_fractionDigits || this.baseType.getType() == InternalType.XsdType.decimal || this.baseType.getType() == InternalType.XsdType.doubleType || this.baseType.getType() == InternalType.XsdType.floatType) break;
                    throw new XsdException("Failed to validate restriction '" + String.valueOf((Object)tag) + "' for simple type '" + this.getName() + "'. Cause: fractionDigits allowed for decimal,double or float types only.");
                }
            }
        }
        catch (NumberFormatException exception) {
            throw new XsdException("Failed to validate restriction '" + String.valueOf((Object)tag) + "' for simple type '" + this.getName() + "'. Cause: " + exception.getMessage());
        }
    }

    @Override
    public String getEdlTypeName(XsdSchema schema, boolean isSimpleTypeAsString) throws XsdException {
        Object edlTypeName = this.baseType.getEdlTypeName(schema, isSimpleTypeAsString);
        if (!isSimpleTypeAsString && this.baseType.isNumeric()) {
            String precision = this.getRestrictionValue(XsdTag.xsd_totalDigits);
            String scale = this.getRestrictionValue(XsdTag.xsd_fractionDigits);
            if (precision != null || scale != null) {
                if (precision == null) {
                    precision = "0";
                }
                if (scale == null) {
                    scale = "0";
                }
                edlTypeName = (String)edlTypeName + "(" + precision;
                if (!scale.equals("0")) {
                    edlTypeName = (String)edlTypeName + ", " + scale;
                }
                edlTypeName = (String)edlTypeName + ")";
            }
        }
        return edlTypeName;
    }

    @Override
    public String getEdlRestrictions(XsdSchema schema, boolean isSimpleTypeAsString) throws XsdException {
        String pattern;
        StringBuilder builder = new StringBuilder();
        String length = this.getRestrictionValue(XsdTag.xsd_maxLength);
        if (length != null) {
            builder.append("length ").append(length);
        } else {
            length = this.getRestrictionValue(XsdTag.xsd_length);
            if (length != null) {
                builder.append("length ").append(length);
            }
        }
        if (this.enumerations != null && this.enumerations.size() > 0) {
            InternalType typeForEscape = this.baseType;
            if (isSimpleTypeAsString) {
                typeForEscape = InternalType.createType("xsd:string");
            }
            builder.append(" in domain (");
            for (String enumValue : this.enumerations) {
                builder.append(typeForEscape.escapeValue(enumValue)).append(", ");
            }
            builder.setLength(builder.length() - 2);
            builder.append(")");
        }
        if (!isSimpleTypeAsString) {
            String max;
            String min = this.getRestrictionValue(XsdTag.xsd_minInclusive);
            if (min == null) {
                min = this.getRestrictionValue(XsdTag.xsd_minExclusive);
            }
            if ((max = this.getRestrictionValue(XsdTag.xsd_maxInclusive)) == null) {
                max = this.getRestrictionValue(XsdTag.xsd_maxExclusive);
            }
            if (min != null || max != null) {
                if (min == null) {
                    min = this.baseType.getMinValue();
                }
                if (max == null) {
                    max = this.baseType.getMaxValue();
                }
                builder.append(" in range(").append(min).append(" ").append(max).append(")");
            }
        }
        if ((pattern = this.getRestrictionValue(XsdTag.xsd_pattern)) != null) {
            builder.append(" matches ('").append(ScriptParser.escapeQuotes(pattern)).append("')");
        }
        return builder.length() > 0 ? builder.toString().trim() : null;
    }

    public static class Restriction {
        private XsdTag tag;
        private String value;

        private Restriction(XsdTag tag, String value) {
            this.tag = tag;
            this.value = value;
        }

        public XsdTag getTag() {
            return this.tag;
        }

        public String getValue() {
            return this.value;
        }
    }
}

