/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.xsd;

import com.fasterxml.jackson.databind.JsonNode;
import com.streamscape.omf.json.JSONSerializerFactory;
import com.streamscape.omf.xsd.AbstractParser;
import com.streamscape.omf.xsd.ComplexType;
import com.streamscape.omf.xsd.EDLType;
import com.streamscape.omf.xsd.InternalType;
import com.streamscape.omf.xsd.XsdElement;
import com.streamscape.omf.xsd.XsdException;
import com.streamscape.omf.xsd.XsdSchema;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;

public class JsonParser
extends AbstractParser {
    private Stack<String> jsonPathStack = new Stack();

    @Override
    protected XsdSchema onParse(Reader in, Map<String, String> typesMap, Map<String, String> aliasesMap) throws XsdException {
        JsonNode root;
        try {
            root = JSONSerializerFactory.getInstance().getDefaultEmptyMapper().readTree(in);
        }
        catch (Exception exception) {
            throw new XsdException("Failed to parse json data. Cause: " + exception.getMessage());
        }
        this.jsonPathStack = new Stack();
        this.schema = new XsdSchema();
        if (!root.isObject() && !root.isArray()) {
            throw new XsdException("Top element should be an object or an array.");
        }
        if (root.isArray()) {
            if (this.getTypeName(typesMap) == null) {
                throw new XsdException("Type of wrapper using AS modifier should be specified for JSON that represents array.");
            }
        } else if (this.getTypeName(typesMap) == null && root.size() != 1) {
            throw new XsdException("If top element represents an object then this object should consist of single element or typename for // should be defined.");
        }
        this.parse(root, null, typesMap, aliasesMap);
        return this.schema;
    }

    private void parse(JsonNode root, XsdElement ownerElement, Map<String, String> typesMap, Map<String, String> aliasesMap) throws XsdException {
        if (root.isObject()) {
            this.parseObject(root, ownerElement, typesMap, aliasesMap);
        } else if (root.isArray()) {
            if (this.jsonPathStack.size() == 0) {
                this.parseRootArray(root, typesMap, aliasesMap);
            } else {
                this.parseArray(root, ownerElement, typesMap, aliasesMap);
            }
        } else if (root.isTextual() || root.isNumber() || root.isNull() || root.isBoolean()) {
            this.parsePrimitives(root, ownerElement, typesMap);
        } else {
            throw new XsdException("Internal error. Unknown json node type '" + String.valueOf((Object)root.getNodeType()) + "'.");
        }
    }

    private void parseObject(JsonNode root, XsdElement ownerElement, Map<String, String> typesMap, Map<String, String> aliasesMap) throws XsdException {
        boolean needToPop = false;
        String objectTypeName = this.getTypeName(typesMap);
        boolean suppressGenericType = false;
        if (objectTypeName == null && root.size() != 1) {
            objectTypeName = "map";
        }
        if (objectTypeName == null) {
            Iterator<Map.Entry<String, JsonNode>> iterator = root.fields();
            iterator.hasNext();
            Map.Entry<String, JsonNode> entry = iterator.next();
            objectTypeName = entry.getKey();
            root = entry.getValue();
            if (ownerElement == null) {
                this.jsonPathStack.push(entry.getKey());
                needToPop = true;
            }
        } else {
            suppressGenericType = true;
        }
        ComplexType objectElementType = new ComplexType(objectTypeName);
        objectElementType.setSuppressGenericType(suppressGenericType);
        XsdElement objectElement = new XsdElement(objectTypeName);
        objectElement.setType(objectElementType);
        objectElement.setAlias(this.resolveAlias(aliasesMap, objectElement.getName()));
        if (!this.schema.existsType(objectTypeName)) {
            this.schema.addElement(objectElement);
        }
        if (ownerElement != null) {
            objectElement.setIsGlobal(false);
            ownerElement.setType(objectElement.getType());
        }
        if (root.isObject()) {
            Iterator<Map.Entry<String, JsonNode>> fields = root.fields();
            while (fields.hasNext()) {
                Map.Entry<String, JsonNode> entry = fields.next();
                XsdElement fieldElement = new XsdElement(entry.getKey());
                fieldElement.setIsGlobal(false);
                ((ComplexType)objectElement.getType()).addElement(fieldElement);
                this.jsonPathStack.push(entry.getKey());
                fieldElement.setAlias(this.resolveAlias(aliasesMap, fieldElement.getName()));
                JsonNode value = this.onBeforeParse(entry.getKey(), entry.getValue(), this.getElementPath(), typesMap);
                this.parse(value, fieldElement, typesMap, aliasesMap);
                this.jsonPathStack.pop();
            }
        } else {
            throw new XsdException("Unexpected json element at path '" + this.getElementPath() + "' should be an object or type of parent element should be specified or set to map.");
        }
        if (needToPop) {
            this.jsonPathStack.pop();
        }
    }

    private void parseRootArray(JsonNode root, Map<String, String> typesMap, Map<String, String> aliasesMap) throws XsdException {
        String arrayWrapperTypeName = this.getTypeName(typesMap);
        String entriesName = "entries";
        int slashPos = arrayWrapperTypeName.indexOf("/");
        if (slashPos != -1) {
            entriesName = arrayWrapperTypeName.substring(slashPos + 1);
            arrayWrapperTypeName = arrayWrapperTypeName.substring(0, slashPos);
        }
        ComplexType objectElementType = new ComplexType(arrayWrapperTypeName);
        objectElementType.setSuppressGenericType(true);
        XsdElement objectElement = new XsdElement(arrayWrapperTypeName);
        objectElement.setType(objectElementType);
        objectElement.setAlias(this.resolveAlias(aliasesMap, objectElement.getName()));
        this.schema.addElement(objectElement);
        XsdElement fieldElement = new XsdElement(entriesName);
        fieldElement.setIsGlobal(false);
        ((ComplexType)objectElement.getType()).addElement(fieldElement);
        this.jsonPathStack.push(entriesName);
        fieldElement.setAlias(this.resolveAlias(aliasesMap, fieldElement.getName()));
        this.parse(root, fieldElement, typesMap, aliasesMap);
        ((ComplexType)fieldElement.getType()).setImplicit(true);
        this.jsonPathStack.pop();
    }

    private void parseArray(JsonNode root, XsdElement ownerElement, Map<String, String> typesMap, Map<String, String> aliasesMap) throws XsdException {
        String typeName = this.getTypeName(typesMap);
        if (root.size() < 1 && typeName == null) {
            throw new XsdException("Json array at path '" + this.getElementPath() + "' should have at least one element or type for this element should be defined.");
        }
        if (root.size() < 1) {
            if (TypeFactory.getBaseType(typeName) != null) {
                ownerElement.setType(EDLType.createType(typeName));
            } else {
                ownerElement.setType(new ComplexType(typeName));
            }
        } else {
            this.parse(root.get(0), ownerElement, typesMap, aliasesMap);
        }
        XsdElement xsdElement = new XsdElement("element");
        xsdElement.setType(ownerElement.getType());
        xsdElement.setAlias(this.resolveAlias(aliasesMap, xsdElement.getName()));
        xsdElement.setMaxOccurs(-1);
        ComplexType elementType = new ComplexType(ownerElement.getType().getName() + "_ARRAY");
        elementType.setIsList(true);
        elementType.addElement(xsdElement);
        if (ownerElement.getType() instanceof ComplexType) {
            elementType.setSuppressGenericType(((ComplexType)ownerElement.getType()).isSuppressGenericType());
        }
        ownerElement.setType(elementType);
    }

    private void parsePrimitives(JsonNode root, XsdElement ownerElement, Map<String, String> typesMap) throws XsdException {
        String defaultValue = null;
        if (!root.isNull()) {
            defaultValue = root.asText();
        }
        ownerElement.setDefaultValue(defaultValue);
        String typeName = this.getTypeName(typesMap);
        if (typeName == null) {
            typeName = "xs:string";
            if (root.isNumber()) {
                Class typeClass = Integer.class;
                switch (root.numberType()) {
                    case INT: {
                        typeClass = Integer.class;
                        break;
                    }
                    case LONG: {
                        typeClass = Long.class;
                        break;
                    }
                    case BIG_INTEGER: {
                        typeClass = BigInteger.class;
                        break;
                    }
                    case FLOAT: {
                        typeClass = Float.class;
                        break;
                    }
                    case DOUBLE: {
                        typeClass = Double.class;
                        break;
                    }
                    case BIG_DECIMAL: {
                        typeClass = BigDecimal.class;
                    }
                }
                typeName = InternalType.convertToXsdType(TypeFactory.resolveBasicType(typeClass).getName());
            } else if (root.isBoolean()) {
                typeName = InternalType.convertToXsdType(TypeFactory.resolveBasicType(Boolean.class).getName());
            }
            ownerElement.setType(InternalType.createType(typeName));
        } else {
            ownerElement.setType(EDLType.createType(typeName));
        }
    }

    protected JsonNode onBeforeParse(String key, JsonNode value, String path, Map<String, String> typesMap) {
        return value;
    }

    protected String getElementPath() {
        if (this.jsonPathStack.size() == 0) {
            return "//";
        }
        StringBuilder path = new StringBuilder("/");
        for (int i = 0; i < this.jsonPathStack.size(); ++i) {
            String fragment = (String)this.jsonPathStack.get(i);
            if (fragment == null || fragment.length() <= 0) continue;
            path.append("/").append(fragment);
        }
        return path.toString();
    }

    protected String getTypeName(Map<String, String> typesMap) {
        if (typesMap == null) {
            return null;
        }
        return typesMap.get(this.getElementPath());
    }

    protected String getAlias(Map<String, String> aliasMap) {
        if (aliasMap == null) {
            return null;
        }
        return aliasMap.get(this.getElementPath());
    }

    protected String resolveAlias(Map<String, String> aliasMap, String name) {
        return JsonParser.resolveAlias(this.getAlias(aliasMap), name);
    }
}

