/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.xsd;

import com.streamscape.omf.xsd.Type;
import com.streamscape.omf.xsd.XsdException;
import com.streamscape.omf.xsd.XsdSchema;
import com.streamscape.sef.evtrigger.function.types.Types;
import com.streamscape.slex.lang.ScriptParser;
import java.util.HashMap;
import java.util.Map;

public class InternalType
extends Type {
    private XsdType type;
    private String edlType;
    private boolean isNumeric;
    private static Map<String, InternalType> types = new HashMap<String, InternalType>();

    private static void registerType(String name, XsdType type, String edlType, boolean isNumeric) {
        types.put(name, new InternalType(name, type, edlType, isNumeric));
    }

    private InternalType(String name, XsdType type, String edlType, boolean isNumeric) {
        super(name);
        this.type = type;
        this.edlType = edlType;
        this.isNumeric = isNumeric;
    }

    public XsdType getType() {
        return this.type;
    }

    @Override
    public String getEdlTypeName(XsdSchema schema, boolean isSimpleTypeAsString) throws XsdException {
        return isSimpleTypeAsString ? "string" : this.edlType;
    }

    public static InternalType createType(String typeName) throws XsdException {
        int pos = 0;
        if (typeName.startsWith("xsd:")) {
            pos = 4;
        } else if (typeName.startsWith("xs:")) {
            pos = 3;
        } else {
            return null;
        }
        InternalType result = types.get(typeName.substring(pos));
        if (result == null) {
            throw new XsdException("Unknown XSD type '" + typeName + "'.");
        }
        return result;
    }

    public static String convertToXsdType(String type) {
        if (type == null || type.length() == 0) {
            return type;
        }
        if (type.startsWith("xs:") || type.startsWith("xsd:")) {
            return type;
        }
        if (type.equalsIgnoreCase(Types.BYTE.getName())) {
            return "xs:byte";
        }
        if (type.equalsIgnoreCase(Types.SHORT.getName())) {
            return "xs:short";
        }
        if (type.equalsIgnoreCase(Types.INT.getName())) {
            return "xs:integer";
        }
        if (type.equalsIgnoreCase(Types.INT.getAlias())) {
            return "xs:integer";
        }
        if (type.equalsIgnoreCase(Types.FLOAT.getName())) {
            return "xs:float";
        }
        if (type.equalsIgnoreCase(Types.LONG.getName())) {
            return "xs:long";
        }
        if (type.equalsIgnoreCase(Types.DOUBLE.getName())) {
            return "xs:double";
        }
        if (type.equalsIgnoreCase(Types.BIGDECIMAL.getName())) {
            return "xs:decimal";
        }
        if (type.equalsIgnoreCase(Types.BIGINT.getName())) {
            return "xs:bigint";
        }
        if (type.equalsIgnoreCase(Types.BIGINT.getAlias())) {
            return "xs:bigint";
        }
        if (type.equalsIgnoreCase(Types.BOOLEAN.getName())) {
            return "xs:boolean";
        }
        if (type.equalsIgnoreCase(Types.STRING.getName())) {
            return "xs:string";
        }
        if (type.equalsIgnoreCase(Types.DATE.getName())) {
            return "xs:string";
        }
        if (type.equalsIgnoreCase(Types.SQL_DATE.getName())) {
            return "xs:string";
        }
        if (type.equalsIgnoreCase(Types.SQL_TIMESTAMP.getName())) {
            return "xs:string";
        }
        return type;
    }

    public boolean isNumeric() {
        return this.isNumeric;
    }

    public String getMinValue() throws XsdException {
        if (!this.isNumeric()) {
            throw new XsdException("get min value allowed for numeric types only.");
        }
        switch (this.type.ordinal()) {
            case 0: {
                return Byte.toString((byte)-128);
            }
            case 1: {
                return Long.toString(Long.MIN_VALUE);
            }
            case 3: {
                return Integer.toString(Integer.MIN_VALUE);
            }
            case 4: {
                return Integer.toString(Integer.MIN_VALUE);
            }
            case 5: {
                return Long.toString(Long.MIN_VALUE);
            }
            case 6: {
                return Integer.toString(Integer.MIN_VALUE);
            }
            case 7: {
                return "0";
            }
            case 8: {
                return Integer.toString(Integer.MIN_VALUE);
            }
            case 9: {
                return "1";
            }
            case 10: {
                return Short.toString((short)Short.MIN_VALUE);
            }
            case 11: {
                return "0";
            }
            case 12: {
                return "0";
            }
            case 13: {
                return "0";
            }
            case 14: {
                return "0";
            }
            case 18: {
                return Double.toString(Double.MIN_VALUE);
            }
            case 19: {
                return Float.toString(Float.MIN_VALUE);
            }
            case 15: {
                throw new XsdException("get min value not allowed for boolean type.");
            }
        }
        throw new XsdException("get min value not allowed for type '" + String.valueOf((Object)this.type) + "'.");
    }

    public String getMaxValue() throws XsdException {
        if (!this.isNumeric()) {
            throw new XsdException("get max value allowed for numeric types only.");
        }
        switch (this.type.ordinal()) {
            case 0: {
                return Byte.toString((byte)127);
            }
            case 1: {
                return Long.toString(Long.MAX_VALUE);
            }
            case 3: {
                return Integer.toString(Integer.MAX_VALUE);
            }
            case 4: {
                return Integer.toString(Integer.MAX_VALUE);
            }
            case 5: {
                return Long.toString(Long.MAX_VALUE);
            }
            case 6: {
                return Integer.toString(-1);
            }
            case 7: {
                return Integer.toString(Integer.MAX_VALUE);
            }
            case 8: {
                return Integer.toString(Integer.MAX_VALUE);
            }
            case 9: {
                return Integer.toString(Integer.MAX_VALUE);
            }
            case 10: {
                return Short.toString((short)Short.MAX_VALUE);
            }
            case 11: {
                return Long.toString(Long.MAX_VALUE);
            }
            case 12: {
                return Integer.toString(Integer.MAX_VALUE);
            }
            case 13: {
                return Short.toString((short)Short.MAX_VALUE);
            }
            case 14: {
                return Byte.toString((byte)127);
            }
            case 18: {
                return Double.toString(Double.MAX_VALUE);
            }
            case 19: {
                return Float.toString(Float.MAX_VALUE);
            }
            case 15: {
                throw new XsdException("get max value not allowed for boolean type.");
            }
        }
        throw new XsdException("get max value not allowed for  type '" + String.valueOf((Object)this.type) + "'.");
    }

    public String escapeValue(String enumValue) {
        if (this.isNumeric()) {
            return enumValue;
        }
        return "'" + ScriptParser.escapeQuotes(enumValue) + "'";
    }

    static {
        InternalType.registerType("unsignedInt", XsdType.unsignedInt, Types.LONG.getName(), true);
        InternalType.registerType("byte", XsdType.byteType, Types.BYTE.getName(), true);
        InternalType.registerType("short", XsdType.shortType, Types.SHORT.getName(), true);
        InternalType.registerType("int", XsdType.intType, Types.INT.getName(), true);
        InternalType.registerType("integer", XsdType.integer, Types.INT.getName(), true);
        InternalType.registerType("long", XsdType.longType, Types.LONG.getName(), true);
        InternalType.registerType("decimal", XsdType.decimal, Types.BIGDECIMAL.getName(), true);
        InternalType.registerType("bigint", XsdType.bigint, Types.BIGINT.getName(), true);
        InternalType.registerType("negativeInteger", XsdType.negativeInteger, Types.LONG.getName(), true);
        InternalType.registerType("nonNegativeInteger", XsdType.nonNegativeInteger, Types.LONG.getName(), true);
        InternalType.registerType("nonPositiveInteger", XsdType.nonPositiveInteger, Types.LONG.getName(), true);
        InternalType.registerType("positiveInteger", XsdType.positiveInteger, Types.LONG.getName(), true);
        InternalType.registerType("unsignedLong", XsdType.unsignedLong, Types.BIGINT.getName(), true);
        InternalType.registerType("unsignedShort", XsdType.unsignedShort, Types.INT.getName(), true);
        InternalType.registerType("unsignedByte", XsdType.unsignedByte, Types.SHORT.getName(), true);
        InternalType.registerType("boolean", XsdType.booleanType, Types.BOOLEAN.getName(), true);
        InternalType.registerType("anyURI", XsdType.anyURI, Types.STRING.getName(), false);
        InternalType.registerType("base64Binary", XsdType.base64Binary, Types.STRING.getName(), false);
        InternalType.registerType("double", XsdType.doubleType, Types.DOUBLE.getName(), true);
        InternalType.registerType("float", XsdType.floatType, Types.FLOAT.getName(), true);
        InternalType.registerType("hexBinary", XsdType.hexBinary, Types.STRING.getName(), false);
        InternalType.registerType("NOTATION", XsdType.NOTATION, Types.STRING.getName(), false);
        InternalType.registerType("QName", XsdType.QName, Types.STRING.getName(), false);
        InternalType.registerType("string", XsdType.string, Types.STRING.getName(), false);
        InternalType.registerType("NMTOKEN", XsdType.NMTOKEN, Types.STRING.getName(), false);
        InternalType.registerType("ENTITIES", XsdType.ENTITIES, Types.STRING.getName(), false);
        InternalType.registerType("ENTITY", XsdType.ENTITY, Types.STRING.getName(), false);
        InternalType.registerType("ID", XsdType.ID, Types.STRING.getName(), false);
        InternalType.registerType("IDREF", XsdType.IDREF, Types.STRING.getName(), false);
        InternalType.registerType("IDREFS", XsdType.IDREFS, Types.STRING.getName(), false);
        InternalType.registerType("language", XsdType.language, Types.STRING.getName(), false);
        InternalType.registerType("Name", XsdType.Name, Types.STRING.getName(), false);
        InternalType.registerType("NCName", XsdType.NCName, Types.STRING.getName(), false);
        InternalType.registerType("NMTOKENS", XsdType.NMTOKENS, Types.STRING.getName(), false);
        InternalType.registerType("normalizedString", XsdType.normalizedString, Types.STRING.getName(), false);
        InternalType.registerType("token", XsdType.token, Types.STRING.getName(), false);
        InternalType.registerType("date", XsdType.date, Types.STRING.getName(), false);
        InternalType.registerType("dateTime", XsdType.dateTime, Types.STRING.getName(), false);
        InternalType.registerType("duration", XsdType.duration, Types.STRING.getName(), false);
        InternalType.registerType("gDay", XsdType.gDay, Types.STRING.getName(), false);
        InternalType.registerType("gMonth", XsdType.gMonth, Types.STRING.getName(), false);
        InternalType.registerType("gMonthDay", XsdType.gMonthDay, Types.STRING.getName(), false);
        InternalType.registerType("gYear", XsdType.gYear, Types.STRING.getName(), false);
        InternalType.registerType("gYearMonth", XsdType.gYearMonth, Types.STRING.getName(), false);
        InternalType.registerType("time", XsdType.time, Types.STRING.getName(), false);
    }

    public static enum XsdType {
        byteType,
        decimal,
        bigint,
        intType,
        integer,
        longType,
        negativeInteger,
        nonNegativeInteger,
        nonPositiveInteger,
        positiveInteger,
        shortType,
        unsignedLong,
        unsignedInt,
        unsignedShort,
        unsignedByte,
        booleanType,
        anyURI,
        base64Binary,
        doubleType,
        floatType,
        hexBinary,
        NOTATION,
        QName,
        ENTITIES,
        ENTITY,
        ID,
        IDREF,
        IDREFS,
        language,
        Name,
        NCName,
        NMTOKEN,
        NMTOKENS,
        normalizedString,
        string,
        token,
        date,
        dateTime,
        duration,
        gDay,
        gMonth,
        gMonthDay,
        gYear,
        gYearMonth,
        time;

    }
}

