/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.xsd;

import com.streamscape.lib.utils.OrderedMap;
import com.streamscape.omf.xsd.ComplexType;
import com.streamscape.omf.xsd.EDLType;
import com.streamscape.omf.xsd.InternalType;
import com.streamscape.omf.xsd.Parser;
import com.streamscape.omf.xsd.SimpleType;
import com.streamscape.omf.xsd.Type;
import com.streamscape.omf.xsd.XsdElement;
import com.streamscape.omf.xsd.XsdException;
import com.streamscape.omf.xsd.XsdSchema;
import com.streamscape.runtime.mf.operation.edl.javadoc.JavaDoc;
import com.streamscape.runtime.mf.operation.edl.javadoc.JavaDocSourceCodeFormatter;
import com.streamscape.slex.lang.ScriptParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Map;

public class EdlGenerator {
    private String namespace = "EDL.GENERATOR.DEFAULT.NAMESPACE";
    private String archiveName = "EDL_GENERATOR_DEFAULT_ARCHIVE.jar";
    private String packageName = "EDL_GENERATOR_DEFAULT_PACKAGE";
    private boolean addArchive = false;
    private boolean addPackage = false;
    private String ancestor = null;
    private boolean isInterface = false;
    private String description = null;
    private boolean noSource = false;
    private boolean noType = false;
    private boolean noDoc = false;
    private boolean simpleTypesAsString = false;
    private boolean withDefaults = false;
    private boolean withWait = false;
    private Parser parser;
    private Map<String, String> typesMap;
    private Map<String, String> aliasesMap;

    public EdlGenerator(boolean withWait) {
        this.withWait = withWait;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getArchiveName() {
        return this.archiveName;
    }

    public void setArchiveName(String archiveName) {
        this.archiveName = archiveName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public boolean isAddArchive() {
        return this.addArchive;
    }

    public boolean isReplaceArchive() {
        return !this.addArchive;
    }

    public void setAddArchive() {
        this.addArchive = true;
    }

    public void setAddArchive(boolean addArchive) {
        this.addArchive = addArchive;
    }

    public void setReplaceArchive() {
        this.addArchive = false;
    }

    public boolean isAddPackage() {
        return this.addPackage;
    }

    public boolean isReplacePackage() {
        return !this.addPackage;
    }

    public void setAddPackage() {
        this.addPackage = true;
    }

    public void setAddPackage(boolean addPackage) {
        this.addPackage = addPackage;
    }

    public void setReplacePackage() {
        this.addPackage = false;
    }

    public String getAncestor() {
        return this.ancestor;
    }

    public void setAncestor(String ancestor) {
        this.ancestor = ancestor;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public void setInterface(boolean isInterface) {
        this.isInterface = isInterface;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isNoSource() {
        return this.noSource;
    }

    public void setNoSource(boolean noSource) {
        this.noSource = noSource;
    }

    public boolean isNoType() {
        return this.noType;
    }

    public void setNoType(boolean noType) {
        this.noType = noType;
    }

    public boolean isNoDoc() {
        return this.noDoc;
    }

    public void setNoDoc(boolean noDoc) {
        this.noDoc = noDoc;
    }

    public boolean isSimpleTypesAsString() {
        return this.simpleTypesAsString;
    }

    public void setSimpleTypesAsString(boolean simpleTypesAsString) {
        this.simpleTypesAsString = simpleTypesAsString;
    }

    public void setWithDefaults(boolean withDefaults) {
        this.withDefaults = withDefaults;
    }

    public boolean isWithWait() {
        return this.withWait;
    }

    public void setWithWait(boolean withWait) {
        this.withWait = withWait;
    }

    public void setParser(Parser parser) {
        this.parser = parser;
    }

    public void setTypesMap(Map<String, String> typesMap) {
        this.typesMap = typesMap;
    }

    public Map<String, String> getTypesMap() {
        return this.typesMap;
    }

    public Map<String, String> getAliasesMap() {
        return this.aliasesMap;
    }

    public void setAliasesMap(Map<String, String> aliasesMap) {
        this.aliasesMap = aliasesMap;
    }

    public synchronized Map<String, String> generateEdl(String fileName) throws XsdException {
        try {
            return this.generateEdl(new FileInputStream(new File(fileName)));
        }
        catch (FileNotFoundException exception) {
            throw new XsdException("File '" + fileName + "' does not exist.");
        }
    }

    public synchronized Map<String, String> generateEdl(InputStream input) throws XsdException {
        XsdSchema schema = this.parser.parse(input, this.typesMap, this.aliasesMap);
        schema.detectListsAndImplicitLists();
        schema.sortElements();
        return this.generateEdl(schema);
    }

    public void generateEdl(StringBuilder builder, XsdSchema schema) throws XsdException {
        for (String edl : this.generateEdl(schema).values()) {
            builder.append(edl).append("\n\n");
        }
    }

    public Map<String, String> generateEdl(XsdSchema schema) throws XsdException {
        OrderedMap<String, String> edls = new OrderedMap<String, String>();
        for (XsdElement element : schema.getElements()) {
            String edl = this.generateEdl(schema, element);
            if (edl == null || edl.length() <= 0) continue;
            String name = element.getType() != null && element.getType() instanceof ComplexType ? element.getType().getName() : element.getName();
            edls.put(name, edl);
        }
        return edls;
    }

    private String generateEdl(XsdSchema schema, XsdElement element) throws XsdException {
        if (element.getName() == null) {
            throw new XsdException("XSD element name is null.");
        }
        if (element.getType() == null) {
            throw new XsdException("XSD element '" + element.getName() + "' type should be not null.");
        }
        if (element.getName().equalsIgnoreCase("map")) {
            return "";
        }
        if (!(element.getType() instanceof ComplexType)) {
            return "";
        }
        ComplexType complexType = (ComplexType)element.getType();
        if (complexType.isList()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        if (element.getDocumentation() != null) {
            builder.append(new JavaDoc.Builder().appendUnformattedJavaDoc(element.getDocumentation().trim()).build().format(new JavaDocSourceCodeFormatter())).append("\n");
        }
        builder.append("create ");
        if (complexType.isChoice()) {
            builder.append("choice ");
        } else {
            builder.append("sdo ");
        }
        builder.append(complexType.getName()).append("\n");
        builder.append("as\n{\n");
        for (XsdElement typeElement : complexType.getElementsAll()) {
            this.appendField(schema, builder, "   ", typeElement);
            builder.append(";\n");
        }
        builder.append("}\n");
        builder.append("namespace " + this.namespace).append("\n");
        if (this.addArchive) {
            builder.append("add ");
        } else {
            builder.append("replace ");
        }
        builder.append("archive " + this.archiveName).append("\n");
        if (this.addPackage) {
            builder.append("add ");
        } else {
            builder.append("replace ");
        }
        builder.append("package " + this.packageName).append("\n");
        if (this.ancestor != null) {
            builder.append("ancestor ").append(this.ancestor).append("\n");
        }
        if (this.isInterface) {
            builder.append("interface true\n");
        }
        if (this.description != null) {
            builder.append("description '").append(this.description).append("'\n");
        }
        if (this.noSource) {
            builder.append("no source\n");
        }
        if (this.noType) {
            builder.append("no type\n");
        }
        if (this.noDoc) {
            builder.append("no doc\n");
        }
        if (this.withWait) {
            builder.append("with wait\n");
        }
        return builder.toString();
    }

    private void appendField(XsdSchema schema, StringBuilder builder, String idention, XsdElement field) throws XsdException {
        String restrictions;
        if (field.getName() == null) {
            throw new XsdException("XSD element name is null.");
        }
        if (field.isGlobal()) {
            throw new XsdException("XSD element '" + field.getName() + "' should be not global.");
        }
        if (field.getType() == null) {
            throw new XsdException("XSD element '" + field.getName() + "' type should be not null.");
        }
        String name = field.getAlias() != null ? field.getAlias() : field.getName();
        String alias = field.getAlias() != null ? field.getName() : field.getAlias();
        builder.append(idention);
        builder.append(field.getType().getEdlTypeName(schema, this.isSimpleTypesAsString()));
        if (field.isXmlAttribute()) {
            builder.append("(xml-attribute)");
        }
        builder.append(" ").append(name);
        if (this.withDefaults && field.getDefaultValue() != null) {
            Type fieldType = field.getType();
            String defaultValue = field.getDefaultValue();
            if (this.isSimpleTypesAsString()) {
                defaultValue = InternalType.createType("xsd:string").escapeValue(defaultValue);
            }
            if ((defaultValue = fieldType instanceof SimpleType ? ((SimpleType)fieldType).getBaseType().escapeValue(defaultValue) : (fieldType instanceof InternalType ? ((InternalType)fieldType).escapeValue(defaultValue) : (fieldType instanceof EDLType ? ((EDLType)fieldType).getEdlType().escapeValue(defaultValue) : null))) != null) {
                builder.append(" = ").append(defaultValue);
            }
        }
        if (field.getMinOccurs() != 0) {
            builder.append(" not null");
        }
        if ((restrictions = field.getType().getEdlRestrictions(schema, this.isSimpleTypesAsString())) != null) {
            builder.append(" ").append(restrictions);
        }
        if (alias != null) {
            builder.append(" alias '").append(alias).append("'");
        }
        if (field.getDocumentation() != null) {
            builder.append(" description '").append(ScriptParser.escapeQuotes(field.getDocumentation()).trim()).append("'");
        }
    }
}

