/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.xsd;

import com.streamscape.omf.xsd.SimpleType;
import com.streamscape.omf.xsd.Type;
import com.streamscape.omf.xsd.XsdElement;
import com.streamscape.omf.xsd.XsdException;
import com.streamscape.omf.xsd.XsdSchema;
import java.util.ArrayList;
import java.util.List;

public class ComplexType
extends Type {
    private List<XsdElement> elements = new ArrayList<XsdElement>();
    private String baseTypeName;
    private ComplexType baseType = null;
    private boolean isList;
    private boolean isChoice = false;
    private boolean suppressGenericType = false;
    private boolean implicit = false;
    private boolean isXmlImplicitCollection = false;

    public ComplexType(String name) {
        super(name);
    }

    public void addElement(XsdElement element) {
        this.elements.add(element);
    }

    public List<XsdElement> getElements() {
        return this.elements;
    }

    public boolean existsElement(String name) {
        for (XsdElement element : this.elements) {
            if (!element.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public List<XsdElement> getElementsAll() throws XsdException {
        if (this.baseTypeName != null && this.baseType == null) {
            throw new XsdException("Base type is not resolved.");
        }
        if (this.baseType != null) {
            ArrayList<XsdElement> result = new ArrayList<XsdElement>();
            result.addAll(this.baseType.getElementsAll());
            result.addAll(this.elements);
            return result;
        }
        return this.elements;
    }

    public String getBaseTypeName() {
        return this.baseTypeName;
    }

    public ComplexType getBaseType() {
        return this.baseType;
    }

    public void setBaseTypeName(String baseTypeName) {
        this.baseTypeName = baseTypeName;
    }

    public void resolveBaseType(XsdSchema schema) throws XsdException {
        if (this.baseType != null) {
            return;
        }
        if (this.baseTypeName == null || this.baseTypeName.length() == 0) {
            return;
        }
        Type type = schema.getType(this.baseTypeName);
        if (!(type instanceof ComplexType)) {
            throw new XsdException("Wrong base type '" + this.baseTypeName + "' for type '" + this.getName() + "'. Only complex types as extensions are supported.");
        }
        this.baseType = (ComplexType)type;
        this.baseType.resolveBaseType(schema);
    }

    public void resolveElementTypes(XsdSchema schema) throws XsdException {
        for (XsdElement element : this.elements) {
            element.resolveType(schema);
        }
    }

    public boolean isList() {
        return this.isList;
    }

    public void setIsList(boolean isList) {
        this.isList = isList;
    }

    @Override
    public String getEdlTypeName(XsdSchema schema, boolean isSimpleTypeAsString) throws XsdException {
        if (this.isList()) {
            if (this.elements.size() != 1) {
                throw new XsdException("ComplexType '" + this.getName() + "' is list and has not one element.");
            }
            XsdElement listElement = this.elements.get(0);
            String type = "list(" + listElement.getType().getEdlTypeName(schema, isSimpleTypeAsString) + " alias " + listElement.getName();
            if (this.isImplicit()) {
                type = type + ", implicit";
            }
            if (this.isXmlImplicitCollection()) {
                type = type + ", xml-implicit-collection";
            }
            if (this.isSuppressGenericType()) {
                type = type + ", json-suppress-generic-type";
            }
            type = type + ")";
            return type;
        }
        if (this.getName().equalsIgnoreCase("map")) {
            if (this.elements != null && this.elements.size() > 0 && this.elements.get(0).getType() != null && this.elements.get(0).getType() instanceof ComplexType && !this.elements.get(0).getType().getName().equalsIgnoreCase("map")) {
                return "map(string, " + this.elements.get(0).getType().getEdlTypeName(schema, isSimpleTypeAsString) + ")";
            }
            return "map(string, object)";
        }
        Type type = schema.getType(this.getName());
        if (type != null && type instanceof SimpleType) {
            return type.getEdlTypeName(schema, isSimpleTypeAsString);
        }
        return this.getName();
    }

    @Override
    public String getEdlRestrictions(XsdSchema schema, boolean isSimpleTypesAsString) throws XsdException {
        if (this.isList()) {
            if (this.elements.size() != 1) {
                throw new XsdException("ComplexType '" + this.getName() + "' is list and has not one element.");
            }
            XsdElement listElement = this.elements.get(0);
            if (listElement.getMaxOccurs() > 0) {
                return "length " + listElement.getMaxOccurs();
            }
        } else {
            Type type = schema.getType(this.getName());
            if (type != null && type instanceof SimpleType) {
                return type.getEdlRestrictions(schema, isSimpleTypesAsString);
            }
        }
        return null;
    }

    public boolean isChoice() {
        return this.isChoice;
    }

    public void setIsChoice(boolean isChoice) {
        this.isChoice = isChoice;
    }

    public boolean isSuppressGenericType() {
        return this.suppressGenericType;
    }

    public void setSuppressGenericType(boolean suppressGenericType) {
        this.suppressGenericType = suppressGenericType;
    }

    public void setImplicit(boolean implicit) {
        this.implicit = implicit;
    }

    public boolean isImplicit() {
        return this.implicit;
    }

    public void setIsXmlImplicitCollection(boolean isXmlImplicitCollection) {
        this.isXmlImplicitCollection = isXmlImplicitCollection;
    }

    public boolean isXmlImplicitCollection() {
        return this.isXmlImplicitCollection;
    }

    public void replace(XsdElement old, XsdElement newElement) {
        for (int i = 0; i < this.elements.size(); ++i) {
            if (this.elements.get(i) != old) continue;
            this.elements.set(i, newElement);
        }
    }
}

