/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.xsd;

import com.streamscape.omf.xsd.Parser;
import com.streamscape.omf.xsd.XsdElement;
import com.streamscape.omf.xsd.XsdException;
import com.streamscape.omf.xsd.XsdSchema;
import com.streamscape.omf.xsd.XsdTag;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Stack;

public abstract class AbstractParser
implements Parser {
    protected XsdSchema schema;
    protected Context context;
    protected Stack<Context> stack = new Stack();

    @Override
    public XsdSchema parse(InputStream input) throws XsdException {
        return this.parse(input, null, null);
    }

    @Override
    public XsdSchema parse(InputStream input, String charset) throws XsdException, UnsupportedEncodingException {
        return this.parse(input, null, null, charset);
    }

    @Override
    public XsdSchema parse(InputStream input, Map<String, String> typesMap, Map<String, String> aliasesMap) throws XsdException {
        return this.onParse(new InputStreamReader(input), typesMap, aliasesMap);
    }

    @Override
    public XsdSchema parse(InputStream input, Map<String, String> typesMap, Map<String, String> aliasesMap, String charset) throws XsdException, UnsupportedEncodingException {
        return this.onParse(new InputStreamReader(input, charset), typesMap, aliasesMap);
    }

    protected abstract XsdSchema onParse(Reader var1, Map<String, String> var2, Map<String, String> var3) throws XsdException;

    public static String resolveAlias(String alias, String name) {
        if (alias != null) {
            return alias;
        }
        alias = AbstractParser.camelCaseName(name);
        if (name.equals(alias)) {
            return null;
        }
        return alias;
    }

    public static String camelCaseName(String name) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            int startI = i;
            char c = name.charAt(i);
            while (i < name.length() && ".-=~*&^%$#@!;,/".indexOf(c) >= 0) {
                c = name.charAt(++i);
            }
            if (i > startI) {
                if (i == name.length()) break;
                builder.append(Character.toUpperCase(c));
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    static class Context {
        XsdTag tag;
        XsdElement element;

        Context(XsdTag tag) {
            this.tag = tag;
        }

        Context(XsdTag tag, XsdElement element) {
            this.tag = tag;
            this.element = element;
        }
    }
}

