/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.xml.xstream.mapper;

import com.streamscape.omf.xml.xstream.mapper.Mapper;
import com.streamscape.omf.xml.xstream.mapper.MapperWrapper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class PackageAliasingMapper
extends MapperWrapper
implements Serializable {
    private static final Comparator REVERSE = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((String)o2).compareTo((String)o1);
        }
    };
    private Map packageToName = new TreeMap(REVERSE);
    protected transient Map nameToPackage = new HashMap();

    public PackageAliasingMapper(Mapper wrapped) {
        super(wrapped);
    }

    public void addPackageAlias(String name, String pkg) {
        if (((String)name).length() > 0 && ((String)name).charAt(((String)name).length() - 1) != '.') {
            name = (String)name + ".";
        }
        if (((String)pkg).length() > 0 && ((String)pkg).charAt(((String)pkg).length() - 1) != '.') {
            pkg = (String)pkg + ".";
        }
        this.nameToPackage.put(name, pkg);
        this.packageToName.put(pkg, name);
    }

    @Override
    public String serializedClass(Class type) {
        String className = type.getName();
        int length = className.length();
        int dot = -1;
        do {
            String pkg;
            String alias;
            if ((alias = (String)this.packageToName.get(pkg = (dot = className.lastIndexOf(46, length)) < 0 ? "" : className.substring(0, dot + 1))) != null) {
                return alias + (dot < 0 ? className : className.substring(dot + 1));
            }
            length = dot - 1;
        } while (dot >= 0);
        return super.serializedClass(type);
    }

    @Override
    public Class realClass(String elementName) {
        int length = ((String)elementName).length();
        int dot = -1;
        do {
            String name;
            String packageName;
            if ((packageName = (String)this.nameToPackage.get(name = (dot = ((String)elementName).lastIndexOf(46, length)) < 0 ? "" : ((String)elementName).substring(0, dot) + ".")) != null) {
                elementName = packageName + (String)(dot < 0 ? elementName : ((String)elementName).substring(dot + 1));
                break;
            }
            length = dot - 1;
        } while (dot >= 0);
        return super.realClass((String)elementName);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(new HashMap(this.packageToName));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.packageToName = new TreeMap(REVERSE);
        this.packageToName.putAll((Map)in.readObject());
        this.nameToPackage = new HashMap();
        for (Object type : this.packageToName.keySet()) {
            this.nameToPackage.put(this.packageToName.get(type), type);
        }
    }
}

