/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.xml.xstream.mapper;

import com.streamscape.omf.xml.xstream.converters.Converter;
import com.streamscape.omf.xml.xstream.converters.SingleValueConverter;
import com.streamscape.omf.xml.xstream.mapper.CannotResolveClassException;
import com.streamscape.omf.xml.xstream.mapper.Mapper;

public class DefaultMapper
implements Mapper {
    private final ClassLoader classLoader;

    public DefaultMapper(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public String serializedClass(Class type) {
        return type.getName();
    }

    @Override
    public Class realClass(String elementName) {
        try {
            if (elementName.charAt(0) != '[') {
                return this.classLoader.loadClass(elementName);
            }
            if (elementName.endsWith(";")) {
                return Class.forName(elementName.toString(), false, this.classLoader);
            }
            return Class.forName(elementName.toString());
        }
        catch (ClassNotFoundException e) {
            throw new CannotResolveClassException(elementName);
        }
    }

    @Override
    public Class defaultImplementationOf(Class type) {
        return type;
    }

    @Override
    public String aliasForAttribute(String attribute) {
        return attribute;
    }

    @Override
    public String attributeForAlias(String alias) {
        return alias;
    }

    @Override
    public String aliasForSystemAttribute(String attribute) {
        return attribute;
    }

    @Override
    public boolean isImmutableValueType(Class type) {
        return false;
    }

    @Override
    public String getFieldNameForItemTypeAndName(Class definedIn, Class itemType, String itemFieldName) {
        return null;
    }

    @Override
    public Class getItemTypeForItemFieldName(Class definedIn, String itemFieldName) {
        return null;
    }

    @Override
    public Mapper.ImplicitCollectionMapping getImplicitCollectionDefForFieldName(Class itemType, String fieldName) {
        return null;
    }

    @Override
    public boolean shouldSerializeMember(Class definedIn, String fieldName) {
        return true;
    }

    public String lookupName(Class type) {
        return this.serializedClass(type);
    }

    public Class lookupType(String elementName) {
        return this.realClass(elementName);
    }

    @Override
    public String serializedMember(Class type, String memberName) {
        return memberName;
    }

    @Override
    public String realMember(Class type, String serialized) {
        return serialized;
    }

    @Override
    public SingleValueConverter getConverterFromItemType(String fieldName, Class type, Class definedIn) {
        return null;
    }

    @Override
    public Converter getLocalConverter(Class definedIn, String fieldName) {
        return null;
    }

    @Override
    public Mapper lookupMapperOfType(Class type) {
        return null;
    }

    @Override
    public SingleValueConverter getConverterFromAttribute(Class definedIn, String attribute, Class type) {
        return null;
    }
}

