/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.xml.xstream.mapper;

import com.streamscape.Trace;
import com.streamscape.omf.FactoryManagerException;
import com.streamscape.omf.serializer.AliasManager;
import com.streamscape.omf.xml.xstream.mapper.Mapper;
import com.streamscape.omf.xml.xstream.mapper.MapperWrapper;
import com.streamscape.runtime.mf.operation.edl.annotations.Alias;

public class ClassAliasingMapper
extends MapperWrapper {
    private transient AliasManager aliasManager = null;

    public ClassAliasingMapper(Mapper wrapped, AliasManager aliasManager) {
        super(wrapped);
        this.aliasManager = aliasManager;
    }

    public void addClassAlias(String name, Class type) {
        try {
            this.aliasManager.alias(name, type);
        }
        catch (FactoryManagerException exception) {
            Trace.logError(this, exception.getMessage());
        }
    }

    @Override
    public String serializedClass(Class type) {
        Alias aliasAnnotation = type.getAnnotation(Alias.class);
        if (aliasAnnotation != null && aliasAnnotation.alias() != null && aliasAnnotation.alias().length() > 0) {
            return aliasAnnotation.alias();
        }
        String alias = this.aliasManager.lookup(type);
        if (alias != null) {
            return alias;
        }
        return super.serializedClass(type);
    }

    @Override
    public Class realClass(String elementName) {
        String mappedName = this.aliasManager.lookup(elementName);
        if (mappedName != null) {
            Class type = this.primitiveClassNamed(mappedName);
            if (type != null) {
                return type;
            }
            elementName = mappedName;
        }
        return super.realClass(elementName);
    }

    public boolean itemTypeAsAttribute(Class clazz) {
        return this.aliasManager.lookup(clazz) != null;
    }

    public boolean aliasIsAttribute(String name) {
        return this.aliasManager.isAliased(name);
    }

    @Override
    public boolean shouldSerializeMember(Class definedIn, String fieldName) {
        return true;
    }

    private Class primitiveClassNamed(String name) {
        return name.equals("void") ? Void.TYPE : (name.equals("boolean") ? Boolean.TYPE : (name.equals("byte") ? Byte.TYPE : (name.equals("char") ? Character.TYPE : (name.equals("short") ? Short.TYPE : (name.equals("int") ? Integer.TYPE : (name.equals("long") ? Long.TYPE : (name.equals("float") ? Float.TYPE : (name.equals("double") ? Double.TYPE : null))))))));
    }
}

