/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.xml.xstream.mapper;

import com.streamscape.omf.xml.xstream.converters.Converter;
import com.streamscape.omf.xml.xstream.converters.ConverterLookup;
import com.streamscape.omf.xml.xstream.converters.SingleValueConverter;
import com.streamscape.omf.xml.xstream.core.util.Fields;
import com.streamscape.omf.xml.xstream.mapper.Mapper;
import com.streamscape.omf.xml.xstream.mapper.MapperWrapper;
import com.streamscape.runtime.mf.operation.edl.annotations.XmlAttribute;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AttributeMapper
extends MapperWrapper {
    private final Map fieldNameToTypeMap = new HashMap();
    private final Set typeSet = new HashSet();
    private ConverterLookup converterLookup;
    private final Set fieldToUseAsAttribute = new HashSet();

    public AttributeMapper(Mapper wrapped, ConverterLookup converterLookup) {
        super(wrapped);
        this.converterLookup = converterLookup;
    }

    public void addAttributeFor(String fieldName, Class type) {
        this.fieldNameToTypeMap.put(fieldName, type);
    }

    public void addAttributeFor(Class type) {
        this.typeSet.add(type);
    }

    private SingleValueConverter getLocalConverterFromItemType(Class type) {
        Converter converter = this.converterLookup.lookupConverterForType(type);
        if (converter != null && converter instanceof SingleValueConverter) {
            return (SingleValueConverter)((Object)converter);
        }
        return null;
    }

    @Override
    public SingleValueConverter getConverterFromItemType(String fieldName, Class type, Class definedIn) {
        SingleValueConverter converter;
        if (this.shouldLookForSingleValueConverter(fieldName, type, definedIn) && (converter = this.getLocalConverterFromItemType(type)) != null) {
            return converter;
        }
        return super.getConverterFromItemType(fieldName, type, definedIn);
    }

    public boolean shouldLookForSingleValueConverter(String fieldName, Class type, Class definedIn) {
        Field field = this.getField(definedIn, fieldName);
        return this.fieldToUseAsAttribute.contains(field) || this.fieldNameToTypeMap.get(fieldName) == type || this.typeSet.contains(type) || field.getAnnotation(XmlAttribute.class) != null;
    }

    @Override
    public SingleValueConverter getConverterFromAttribute(Class definedIn, String attribute, Class type) {
        SingleValueConverter converter;
        if (this.shouldLookForSingleValueConverter(attribute, type, definedIn) && (converter = this.getLocalConverterFromItemType(type)) != null) {
            return converter;
        }
        return super.getConverterFromAttribute(definedIn, attribute, type);
    }

    public void addAttributeFor(Field field) {
        this.fieldToUseAsAttribute.add(field);
    }

    public void addAttributeFor(Class definedIn, String fieldName) {
        this.fieldToUseAsAttribute.add(this.getField(definedIn, fieldName));
    }

    private Field getField(Class definedIn, String fieldName) {
        return Fields.find(definedIn, fieldName);
    }
}

