/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.xml.xstream.io.xml;

import com.streamscape.omf.xml.xstream.converters.reflection.ObjectAccessException;
import com.streamscape.omf.xml.xstream.io.naming.NameCoder;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;

public class XmlFriendlyNameCoder
implements NameCoder,
Cloneable {
    private final String dollarReplacement;
    private final String escapeCharReplacement;
    private transient Map escapeCache;
    private transient Map unescapeCache;

    public XmlFriendlyNameCoder() {
        this("_-", "__");
    }

    public XmlFriendlyNameCoder(String dollarReplacement, String escapeCharReplacement) {
        this.dollarReplacement = dollarReplacement;
        this.escapeCharReplacement = escapeCharReplacement;
        this.readResolve();
    }

    @Override
    public String decodeAttribute(String attributeName) {
        return this.decodeName(attributeName);
    }

    @Override
    public String decodeNode(String elementName) {
        return this.decodeName(elementName);
    }

    @Override
    public String encodeAttribute(String name) {
        return this.encodeName(name);
    }

    @Override
    public String encodeNode(String name) {
        return this.encodeName(name);
    }

    private String encodeName(String name) {
        WeakReference ref = (WeakReference)this.escapeCache.get(name);
        String s = ref == null ? null : ref.get();
        if (s == null) {
            char c;
            int i;
            int length = name.length();
            for (i = 0; i < length && (c = name.charAt(i)) != '$' && c != '_'; ++i) {
            }
            if (i == length) {
                return name;
            }
            StringBuffer result = new StringBuffer(length + 8);
            if (i > 0) {
                result.append(name.substring(0, i));
            }
            while (i < length) {
                char c2 = name.charAt(i);
                if (c2 == '$') {
                    result.append(this.dollarReplacement);
                } else if (c2 == '_') {
                    result.append(this.escapeCharReplacement);
                } else {
                    result.append(c2);
                }
                ++i;
            }
            s = result.toString();
            this.escapeCache.put(name, new WeakReference<String>(s));
        }
        return s;
    }

    private String decodeName(String name) {
        WeakReference ref = (WeakReference)this.unescapeCache.get(name);
        String s = ref == null ? null : ref.get();
        if (s == null) {
            char c;
            int i;
            char dollarReplacementFirstChar = this.dollarReplacement.charAt(0);
            char escapeReplacementFirstChar = this.escapeCharReplacement.charAt(0);
            int length = name.length();
            for (i = 0; i < length && (c = name.charAt(i)) != dollarReplacementFirstChar && c != escapeReplacementFirstChar; ++i) {
            }
            if (i == length) {
                return name;
            }
            StringBuffer result = new StringBuffer(length + 8);
            if (i > 0) {
                result.append(name.substring(0, i));
            }
            while (i < length) {
                char c2 = name.charAt(i);
                if (c2 == dollarReplacementFirstChar && name.startsWith(this.dollarReplacement, i)) {
                    i += this.dollarReplacement.length() - 1;
                    result.append('$');
                } else if (c2 == escapeReplacementFirstChar && name.startsWith(this.escapeCharReplacement, i)) {
                    i += this.escapeCharReplacement.length() - 1;
                    result.append('_');
                } else {
                    result.append(c2);
                }
                ++i;
            }
            s = result.toString();
            this.unescapeCache.put(name, new WeakReference<String>(s));
        }
        return s;
    }

    public Object clone() {
        try {
            XmlFriendlyNameCoder coder = (XmlFriendlyNameCoder)super.clone();
            coder.readResolve();
            return coder;
        }
        catch (CloneNotSupportedException e) {
            throw new ObjectAccessException("Cannot clone XmlFriendlyNameCoder", e);
        }
    }

    private Object readResolve() {
        this.escapeCache = new WeakHashMap();
        this.unescapeCache = new WeakHashMap();
        return this;
    }
}

