/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.xml.xstream.io.xml;

import com.streamscape.omf.xml.xstream.converters.ErrorWriter;
import com.streamscape.omf.xml.xstream.io.StreamException;
import com.streamscape.omf.xml.xstream.io.naming.NameCoder;
import com.streamscape.omf.xml.xstream.io.xml.AbstractPullReader;
import com.streamscape.omf.xml.xstream.io.xml.QNameMap;
import com.streamscape.omf.xml.xstream.io.xml.XmlFriendlyNameCoder;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class StaxReader
extends AbstractPullReader {
    private final QNameMap qnameMap;
    private final XMLStreamReader in;

    public StaxReader(QNameMap qnameMap, XMLStreamReader in) {
        this(qnameMap, in, new XmlFriendlyNameCoder());
    }

    public StaxReader(QNameMap qnameMap, XMLStreamReader in, NameCoder replacer) {
        super(replacer);
        this.qnameMap = qnameMap;
        this.in = in;
        this.moveDown();
    }

    @Override
    protected int pullNextEvent() {
        try {
            switch (this.in.next()) {
                case 1: 
                case 7: {
                    return 1;
                }
                case 2: 
                case 8: {
                    return 2;
                }
                case 4: {
                    return 3;
                }
                case 5: {
                    return 4;
                }
            }
            return 0;
        }
        catch (XMLStreamException e) {
            throw new StreamException(e);
        }
    }

    @Override
    protected String pullElementName() {
        QName qname = this.in.getName();
        return this.qnameMap.getJavaClassName(qname);
    }

    @Override
    protected String pullText() {
        return this.in.getText();
    }

    @Override
    public String getAttribute(String name) {
        return this.in.getAttributeValue(null, this.encodeAttribute(name));
    }

    @Override
    public String getAttribute(int index) {
        return this.in.getAttributeValue(index);
    }

    @Override
    public int getAttributeCount() {
        return this.in.getAttributeCount();
    }

    @Override
    public String getAttributeName(int index) {
        return this.decodeAttribute(this.in.getAttributeLocalName(index));
    }

    @Override
    public void appendErrors(ErrorWriter errorWriter) {
        errorWriter.add("line number", String.valueOf(this.in.getLocation().getLineNumber()));
    }

    @Override
    public void close() {
        try {
            this.in.close();
        }
        catch (XMLStreamException e) {
            throw new StreamException(e);
        }
    }
}

