/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.xml.xstream.io.xml;

import com.streamscape.omf.xml.xstream.io.AbstractDriver;
import com.streamscape.omf.xml.xstream.io.HierarchicalStreamReader;
import com.streamscape.omf.xml.xstream.io.HierarchicalStreamWriter;
import com.streamscape.omf.xml.xstream.io.StreamException;
import com.streamscape.omf.xml.xstream.io.naming.NameCoder;
import com.streamscape.omf.xml.xstream.io.xml.DomReader;
import com.streamscape.omf.xml.xstream.io.xml.PrettyPrintWriter;
import com.streamscape.omf.xml.xstream.io.xml.XmlFriendlyNameCoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DomDriver
extends AbstractDriver {
    private final String encoding;
    private final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();

    public DomDriver() {
        this((String)null);
    }

    public DomDriver(String encoding) {
        this(encoding, new XmlFriendlyNameCoder());
    }

    public DomDriver(String encoding, NameCoder nameCoder) {
        super(nameCoder);
        this.encoding = encoding;
    }

    @Override
    public HierarchicalStreamReader createReader(Reader xml) {
        return this.createReader(new InputSource(xml));
    }

    @Override
    public HierarchicalStreamReader createReader(InputStream xml) {
        return this.createReader(new InputSource(xml));
    }

    private HierarchicalStreamReader createReader(InputSource source) {
        try {
            DocumentBuilder documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
            if (this.encoding != null) {
                source.setEncoding(this.encoding);
            }
            Document document = documentBuilder.parse(source);
            return new DomReader(document, this.getNameCoder());
        }
        catch (FactoryConfigurationError e) {
            throw new StreamException(e);
        }
        catch (ParserConfigurationException e) {
            throw new StreamException(e);
        }
        catch (SAXException e) {
            throw new StreamException(e);
        }
        catch (IOException e) {
            throw new StreamException(e);
        }
    }

    @Override
    public HierarchicalStreamWriter createWriter(Writer out) {
        return new PrettyPrintWriter(out, this.getNameCoder());
    }

    @Override
    public HierarchicalStreamWriter createWriter(OutputStream out) {
        try {
            return this.createWriter(this.encoding != null ? new OutputStreamWriter(out, this.encoding) : new OutputStreamWriter(out));
        }
        catch (UnsupportedEncodingException e) {
            throw new StreamException(e);
        }
    }
}

