/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.xml.xstream.io.xml;

import com.streamscape.omf.xml.xstream.core.util.XmlHeaderAwareReader;
import com.streamscape.omf.xml.xstream.io.AbstractDriver;
import com.streamscape.omf.xml.xstream.io.HierarchicalStreamReader;
import com.streamscape.omf.xml.xstream.io.HierarchicalStreamWriter;
import com.streamscape.omf.xml.xstream.io.StreamException;
import com.streamscape.omf.xml.xstream.io.naming.NameCoder;
import com.streamscape.omf.xml.xstream.io.xml.PrettyPrintWriter;
import com.streamscape.omf.xml.xstream.io.xml.XppReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class AbstractXppDriver
extends AbstractDriver {
    public AbstractXppDriver(NameCoder nameCoder) {
        super(nameCoder);
    }

    @Override
    public HierarchicalStreamReader createReader(Reader in) {
        in = in instanceof BufferedReader ? in : new BufferedReader(in);
        try {
            return new XppReader(in, this.createParser(), this.getNameCoder());
        }
        catch (XmlPullParserException e) {
            throw new StreamException("Cannot create XmlPullParser");
        }
    }

    @Override
    public HierarchicalStreamReader createReader(InputStream in) {
        try {
            return this.createReader(new XmlHeaderAwareReader(in));
        }
        catch (UnsupportedEncodingException e) {
            throw new StreamException(e);
        }
        catch (IOException e) {
            throw new StreamException(e);
        }
    }

    @Override
    public HierarchicalStreamWriter createWriter(Writer out) {
        return new PrettyPrintWriter(out, this.getNameCoder());
    }

    @Override
    public HierarchicalStreamWriter createWriter(OutputStream out) {
        return this.createWriter(new OutputStreamWriter(out));
    }

    protected abstract XmlPullParser createParser() throws XmlPullParserException;
}

