/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.xml.xstream.io.xml;

import com.streamscape.omf.xml.xstream.core.util.XmlHeaderAwareReader;
import com.streamscape.omf.xml.xstream.io.AbstractDriver;
import com.streamscape.omf.xml.xstream.io.HierarchicalStreamReader;
import com.streamscape.omf.xml.xstream.io.HierarchicalStreamWriter;
import com.streamscape.omf.xml.xstream.io.StreamException;
import com.streamscape.omf.xml.xstream.io.naming.NameCoder;
import com.streamscape.omf.xml.xstream.io.xml.PrettyPrintWriter;
import com.streamscape.omf.xml.xstream.io.xml.XppDomReader;
import com.streamscape.omf.xml.xstream.io.xml.xppdom.XppDom;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class AbstractXppDomDriver
extends AbstractDriver {
    public AbstractXppDomDriver(NameCoder nameCoder) {
        super(nameCoder);
    }

    @Override
    public HierarchicalStreamReader createReader(Reader in) {
        try {
            XmlPullParser parser = this.createParser();
            parser.setInput(in);
            return new XppDomReader(XppDom.build(parser), this.getNameCoder());
        }
        catch (XmlPullParserException e) {
            throw new StreamException(e);
        }
        catch (IOException e) {
            throw new StreamException(e);
        }
    }

    @Override
    public HierarchicalStreamReader createReader(InputStream in) {
        try {
            return this.createReader(new XmlHeaderAwareReader(in));
        }
        catch (UnsupportedEncodingException e) {
            throw new StreamException(e);
        }
        catch (IOException e) {
            throw new StreamException(e);
        }
    }

    @Override
    public HierarchicalStreamWriter createWriter(Writer out) {
        return new PrettyPrintWriter(out, this.getNameCoder());
    }

    @Override
    public HierarchicalStreamWriter createWriter(OutputStream out) {
        return this.createWriter(new OutputStreamWriter(out));
    }

    protected abstract XmlPullParser createParser() throws XmlPullParserException;
}

