/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.xml.xstream.core.util;

import com.streamscape.omf.xml.xstream.converters.ConversionException;
import com.streamscape.omf.xml.xstream.converters.DataHolder;
import com.streamscape.omf.xml.xstream.core.util.FastStack;
import com.streamscape.omf.xml.xstream.core.util.OrderRetainingMap;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Map;

public class CustomObjectOutputStream
extends ObjectOutputStream {
    private FastStack callbacks = new FastStack(1);
    private FastStack customFields = new FastStack(1);
    private static final String DATA_HOLDER_KEY = CustomObjectOutputStream.class.getName();

    public static synchronized CustomObjectOutputStream getInstance(DataHolder whereFrom, StreamCallback callback) {
        try {
            CustomObjectOutputStream result = (CustomObjectOutputStream)whereFrom.get(DATA_HOLDER_KEY);
            if (result == null) {
                result = new CustomObjectOutputStream(callback);
                whereFrom.put(DATA_HOLDER_KEY, result);
            } else {
                result.pushCallback(callback);
            }
            return result;
        }
        catch (IOException e) {
            throw new ConversionException("Cannot create CustomObjectStream", e);
        }
    }

    public CustomObjectOutputStream(StreamCallback callback) throws IOException, SecurityException {
        this.callbacks.push(callback);
    }

    public void pushCallback(StreamCallback callback) {
        this.callbacks.push(callback);
    }

    public StreamCallback popCallback() {
        return (StreamCallback)this.callbacks.pop();
    }

    public StreamCallback peekCallback() {
        return (StreamCallback)this.callbacks.peek();
    }

    @Override
    public void defaultWriteObject() throws IOException {
        this.peekCallback().defaultWriteObject();
    }

    @Override
    protected void writeObjectOverride(Object obj) throws IOException {
        this.peekCallback().writeToStream(obj);
    }

    @Override
    public void writeBoolean(boolean val) throws IOException {
        this.peekCallback().writeToStream(val ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void writeByte(int val) throws IOException {
        this.peekCallback().writeToStream(new Byte((byte)val));
    }

    @Override
    public void writeInt(int val) throws IOException {
        this.peekCallback().writeToStream(new Integer(val));
    }

    @Override
    public void writeChar(int val) throws IOException {
        this.peekCallback().writeToStream(new Character((char)val));
    }

    @Override
    public void writeDouble(double val) throws IOException {
        this.peekCallback().writeToStream(new Double(val));
    }

    @Override
    public void writeFloat(float val) throws IOException {
        this.peekCallback().writeToStream(new Float(val));
    }

    @Override
    public void writeLong(long val) throws IOException {
        this.peekCallback().writeToStream(new Long(val));
    }

    @Override
    public void writeShort(int val) throws IOException {
        this.peekCallback().writeToStream(new Short((short)val));
    }

    @Override
    public void write(byte[] buf) throws IOException {
        this.peekCallback().writeToStream(buf);
    }

    @Override
    public void writeChars(String str) throws IOException {
        this.peekCallback().writeToStream(str.toCharArray());
    }

    @Override
    public void writeUTF(String str) throws IOException {
        this.peekCallback().writeToStream(str);
    }

    @Override
    public void write(int val) throws IOException {
        this.peekCallback().writeToStream(new Byte((byte)val));
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        byte[] b = new byte[len];
        System.arraycopy(buf, off, b, 0, len);
        this.peekCallback().writeToStream(b);
    }

    @Override
    public void flush() throws IOException {
        this.peekCallback().flush();
    }

    @Override
    public void close() throws IOException {
        this.peekCallback().close();
    }

    @Override
    public ObjectOutputStream.PutField putFields() {
        CustomPutField result = new CustomPutField();
        this.customFields.push(result);
        return result;
    }

    @Override
    public void writeFields() throws IOException {
        CustomPutField customPutField = (CustomPutField)this.customFields.pop();
        this.peekCallback().writeFieldsToStream(customPutField.asMap());
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void useProtocolVersion(int version) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeBytes(String str) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeUnshared(Object obj) {
        throw new UnsupportedOperationException();
    }

    public static interface StreamCallback {
        public void writeToStream(Object var1) throws IOException;

        public void writeFieldsToStream(Map var1) throws IOException;

        public void defaultWriteObject() throws IOException;

        public void flush() throws IOException;

        public void close() throws IOException;
    }

    private class CustomPutField
    extends ObjectOutputStream.PutField {
        private final Map fields = new OrderRetainingMap();

        private CustomPutField() {
        }

        public Map asMap() {
            return this.fields;
        }

        @Override
        public void write(ObjectOutput out) throws IOException {
            CustomObjectOutputStream.this.peekCallback().writeToStream(this.asMap());
        }

        @Override
        public void put(String name, Object val) {
            this.fields.put(name, val);
        }

        @Override
        public void put(String name, byte val) {
            this.put(name, new Byte(val));
        }

        @Override
        public void put(String name, char val) {
            this.put(name, new Character(val));
        }

        @Override
        public void put(String name, double val) {
            this.put(name, new Double(val));
        }

        @Override
        public void put(String name, float val) {
            this.put(name, new Float(val));
        }

        @Override
        public void put(String name, int val) {
            this.put(name, new Integer(val));
        }

        @Override
        public void put(String name, long val) {
            this.put(name, new Long(val));
        }

        @Override
        public void put(String name, short val) {
            this.put(name, new Short(val));
        }

        @Override
        public void put(String name, boolean val) {
            this.put(name, val ? Boolean.TRUE : Boolean.FALSE);
        }
    }
}

