/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.xml.xstream.core;

import com.streamscape.omf.xml.XSerializerRuntimeException;
import com.streamscape.omf.xml.xstream.converters.ConversionException;
import com.streamscape.omf.xml.xstream.converters.Converter;
import com.streamscape.omf.xml.xstream.converters.ConverterLookup;
import com.streamscape.omf.xml.xstream.converters.DataHolder;
import com.streamscape.omf.xml.xstream.converters.MarshallingContext;
import com.streamscape.omf.xml.xstream.core.MapBackedDataHolder;
import com.streamscape.omf.xml.xstream.core.util.NameValueWrapper;
import com.streamscape.omf.xml.xstream.core.util.ObjectIdDictionary;
import com.streamscape.omf.xml.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import com.streamscape.omf.xml.xstream.io.HierarchicalStreamWriter;
import com.streamscape.omf.xml.xstream.mapper.Mapper;
import java.util.Iterator;

public class TreeMarshaller
implements MarshallingContext {
    protected HierarchicalStreamWriter writer;
    protected ConverterLookup converterLookup;
    private Mapper mapper;
    private ObjectIdDictionary parentObjects = new ObjectIdDictionary();
    private DataHolder dataHolder;

    public TreeMarshaller(HierarchicalStreamWriter writer, ConverterLookup converterLookup, Mapper mapper) {
        this.writer = writer;
        this.converterLookup = converterLookup;
        this.mapper = mapper;
    }

    @Override
    public void convertAnother(Object item) {
        this.convertAnother(item, null);
    }

    @Override
    public void convertAnother(Object item, Converter converter) {
        if (converter == null) {
            converter = this.converterLookup.lookupConverterForType(item.getClass());
        } else if (!converter.canConvert(item.getClass())) {
            ConversionException e = new ConversionException("Explicit selected converter cannot handle item");
            e.add("item-type", item.getClass().getName());
            e.add("converter-type", converter.getClass().getName());
            throw e;
        }
        this.convert(item, converter);
    }

    protected void convert(Object item, Converter converter) {
        if (this.parentObjects.containsId(item)) {
            throw new CircularReferenceException();
        }
        this.parentObjects.associateId(item, "");
        converter.marshal(item, this.writer, this);
        this.parentObjects.removeId(item);
    }

    public void start(Object item, DataHolder dataHolder) {
        this.dataHolder = dataHolder;
        if (item == null) {
            this.writer.startNode(this.mapper.serializedClass(null));
            this.writer.endNode();
        } else if (item instanceof NameValueWrapper) {
            this.writer.startNode(((NameValueWrapper)item).getName());
            if (((NameValueWrapper)item).getValue() != null) {
                this.convertAnother(((NameValueWrapper)item).getValue());
            } else {
                this.writer.setValue("null");
            }
            this.writer.endNode();
        } else {
            ExtendedHierarchicalStreamWriterHelper.startNode(this.writer, this.mapper.serializedClass(item.getClass()), item.getClass());
            this.convertAnother(item);
            this.writer.endNode();
        }
    }

    @Override
    public Object get(Object key) {
        this.lazilyCreateDataHolder();
        return this.dataHolder.get(key);
    }

    @Override
    public void put(Object key, Object value) {
        this.lazilyCreateDataHolder();
        this.dataHolder.put(key, value);
    }

    @Override
    public Iterator keys() {
        this.lazilyCreateDataHolder();
        return this.dataHolder.keys();
    }

    private void lazilyCreateDataHolder() {
        if (this.dataHolder == null) {
            this.dataHolder = new MapBackedDataHolder();
        }
    }

    protected Mapper getMapper() {
        return this.mapper;
    }

    public static class CircularReferenceException
    extends XSerializerRuntimeException {
    }
}

