/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.xml.xstream.core;

import com.streamscape.omf.xml.xstream.converters.ConversionException;
import com.streamscape.omf.xml.xstream.converters.Converter;
import com.streamscape.omf.xml.xstream.converters.ConverterLookup;
import com.streamscape.omf.xml.xstream.converters.MarshallingContext;
import com.streamscape.omf.xml.xstream.core.ReferencingMarshallingContext;
import com.streamscape.omf.xml.xstream.core.TreeMarshaller;
import com.streamscape.omf.xml.xstream.core.util.ObjectIdDictionary;
import com.streamscape.omf.xml.xstream.io.HierarchicalStreamWriter;
import com.streamscape.omf.xml.xstream.io.path.Path;
import com.streamscape.omf.xml.xstream.io.path.PathTracker;
import com.streamscape.omf.xml.xstream.io.path.PathTrackingWriter;
import com.streamscape.omf.xml.xstream.mapper.Mapper;
import java.util.Iterator;

public abstract class AbstractReferenceMarshaller
extends TreeMarshaller
implements MarshallingContext {
    private ObjectIdDictionary references = new ObjectIdDictionary();
    private ObjectIdDictionary implicitElements = new ObjectIdDictionary();
    private PathTracker pathTracker = new PathTracker();
    private Path lastPath;

    public AbstractReferenceMarshaller(HierarchicalStreamWriter writer, ConverterLookup converterLookup, Mapper mapper) {
        super(writer, converterLookup, mapper);
        this.writer = new PathTrackingWriter(writer, this.pathTracker);
    }

    @Override
    public void convert(Object item, Converter converter) {
        if (this.getMapper().isImmutableValueType(item.getClass())) {
            converter.marshal(item, this.writer, this);
        } else {
            Path currentPath = this.pathTracker.getPath();
            Object existingReferenceKey = this.references.lookupId(item);
            if (existingReferenceKey != null && existingReferenceKey != currentPath) {
                String attributeName = this.getMapper().aliasForSystemAttribute("reference");
                if (attributeName != null) {
                    this.writer.addAttribute(attributeName, this.createReference(currentPath, existingReferenceKey));
                }
            } else {
                Object newReferenceKey;
                Object object = newReferenceKey = existingReferenceKey == null ? this.createReferenceKey(currentPath, item) : existingReferenceKey;
                if (this.lastPath == null || !currentPath.isAncestor(this.lastPath)) {
                    this.fireValidReference(newReferenceKey);
                    this.lastPath = currentPath;
                    this.references.associateId(item, newReferenceKey);
                }
                converter.marshal(item, this.writer, new ReferencingMarshallingContext(){

                    @Override
                    public void put(Object key, Object value) {
                        AbstractReferenceMarshaller.this.put(key, value);
                    }

                    @Override
                    public Iterator keys() {
                        return AbstractReferenceMarshaller.this.keys();
                    }

                    @Override
                    public Object get(Object key) {
                        return AbstractReferenceMarshaller.this.get(key);
                    }

                    @Override
                    public void convertAnother(Object nextItem, Converter converter) {
                        AbstractReferenceMarshaller.this.convertAnother(nextItem, converter);
                    }

                    @Override
                    public void convertAnother(Object nextItem) {
                        AbstractReferenceMarshaller.this.convertAnother(nextItem);
                    }

                    @Override
                    public void replace(Object original, Object replacement) {
                        AbstractReferenceMarshaller.this.references.associateId(replacement, newReferenceKey);
                    }

                    @Override
                    public Object lookupReference(Object item) {
                        return AbstractReferenceMarshaller.this.references.lookupId(item);
                    }

                    @Override
                    public Path currentPath() {
                        return AbstractReferenceMarshaller.this.pathTracker.getPath();
                    }

                    @Override
                    public void registerImplicit(Object item) {
                        if (AbstractReferenceMarshaller.this.implicitElements.containsId(item)) {
                            throw new ReferencedImplicitElementException(item, this.currentPath());
                        }
                        AbstractReferenceMarshaller.this.implicitElements.associateId(item, newReferenceKey);
                    }
                });
            }
        }
    }

    protected abstract String createReference(Path var1, Object var2);

    protected abstract Object createReferenceKey(Path var1, Object var2);

    protected abstract void fireValidReference(Object var1);

    public static class ReferencedImplicitElementException
    extends ConversionException {
        public ReferencedImplicitElementException(Object item, Path path) {
            super("Cannot reference implicit element");
            this.add("implicit-element", item.toString());
            this.add("referencing-element", path.toString());
        }
    }
}

