/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.xml.xstream.converters.reflection;

import com.streamscape.lib.utils.JVM;
import com.streamscape.omf.xml.xstream.converters.reflection.FieldDictionary;
import com.streamscape.omf.xml.xstream.converters.reflection.ImmutableFieldKeySorter;
import com.streamscape.omf.xml.xstream.converters.reflection.ObjectAccessException;
import com.streamscape.omf.xml.xstream.converters.reflection.ReflectionProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public class PureJavaReflectionProvider
implements ReflectionProvider {
    private transient Map serializedDataCache = new WeakHashMap();
    protected FieldDictionary fieldDictionary;

    public PureJavaReflectionProvider() {
        this(new FieldDictionary(new ImmutableFieldKeySorter()));
    }

    public PureJavaReflectionProvider(FieldDictionary fieldDictionary) {
        this.fieldDictionary = fieldDictionary;
    }

    @Override
    public Object newInstance(Class type) {
        try {
            Constructor<?>[] constructors = type.getDeclaredConstructors();
            for (int i = 0; i < constructors.length; ++i) {
                if (constructors[i].getParameterTypes().length != 0) continue;
                if (!Modifier.isPublic(constructors[i].getModifiers())) {
                    constructors[i].setAccessible(true);
                }
                return constructors[i].newInstance(new Object[0]);
            }
            if (Serializable.class.isAssignableFrom(type)) {
                return this.instantiateUsingSerialization(type);
            }
            throw new ObjectAccessException("Cannot construct " + type.getName() + " as it does not have a no-args constructor");
        }
        catch (InstantiationException e) {
            throw new ObjectAccessException("Cannot construct " + type.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new ObjectAccessException("Cannot construct " + type.getName(), e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw new ObjectAccessException("Constructor for " + type.getName() + " threw an exception", e.getTargetException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object instantiateUsingSerialization(Class type) {
        try {
            Map map = this.serializedDataCache;
            synchronized (map) {
                byte[] data = (byte[])this.serializedDataCache.get(type);
                if (data == null) {
                    ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                    DataOutputStream stream = new DataOutputStream(bytes);
                    stream.writeShort(-21267);
                    stream.writeShort(5);
                    stream.writeByte(115);
                    stream.writeByte(114);
                    stream.writeUTF(type.getName());
                    stream.writeLong(ObjectStreamClass.lookup(type).getSerialVersionUID());
                    stream.writeByte(2);
                    stream.writeShort(0);
                    stream.writeByte(120);
                    stream.writeByte(112);
                    data = bytes.toByteArray();
                    this.serializedDataCache.put(type, data);
                }
                ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(data));
                return in.readObject();
            }
        }
        catch (IOException e) {
            throw new ObjectAccessException("Cannot create " + type.getName() + " by JDK serialization", e);
        }
        catch (ClassNotFoundException e) {
            throw new ObjectAccessException("Cannot find class " + e.getMessage());
        }
    }

    @Override
    public void visitSerializableFields(Object object, ReflectionProvider.Visitor visitor) {
        Iterator iterator = this.fieldDictionary.fieldsFor(object.getClass());
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            if (!this.fieldModifiersSupported(field)) continue;
            this.validateFieldAccess(field);
            try {
                Object value = field.get(object);
                visitor.visit(field.getName(), field.getType(), field.getDeclaringClass(), value);
            }
            catch (IllegalArgumentException e) {
                throw new ObjectAccessException("Could not get field " + String.valueOf(field.getClass()) + "." + field.getName(), e);
            }
            catch (IllegalAccessException e) {
                throw new ObjectAccessException("Could not get field " + String.valueOf(field.getClass()) + "." + field.getName(), e);
            }
        }
    }

    @Override
    public void writeField(Object object, String fieldName, Object value, Class definedIn) {
        Field field = this.fieldDictionary.field(object.getClass(), fieldName, definedIn);
        this.validateFieldAccess(field);
        try {
            field.set(object, value);
        }
        catch (IllegalArgumentException e) {
            throw new ObjectAccessException("Could not set field " + String.valueOf(object.getClass()) + "." + field.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new ObjectAccessException("Could not set field " + String.valueOf(object.getClass()) + "." + field.getName(), e);
        }
    }

    @Override
    public Class getFieldType(Object object, String fieldName, Class definedIn) {
        return this.fieldDictionary.field(object.getClass(), fieldName, definedIn).getType();
    }

    @Override
    public boolean fieldDefinedInClass(String fieldName, Class type) {
        Field field = this.fieldDictionary.fieldOrNull(type, fieldName, null);
        return field != null && (this.fieldModifiersSupported(field) || Modifier.isTransient(field.getModifiers()));
    }

    protected boolean fieldModifiersSupported(Field field) {
        return !Modifier.isStatic(field.getModifiers()) && !Modifier.isTransient(field.getModifiers());
    }

    protected void validateFieldAccess(Field field) {
        if (Modifier.isFinal(field.getModifiers())) {
            if (JVM.is1_5()) {
                field.setAccessible(true);
            } else {
                throw new ObjectAccessException("Invalid final field " + field.getDeclaringClass().getName() + "." + field.getName());
            }
        }
    }

    @Override
    public Field getField(Class definedIn, String fieldName) {
        return this.fieldDictionary.field(definedIn, fieldName, null);
    }

    public void setFieldDictionary(FieldDictionary dictionary) {
        this.fieldDictionary = dictionary;
    }

    protected Object readResolve() {
        this.serializedDataCache = new WeakHashMap();
        return this;
    }
}

