/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.xml.xstream.converters.reflection;

import com.streamscape.omf.xml.XConstants;
import com.streamscape.omf.xml.XSerializerRuntimeException;
import com.streamscape.omf.xml.xstream.converters.ConversionException;
import com.streamscape.omf.xml.xstream.converters.Converter;
import com.streamscape.omf.xml.xstream.converters.ConverterLookup;
import com.streamscape.omf.xml.xstream.converters.MarshallingContext;
import com.streamscape.omf.xml.xstream.converters.SingleValueConverter;
import com.streamscape.omf.xml.xstream.converters.UnmarshallingContext;
import com.streamscape.omf.xml.xstream.converters.collections.CollectionConverter;
import com.streamscape.omf.xml.xstream.converters.enums.EnumConverter;
import com.streamscape.omf.xml.xstream.converters.reflection.FabricDefaultsProvider;
import com.streamscape.omf.xml.xstream.converters.reflection.ReflectionConverter;
import com.streamscape.omf.xml.xstream.converters.reflection.ReflectionProvider;
import com.streamscape.omf.xml.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import com.streamscape.omf.xml.xstream.io.HierarchicalStreamReader;
import com.streamscape.omf.xml.xstream.io.HierarchicalStreamWriter;
import com.streamscape.omf.xml.xstream.mapper.Mapper;
import com.streamscape.omf.xml.xstream.mapper.MapperWrapper;
import com.streamscape.runtime.mf.operation.edl.annotations.SemanticType;
import java.io.Externalizable;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Stack;

public class FabricReflectionConverter
extends ReflectionConverter {
    private FabricDefaultsProvider defaultsProvider;
    private ConverterLookup converterLookup;
    private boolean isProcessSerializableAndExternalizable;
    private final HashMap<Thread, Stack<HierarchicalStreamReader>> readers = new HashMap();
    private final HashMap<Thread, Counter> doMarshalRecursiveCounters = new HashMap();

    public FabricReflectionConverter(Mapper mapper, ReflectionProvider reflectionProvider, FabricDefaultsProvider defaultsProvider, ConverterLookup converterLookup) {
        super(mapper, reflectionProvider);
        this.defaultsProvider = defaultsProvider;
        this.converterLookup = converterLookup;
    }

    private Object getDefaultValue(String fieldName, Class type, Class definedIn) {
        byte[] array = new byte[1];
        Object value = this.defaultsProvider.getFieldDefault(fieldName, type, definedIn);
        if (value == null) {
            value = this.defaultsProvider.getClassDefault(type);
        }
        if (value == null && this.defaultsProvider.isGenerateNullFields()) {
            try {
                value = type.isInstance(array) ? (Object)new byte[1] : (type.isInterface() ? new Object() : type.newInstance());
            }
            catch (InstantiationException ex) {
                throw new XSerializerRuntimeException("Could not instantiate type '" + type.getName() + "', " + ex.getMessage());
            }
            catch (IllegalAccessException ex) {
                throw new XSerializerRuntimeException("Illegal access for type '" + type.getName() + "', " + ex.getMessage());
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean increaseDoMarshalRecursiveCounter() {
        HashMap<Thread, Counter> hashMap = this.doMarshalRecursiveCounters;
        synchronized (hashMap) {
            Counter counter = this.doMarshalRecursiveCounters.get(Thread.currentThread());
            if (counter == null) {
                counter = new Counter();
                this.doMarshalRecursiveCounters.put(Thread.currentThread(), counter);
                return true;
            }
            ++counter.count;
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decreaseDoMarshalRecursiveCounter() {
        HashMap<Thread, Counter> hashMap = this.doMarshalRecursiveCounters;
        synchronized (hashMap) {
            Counter counter = this.doMarshalRecursiveCounters.get(Thread.currentThread());
            if (counter != null && --counter.count <= 0) {
                this.doMarshalRecursiveCounters.remove(Thread.currentThread());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doMarshal(final Object source, final HierarchicalStreamWriter writer, final MarshallingContext context) {
        boolean firstInRecursive = this.increaseDoMarshalRecursiveCounter();
        try {
            if (firstInRecursive && this.defaultsProvider.isIncludeXmlNsXsi()) {
                writer.addAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            }
            final HashSet seenFields = new HashSet();
            final HashMap defaultFieldDefinition = new HashMap();
            this.reflectionProvider.visitSerializableFields(source, new ReflectionProvider.Visitor(){

                @Override
                public void visit(String fieldName, Class type, Class definedIn, Object value) {
                    SingleValueConverter converter;
                    if (!FabricReflectionConverter.this.mapper.shouldSerializeMember(definedIn, fieldName)) {
                        return;
                    }
                    if (!defaultFieldDefinition.containsKey(fieldName)) {
                        Class<?> lookupType = source.getClass();
                        defaultFieldDefinition.put(fieldName, FabricReflectionConverter.this.reflectionProvider.getField(lookupType, fieldName));
                    }
                    if ((converter = FabricReflectionConverter.this.mapper.getConverterFromItemType(fieldName, type, definedIn)) != null) {
                        if (value == null && (value = FabricReflectionConverter.this.getDefaultValue(fieldName, type, definedIn)) == XConstants.NULL) {
                            value = "null";
                        }
                        if (value != null) {
                            if (seenFields.contains(fieldName)) {
                                throw new ConversionException("Cannot write field with name '" + fieldName + "' twice as attribute for object of type " + source.getClass().getName());
                            }
                            String str = converter.toString(value);
                            if (str != null) {
                                writer.addAttribute(FabricReflectionConverter.this.mapper.aliasForAttribute(FabricReflectionConverter.this.mapper.serializedMember(definedIn, fieldName)), str);
                            }
                        }
                        seenFields.add(fieldName);
                    }
                }
            });
            this.reflectionProvider.visitSerializableFields(source, new ReflectionProvider.Visitor(){

                @Override
                public void visit(String fieldName, Class fieldType, Class definedIn, Object value) {
                    if (!FabricReflectionConverter.this.mapper.shouldSerializeMember(definedIn, fieldName)) {
                        return;
                    }
                    if (!seenFields.contains(fieldName)) {
                        boolean isNull;
                        boolean bl = isNull = value == null;
                        if (isNull) {
                            value = FabricReflectionConverter.this.getDefaultValue(fieldName, fieldType, definedIn);
                        }
                        if (value != null) {
                            if (value == XConstants.XSI_NIL) {
                                writer.startNode(FabricReflectionConverter.this.mapper.serializedMember(source.getClass(), fieldName));
                                writer.addAttribute("xsi:nil", "true");
                                writer.endNode();
                            } else if (value != XConstants.NULL || !FabricReflectionConverter.this.defaultsProvider.isOmitNullFields()) {
                                if (isNull && value.getClass().equals(String.class)) {
                                    writer.startNode(fieldName);
                                    writer.setValue(value.toString());
                                    writer.endNode();
                                } else {
                                    Mapper.ImplicitCollectionMapping mapping = FabricReflectionConverter.this.mapper.getImplicitCollectionDefForFieldName(source.getClass(), fieldName);
                                    if (mapping != null) {
                                        if (mapping.getItemFieldName() != null) {
                                            Collection list = (Collection)value;
                                            for (Object obj : list) {
                                                this.writeField(fieldName, mapping.getItemFieldName(), mapping.getItemType(), definedIn, obj);
                                            }
                                        } else {
                                            context.convertAnother(value);
                                        }
                                    } else {
                                        this.writeField(fieldName, fieldName, fieldType, definedIn, value);
                                    }
                                }
                            }
                        }
                    }
                }

                private void writeField(String fieldName, String aliasName, Class fieldType, Class definedIn, Object newObj) {
                    ExtendedHierarchicalStreamWriterHelper.startNode(writer, FabricReflectionConverter.this.mapper.serializedMember(source.getClass(), aliasName), fieldType);
                    if (newObj == XConstants.NULL) {
                        newObj = "null";
                    } else {
                        String serializedClassName;
                        Class defaultType;
                        Class<?> actualType = newObj.getClass();
                        if (!actualType.equals(defaultType = FabricReflectionConverter.this.mapper.defaultImplementationOf(fieldType)) && !(serializedClassName = FabricReflectionConverter.this.mapper.serializedClass(actualType)).equals(FabricReflectionConverter.this.mapper.serializedClass(defaultType))) {
                            writer.addAttribute(FabricReflectionConverter.this.mapper.aliasForAttribute("class"), serializedClassName);
                        }
                    }
                    Field defaultField = (Field)defaultFieldDefinition.get(fieldName);
                    if (defaultField.getDeclaringClass() != definedIn) {
                        writer.addAttribute(FabricReflectionConverter.this.mapper.aliasForAttribute("defined-in"), FabricReflectionConverter.this.mapper.serializedClass(definedIn));
                    }
                    Field field = FabricReflectionConverter.this.reflectionProvider.getField(definedIn, fieldName);
                    FabricReflectionConverter.this.marshallField(context, newObj, field);
                    writer.endNode();
                }
            });
        }
        finally {
            this.decreaseDoMarshalRecursiveCounter();
        }
    }

    @Override
    protected void marshallField(MarshallingContext context, Object newObj, Field field) {
        context.convertAnother(newObj, this.createLocalOrCollectionConverterWithSemanticTypeAliasMapper(newObj.getClass(), field));
    }

    private Converter createLocalOrCollectionConverterWithSemanticTypeAliasMapper(Class clazz, Field field) {
        Converter converter = this.mapper.getLocalConverter(field.getDeclaringClass(), field.getName());
        if (converter != null) {
            return converter;
        }
        final SemanticType semanticType = field.getAnnotation(SemanticType.class);
        if (semanticType != null && semanticType.alias() != null && semanticType.alias().length() > 0 && (converter = this.converterLookup.lookupConverterForType(clazz)) != null && converter instanceof CollectionConverter) {
            converter = new CollectionConverter(new MapperWrapper(this, this.mapper){

                @Override
                public String serializedClass(Class type) {
                    if (type.getName().equals(semanticType.type())) {
                        return semanticType.alias();
                    }
                    return super.serializedClass(type);
                }

                @Override
                public Class realClass(String elementName) {
                    if (elementName.equals(semanticType.alias())) {
                        return super.realClass(semanticType.type());
                    }
                    return super.realClass(elementName);
                }
            });
        }
        return converter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HierarchicalStreamReader peekReader() {
        HashMap<Thread, Stack<HierarchicalStreamReader>> hashMap = this.readers;
        synchronized (hashMap) {
            Stack<HierarchicalStreamReader> stack = this.readers.get(Thread.currentThread());
            if (stack != null) {
                return stack.size() > 0 ? stack.peek() : null;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushReader(HierarchicalStreamReader reader) {
        HashMap<Thread, Stack<HierarchicalStreamReader>> hashMap = this.readers;
        synchronized (hashMap) {
            Stack<HierarchicalStreamReader> stack = this.readers.get(Thread.currentThread());
            if (stack == null) {
                stack = new Stack();
                this.readers.put(Thread.currentThread(), stack);
            }
            stack.push(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HierarchicalStreamReader popReader() {
        HashMap<Thread, Stack<HierarchicalStreamReader>> hashMap = this.readers;
        synchronized (hashMap) {
            Stack<HierarchicalStreamReader> stack = this.readers.get(Thread.currentThread());
            if (stack != null) {
                HierarchicalStreamReader reader = stack.pop();
                if (stack.size() == 0) {
                    this.readers.remove(Thread.currentThread());
                }
                return reader;
            }
            return null;
        }
    }

    @Override
    protected Object unmarshallField(UnmarshallingContext context, Object result, Class type, Field field) {
        HierarchicalStreamReader reader = this.peekReader();
        if (reader != null) {
            int count = reader.getAttributeCount();
            for (int i = 0; i < count; ++i) {
                if (!"nil".equals(reader.getAttributeName(i)) && !"xsi:nil".equals(reader.getAttributeName(i)) || !"true".equals(reader.getAttribute(i))) continue;
                return null;
            }
        }
        Object rval = context.convertAnother(result, type, this.createLocalOrCollectionConverterWithSemanticTypeAliasMapper(type, field));
        if (reader != null) {
            String value = reader.getValue();
            if ("null".equalsIgnoreCase(value) && this.getDefaultValue(field.getName(), type, field.getDeclaringClass()) == XConstants.NULL) {
                return null;
            }
            Converter converter = this.mapper.getLocalConverter(field.getDeclaringClass(), field.getName());
            if (converter == null) {
                converter = this.converterLookup.lookupConverterForType(this.mapper.defaultImplementationOf(type));
            }
            if (value != null && value.trim().length() > 0 && !(converter instanceof SingleValueConverter) && !(converter instanceof EnumConverter)) {
                throw new XSerializerRuntimeException("Failed to convert '" + value + "' to type '" + type.getName() + "'");
            }
        }
        return rval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object doUnmarshal(Object result, HierarchicalStreamReader reader, UnmarshallingContext context) {
        this.pushReader(reader);
        try {
            result = super.doUnmarshal(result, reader, context);
        }
        finally {
            this.popReader();
        }
        final Object resultRef = result;
        this.reflectionProvider.visitSerializableFields(result, new ReflectionProvider.Visitor(){

            @Override
            public void visit(String name, Class type, Class definedIn, Object value) {
                if (value == null && (value = FabricReflectionConverter.this.getDefaultValue(name, type, definedIn)) != null && !(value instanceof XConstants)) {
                    try {
                        FabricReflectionConverter.this.reflectionProvider.writeField(resultRef, name, value, definedIn);
                    }
                    catch (Exception ex) {
                        throw new XSerializerRuntimeException(ex.getMessage(), ex);
                    }
                }
            }
        });
        return result;
    }

    private boolean isSerializable(Class type) {
        return Serializable.class.isAssignableFrom(type) && (this.serializationMethodInvoker.supportsReadObject(type, true) || this.serializationMethodInvoker.supportsWriteObject(type, true));
    }

    public boolean isExternalizable(Class type) {
        return Externalizable.class.isAssignableFrom(type);
    }

    @Override
    public boolean canConvert(Class type) {
        return this.isProcessSerializableAndExternalizable || !this.isSerializable(type) && !this.isExternalizable(type);
    }

    public boolean isProcessSerializableAndExternalizable() {
        return this.isProcessSerializableAndExternalizable;
    }

    public void setProcessSerializableAndExternalizable(boolean value) {
        this.isProcessSerializableAndExternalizable = value;
    }

    private static class Counter {
        public int count = 1;
    }
}

