/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.xml.xstream.converters.reflection;

import com.streamscape.omf.xml.XConstants;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;

public class FabricDefaultsProvider {
    private HashMap<Class, Object> classDefaults = new HashMap();
    private HashMap<Class, FieldMap> declaringClassView = new HashMap();
    private boolean isGenerateNullFields = false;
    private int xsiNilCounter = 0;
    private boolean isXFragment = false;
    private boolean omitNullFields = false;

    public FabricDefaultsProvider() {
        this.setClassDefault(Byte.class, (byte)0);
        this.setClassDefault(Short.class, (short)0);
        this.setClassDefault(Integer.class, 0);
        this.setClassDefault(Long.class, 0L);
        this.setClassDefault(Float.class, Float.valueOf(0.0f));
        this.setClassDefault(Double.class, 0.0);
    }

    public Object getDefault(String fieldName, Class clazz, Class definedIn) {
        Object defaultValue = this.getFieldDefault(fieldName, clazz, definedIn);
        if (defaultValue != null) {
            return defaultValue;
        }
        return this.getClassDefault(clazz);
    }

    public Object getClassDefault(Class clazz) {
        Object result = this.classDefaults.get(clazz);
        return result;
    }

    public <T> void setClassDefault(Class<T> clazz, T value) {
        this.classDefaults.put(clazz, value);
    }

    public void setClassStringDefault(Class clazz, String xmlValue) {
        this.classDefaults.put(clazz, xmlValue);
    }

    public void setClassDefault(Class clazz, XConstants value) {
        this.classDefaults.put(clazz, value);
        if (value == XConstants.XSI_NIL) {
            ++this.xsiNilCounter;
        }
    }

    public void removeClassDefault(Class clazz) {
        if (this.classDefaults.remove(clazz) == XConstants.XSI_NIL) {
            --this.xsiNilCounter;
        }
    }

    public Object getFieldDefault(String fieldName, Class clazz, Class definedIn) {
        FieldMap fMap = this.declaringClassView.get(definedIn);
        if (fMap != null) {
            return fMap.lookupFieldDefault(fieldName);
        }
        return null;
    }

    private void setFieldDefaultObject(String fieldName, Class clazz, Class definedIn, Object defaultValue) {
        FieldMap fMap = this.declaringClassView.get(definedIn);
        if (fMap == null) {
            fMap = new FieldMap();
            this.declaringClassView.put(definedIn, fMap);
        }
        fMap.addField(fieldName, defaultValue);
    }

    public <T> void setFieldDefault(String fieldName, Class<T> clazz, Class definedIn, T value) {
        this.setFieldDefaultObject(fieldName, clazz, definedIn, value);
    }

    public void setFieldStringDefault(String fieldName, Class clazz, Class definedIn, String value) {
        this.setFieldDefaultObject(fieldName, clazz, definedIn, value);
    }

    public void setFieldDefault(String fieldName, Class clazz, Class definedIn, XConstants defaultValue) {
        this.setFieldDefaultObject(fieldName, clazz, definedIn, defaultValue);
        if (defaultValue == XConstants.XSI_NIL) {
            ++this.xsiNilCounter;
        }
    }

    public void removeFieldDefault(String fieldName, Class definedIn) {
        FieldMap fMap = this.declaringClassView.get(definedIn);
        if (fMap != null && fMap.removeField(fieldName) == XConstants.XSI_NIL) {
            --this.xsiNilCounter;
        }
    }

    public void setGenerateNullFields(boolean value) {
        this.isGenerateNullFields = value;
    }

    public void setXFragment(boolean value) {
        this.isXFragment = value;
    }

    public boolean isGenerateNullFields() {
        return this.isGenerateNullFields;
    }

    public boolean isIncludeXmlNsXsi() {
        return this.xsiNilCounter > 0 && !this.isXFragment;
    }

    public boolean isOmitNullFields() {
        return this.omitNullFields;
    }

    public void setOmitNullFields(boolean omitNullFields) {
        this.omitNullFields = omitNullFields;
    }

    class FieldMap
    extends Hashtable<String, Object> {
        FieldMap() {
        }

        public void addField(String fieldName, Object obj) {
            this.put(fieldName, obj);
        }

        public Object removeField(String fieldName) {
            return this.remove(fieldName);
        }

        public Object lookupFieldDefault(String fieldName) {
            return this.get(fieldName);
        }

        public Enumeration<String> getFields() {
            return this.keys();
        }
    }
}

