/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.xml.xstream.converters.reflection;

import com.streamscape.omf.xml.xstream.converters.ConversionException;
import com.streamscape.omf.xml.xstream.converters.Converter;
import com.streamscape.omf.xml.xstream.converters.MarshallingContext;
import com.streamscape.omf.xml.xstream.converters.UnmarshallingContext;
import com.streamscape.omf.xml.xstream.core.util.CustomObjectInputStream;
import com.streamscape.omf.xml.xstream.core.util.CustomObjectOutputStream;
import com.streamscape.omf.xml.xstream.core.util.HierarchicalStreams;
import com.streamscape.omf.xml.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import com.streamscape.omf.xml.xstream.io.HierarchicalStreamReader;
import com.streamscape.omf.xml.xstream.io.HierarchicalStreamWriter;
import com.streamscape.omf.xml.xstream.mapper.Mapper;
import java.io.Externalizable;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInputValidation;
import java.util.Map;

public class ExternalizableConverter
implements Converter {
    private Mapper mapper;

    public ExternalizableConverter(Mapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public boolean canConvert(Class type) {
        return Externalizable.class.isAssignableFrom(type);
    }

    @Override
    public void marshal(Object source, final HierarchicalStreamWriter writer, final MarshallingContext context) {
        try {
            Externalizable externalizable = (Externalizable)source;
            CustomObjectOutputStream.StreamCallback callback = new CustomObjectOutputStream.StreamCallback(){

                @Override
                public void writeToStream(Object object) {
                    if (object == null) {
                        writer.startNode("null");
                        writer.endNode();
                    } else {
                        ExtendedHierarchicalStreamWriterHelper.startNode(writer, ExternalizableConverter.this.mapper.serializedClass(object.getClass()), object.getClass());
                        context.convertAnother(object);
                        writer.endNode();
                    }
                }

                @Override
                public void writeFieldsToStream(Map fields) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void defaultWriteObject() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void flush() {
                    writer.flush();
                }

                @Override
                public void close() {
                    throw new UnsupportedOperationException("Objects are not allowed to call ObjectOutput.close() from writeExternal()");
                }
            };
            CustomObjectOutputStream objectOutput = CustomObjectOutputStream.getInstance(context, callback);
            externalizable.writeExternal(objectOutput);
            objectOutput.popCallback();
        }
        catch (IOException e) {
            throw new ConversionException("Cannot serialize " + source.getClass().getName() + " using Externalization", e);
        }
    }

    @Override
    public Object unmarshal(final HierarchicalStreamReader reader, final UnmarshallingContext context) {
        Class type = context.getRequiredType();
        try {
            final Externalizable externalizable = (Externalizable)type.newInstance();
            CustomObjectInputStream.StreamCallback callback = new CustomObjectInputStream.StreamCallback(){

                @Override
                public Object readFromStream() {
                    reader.moveDown();
                    Class type = HierarchicalStreams.readClassType(reader, ExternalizableConverter.this.mapper);
                    Object streamItem = context.convertAnother(externalizable, type);
                    reader.moveUp();
                    return streamItem;
                }

                @Override
                public Map readFieldsFromStream() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void defaultReadObject() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void registerValidation(ObjectInputValidation validation, int priority) throws NotActiveException {
                    throw new NotActiveException("stream inactive");
                }

                @Override
                public void close() {
                    throw new UnsupportedOperationException("Objects are not allowed to call ObjectInput.close() from readExternal()");
                }
            };
            CustomObjectInputStream objectInput = CustomObjectInputStream.getInstance(context, callback);
            externalizable.readExternal(objectInput);
            objectInput.popCallback();
            return externalizable;
        }
        catch (InstantiationException e) {
            throw new ConversionException("Cannot construct " + String.valueOf(type.getClass()), e);
        }
        catch (IllegalAccessException e) {
            throw new ConversionException("Cannot construct " + String.valueOf(type.getClass()), e);
        }
        catch (IOException e) {
            throw new ConversionException("Cannot externalize " + String.valueOf(type.getClass()), e);
        }
        catch (ClassNotFoundException e) {
            throw new ConversionException("Cannot externalize " + String.valueOf(type.getClass()), e);
        }
    }
}

