/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.xml.xstream.converters.reflection;

import com.streamscape.omf.xml.XConstants;
import java.util.HashMap;

public class DefaultsProvider {
    private HashMap<Class, Object> classDefaults = new HashMap();
    private HashMap<String, HashMap<Class, Object>> fieldDefaults = new HashMap();
    private boolean isGenerateNullFields = false;
    private int xsiNilCounter = 0;

    public DefaultsProvider() {
        this.setClassDefault(Byte.class, (byte)0);
        this.setClassDefault(Short.class, (short)0);
        this.setClassDefault(Integer.class, 0);
        this.setClassDefault(Long.class, 0L);
        this.setClassDefault(Float.class, Float.valueOf(0.0f));
        this.setClassDefault(Double.class, 0.0);
    }

    public Object getClassDefault(Class clazz) {
        Object result = this.classDefaults.get(clazz);
        return result;
    }

    public <T> void setClassDefault(Class<T> clazz, T value) {
        this.classDefaults.put(clazz, value);
    }

    public void setClassStringDefault(Class clazz, String value) {
        this.classDefaults.put(clazz, value);
    }

    public void setClassDefault(Class clazz, XConstants value) {
        this.classDefaults.put(clazz, value);
        if (value == XConstants.XSI_NIL) {
            ++this.xsiNilCounter;
        }
    }

    public void removeClassDefault(Class clazz) {
        if (this.classDefaults.remove(clazz) == XConstants.XSI_NIL) {
            --this.xsiNilCounter;
        }
    }

    public Object getFieldDefault(String fieldName, Class clazz) {
        HashMap<Class, Object> byClass = this.fieldDefaults.get(fieldName);
        if (byClass != null) {
            return byClass.get(clazz);
        }
        return null;
    }

    private void setFieldDefaultObject(String fieldName, Class clazz, Object value) {
        HashMap<Class<Object>, Object> byClass = this.fieldDefaults.get(fieldName);
        if (byClass == null) {
            byClass = new HashMap();
            this.fieldDefaults.put(fieldName, byClass);
        }
        byClass.put(clazz, value);
    }

    public <T> void setFieldDefault(String fieldName, Class<T> clazz, T value) {
        this.setFieldDefaultObject(fieldName, clazz, value);
    }

    public void setFieldStringDefault(String fieldName, Class clazz, String value) {
        this.setFieldDefaultObject(fieldName, clazz, value);
    }

    public void setFieldDefault(String fieldName, Class clazz, XConstants value) {
        this.setFieldDefaultObject(fieldName, clazz, value);
        if (value == XConstants.XSI_NIL) {
            ++this.xsiNilCounter;
        }
    }

    public void removeFieldDefault(String fieldName, Class clazz) {
        HashMap<Class, Object> byClass = this.fieldDefaults.get(fieldName);
        if (byClass != null && byClass.remove(clazz) == XConstants.XSI_NIL) {
            --this.xsiNilCounter;
        }
    }

    public void removeFieldDefault(String fieldName) {
        this.fieldDefaults.remove(fieldName);
    }

    public void setGenerateNullFields(boolean value) {
        this.isGenerateNullFields = value;
    }

    public boolean isGenerateNullFields() {
        return this.isGenerateNullFields;
    }

    public boolean isIncludeXmlNsXsi() {
        return this.xsiNilCounter > 0;
    }
}

