/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.xml.xstream.converters.javabean;

import com.streamscape.omf.xml.xstream.converters.ConversionException;
import com.streamscape.omf.xml.xstream.converters.Converter;
import com.streamscape.omf.xml.xstream.converters.MarshallingContext;
import com.streamscape.omf.xml.xstream.converters.UnmarshallingContext;
import com.streamscape.omf.xml.xstream.converters.javabean.BeanProvider;
import com.streamscape.omf.xml.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import com.streamscape.omf.xml.xstream.io.HierarchicalStreamReader;
import com.streamscape.omf.xml.xstream.io.HierarchicalStreamWriter;
import com.streamscape.omf.xml.xstream.mapper.Mapper;

public class JavaBeanConverter
implements Converter {
    private Mapper mapper;
    private BeanProvider beanProvider;
    private String classAttributeIdentifier;

    public JavaBeanConverter(Mapper mapper) {
        this(mapper, new BeanProvider());
    }

    public JavaBeanConverter(Mapper mapper, BeanProvider beanProvider) {
        this.mapper = mapper;
        this.beanProvider = beanProvider;
    }

    public JavaBeanConverter(Mapper mapper, String classAttributeIdentifier) {
        this(mapper, new BeanProvider());
        this.classAttributeIdentifier = classAttributeIdentifier;
    }

    @Override
    public boolean canConvert(Class type) {
        return this.beanProvider.canInstantiate(type);
    }

    @Override
    public void marshal(final Object source, final HierarchicalStreamWriter writer, final MarshallingContext context) {
        final String classAttributeName = this.classAttributeIdentifier != null ? this.classAttributeIdentifier : this.mapper.aliasForSystemAttribute("class");
        this.beanProvider.visitSerializableProperties(source, new BeanProvider.Visitor(){

            @Override
            public boolean shouldVisit(String name, Class definedIn) {
                return JavaBeanConverter.this.mapper.shouldSerializeMember(definedIn, name);
            }

            @Override
            public void visit(String propertyName, Class fieldType, Class definedIn, Object newObj) {
                if (newObj != null) {
                    this.writeField(propertyName, fieldType, newObj, definedIn);
                }
            }

            private void writeField(String propertyName, Class fieldType, Object newObj, Class definedIn) {
                String serializedMember = JavaBeanConverter.this.mapper.serializedMember(source.getClass(), propertyName);
                ExtendedHierarchicalStreamWriterHelper.startNode(writer, serializedMember, fieldType);
                Class<?> actualType = newObj.getClass();
                Class defaultType = JavaBeanConverter.this.mapper.defaultImplementationOf(fieldType);
                if (!actualType.equals(defaultType) && classAttributeName != null) {
                    writer.addAttribute(classAttributeName, JavaBeanConverter.this.mapper.serializedClass(actualType));
                }
                context.convertAnother(newObj);
                writer.endNode();
            }
        });
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Object result = this.instantiateNewInstance(context);
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String propertyName = this.mapper.realMember(result.getClass(), reader.getNodeName());
            boolean propertyExistsInClass = this.beanProvider.propertyDefinedInClass(propertyName, result.getClass());
            if (propertyExistsInClass) {
                Class type = this.determineType(reader, result, propertyName);
                Object value = context.convertAnother(result, type);
                this.beanProvider.writeProperty(result, propertyName, value);
            } else if (this.mapper.shouldSerializeMember(result.getClass(), propertyName)) {
                throw new ConversionException("Property '" + propertyName + "' not defined in class " + result.getClass().getName());
            }
            reader.moveUp();
        }
        return result;
    }

    private Object instantiateNewInstance(UnmarshallingContext context) {
        Object result = context.currentObject();
        if (result == null) {
            result = this.beanProvider.newInstance(context.getRequiredType());
        }
        return result;
    }

    private Class determineType(HierarchicalStreamReader reader, Object result, String fieldName) {
        String classAttribute;
        String classAttributeName = this.classAttributeIdentifier != null ? this.classAttributeIdentifier : this.mapper.aliasForSystemAttribute("class");
        String string = classAttribute = classAttributeName == null ? null : reader.getAttribute(classAttributeName);
        if (classAttribute != null) {
            return this.mapper.realClass(classAttribute);
        }
        return this.mapper.defaultImplementationOf(this.beanProvider.getPropertyType(result, fieldName));
    }

    public static class DuplicateFieldException
    extends ConversionException {
        public DuplicateFieldException(String msg) {
            super(msg);
        }
    }
}

