/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.xml.xstream.converters.extended;

import com.streamscape.omf.xml.xstream.converters.Converter;
import com.streamscape.omf.xml.xstream.converters.MarshallingContext;
import com.streamscape.omf.xml.xstream.converters.UnmarshallingContext;
import com.streamscape.omf.xml.xstream.io.HierarchicalStreamReader;
import com.streamscape.omf.xml.xstream.io.HierarchicalStreamWriter;

public class ThrowableConverter
implements Converter {
    private Converter defaultConverter;

    public ThrowableConverter(Converter defaultConverter) {
        this.defaultConverter = defaultConverter;
    }

    @Override
    public boolean canConvert(Class type) {
        return Throwable.class.isAssignableFrom(type);
    }

    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Throwable throwable = (Throwable)source;
        if (throwable.getCause() == null) {
            try {
                throwable.initCause(null);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        throwable.getStackTrace();
        this.defaultConverter.marshal(throwable, writer, context);
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        return this.defaultConverter.unmarshal(reader, context);
    }
}

