/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.xml.xstream.converters.extended;

import com.streamscape.lib.utils.StringUtils;
import com.streamscape.omf.xml.xstream.converters.ConversionException;
import com.streamscape.omf.xml.xstream.converters.basic.AbstractSingleValueConverter;
import com.streamscape.omf.xml.xstream.converters.extended.StackTraceElementFactory;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StackTraceElementConverter
extends AbstractSingleValueConverter {
    private static final Pattern PATTERN_JAVA_8 = Pattern.compile("^(.+)\\.([^\\(]+)\\(([^:]*)(:(-)?(\\d+))?\\)$");
    private static final StackTraceElementFactory FACTORY = new StackTraceElementFactory();

    @Override
    public boolean canConvert(Class type) {
        return StackTraceElement.class.equals((Object)type);
    }

    @Override
    public String toString(Object obj) {
        StackTraceElement element = (StackTraceElement)obj;
        return StackTraceElementConverter.encode(element.getClassLoaderName()) + ":" + StackTraceElementConverter.encode(element.getModuleName()) + ":" + StackTraceElementConverter.encode(element.getModuleVersion()) + ":" + StackTraceElementConverter.encode(element.getClassName()) + ":" + StackTraceElementConverter.encode(element.getMethodName()) + ":" + StackTraceElementConverter.encode(element.getFileName()) + ":" + element.getLineNumber();
    }

    @Override
    public Object fromString(String str) {
        List<String> tokens = StringUtils.split(str, ":");
        if (tokens.size() < 7) {
            return this.convertFromJava8(str);
        }
        try {
            String classLoaderName = StackTraceElementConverter.decode(tokens.get(0));
            String moduleName = StackTraceElementConverter.decode(tokens.get(1));
            String moduleVersion = StackTraceElementConverter.decode(tokens.get(2));
            String declaringClass = StackTraceElementConverter.decode(tokens.get(3));
            String methodName = StackTraceElementConverter.decode(tokens.get(4));
            String fileName = StackTraceElementConverter.decode(tokens.get(5));
            int lineNumber = Integer.parseInt(tokens.get(6));
            return new StackTraceElement(classLoaderName, moduleName, moduleVersion, declaringClass, methodName, fileName, lineNumber);
        }
        catch (Exception exception) {
            throw new ConversionException("Parsing StackTraceElement failed ('" + str + "').", exception);
        }
    }

    private StackTraceElement convertFromJava8(String str) {
        Matcher matcher = PATTERN_JAVA_8.matcher(str);
        if (matcher.matches()) {
            String declaringClass = matcher.group(1);
            String methodName = matcher.group(2);
            String fileName = matcher.group(3);
            if (fileName.equals("Unknown Source")) {
                return FACTORY.unknownSourceElement(declaringClass, methodName);
            }
            if (fileName.equals("Native Method")) {
                return FACTORY.nativeMethodElement(declaringClass, methodName);
            }
            if (matcher.group(4) != null) {
                int sign = matcher.group(5) != null ? -1 : 1;
                int lineNumber = Integer.parseInt(matcher.group(6));
                return FACTORY.element(declaringClass, methodName, fileName, sign * lineNumber);
            }
            return FACTORY.element(declaringClass, methodName, fileName);
        }
        throw new ConversionException("Parsing StackTraceElement failed ('" + str + "').");
    }

    private static String encode(String value) {
        return value == null ? "" : value;
    }

    private static String decode(String value) {
        return value.isEmpty() ? null : value;
    }
}

