/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.xml.xstream.converters.extended;

import com.streamscape.omf.xml.xstream.converters.ConversionException;
import com.streamscape.omf.xml.xstream.converters.Converter;
import com.streamscape.omf.xml.xstream.converters.MarshallingContext;
import com.streamscape.omf.xml.xstream.converters.SingleValueConverter;
import com.streamscape.omf.xml.xstream.converters.UnmarshallingContext;
import com.streamscape.omf.xml.xstream.converters.extended.JavaClassConverter;
import com.streamscape.omf.xml.xstream.io.HierarchicalStreamReader;
import com.streamscape.omf.xml.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Field;

public class JavaFieldConverter
implements Converter {
    private final SingleValueConverter javaClassConverter;

    public JavaFieldConverter(ClassLoader classLoader) {
        this.javaClassConverter = new JavaClassConverter(classLoader);
    }

    @Override
    public boolean canConvert(Class type) {
        return type.equals(Field.class);
    }

    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Field field = (Field)source;
        writer.startNode("name");
        writer.setValue(field.getName());
        writer.endNode();
        writer.startNode("clazz");
        writer.setValue(this.javaClassConverter.toString(field.getDeclaringClass()));
        writer.endNode();
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String methodName = null;
        String declaringClassName = null;
        while ((methodName == null || declaringClassName == null) && reader.hasMoreChildren()) {
            reader.moveDown();
            if (reader.getNodeName().equals("name")) {
                methodName = reader.getValue();
            } else if (reader.getNodeName().equals("clazz")) {
                declaringClassName = reader.getValue();
            }
            reader.moveUp();
        }
        Class declaringClass = (Class)this.javaClassConverter.fromString(declaringClassName);
        try {
            return declaringClass.getDeclaredField(methodName);
        }
        catch (NoSuchFieldException e) {
            throw new ConversionException(e);
        }
    }
}

