/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.xml.xstream.converters.enums;

import com.streamscape.omf.xml.xstream.converters.basic.AbstractSingleValueConverter;

public class EnumSingleValueConverter
extends AbstractSingleValueConverter {
    private final Class enumType;

    public EnumSingleValueConverter(Class type) {
        if (!Enum.class.isAssignableFrom(type) && type != Enum.class) {
            throw new IllegalArgumentException("Converter can only handle defined enums");
        }
        this.enumType = type;
    }

    @Override
    public boolean canConvert(Class type) {
        return this.enumType.isAssignableFrom(type);
    }

    @Override
    public Object fromString(String str) {
        return Enum.valueOf(this.enumType, str);
    }
}

