/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.xml.xstream.converters.enums;

import com.streamscape.omf.xml.xstream.converters.Converter;
import com.streamscape.omf.xml.xstream.converters.MarshallingContext;
import com.streamscape.omf.xml.xstream.converters.UnmarshallingContext;
import com.streamscape.omf.xml.xstream.io.HierarchicalStreamReader;
import com.streamscape.omf.xml.xstream.io.HierarchicalStreamWriter;

public class EnumConverter
implements Converter {
    @Override
    public boolean canConvert(Class type) {
        return type.isEnum() || Enum.class.isAssignableFrom(type);
    }

    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        writer.setValue(((Enum)source).name());
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Class type = context.getRequiredType();
        if (type.getSuperclass() != Enum.class) {
            type = type.getSuperclass();
        }
        return Enum.valueOf(type, reader.getValue());
    }
}

