/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.xml.xstream.converters.collections;

import com.streamscape.omf.xml.xstream.converters.ConversionException;
import com.streamscape.omf.xml.xstream.converters.MarshallingContext;
import com.streamscape.omf.xml.xstream.converters.UnmarshallingContext;
import com.streamscape.omf.xml.xstream.converters.collections.CollectionConverter;
import com.streamscape.omf.xml.xstream.io.HierarchicalStreamReader;
import com.streamscape.omf.xml.xstream.io.HierarchicalStreamWriter;
import com.streamscape.omf.xml.xstream.mapper.Mapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public class TreeSetConverter
extends CollectionConverter {
    public TreeSetConverter(Mapper mapper) {
        super(mapper);
    }

    @Override
    public boolean canConvert(Class type) {
        return type.equals(TreeSet.class);
    }

    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        TreeSet treeSet = (TreeSet)source;
        Comparator comparator = treeSet.comparator();
        if (comparator == null) {
            writer.startNode("no-comparator");
            writer.endNode();
        } else {
            writer.startNode("comparator");
            writer.addAttribute("class", this.mapper().serializedClass(comparator.getClass()));
            context.convertAnother(comparator);
            writer.endNode();
        }
        super.marshal(source, writer, context);
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        TreeSet result;
        PresortedSet sortedSet;
        reader.moveDown();
        if (reader.getNodeName().equals("comparator")) {
            String comparatorClass = reader.getAttribute("class");
            Comparator comparator = (Comparator)context.convertAnother(null, this.mapper().realClass(comparatorClass));
            sortedSet = new PresortedSet(comparator);
            result = new TreeSet(comparator);
        } else if (reader.getNodeName().equals("no-comparator")) {
            sortedSet = new PresortedSet();
            result = new TreeSet();
        } else {
            throw new ConversionException("TreeSet does not contain <comparator> element");
        }
        reader.moveUp();
        super.populateCollection(reader, context, sortedSet);
        result.addAll(sortedSet);
        return result;
    }

    private static class PresortedSet
    implements SortedSet {
        private final List list = new ArrayList();
        private final Comparator comparator;

        PresortedSet() {
            this(null);
        }

        PresortedSet(Comparator comparator) {
            this.comparator = comparator;
        }

        @Override
        public boolean add(Object e) {
            return this.list.add(e);
        }

        @Override
        public boolean addAll(Collection c) {
            return this.list.addAll(c);
        }

        @Override
        public void clear() {
            this.list.clear();
        }

        @Override
        public boolean contains(Object o) {
            return this.list.contains(o);
        }

        @Override
        public boolean containsAll(Collection c) {
            return this.list.containsAll(c);
        }

        @Override
        public boolean equals(Object o) {
            return this.list.equals(o);
        }

        @Override
        public int hashCode() {
            return this.list.hashCode();
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        public Iterator iterator() {
            return this.list.iterator();
        }

        @Override
        public boolean remove(Object o) {
            return this.list.remove(o);
        }

        @Override
        public boolean removeAll(Collection c) {
            return this.list.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection c) {
            return this.list.retainAll(c);
        }

        @Override
        public int size() {
            return this.list.size();
        }

        public List subList(int fromIndex, int toIndex) {
            return this.list.subList(fromIndex, toIndex);
        }

        @Override
        public Object[] toArray() {
            return this.list.toArray();
        }

        @Override
        public Object[] toArray(Object[] a) {
            return this.list.toArray(a);
        }

        public Comparator comparator() {
            return this.comparator;
        }

        public Object first() {
            return this.list.isEmpty() ? null : this.list.get(0);
        }

        public SortedSet headSet(Object toElement) {
            throw new UnsupportedOperationException();
        }

        public Object last() {
            return this.list.isEmpty() ? null : this.list.get(this.list.size() - 1);
        }

        public SortedSet subSet(Object fromElement, Object toElement) {
            throw new UnsupportedOperationException();
        }

        public SortedSet tailSet(Object fromElement) {
            throw new UnsupportedOperationException();
        }
    }
}

