/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.xml.xstream.converters.collections;

import com.streamscape.omf.xml.xstream.converters.ConversionException;
import com.streamscape.omf.xml.xstream.converters.Converter;
import com.streamscape.omf.xml.xstream.converters.MarshallingContext;
import com.streamscape.omf.xml.xstream.converters.UnmarshallingContext;
import com.streamscape.omf.xml.xstream.core.util.HierarchicalStreams;
import com.streamscape.omf.xml.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import com.streamscape.omf.xml.xstream.io.HierarchicalStreamReader;
import com.streamscape.omf.xml.xstream.io.HierarchicalStreamWriter;
import com.streamscape.omf.xml.xstream.mapper.Mapper;

public abstract class AbstractCollectionConverter
implements Converter {
    private final Mapper mapper;

    @Override
    public abstract boolean canConvert(Class var1);

    public AbstractCollectionConverter(Mapper mapper) {
        this.mapper = mapper;
    }

    protected Mapper mapper() {
        return this.mapper;
    }

    @Override
    public abstract void marshal(Object var1, HierarchicalStreamWriter var2, MarshallingContext var3);

    @Override
    public abstract Object unmarshal(HierarchicalStreamReader var1, UnmarshallingContext var2);

    protected void writeItem(Object item, MarshallingContext context, HierarchicalStreamWriter writer) {
        if (item == null) {
            String name = this.mapper().serializedClass(null);
            ExtendedHierarchicalStreamWriterHelper.startNode(writer, name, Mapper.Null.class);
            writer.endNode();
        } else {
            String name = this.mapper().serializedClass(item.getClass());
            ExtendedHierarchicalStreamWriterHelper.startNode(writer, name, item.getClass());
            context.convertAnother(item);
            writer.endNode();
        }
    }

    protected Object readItem(HierarchicalStreamReader reader, UnmarshallingContext context, Object current) {
        Class type = HierarchicalStreams.readClassType(reader, this.mapper());
        return context.convertAnother(current, type);
    }

    protected Object createCollection(Class type) {
        Class defaultType = this.mapper().defaultImplementationOf(type);
        try {
            return defaultType.newInstance();
        }
        catch (InstantiationException e) {
            throw new ConversionException("Cannot instantiate " + defaultType.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new ConversionException("Cannot instantiate " + defaultType.getName(), e);
        }
    }
}

