/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.omf.xml.xstream.converters.basic;

import com.streamscape.omf.xml.xstream.converters.ConversionException;
import com.streamscape.omf.xml.xstream.converters.basic.AbstractSingleValueConverter;
import com.streamscape.omf.xml.xstream.core.util.ThreadSafeSimpleDateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;

public class DateConverter
extends AbstractSingleValueConverter {
    private static final String[] DEFAULT_ACCEPTABLE_FORMATS = new String[]{"yyyy-MM-dd HH:mm:ss.S", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm:ss.S a", "yyyy-MM-dd HH:mm:ssz", "yyyy-MM-dd HH:mm:ss z", "yyyy-MM-dd HH:mm:ssa", "yyyy-MM-dd"};
    private static final String DEFAULT_PATTERN = "yyyy-MM-dd HH:mm:ss.S z";
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final TimeZone DEFAULT_TIMEZONE = TimeZone.getDefault();
    private final ThreadSafeSimpleDateFormat defaultFormat;
    private final ThreadSafeSimpleDateFormat[] acceptableFormats;

    public DateConverter() {
        this(false);
    }

    public DateConverter(TimeZone timeZone) {
        this(DEFAULT_PATTERN, DEFAULT_ACCEPTABLE_FORMATS, timeZone);
    }

    public DateConverter(boolean lenient) {
        this(DEFAULT_PATTERN, DEFAULT_ACCEPTABLE_FORMATS, lenient);
    }

    public DateConverter(String defaultFormat, String[] acceptableFormats) {
        this(defaultFormat, acceptableFormats, false);
    }

    public DateConverter(String defaultFormat, String[] acceptableFormats, TimeZone timeZone) {
        this(defaultFormat, acceptableFormats, timeZone, false);
    }

    public DateConverter(String defaultFormat, String[] acceptableFormats, boolean lenient) {
        this(defaultFormat, acceptableFormats, DEFAULT_TIMEZONE, lenient);
    }

    public DateConverter(String defaultFormat, String[] acceptableFormats, TimeZone timeZone, boolean lenient) {
        this.defaultFormat = new ThreadSafeSimpleDateFormat(defaultFormat, timeZone, 4, 20, lenient);
        this.acceptableFormats = acceptableFormats != null ? new ThreadSafeSimpleDateFormat[acceptableFormats.length] : new ThreadSafeSimpleDateFormat[]{};
        for (int i = 0; i < this.acceptableFormats.length; ++i) {
            this.acceptableFormats[i] = new ThreadSafeSimpleDateFormat(acceptableFormats[i], timeZone, 1, 20, lenient);
        }
    }

    @Override
    public boolean canConvert(Class type) {
        return type.equals(Date.class);
    }

    @Override
    public Object fromString(String str) {
        try {
            return this.defaultFormat.parse(str);
        }
        catch (ParseException e) {
            for (int i = 0; i < this.acceptableFormats.length; ++i) {
                try {
                    return this.acceptableFormats[i].parse(str);
                }
                catch (ParseException parseException) {
                    continue;
                }
            }
            throw new ConversionException("Cannot parse date " + str);
        }
    }

    @Override
    public String toString(Object obj) {
        return this.defaultFormat.format((Date)obj);
    }
}

